/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.web.controller;

import cn.remex.RemexConstants;
import cn.remex.core.exception.NestedException;
import cn.remex.core.net.HttpHelper;
import cn.remex.core.util.FileHelper;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.MapHelper;
import cn.remex.core.util.StringHelper;
import cn.remex.web.service.BsRvo;
import cn.remex.web.service.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DefaultSpringMVCController
implements RemexConstants {
    @RequestMapping(value={"{bs:[a-zA-Z0-9]+}"})
    public ModelAndView execute1(@PathVariable String bs, @RequestParam(value="files", required=false) CommonsMultipartFile[] files, HttpServletRequest request, HttpServletResponse response) {
        return this.execute(bs, "execute", null, request, response, files, null);
    }

    @RequestMapping(value={"{bs:[a-zA-Z0-9]+}/{bsCmd:[a-zA-Z0-9]+}"})
    public ModelAndView execute2(@PathVariable String bs, @PathVariable String bsCmd, @RequestParam(value="files", required=false) CommonsMultipartFile[] files, HttpServletRequest request, HttpServletResponse response) {
        return this.execute(bs, bsCmd, null, request, response, files, null);
    }

    @RequestMapping(value={"DataService/{modelName:\\S+}/{bsCmd:[a-zA-Z0-9]+}"})
    public ModelAndView execute_DataService(@PathVariable String bsCmd, @PathVariable String modelName, @RequestParam(value="files", required=false) CommonsMultipartFile[] files, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("modelName", modelName);
        return this.execute("DataService", bsCmd, null, request, response, files, params);
    }

    @RequestMapping(value={"ViewService/{viewName:\\S+}/{bsCmd:[a-zA-Z0-9]+}"})
    public ModelAndView execute_ViewService(@PathVariable String bsCmd, @PathVariable String modelName, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("viewName", modelName);
        return this.execute("ViewService", bsCmd, null, request, response, null, params);
    }

    @RequestMapping(value={"{bs:[a-zA-Z0-9]+}/{bsCmd:[a-zA-Z0-9]+}/{id:\\S+}"})
    public ModelAndView execute3(@PathVariable String bs, @PathVariable String bsCmd, @PathVariable String id, @RequestParam(value="files", required=false) CommonsMultipartFile[] files, HttpServletRequest request, HttpServletResponse response) {
        return this.execute(bs, bsCmd, id, request, response, files, null);
    }

    private ModelAndView execute(@PathVariable String bs, @PathVariable String bsCmd, @PathVariable String pk, HttpServletRequest request, HttpServletResponse response, CommonsMultipartFile[] files, Map params) {
        Object rp;
        String rv;
        RemexConstants.ResponseContentType rt;
        BsRvo bsRvo = ServiceFactory.executeBs(bs, bsCmd, pk, request, response, params);
        Map<String, Object> map = MapHelper.toMap((Object)bsRvo);
        RemexConstants.ResponseContentType responseContentType = rt = Judgment.nullOrBlank(request.getParameter("rt")) ? null : RemexConstants.ResponseContentType.valueOf(request.getParameter("rt"));
        if (Judgment.nullOrBlank((Object)rt) && Judgment.nullOrBlank((Object)(rt = bsRvo.getResponseContentType()))) {
            rt = RemexConstants.ResponseContentType.json;
        }
        if (Judgment.nullOrBlank(rv = request.getParameter("rv")) && Judgment.nullOrBlank(rv = bsRvo.getResponseHandelParam()) && RemexConstants.ResponseContentType.jsp.equals((Object)rt)) {
            rv = "default_layout";
        }
        if (Judgment.nullOrBlank(rp = request.getParameter("rp")) && Judgment.nullOrBlank(rp = map.get("rp")) && Judgment.nullOrBlank(rp = bsRvo.getResponseHandelParam()) && "jsp".equals((Object)rt)) {
            map.put("rp", ("bspage/" + bs + "_" + bsCmd).toLowerCase());
        }
        if ("ACCOUNT_NOT_AUTH".equals(bsRvo.getCode()) || "ACCOUNT_NOT_PERMIT".equals(bsRvo.getCode())) {
            try {
                response.sendError(401, bsRvo.getMsg());
            }
            catch (IOException e) {
                throw new NestedException("ERROR", "\u8d26\u6237401\u9519\u8bef\u5b9a\u5411\u9519\u8bef");
            }
        }
        if (RemexConstants.ResponseContentType.redirect.equals((Object)rt)) {
            try {
                response.sendRedirect(rv.toString());
            }
            catch (IOException e) {
                RemexConstants.logger.error((Object)"redirect \u5931\u8d25", (Throwable)e);
            }
            return null;
        }
        if (RemexConstants.ResponseContentType.stream.equals((Object)rt)) {
            if (bsRvo.getBody() != null) {
                if (bsRvo.getBody() instanceof File) {
                    File file = (File)bsRvo.getBody();
                    response.setContentType(FileHelper.getContentType(file));
                    response.addHeader("Content-Disposition", "attachment;filename=" + StringHelper.exCharset(Judgment.nullOrBlank(rv) ? file.getName() : rv.toString(), "UTF-8", "ISO-8859-1"));
                    HttpHelper.writeToResponse(file, response);
                } else if (bsRvo.getBody() instanceof InputStream) {
                    response.addHeader("Content-Disposition", "attachment;filename=" + StringHelper.exCharset(rv.toString(), "UTF-8", "ISO-8859-1"));
                    HttpHelper.writeToResponse((InputStream)bsRvo.getBody(), response);
                }
            }
            return null;
        }
        if (RemexConstants.ResponseContentType.text.equals((Object)rt)) {
            if (bsRvo.getBody() != null) {
                HttpHelper.writeToResponse(bsRvo.getBody().toString(), response);
            }
            return null;
        }
        ModelAndView mv = RemexConstants.ResponseContentType.jsp.equals((Object)rt) ? new ModelAndView(rv.toString()) : new ModelAndView();
        RemexConstants.ResponseContentType finalRt = rt;
        map.forEach((arg_0, arg_1) -> DefaultSpringMVCController.lambda$execute$130((Object)((Object)finalRt), mv, arg_0, arg_1));
        if (!Judgment.nullOrBlank(pk) || !Judgment.nullOrBlank(map.get("pk"))) {
            mv.addObject("pk", Judgment.nullOrBlank(pk) ? map.get("pk") : pk);
        }
        return mv;
    }

    private static /* synthetic */ void lambda$execute$130(Object finalRt, ModelAndView mv, String k, Object v) {
        if (!("class".equals(k) || "responseContentType".equals(k) || "responseHandelParam".equals(k) || "json".equals(finalRt) && "rp".equals(k))) {
            mv.addObject(k, v);
        }
    }
}

