/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.web.aspect;

import cn.remex.RemexConstants;
import cn.remex.contrib.auth.AuthenticateBtx;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Param;
import cn.remex.core.util.ThreadHelper;
import cn.remex.db.Database;
import cn.remex.db.model.SysStatus;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.sql.Sort;
import cn.remex.db.sql.WhereRuleOper;
import cn.remex.web.service.BusinessService;
import cn.remex.web.service.appbeans.AsyncCvo;
import cn.remex.web.service.appbeans.AsyncRvo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class BusinessServiceAspect {
    private static Map<String, Object> cachedBsRvoMap = new HashMap<String, Object>();
    private static Map<String, Long> cachedExpiredMap = new HashMap<String, Long>();

    public static void resetCache() {
        cachedBsRvoMap = new HashMap<String, Object>();
        cachedExpiredMap = new HashMap<String, Long>();
    }

    @Around(value="@annotation(cn.remex.web.service.BusinessService) && @annotation(bsAnno)")
    public Object doAroundBusinessService(ProceedingJoinPoint pjp, BusinessService bsAnno) throws Throwable {
        if (bsAnno.needAuth()) {
            Assert.isTrue(AuthenticateBtx.checkToken(), "ACCOUNT_NOT_AUTH", "\u7528\u6237\u672a\u767b\u5f55");
        }
        if (bsAnno.cachedArgIndexs().length > 0 || bsAnno.needCache()) {
            StringBuilder keyHash = new StringBuilder(pjp.getSignature().getDeclaringType().getName() + "" + pjp.getSignature().getName());
            for (int s : bsAnno.cachedArgIndexs()) {
                keyHash.append(pjp.getArgs()[s] == null ? "0" : Integer.valueOf(pjp.getArgs()[s].hashCode())).append("-");
            }
            String key = keyHash.toString();
            Object retObj = cachedBsRvoMap.get(keyHash.toString());
            if (retObj != null && (null == cachedExpiredMap.get(key) || System.currentTimeMillis() - cachedExpiredMap.get(key) < bsAnno.cachedExpired() * 1000L)) {
                return retObj;
            }
            Param retObj2 = new Param();
            Runnable runnable = () -> {
                try {
                    retObj2.param = pjp.proceed();
                    cachedExpiredMap.put(key, System.currentTimeMillis());
                    cachedBsRvoMap.remove(key);
                    cachedBsRvoMap.put(key, retObj2.param);
                }
                catch (Throwable throwable) {
                    cachedBsRvoMap.remove(key);
                    cachedExpiredMap.remove(key);
                    RemexConstants.logger.error((Object)"\u670d\u52a1\u7f13\u5b58\u540e\u53f0\u7ebf\u7a0b\u5f02\u5e38", throwable);
                }
            };
            if (retObj != null) {
                ThreadHelper.run(runnable);
                return retObj;
            }
            runnable.run();
            return retObj2.param;
        }
        if (BusinessService.ServiceType.AsyncService.equals((Object)bsAnno.type())) {
            return this.handleService(pjp, bsAnno);
        }
        return pjp.proceed();
    }

    private Object handleService(ProceedingJoinPoint pjp, BusinessService bsAnno) throws Throwable {
        Param<Object> cvoParam = new Param<Object>(null);
        Arrays.asList(pjp.getArgs()).stream().filter(arg -> null != arg && arg instanceof AsyncCvo).findFirst().ifPresent(cvo -> {
            cvoParam.param = (AsyncCvo)cvo;
            Object cfr_ignored_0 = cvoParam.param;
        });
        AsyncCvo cvo2 = (AsyncCvo)cvoParam.param;
        Assert.notNull(cvo2, "BS_ERROR", "AsyncService \u5fc5\u987b\u4f7f\u7528AsyncCvo!");
        Assert.notNull(cvo2.getAsyncKey(), "BS_ERROR", "\u5f02\u6b65\u670d\u52a1\u5fc5\u987b\u4f20asyncKey");
        Object ret = pjp.proceed();
        Assert.isTrue(ret != null && ret instanceof AsyncRvo, "BS_ERROR", "AsyncService \u5fc5\u987b\u8fd4\u56deAsyncRvo");
        AsyncRvo rvo = (AsyncRvo)ret;
        SysStatus sysStatus = Database.createDbCvo(SysStatus.class).filterBy(SysStatus::getKey, WhereRuleOper.eq, (Object)cvo2.getAsyncKey()).orderBy(ModelableImpl::getModifyTime, Sort.DESC).ready().queryBean();
        sysStatus = null == sysStatus ? new SysStatus() : sysStatus;
        sysStatus.setKey(cvo2.getAsyncKey());
        rvo.setAsyncStatus(sysStatus);
        AsyncRvo retRvo = rvo.getProcessFunction().apply(rvo);
        if (null == sysStatus.getStatus() || RsqlConstants.SysStatusEnum.Init.equals((Object)sysStatus.getStatus()) || (RsqlConstants.SysStatusEnum.Finish.equals((Object)sysStatus.getStatus()) || RsqlConstants.SysStatusEnum.Fail.equals((Object)sysStatus.getStatus())) && cvo2.getAsyncRestart()) {
            if (RsqlConstants.SysStatusEnum.Finish.equals((Object)sysStatus.getStatus()) || RsqlConstants.SysStatusEnum.Fail.equals((Object)sysStatus.getStatus())) {
                sysStatus.setProgressRate(0.0);
                sysStatus.setDesc("\u91cd\u65b0\u542f\u52a8\u4e2d...");
            }
            Assert.notNull(rvo.getStartFunction(), "BS_ERROR", "\u5f02\u6b65\u670d\u52a1\u5fc5\u987b \u901a\u8fc7asyncRvo.process(asyncRvo -> {//do you work} \u6ce8\u5165\u66f4\u65b0\u903b\u8f91");
            rvo._update(c -> ThreadHelper.run(() -> Database.getSession().store(c.getAsyncStatus())));
            ThreadHelper.run(() -> {
                try {
                    rvo.getStartFunction().apply(rvo);
                }
                catch (Throwable t) {
                    RemexConstants.logger.error((Object)"\u5f02\u6b65\u670d\u52a1\u51fa\u73b0\u9519\u8bef\uff1a", t);
                    rvo.update(RsqlConstants.SysStatusEnum.Fail, rvo.getAsyncStatus().getProgressRate(), t.toString());
                }
            });
            sysStatus.setStatus(RsqlConstants.SysStatusEnum.Doing);
            Database.getSession().store(sysStatus);
        } else if (RsqlConstants.SysStatusEnum.Finish.equals((Object)sysStatus.getStatus()) && rvo.getSuccessFunction() != null) {
            retRvo = rvo.getSuccessFunction().apply(rvo);
            sysStatus.setStatus(RsqlConstants.SysStatusEnum.Finish);
            Database.getSession().store(sysStatus);
        }
        return retRvo;
    }
}

