/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.web;

import cn.remex.RemexConstants;
import cn.remex.contrib.auth.AuthenticateBtx;
import cn.remex.core.CoreSvo;
import cn.remex.core.RemexApplication;
import cn.remex.core.exception.FilterException;
import cn.remex.core.exception.NestedException;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.RequestHelper;
import cn.remex.db.model.cert.AuthRole;
import cn.remex.web.RemexWebConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemexFilter
implements Filter,
RemexConstants {
    private FilterConfig filterConfig = null;
    private boolean needAuthenticate = false;
    private ArrayList<String> permitUriPres = new ArrayList();
    private String urlRoot = null;
    private String errorUri = "/WEB-INF/page/error.jsp";
    private String loginUri;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sRequest, ServletResponse sResponse, FilterChain chain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        HttpServletRequest request = (HttpServletRequest)sRequest;
        HttpServletResponse response = (HttpServletResponse)sResponse;
        String uri = request.getRequestURI();
        String svlPath = request.getServletPath();
        String uriParams = request.getQueryString();
        String context = request.getContextPath();
        CoreSvo.initHttp(request, response);
        try {
            boolean isAuthed;
            if (this.isPublic(request) || (isAuthed = AuthenticateBtx.checkToken()) && this.isPermit(request)) {
                this.handleCrossDomain(response, request);
                chain.doFilter(sRequest, sResponse);
            } else if (isAuthed) {
                logger.warn((Object)("\u8eab\u4efd\u9a8c\u8bc1\u6ca1\u6709\u901a\u8fc7\uff0c\u5ba2\u6237\u7aefIP:" + RequestHelper.getClientIP(request) + ",URI:" + uri));
                response.sendError(401);
            } else {
                logger.warn((Object)("\u6743\u9650\u9a8c\u8bc1\u6ca1\u6709\u901a\u8fc7\uff0c\u5ba2\u6237\u7aefIP:" + RequestHelper.getClientIP(request) + ",URI:" + uri));
                response.sendError(401, "\u8eab\u4efd\u53ca\u6743\u9650\u9a8c\u8bc1\u7684\u9519\u8bef");
            }
        }
        catch (Exception e) {
            if (e.toString().indexOf("Broken pipe") > 0 || e.toString().indexOf("\u65ad\u5f00\u7684\u7ba1\u9053") > 0) {
                logger.error((Object)("RemexFilter\u6355\u83b7\u5230\u6846\u67b6\u65e0\u6cd5\u5904\u7406\u7684\u5f02\u5e38:" + e.toString()));
            } else {
                logger.error((Object)"RemexFilter\u6355\u83b7\u5230\u6846\u67b6\u65e0\u6cd5\u5904\u7406\u7684\u5f02\u5e38:", (Throwable)e);
                request.setAttribute("exception", (Object)e);
                request.getRequestDispatcher(this.errorUri).forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            CoreSvo.destoryHttp();
            logger.info((Object)new StringBuilder("Handle ").append(RequestHelper.getClientIP(request)).append(" request [").append(uri).append("?").append(uriParams).append("] took ").append(System.currentTimeMillis() - startTime).append(" ms.").append("\r\n==============================================================\r\n"));
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        try {
            RemexApplication.refresh();
        }
        catch (NestedException e) {
            throw new FilterException("RemexFilter\u521d\u59cb\u5316\u9519\u8bef\uff0c\u67b6\u6784\u6355\u83b7\u5230\u6570\u636e\u5e93\u5f02\u5e38:", e);
        }
        catch (Exception e) {
            throw new FilterException("RemexFilter\u521d\u59cb\u5316\u9519\u8bef\uff0c\u67b6\u6784\u672a\u5904\u7406\u7684\u6570\u636e\u5e93\u5f02\u5e38:", e);
        }
        String needAuthenticateString = this.filterConfig.getInitParameter("needAuthenticate");
        for (String dir : this.filterConfig.getInitParameter("permitUriPres").split(";")) {
            this.permitUriPres.add(dir.trim());
        }
        this.urlRoot = this.filterConfig.getServletContext().getContextPath();
        if ("true".equals(needAuthenticateString)) {
            System.out.println("\u7cfb\u7edf\u914d\u7f6e\u4e3a\u8eab\u4efd\u9a8c\u8bc1\uff0c\u9700\u8fdb\u884c\u5b89\u5168\u8ba4\u8bc1\u3002");
        } else {
            System.out.println("\u7cfb\u7edf\u914d\u7f6e\u4e3a\u901a\u884c\u6a21\u5f0f\uff0c\u65e0\u9700\u9a8c\u8bc1\u5373\u53ef\u8bbf\u95ee\u3002");
        }
    }

    private boolean isPublic(HttpServletRequest request) {
        String uri = request.getRequestURI();
        return uri.startsWith("/smvc/");
    }

    private boolean isPermit(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String ctx = request.getContextPath();
        if ((uri = uri.replaceFirst("/smvc", "").replaceAll(".json", "").replaceAll(".jsp", "").replaceAll(ctx, "").replaceAll("(/[a-zA-Z\\-]*[\\d]+$)|(.json)|(.jsp)|()", "")).equals("/")) {
            return true;
        }
        Map<String, Map<String, ?>> uris = AuthenticateBtx.obtainSysUriMapToRole();
        Map<String, ?> rolesOfCurUri = uris.get(uri);
        if (null == rolesOfCurUri) {
            return false;
        }
        List<AuthRole> roles = AuthenticateBtx.obtainCurUser().getRoles();
        boolean permit = roles != null && roles.stream().anyMatch(curRole -> rolesOfCurUri.containsKey(curRole.getId()));
        return permit;
    }

    private void handleCrossDomain(HttpServletResponse response, HttpServletRequest request) {
        String refer;
        String origin = request.getHeader("origin");
        if (Judgment.nullOrBlank(origin) && !Judgment.nullOrBlank(refer = request.getHeader("referer"))) {
            origin = refer.substring(7);
            origin = "http://" + origin.substring(0, origin.indexOf("/"));
        }
        if (!Judgment.nullOrBlank(origin)) {
            response.setHeader("Access-Control-Allow-Origin", RemexWebConfig.getCrossDomain().indexOf(origin) >= 0 ? origin : "-");
            response.setHeader("Access-Control-Allow-Methods", "*");
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Allow-Headers", "Origin, No-Cache, X-Requested-With, If-Modified-Since, Pragma, Last-Modified, Cache-Control, Expires, Content-Type, X-E4M-With");
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
    }
}

