/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.redis;

import cn.remex.RemexConstants;
import cn.remex.core.RemexApplication;
import cn.remex.redis.RedisDataSource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import redis.clients.jedis.ShardedJedis;

public class RedisClientFactory {
    Logger log = RemexConstants.logger;
    private RedisDataSource redisDataSource = RemexApplication.getBean(RedisDataSource.class, new String[0]);

    public RedisDataSource getRedisDataSource() {
        return this.redisDataSource;
    }

    public void setRedisDataSource(RedisDataSource redisDataSource) {
        this.redisDataSource = redisDataSource;
    }

    public void disconnect() {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        shardedJedis.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.set(key, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, String nxxx, String expx, long time) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.set(key, value, nxxx, expx, time);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.get(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String key) {
        Boolean result = false;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return false;
        }
        try {
            result = shardedJedis.exists(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.type(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String key, int seconds) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.expire(key, seconds);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expireAt(String key, long unixTime) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.expireAt(key, unixTime);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(String key) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return result;
        }
        try {
            result = shardedJedis.ttl(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSet(String key, String value) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.getSet(key, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String key, String value) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return result;
        }
        try {
            result = shardedJedis.setnx(key, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(String key, int seconds, String value) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.setex(key, seconds, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long append(String key, String value) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.append(key, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substr(String key, int start, int end) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.substr(key, start, end);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String key, String field, String value) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.hset(key, field, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hmset(String key, Map<String, String> map) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return false;
        }
        try {
            result = shardedJedis.hmset(key, map);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result == "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.hget(key, field);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.del(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(String key, String field) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.hdel(key, new String[]{field});
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> hvals(String key) {
        List result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.hvals(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        Map result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.hgetAll(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(String key, String string) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.rpush(key, new String[]{string});
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(String key, String string) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.lpush(key, new String[]{string});
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lLength(String key) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.llen(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listRange(String key, long start, long end) {
        List result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.lrange(key, start, end);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listTrim(String key, long start, long end) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.ltrim(key, start, end);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listIndex(String key, long index) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.lindex(key, index);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSet(String key, long index, String value) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.lset(key, index, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lrem(String key, long count, String value) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return result;
        }
        try {
            result = shardedJedis.lrem(key, count, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.lpop(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpop(String key) {
        String result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.rpop(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(String key, String ... member) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.sadd(key, member);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> smembers(String key) {
        Set result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return result;
        }
        try {
            result = shardedJedis.smembers(key);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(String key, String member) {
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        Long result = null;
        if (shardedJedis == null) {
            return null;
        }
        try {
            result = shardedJedis.srem(key, new String[]{member});
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hincrBy(String key, String field, long value) {
        Long result = null;
        ShardedJedis shardedJedis = this.redisDataSource.getRedisClient();
        if (shardedJedis == null) {
            return result;
        }
        try {
            result = shardedJedis.hincrBy(key, field, value);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            shardedJedis.close();
        }
        return result;
    }
}

