/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.sql;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.ReadOnlyMap;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class SqlType {
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Type>> TAllFields = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Type>> TBaseFields = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TBaseGetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TBaseSetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Type>> TCollectionFields = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TCollectionGetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TCollectionSetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Type>> TMapFields = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TMapGetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TMapSetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Type>> TObjectFields = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TObjectGetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> TObjectSetter = new ReadOnlyMap();
    private static final ArrayList<Class<?>> TypeBase = new ArrayList(0);
    private static final ArrayList<Class<?>> TypeNumeric = new ArrayList(0);

    public static void clearCache() {
        TAllFields.clear();
        TBaseFields.clear();
        TBaseGetter.clear();
        TBaseSetter.clear();
        TCollectionFields.clear();
        TCollectionGetter.clear();
        TCollectionSetter.clear();
        TMapFields.clear();
        TMapGetter.clear();
        TMapSetter.clear();
        TObjectFields.clear();
        TObjectGetter.clear();
        TObjectSetter.clear();
    }

    public static Map<String, Type> getFields(Class<?> clazz, FieldType fieldType) {
        ReadOnlyMap<Class<?>, ReadOnlyMap<String, Type>> pool;
        switch (fieldType) {
            case TBase: {
                pool = TBaseFields;
                break;
            }
            case TObject: {
                pool = TObjectFields;
                break;
            }
            case TCollection: {
                pool = TCollectionFields;
                break;
            }
            case TMap: {
                pool = TMapFields;
                break;
            }
            default: {
                pool = TAllFields;
            }
        }
        ReadOnlyMap<String, Type> fields = (ReadOnlyMap<String, Type>)pool.get(clazz);
        if (null != fields) {
            return fields;
        }
        fields = new ReadOnlyMap<String, Type>();
        Map<String, Method> setters = SqlType.getSetters(clazz, fieldType);
        Map<String, Method> getters = SqlType.getGetters(clazz, fieldType);
        for (String fieldName : setters.keySet()) {
            if (!getters.containsKey(fieldName)) continue;
            fields.put(fieldName, getters.get(fieldName).getGenericReturnType());
        }
        pool.put(clazz, fields);
        return fields;
    }

    public static Map<String, Method> getGetters(Class<?> clazz, FieldType fieldType) {
        return SqlType.getMethods(clazz, MethodType.MTGet, fieldType);
    }

    public static Map<String, Method> getSetters(Class<?> clazz, FieldType fieldType) {
        return SqlType.getMethods(clazz, MethodType.MTSet, fieldType);
    }

    public static boolean isTBase(Type type) {
        return TypeBase.contains(type) || Enum.class.isAssignableFrom(ReflectUtil.obtainClass(type));
    }

    public static boolean isTCollection(Type type) {
        Class<?> clazz2 = ReflectUtil.obtainClass(type);
        if (Collection.class.isAssignableFrom(clazz2)) {
            Type[] atas = ReflectUtil.getActualTypeArguments(type);
            if (atas.length == 1) {
                return ModelableImpl.class.isAssignableFrom((Class)atas[0]);
            }
            return false;
        }
        return false;
    }

    public static boolean isTObject(Type type) {
        return type instanceof Class && ModelableImpl.class.isAssignableFrom((Class)type);
    }

    private static Map<String, Method> getMethods(Class<?> clazz, MethodType methodType, FieldType fieldType) {
        ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> pool;
        Map<String, Method> allNeedMethods;
        block0 : switch (methodType) {
            case MTSet: {
                allNeedMethods = ReflectUtil.getAllSetters(clazz);
                switch (fieldType) {
                    case TBase: {
                        pool = TBaseSetter;
                        break block0;
                    }
                    case TObject: {
                        pool = TObjectSetter;
                        break block0;
                    }
                    case TCollection: {
                        pool = TCollectionSetter;
                        break block0;
                    }
                }
                return allNeedMethods;
            }
            case MTGet: {
                allNeedMethods = ReflectUtil.getAllGetters(clazz);
                switch (fieldType) {
                    case TBase: {
                        pool = TBaseGetter;
                        break block0;
                    }
                    case TObject: {
                        pool = TObjectGetter;
                        break block0;
                    }
                    case TCollection: {
                        pool = TCollectionGetter;
                        break block0;
                    }
                }
                return allNeedMethods;
            }
            default: {
                return null;
            }
        }
        ReadOnlyMap<String, Method> methods = (ReadOnlyMap<String, Method>)pool.get(clazz);
        if (null != methods) {
            return methods;
        }
        Map<String, Method> allSetMethods = ReflectUtil.getAllSetters(clazz);
        Map<String, Method> allGetMethods = ReflectUtil.getAllGetters(clazz);
        methods = new ReadOnlyMap<String, Method>();
        switch (fieldType) {
            case TBase: {
                for (String fieldName : allNeedMethods.keySet()) {
                    Method setter = allSetMethods.get(fieldName);
                    Method getter = allGetMethods.get(fieldName);
                    if (null == setter || null == getter) continue;
                    Type[] sType = setter.getGenericParameterTypes();
                    Type gType = getter.getGenericReturnType();
                    if (null == gType || null == sType || sType.length != 1 || !ReflectUtil.evaluateEqual(gType, sType[0]) || !SqlType.isTBase(gType)) continue;
                    methods.put(fieldName, allNeedMethods.get(fieldName));
                }
                break;
            }
            case TObject: {
                for (String fieldName : allNeedMethods.keySet()) {
                    Method setter = allSetMethods.get(fieldName);
                    Method getter = allGetMethods.get(fieldName);
                    if (null == setter || null == getter) continue;
                    Type[] sType = setter.getGenericParameterTypes();
                    Type gType = getter.getGenericReturnType();
                    if (null == gType || null == sType || sType.length != 1 || !ReflectUtil.evaluateEqual(gType, sType[0]) || !SqlType.isTObject(gType)) continue;
                    methods.put(fieldName, allNeedMethods.get(fieldName));
                }
                break;
            }
            case TCollection: {
                for (String fieldName : allNeedMethods.keySet()) {
                    Method setter = allSetMethods.get(fieldName);
                    Method getter = allGetMethods.get(fieldName);
                    if (null == setter || null == getter) continue;
                    Type[] sType = setter.getGenericParameterTypes();
                    Type gType = getter.getGenericReturnType();
                    if (null == gType || null == sType || sType.length != 1 || !ReflectUtil.evaluateEqual(gType, sType[0]) || !SqlType.isTCollection(gType)) continue;
                    methods.put(fieldName, allNeedMethods.get(fieldName));
                }
                break;
            }
            default: {
                return null;
            }
        }
        pool.put(clazz, methods);
        return methods;
    }

    static {
        TypeNumeric.add(Integer.TYPE);
        TypeNumeric.add(Long.TYPE);
        TypeNumeric.add(Double.TYPE);
        TypeNumeric.add(Float.TYPE);
        TypeNumeric.add(Boolean.TYPE);
        TypeNumeric.add(Short.TYPE);
        TypeNumeric.add(Character.TYPE);
        TypeNumeric.add(Byte.TYPE);
        TypeNumeric.add(Integer.class);
        TypeNumeric.add(Long.class);
        TypeNumeric.add(Double.class);
        TypeNumeric.add(Float.class);
        TypeNumeric.add(Boolean.class);
        TypeNumeric.add(Short.class);
        TypeNumeric.add(Character.class);
        TypeNumeric.add(Byte.class);
        TypeBase.addAll(TypeNumeric);
        TypeBase.add(String.class);
        TypeBase.add(Date.class);
    }
}

