/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.sql;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.core.util.StringHelper;
import cn.remex.db.DbCvo;
import cn.remex.db.exception.RsqlConnectionException;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.RsqlUtils;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.sql.AggregateFunction;
import cn.remex.db.sql.ColumnType;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.NamedParam;
import cn.remex.db.sql.Order;
import cn.remex.db.sql.SqlColumn;
import cn.remex.db.sql.SqlType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;

public class Select<T extends Modelable> {
    private Dialect dialect;
    private DbCvo<T> dbCvo;
    private String beanName;
    private String tableName;
    private String aliasName;
    private Param<Integer> tableIndex;
    private Param<Integer> paramIndex;
    private List<NamedParam> namedParams;
    private String prefix = "SELECT \r\n\t";
    private String part_from;
    private String part_where;
    private StringBuilder part_column_sb = new StringBuilder();
    private StringBuilder part_jion_sb = new StringBuilder();
    private StringBuilder part_groupby_sb = new StringBuilder("GROUP BY \r\n\t");
    private StringBuilder sqlString = new StringBuilder();

    public Select(DbCvo<T> dbCvo) {
        String string;
        Integer n;
        Integer n2;
        Param<Integer> param;
        if (dbCvo._getTableIndex() == null) {
            dbCvo._setTableIndex(new Param<Integer>(0));
        }
        if (dbCvo._getParamIndex() == null) {
            dbCvo._setParamIndex(new Param<Integer>(0));
        }
        if (dbCvo._getTableAliasName() == null) {
            param = dbCvo._getTableIndex();
            n2 = (Integer)param.param;
            param.param = (Integer)param.param + 1;
            n = param.param;
            dbCvo._setTableAliasName((dbCvo._getTableAliasName() == null ? "T" : dbCvo._getTableAliasName()) + n2);
        }
        if (dbCvo._getNamedParams() == null) {
            dbCvo._setNamedParams(new ArrayList<NamedParam>());
        }
        this.dbCvo = dbCvo;
        this.namedParams = dbCvo._getNamedParams();
        this.dialect = RDBManager.getLocalSpaceConfig(dbCvo._getSpaceName()).getDialect();
        this.tableIndex = dbCvo._getTableIndex();
        this.paramIndex = dbCvo._getParamIndex();
        this.beanName = this.dbCvo.getBeanName();
        this.tableName = this.dbCvo.getBeanName();
        if (dbCvo._getTableAliasName() == null) {
            param = this.tableIndex;
            n2 = (Integer)param.param;
            param.param = (Integer)param.param + 1;
            n = param.param;
            string = "T" + n2;
        } else {
            string = dbCvo._getTableAliasName();
        }
        this.aliasName = string;
        this.part_from = "\r\nFROM " + this.dialect.aliasTableName(this.tableName, this.aliasName);
        this.part_where = "\r\n  WHERE 1=1 \r\n";
    }

    @Deprecated
    public void appendBaseColumn(String fieldName, String fieldAlias) {
        this.part_column_sb.append(this.dialect.aliasFullName(this.aliasName, fieldName, fieldAlias)).append(",\r\n\t");
    }

    public void appendColumn(SqlColumn column) {
        String curAliasName;
        String string = curAliasName = null == column.getSupColumn() || null == column.getSupColumn().getFieldAliasName() ? this.aliasName : column.getSupColumn().getAliasName();
        if (column.isDistinct()) {
            this.part_column_sb.append(" DISTINCT ");
        }
        if (this.dbCvo._isHasAggregateBy() && column.getAggregateFunction() != null) {
            this.part_column_sb.append(this.dialect.aliasAggrFun(this.useAggregateFunction(curAliasName, column.getAggregateFunction(), column.getAggregateFunArgs(), column.getFieldName()), !Judgment.nullOrBlank(column.getAggregateAliasName()) ? column.getAggregateAliasName() : Select.aliasAggregateFunction(column.getAggregateFunction(), column.getFieldName())));
        } else if (this.dbCvo._isHasGroupBy() && column.isGroupBy()) {
            if (column.getGroupFunction() != null) {
                this.part_column_sb.append(column.getGroupFunction().toString()).append("(").append(curAliasName).append(".").append(this.dialect.openQuote()).append(column.getFieldName()).append(this.dialect.closeQuote());
                if (null != column.getGroupFunctionArgs()) {
                    for (Object arg : column.getGroupFunctionArgs()) {
                        this.part_column_sb.append(",").append(ReflectUtil.isNumeralType(arg.getClass()) ? arg : this.dialect.quoteAsString(arg.toString()));
                    }
                }
                this.part_column_sb.append(") ").append(this.dialect.openQuote()).append(Judgment.nullOrBlank(column.getGroupAliasName()) ? column.getFieldName() : column.getGroupAliasName()).append(this.dialect.closeQuote());
            } else {
                this.part_column_sb.append(this.dialect.aliasFullName(curAliasName, column.getFieldName(), Judgment.nullOrBlank(column.getGroupAliasName()) ? column.getFieldName() : column.getGroupAliasName()));
            }
        } else {
            this.part_column_sb.append(this.dialect.aliasFullName(curAliasName, column.getFieldName(), column.getFieldAliasName()));
        }
        this.part_column_sb.append(",\r\n\t");
    }

    public void leftJoinModel(SqlColumn column) {
        String filterStr;
        Class fieldClass = column.getNodeClass();
        String jioned_Tb = StringHelper.getClassSimpleName(fieldClass);
        Param<Integer> param = this.tableIndex;
        Integer n = (Integer)param.param;
        param.param = (Integer)param.param + 1;
        Integer n2 = param.param;
        String jioned_Tb_alias = StringHelper.getAbbreviation(fieldClass) + n;
        column.setTableName(jioned_Tb);
        column.setAliasName(jioned_Tb_alias);
        this.part_jion_sb.append("\r\nLEFT JOIN ").append(this.dialect.aliasTableName(jioned_Tb, jioned_Tb_alias)).append("\r\n\tON ").append(this.dialect.quoteFullName(jioned_Tb_alias, "id")).append("=").append(this.dialect.quoteFullName(null == column.getSupColumn() || null == column.getSupColumn().getFieldAliasName() ? this.aliasName : column.getSupColumn().getAliasName(), column.getFieldName())).append(" ");
        if (null != column.getOnFilter() && !Judgment.nullOrBlank((filterStr = column.getOnFilter().toSQL(false, column.getAliasName(), this.namedParams, this.paramIndex, this.tableIndex, this.dbCvo)).trim())) {
            this.part_jion_sb.append(" AND (").append(filterStr).append(") ");
        }
        if (null != column.getFilter() && !Judgment.nullOrBlank((filterStr = column.getFilter().toSQL(false, column.getAliasName(), this.namedParams, this.paramIndex, this.tableIndex, this.dbCvo)).trim())) {
            this.part_where = this.part_where + " AND (" + filterStr + ") ";
        }
        if (!this.dbCvo._isHasGroupBy() && !this.dbCvo._isSubStatment()) {
            this.part_column_sb.append(this.dialect.aliasFullName(jioned_Tb_alias, "id", column.obtainChain().toString() + "id")).append(",\r\n\t");
        }
    }

    public void leftJoinList(SqlColumn column) {
        String filterStr;
        Class fieldClass = column.getNodeClass();
        String jioned_Tb = StringHelper.getClassSimpleName(fieldClass);
        Param<Integer> param = this.tableIndex;
        Integer n = (Integer)param.param;
        param.param = (Integer)param.param + 1;
        Integer n2 = param.param;
        String jioned_Tb_alias = StringHelper.getAbbreviation(fieldClass) + n;
        column.setTableName(jioned_Tb);
        column.setAliasName(jioned_Tb_alias);
        Class<Object> parentClass = column.getSupColumn() == null ? this.dbCvo.getBeanClass() : column.getSupColumn().getNodeClass();
        String parentAlias = column.getSupColumn() == null || Judgment.nullOrBlank(column.getSupColumn().getAliasName()) ? this.aliasName : column.getSupColumn().getAliasName();
        OneToMany otm = ReflectUtil.getAnnotation(parentClass, column.getFieldName(), OneToMany.class);
        ManyToMany curMtm = ReflectUtil.getAnnotation(parentClass, column.getFieldName(), ManyToMany.class);
        if (otm != null) {
            this.part_jion_sb.append("\r\nLEFT JOIN ").append(this.dialect.aliasTableName(jioned_Tb, jioned_Tb_alias)).append("\r\n\tON ").append(this.dialect.quoteFullName(jioned_Tb_alias, otm.mappedBy())).append("=").append(this.dialect.quoteFullName(null == column.getSupColumn() || null == column.getSupColumn().getFieldAliasName() ? this.aliasName : column.getSupColumn().getAliasName(), "id")).append(" ");
        } else {
            String primaryBeanName = parentClass.getSimpleName();
            Class<Object> primaryBeanClass = parentClass;
            String primaryFieldName = column.getFieldName();
            Type primaryFieldType = column.getNodeType();
            Class<?> tgtBeanClass = ReflectUtil.getListActualType(column.getNodeType());
            boolean meIsManyToManyPrimary = true;
            String tgtMappedBy = null;
            String mappedBy = null;
            Map<String, Method> tcGetters = SqlType.getGetters(tgtBeanClass, FieldType.TCollection);
            if (curMtm != null && !Judgment.nullOrBlank(curMtm.mappedBy())) {
                mappedBy = curMtm.mappedBy();
                Assert.notNull(mappedBy, "ERROR", "\u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\u672c\u7c7b" + this.dbCvo.getBeanClass().getName() + "\u6ca1\u6709\u6307\u5b9a\u5bf9\u65b9\u7c7b\u591a\u5bf9\u591a\u5c5e\u6027:" + mappedBy, RsqlConnectionException.class);
                Assert.isTrue(tcGetters.containsKey(mappedBy), "ERROR", " \u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\u5bf9\u65b9\u7c7b" + tgtBeanClass.getName() + "\u4e0d\u5b58\u5728\u8be5\u591a\u5bf9\u591a\u5c5e\u6027:" + mappedBy, RsqlConnectionException.class);
                ManyToMany tgtMtm = ReflectUtil.getAnnotation(tgtBeanClass, mappedBy, ManyToMany.class);
                Assert.notNull(tgtMtm, "ERROR", "\u663e\u793a\u58f0\u660e\u591a\u5bf9\u591a\u65f6\uff0c\u9700\u8981\u53cc\u65b9\u6307\u5b9aManyToMany\u58f0\u660e\uff0c\u6b64\u5904\u5bf9\u65b9\u7c7b\u7684ManyToMany\u58f0\u660e\u4e3a\u7a7a\uff01\u8bf7\u66f4\u6b63\uff01", RsqlConnectionException.class);
                tgtMappedBy = tgtMtm.mappedBy();
                Assert.notNull(tgtMappedBy, "ERROR", "\u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\u5bf9\u65b9\u7c7b" + tgtBeanClass.getName() + "\u6ca1\u6709\u6307\u5b9a\u672c\u7c7b\u7684\u591a\u5bf9\u591a\u5c5e\u6027:" + mappedBy, RsqlConnectionException.class);
                Class curTe = curMtm.targetEntity();
                Class tgtTe = tgtMtm.targetEntity();
                Assert.isTrue(null == curTe && null == tgtTe || null != curTe && null != tgtTe, "ERROR", "\u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\uff0cManyToMany\u58f0\u660e\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6etargetEntity\u6216\u8005targetEntity\u540c\u65f6\u4e3a\u7a7a\uff01\u8bbe\u7f6etargetEntity\u7684\u4e3a\u4e3b\u7ef4\u62a4\u65b9\u3002" + mappedBy, RsqlConnectionException.class);
                boolean bl = meIsManyToManyPrimary = !"void".equals(curTe.toString());
            }
            if (!meIsManyToManyPrimary) {
                primaryBeanName = tgtBeanClass.getSimpleName();
                primaryBeanClass = tgtBeanClass;
                primaryFieldName = mappedBy;
                primaryFieldType = SqlType.getFields(primaryBeanClass, FieldType.TCollection).get(primaryFieldName);
            }
            Map<String, ColumnType> ctColumns = RsqlUtils.obtainListColumnFKColumnType(primaryBeanName, primaryFieldName, primaryFieldType);
            Iterator<Map.Entry<String, ColumnType>> ctkeys = ctColumns.entrySet().iterator();
            String Mid_Foreign_column = ctkeys.next().getKey();
            String Mid_Primary_column = ctkeys.next().getKey();
            String Mid_table_name = RsqlUtils.obtainListColumnFKTableName(this.dialect, primaryBeanName, primaryFieldName);
            Param<Integer> param2 = this.tableIndex;
            Integer n3 = (Integer)param2.param;
            param2.param = (Integer)param2.param + 1;
            Integer n4 = param2.param;
            String Mid_table_alias = StringHelper.getAbbreviation(parentClass) + "_" + StringHelper.getAbbreviation(tgtBeanClass) + "_" + n3;
            this.part_jion_sb.append("\n\rLEFT JOIN ").append(this.dialect.aliasTableName(Mid_table_name, Mid_table_alias)).append("\n\r\tON ").append(this.dialect.quoteFullName(Mid_table_alias, meIsManyToManyPrimary ? Mid_Primary_column : Mid_Foreign_column)).append("=").append(this.dialect.quoteFullName(parentAlias, "id")).append("\n\rLEFT JOIN ").append(this.dialect.aliasTableName(jioned_Tb, jioned_Tb_alias)).append("\n\r\tON ").append(this.dialect.quoteFullName(Mid_table_alias, meIsManyToManyPrimary ? Mid_Foreign_column : Mid_Primary_column)).append("=").append(this.dialect.quoteFullName(jioned_Tb_alias, "id"));
        }
        if (null != column.getOnFilter() && !Judgment.nullOrBlank((filterStr = column.getOnFilter().toSQL(false, column.getAliasName(), this.namedParams, this.paramIndex, this.tableIndex, this.dbCvo)).trim())) {
            this.part_jion_sb.append(" AND (").append(filterStr).append(") ");
        }
        if (null != column.getFilter() && !Judgment.nullOrBlank((filterStr = column.getFilter().toSQL(false, column.getAliasName(), this.namedParams, this.paramIndex, this.tableIndex, this.dbCvo)).trim())) {
            this.part_where = this.part_where + " AND (" + filterStr + ") ";
        }
        if (!this.dbCvo._isHasGroupBy() && !this.dbCvo._isSubStatment()) {
            this.part_column_sb.append(this.dialect.aliasFullName(jioned_Tb_alias, "id", column.obtainChain().toString() + "id")).append(",\r\n\t");
        }
    }

    public String sqlString() {
        String where = this.dbCvo.getFilter().toSQL(false, this.aliasName, this.namedParams, this.paramIndex, this.tableIndex, this.dbCvo);
        if (!Judgment.nullOrBlank(where.trim())) {
            this.part_where = this.part_where + " AND (" + where + ") ";
        }
        Assert.notNullAndEmpty(this.part_column_sb.toString(), "RSQL_SQL_ERROR", "\u8bed\u53e5\u4e2d\u6ca1\u6709\u6dfb\u52a0\u9700\u8981\u67e5\u8be2\u7684\u5217\uff0c\u5982\u679c\u662f\u7edf\u8ba1\u9884\u8ba1\u9700\u8981\u660e\u786e\u6307\u5b9a\u7edf\u8ba1\u54ea\u4e9b\u5b57\u6bb5");
        String part_column = this.part_column_sb.delete(this.part_column_sb.length() - 4, this.part_column_sb.length()).toString();
        String part_groupBy = this.dbCvo._isHasGroupBy() ? this.part_groupby_sb.delete(this.part_groupby_sb.length() - 4, this.part_groupby_sb.length()).toString() : "";
        this.sqlString.append(this.prefix).append(part_column).append(this.part_from).append(this.part_jion_sb.toString()).append(this.part_where).append(part_groupBy);
        ((ArrayList)this.namedParams).trimToSize();
        return this.sqlString.toString();
    }

    public void groupBy(SqlColumn column) {
        String curAliasName;
        String string = curAliasName = null == column.getSupColumn() || null == column.getSupColumn().getFieldAliasName() ? this.aliasName : column.getSupColumn().getAliasName();
        if (column.isGroupBy() && null != column.getGroupFunction()) {
            this.part_groupby_sb.append(column.getGroupFunction().toString()).append("(").append(curAliasName).append(".").append(this.dialect.openQuote()).append(column.getFieldName()).append(this.dialect.closeQuote());
            if (null != column.getGroupFunctionArgs()) {
                for (Object arg : column.getGroupFunctionArgs()) {
                    this.part_groupby_sb.append(",").append(ReflectUtil.isNumeralType(arg.getClass()) ? arg : this.dialect.quoteAsString(arg.toString()));
                }
            }
            this.part_groupby_sb.append("),\r\n\t");
        } else {
            this.part_groupby_sb.append(curAliasName).append(".").append(this.dialect.openQuote()).append(column.getFieldName()).append(this.dialect.closeQuote()).append(",\r\n\t");
        }
    }

    private String useAggregateFunction(String curAliasName, AggregateFunction fun, Object[] aggregateFunArgs, String fieldName) {
        String fixFildName = null;
        switch (fun) {
            case CASE_SUM: {
                if (aggregateFunArgs == null) break;
                StringBuilder fixStr = new StringBuilder("CASE " + curAliasName + "." + this.dialect.openQuote() + fieldName + this.dialect.openQuote() + " ");
                int repeatCount = aggregateFunArgs.length % 2 == 0 ? aggregateFunArgs.length : aggregateFunArgs.length - 1;
                for (int i = 0; i < repeatCount; ++i) {
                    fixStr.append(i % 2 == 0 ? "WHEN " : "THEN ").append("'").append(aggregateFunArgs[i]).append("' ");
                }
                if (aggregateFunArgs.length % 2 != 0) {
                    fixStr.append("ELSE ").append("'").append(aggregateFunArgs[aggregateFunArgs.length - 1]).append("' ");
                }
                fixStr.append("END");
                fixFildName = fixStr.toString();
                break;
            }
            default: {
                fixFildName = curAliasName + "." + this.dialect.openQuote() + fieldName + this.dialect.closeQuote();
            }
        }
        return fun.toString().replaceFirst("^[a-z|A-Z]+_", "") + "(" + fixFildName + ")";
    }

    public static String aliasAggregateFunction(AggregateFunction fun, String fieldName) {
        if (fun.toString().startsWith("Field_")) {
            return fieldName;
        }
        return fieldName + "$" + fun.toString();
    }

    public static <T extends Modelable> String obtainSQLOrder(DbCvo<T> cvo) {
        if (RsqlConstants.SqlOper.sql.equals((Object)cvo.getOper())) {
            return "";
        }
        List<Order> orders = cvo.getOrders();
        if (null == orders) {
            return "";
        }
        Dialect dialect = RDBManager.getLocalSpaceConfig(cvo._getSpaceName()).getDialect();
        StringBuilder result = new StringBuilder(" ORDER BY ");
        for (Order order : orders) {
            if (!order.isSortable()) continue;
            result.append(dialect.quoteKey(order.getSidx())).append(" ").append(order.getSord()).append(", ");
        }
        if (!cvo._isHasGroupBy()) {
            result.append(dialect.quoteFullName(cvo._getTableAliasName(), "id")).append(" DESC, ");
        }
        if (result.length() == " ORDER BY ".length()) {
            return "";
        }
        result.deleteCharAt(result.length() - 2);
        return result.toString();
    }
}

