/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.connection.dialect;

import cn.remex.db.exception.RsqlDialectException;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.sql.ColumnType;
import java.util.Map;

public class MysqlDialect
extends Dialect {
    @Override
    public String aliasFullName(String tableAliasName, String fieldName, String aliasName) {
        return tableAliasName + "." + this.openQuote() + fieldName + this.closeQuote() + " " + this.openQuote() + aliasName + this.closeQuote();
    }

    @Override
    public String aliasAggrFun(String fieldName, String aliasName) {
        return fieldName + " " + this.openQuote() + aliasName + this.closeQuote();
    }

    @Override
    public String obtainSelectRegex() {
        return "FROM\\s+\\" + this.openQuote() + "([\\w_0-9]+)\\" + this.closeQuote() + "\\s+[\\" + this.openQuote() + "]?([\\w_0-9]+)[\\" + this.closeQuote() + "]?";
    }

    @Override
    public String aliasTableName(String tableName, String aliasName) {
        return this.openQuote() + tableName + this.closeQuote() + " " + aliasName;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char closeStringQuote() {
        return '\'';
    }

    @Override
    public String concat(String ... strings) {
        StringBuffer sb = new StringBuffer("CONCAT(");
        int c = strings.length - 1;
        for (int i = 0; i < c; ++i) {
            sb.append(strings[i]).append(",");
        }
        return sb.append(strings[c]).append(")").toString();
    }

    @Override
    public String obtainPagingSQL(String sqlString, long start, long end, long rowCount) {
        StringBuilder sb = new StringBuilder(sqlString).append(" LIMIT ").append(start).append(",").append(rowCount);
        return sb.toString();
    }

    @Override
    public String obtainSQLSelectIndexs(String beanName) {
        return "SHOW Index from " + this.quoteKey(beanName);
    }

    @Override
    public String obtainSQLIndexNameField() {
        return "Key_name";
    }

    @Override
    public String obtainSQLSelectTableNames() {
        return "select table_name from information_schema.tables where table_schema in (select database() )";
    }

    @Override
    public String obtainSQLSelectTablesColumnNames(String tableName) {
        StringBuilder sqlString = new StringBuilder();
        sqlString.append("SELECT\n  t.COLUMN_NAME,\n  t.DATA_TYPE                DATA_TYPE,\n  t.CHARACTER_MAXIMUM_LENGTH DATA_LENGTH,\n  t.COLUMN_COMMENT           COMMENTS,\n  t.NUMERIC_PRECISION        DATA_PRECISION,\n  t.NUMERIC_SCALE            DATA_SCALE,\n  t.IS_NULLABLE              NULLABLE\nFROM information_schema.columns t\nWHERE table_schema IN (SELECT database()) AND table_name= " + this.quoteAsString(tableName));
        return sqlString.toString();
    }

    @Override
    public String obtainSQLTypeString(int type) {
        return this.obtainSQLTypeString(new ColumnType(type, -1));
    }

    @Override
    public String obtainSQLTypeString(ColumnType columnType) {
        String nullSql = columnType.nullable ? " NULL " : " NOT NULL ";
        switch (columnType.type) {
            case 2: {
                return " NUMERIC(" + columnType.length + "," + columnType.scale + ") " + nullSql;
            }
            case 4: {
                return " INTEGER " + nullSql;
            }
            case 8: {
                return " DOUBLE(" + columnType.length + "," + columnType.scale + ") " + nullSql;
            }
            case 6: {
                return " FLOAT(" + columnType.length + "," + columnType.scale + ") " + nullSql;
            }
            case 16: {
                return " VARCHAR(5) " + nullSql;
            }
            case -7: {
                return " BIT " + nullSql;
            }
            case 1: {
                return " VARCHAR(" + (columnType.length == -1 ? 600 : columnType.length) + ") " + nullSql;
            }
            case 91: {
                return " VARCHAR(20) " + nullSql;
            }
            case 2000: {
                return " VARCHAR(2000) " + nullSql;
            }
            case 2005: {
                return " TEXT " + nullSql;
            }
        }
        throw new RsqlDialectException("RSQL_DIALECT_ERROR", MysqlDialect.class + "\u4e2d\u4f7f\u7528\u4e86\u672a\u5b9a\u4e49\u7684SQLTypes!");
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public char openStringQuote() {
        return '\'';
    }

    @Override
    public String quoteAsString(Object value) {
        if (null == value) {
            return "null";
        }
        return "" + this.openStringQuote() + value + this.closeStringQuote();
    }

    @Override
    public String quoteFullName(String tableName, String fieldName) {
        return tableName + "." + this.openQuote() + fieldName + this.closeQuote();
    }

    @Override
    public String renameTableSql() {
        return "RENAME TABLE :oldTableName to :newTableName ";
    }

    @Override
    public String renameColumnSql() {
        return "alter table :tableName change :oldColumnName :newColumnName ";
    }

    @Override
    public String obtainCreateSerialNumberFunctionSQL() {
        String sql = "DELIMITER $$ \n DROP FUNCTION IF EXISTS `createSerialNumber`;\n CREATE FUNCTION `createSerialNumber`(beanName varchar(255), fieldName varchar(255)) RETURNS INTEGER\n BEGIN\n \tdeclare cv int;\n \tdeclare cnt int default 0;\n \t/*\u6700\u5927\u6570\u52a01*/\n \tUPDATE `SysSerialNumber` SET  `currentValue` =(SELECT @cv:= (`currentValue`+1)) where `beanName` = beanName and `fieldName` = fieldName LIMIT 1;\n     set cv =( select @cv);\n     set cnt = (select row_count());\n     if cnt = 0 then\n \t\tINSERT INTO `SysSerialNumber` (`id`,`beanName`,`fieldName`,`currentValue`) values(UUID(),beanName,fieldName,1) ;\n     end if;\n RETURN cv;\n END $$";
        return sql;
    }

    @Override
    public String obtainQuerySerialNumberFunctionSQL() {
        return "SELECT `createSerialNumber`(:beanName,:fieldName) from dual";
    }

    @Override
    public StringBuilder obtainDecodeSQL(Map<String, String> map, String decodeKey, String displayName) {
        StringBuilder sb = new StringBuilder("case ").append(decodeKey);
        for (String code : map.keySet()) {
            sb.append(" when ").append(this.quoteAsString(code)).append(" then ").append(this.quoteAsString(map.get(code)));
        }
        sb.append(" end ");
        if (displayName != null) {
            sb.append(this.quoteKey(displayName));
        }
        return sb;
    }

    @Override
    public String obtainCountSql(String sqlString) {
        return "SELECT FOUND_ROWS() AS count;";
    }

    @Override
    public String prepareSqlForCount(String sqlString) {
        return sqlString.replaceFirst("(SELECT)|(Select)|(select)\\s", "SELECT SQL_CALC_FOUND_ROWS ");
    }

    @Override
    public boolean needSetParamForCount() {
        return false;
    }

    @Override
    public boolean needLowCaseTableName() {
        return false;
    }
}

