/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.connection;

import cn.remex.core.CoreSvo;
import cn.remex.core.exception.NestedException;
import cn.remex.core.util.Assert;
import cn.remex.core.util.PackageUtil;
import cn.remex.db.exception.RsqlConnectionException;
import cn.remex.db.exception.RsqlException;
import cn.remex.db.exception.RsqlExecuteException;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.RsqlDefiner;
import cn.remex.db.rsql.connection.RDBSpaceConfig;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.rsql.transactional.RsqlTransaction;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class RDBManager {
    private static RDBManager instance;
    public static String DEFAULT_SPACE;
    private static HashMap<String, RDBSpaceConfig> spaceConfigs;
    private static final String RsqlTransactionFlag = "cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionFlag";
    private static final String RsqlUseBatchUpdateFlag = "cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlUseBatchUpdateFlag";
    private static final String RsqlAnnoFlag = "cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlAnnoFlag";
    private static final String RsqlTransactionLevelFlag = "cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag";
    private static final String RsqlTransactionConnectionFlag = "cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag";

    public static boolean isTransaction(String spaceName) {
        return null == CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionFlag#" + spaceName) ? false : (Boolean)CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionFlag#" + spaceName);
    }

    public static boolean isUseBatchUpdate(String spaceName) {
        Object usedBatchUpdateObj = CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlUseBatchUpdateFlag#" + spaceName);
        return null != usedBatchUpdateObj && (Boolean)usedBatchUpdateObj != false;
    }

    public static void beginTransactional(String spaceName, RsqlTransaction rsqlTranAnno) {
        RDBSpaceConfig spaceConfig = spaceConfigs.get(spaceName);
        Connection localCon = (Connection)CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag#" + spaceName);
        if (null == localCon) {
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName, 1);
            try {
                localCon = spaceConfig.getDataSource().getConnection();
            }
            catch (SQLException e) {
                throw new RsqlConnectionException("RSQL_CONNECTION_ERROR", "\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef", e);
            }
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag#" + spaceName, localCon);
        } else {
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName, (Integer)CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName) + 1);
        }
        if (RsqlConstants.isDebug) {
            RsqlConstants.logger.info((Object)("\u6570\u636e\u5e93\u4e8b\u52a1\u5f00\u59cb\uff0c\u5f53\u524d\u5c42\u7ea7:" + CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName) + ",\u6570\u636e\u7a7a\u95f4\uff1a" + spaceName));
        }
        try {
            localCon.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RsqlConnectionException("RSQL_CONNECTION_ERROR", "\u6570\u636e\u5e93\u4e8b\u52a1\u8bbe\u7f6e\u4e3a\u975e\u81ea\u52a8\u63d0\u4ea4\u5f02\u5e38", e);
        }
        CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionFlag#" + spaceName, true);
        if (null != rsqlTranAnno && rsqlTranAnno.useBatchUpdate()) {
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlUseBatchUpdateFlag#" + spaceName, rsqlTranAnno.useBatchUpdate());
        }
        if (RDBManager.isUseBatchUpdate(spaceName) && null == CoreSvo.valLocal(spaceName + "#BacthPerpareStatement")) {
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlAnnoFlag#" + spaceName, rsqlTranAnno);
            CoreSvo.putLocal(spaceName + "#BacthPerpareStatement", new HashMap());
        }
    }

    public static void finishTransactional(String spaceName) {
        block11: {
            int level;
            block10: {
                Connection localCon;
                if (RsqlConstants.isDebug) {
                    RsqlConstants.logger.debug((Object)("\u6b63\u5c1d\u8bd5\u63d0\u4ea4\u4e8b\u52a1(\u5c42\u7ea7\u7b49\u4e8e1\u624d\u771f\u6b63\u63d0\u4ea4)\uff0c\u5f53\u524d\u5c42\u7ea7:" + CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName) + ",\u6570\u636e\u7a7a\u95f4\uff1a" + spaceName));
                }
                boolean hasLocalCon = null != (localCon = (Connection)CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag#" + spaceName));
                level = (Integer)CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName);
                try {
                    if (hasLocalCon && level == 1) {
                        if (RDBManager.isUseBatchUpdate(spaceName)) {
                            HashMap batchPstmtMap = (HashMap)CoreSvo.valLocal(spaceName + "#BacthPerpareStatement");
                            batchPstmtMap.forEach((sqlHashCode, preparedStatement) -> {
                                try {
                                    if (RsqlConstants.isDebug) {
                                        RsqlConstants.logger.debug((Object)("\u6b63\u6267\u884cexecuteBatch\uff0csqlHashCode=" + sqlHashCode + ";batchSize=" + CoreSvo.valLocal(spaceName + "#BacthPerpareStatement#" + sqlHashCode + "#batchCount")));
                                    }
                                    preparedStatement.executeLargeBatch();
                                }
                                catch (SQLException e) {
                                    throw new RsqlExecuteException("RSQL_EXECUTE_ERROR", "\u6279\u5904\u7406\u6700\u540e\u4e00\u6279\u63d0\u4ea4\u5931\u8d25", e);
                                }
                            });
                            batchPstmtMap.clear();
                        }
                        if (RsqlConstants.isDebug) {
                            RsqlConstants.logger.debug((Object)("\u63d0\u4ea4\u4e8b\u52a1\uff0c\u5f53\u524d\u5c42\u7ea7:" + level + ",\u6570\u636e\u7a7a\u95f4\uff1a" + spaceName));
                        }
                        localCon.commit();
                        localCon.setAutoCommit(true);
                        localCon.close();
                        CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag#" + spaceName, null);
                    }
                    if (level != 1) break block10;
                }
                catch (Exception e) {
                    try {
                        throw new RsqlConnectionException("RSQL_CONNECTION_ERROR", "\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25", e);
                    }
                    catch (Throwable throwable) {
                        if (level == 1) {
                            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName, 1);
                            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionFlag#" + spaceName, false);
                            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlUseBatchUpdateFlag#" + spaceName, false);
                        } else {
                            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName, level > 1 ? --level : 1);
                        }
                        throw throwable;
                    }
                }
                CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName, 1);
                CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionFlag#" + spaceName, false);
                CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlUseBatchUpdateFlag#" + spaceName, false);
                break block11;
            }
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName, level > 1 ? --level : 1);
        }
    }

    public static void abortTransactional(Throwable ex, String spaceName) {
        Connection con = null;
        try {
            try {
                con = (Connection)CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag#" + spaceName);
                if (con != null) {
                    con.rollback();
                    con.setAutoCommit(true);
                }
                if (RsqlConstants.isDebug) {
                    RsqlConstants.logger.info((Object)("\u6570\u636e\u5e93\u4e8b\u52a1\u56de\u6eda\uff08\u65e0\u8bba\u4e8b\u52a1\u662f\u5426\u5d4c\u5957\uff0c\u6574\u4e2a\u4e8b\u52a1\u5b8c\u5168\u56de\u6eda\uff09\uff01\u5f53\u524d\u5c42\u7ea7:" + CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionLevelFlag#" + spaceName) + ",\u6570\u636e\u5e93\u6c60\uff1a" + spaceName));
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new NestedException("RSQL_CONNECTION_ERROR", "\u6570\u636e\u5e93\u4e8b\u52a1\u4e2d\u51fa\u73b0\u975e\u67b6\u6784\u5f02\u5e38", ex);
            }
            catch (SQLException e) {
                throw new RsqlConnectionException("RSQL_CONNECTION_ERROR", "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff0c\u540c\u65f6\u56de\u6eda\u64cd\u4f5c\u4e5f\u5931\u8d25\uff01" + e.toString(), ex);
            }
        }
        catch (Throwable throwable) {
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionFlag#" + spaceName, false);
            if (null != con) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag#" + spaceName, null);
            throw throwable;
        }
    }

    public static void commitTransactional(String spaceName) {
        Object useBatch = CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlUseBatchUpdateFlag#" + spaceName);
        RDBManager.finishTransactional(spaceName);
        CoreSvo.putLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlUseBatchUpdateFlag#" + spaceName, useBatch);
        RDBManager.beginTransactional(spaceName, null);
    }

    public static void freeLocalConnection(String spaceName, Connection con) {
        if (!RDBManager.isTransaction(spaceName)) {
            try {
                con.close();
            }
            catch (SQLException e) {
                throw new RsqlConnectionException("RSQL_CONNECTION_ERROR", "\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef", e);
            }
        }
    }

    public static Connection getLocalConnection(String spaceName) {
        RDBSpaceConfig pool = spaceConfigs.get(spaceName);
        if (RDBManager.isTransaction(spaceName)) {
            Connection localCon = (Connection)CoreSvo.valLocal("cn.remex.db.rsql.transactional.RsqlTransactionalManager.RsqlTransactionConnectionFlag#" + spaceName);
            Assert.notNull(localCon, "RSQL_CONNECTION_ERROR", "\u521d\u59cb\u5316\u4e8b\u52a1\u65f6\u6ca1\u6709\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", RsqlConnectionException.class);
            return localCon;
        }
        try {
            return pool.getDataSource().getConnection();
        }
        catch (SQLException e) {
            throw new RsqlConnectionException("RSQL_CONNECTION_ERROR", "\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef", e);
        }
    }

    static void createSpace(RDBSpaceConfig spaceConfig) {
        (null != instance ? instance : new RDBManager()).createSpace(spaceConfig, false);
    }

    public static RDBSpaceConfig getLocalSpaceConfig() {
        return spaceConfigs.get(DEFAULT_SPACE);
    }

    public static RDBSpaceConfig getLocalSpaceConfig(String spaceName) {
        return spaceConfigs.get(spaceName);
    }

    public static synchronized void reset(boolean rebuildDB) {
        if (null != instance) {
            RDBManager.destroy();
        }
        instance = new RDBManager();
        for (RDBSpaceConfig spaceConfig : spaceConfigs.values()) {
            instance.createSpace(spaceConfig, rebuildDB && !spaceConfig.isCannotRebuild());
        }
    }

    public static synchronized void destroy() {
    }

    private RDBManager() {
    }

    private void createSpace(RDBSpaceConfig spaceConfig, boolean rebuildDB) {
        HashMap<String, Class<? extends Modelable>> ormBeans = new HashMap<String, Class<? extends Modelable>>();
        RsqlConstants.logger.info((Object)("\u6570\u636e\u5e93\u7a7a\u95f4\u3010" + spaceConfig.getSpaceName() + "\u3011\u521d\u59cb\u5316\u4e2d,cn.remex\u4e0b\u5c5e\u6240\u6709\u7684\u5305\u90fd\u9ed8\u8ba4\u6dfb\u52a0\u5230ORMBeans\u4e2d..."));
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(spaceConfig.getOrmBeanPackages());
        list.add("cn.remex");
        for (String pkg : list) {
            Set<Class<?>> orbs = PackageUtil.getClasses(pkg);
            for (Class<?> c : orbs) {
                String cn = c.getSimpleName();
                String fn = c.getName();
                if (!Modelable.class.isAssignableFrom(c)) continue;
                if (ormBeans.get(cn) != null) {
                    RsqlConstants.logger.error((Object)("ORMBeans \u7684\u5305\u4e2d\u6709\u91cd\u590d\u7c7b\u7b80\u540d\u7684\u7c7b\uff0c\u56e0\u6570\u636e\u5e93\u5efa\u8868\u8868\u660e\u65e0\u6cd5\u91cd\u590d\uff0c\u8fd9\u79cd\u60c5\u51b5\u662f\u4e0d\u5141\u8bb8\u7684\uff01,\u6b64\u7c7b\u5c06\u88ab\u5ffd\u7565\uff0c\u5176\u540d\u4e3a" + fn));
                    continue;
                }
                if (fn.indexOf(36) > 0) {
                    RsqlConstants.logger.warn((Object)("ORMBeans \u7684\u5305\u4e2d\u6709inner\u7c7b\uff0c\u4e0d\u5efa\u8bae\u5728\u6570\u636e\u6a21\u578b\u7c7b\u4e2d\u4f7f\u7528\u8fd9\u79cd\u7c7b\u578b\u5e76\u6301\u4e45\u5316\uff01\u60a8\u4f9d\u7136\u53ef\u4ee5\u4f7f\u7528\u8be5\u7c7b\u7f16\u7a0b\uff0c\u4f46\u6570\u636e\u5e93\u5efa\u6a21\u4e2d\u5c06\u5ffd\u7565\u6b64\u7c7b\uff0c\u5176\u540d\u4e3a" + fn));
                    continue;
                }
                if (Modifier.isAbstract(c.getModifiers())) {
                    RsqlConstants.logger.info((Object)("\u5728\u6570\u636e\u5e93\u5efa\u6a21package\u4e2d\u53d1\u73b0\u4e00\u4e2a\u62bd\u8c61\u7c7b" + fn + "\u5c06\u88ab\u5ffd\u7565!"));
                    continue;
                }
                if (c.isInterface()) {
                    RsqlConstants.logger.info((Object)("\u5728\u6570\u636e\u5e93\u5efa\u6a21package\u4e2d\u53d1\u73b0\u4e00\u4e2a\u63a5\u53e3" + fn + "\u5c06\u88ab\u5ffd\u7565!"));
                    continue;
                }
                ormBeans.put(cn, c);
            }
        }
        spaceConfig.setOrmBeans(ormBeans);
        try {
            if (rebuildDB) {
                RsqlDefiner.refreshORMBaseTables(spaceConfig);
                RsqlDefiner.refreshORMCollectionTables(spaceConfig);
                RsqlDefiner.refreshORMConstraints(spaceConfig);
            }
        }
        catch (NestedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RsqlException("RSQL_INIT_ERROR", "\u521d\u59cb\u5316\u6570\u636e\u5e93\u9519\u8bef\uff01", e);
        }
        spaceConfigs.put(spaceConfig.getSpaceName(), spaceConfig);
    }

    static {
        DEFAULT_SPACE = "default";
        spaceConfigs = new HashMap();
    }
}

