/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql;

import cn.remex.core.exception.InvalidCharacterException;
import cn.remex.core.reflect.ReflectFeatureStatus;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Param;
import cn.remex.db.Container;
import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.appbeans.BeanVo;
import cn.remex.db.appbeans.MapVo;
import cn.remex.db.lambdaapi.ColumnPredicate;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.rsql.sqlutil.Node;
import cn.remex.db.rsql.sqlutil.ReslutList;
import cn.remex.db.sql.AggregateFunction;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.Select;
import cn.remex.db.sql.SqlType;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RsqlRvo<T extends Modelable>
extends DbRvo<T> {
    private static final long serialVersionUID = 3568677065938784490L;
    private static Pattern simpleChian = Pattern.compile("([_\\w\u4e00-\u9fa5]+\\.)+([_\\w\u4e00-\u9fa5]+)");
    private Class<T> beanClass;
    private int effectRowCount;
    private String id = null;
    private Map<Integer, Map<String, List<List<Object>>>> mapRowsCache;
    private boolean OK = false;
    private int pagination;
    private int recordCount;
    private int rowCount;
    private List<List<Object>> rows;
    private DbCvo<T> rsqlCvo;
    private List<String> titles;

    private RsqlRvo(DbCvo<T> rsqlCvo) {
        this.rsqlCvo = rsqlCvo;
        if (null != rsqlCvo) {
            this.beanClass = rsqlCvo.getBeanClass();
        }
    }

    public static <T extends Modelable> RsqlRvo<T> create(DbCvo<T> dbCvo) {
        return new RsqlRvo<T>(dbCvo);
    }

    public DbCvo<T> _getRsqlCvo() {
        return this.rsqlCvo;
    }

    public boolean isOK() {
        return this.OK;
    }

    public List<T> obtainBeansNew(Class<T> clazz) {
        ArrayList list = new ArrayList();
        if (this.rows == null) {
            return list;
        }
        Node rootNode = new Node(clazz);
        this.titles.forEach(t -> rootNode.addIndex((String)t));
        return list;
    }

    public void saveData(ResultSet rs, DbCvo<T> dbCvo) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        this.titles = new ArrayList<String>();
        for (int m = 0; m < columnCount; ++m) {
            this.titles.add(rsmd.getColumnLabel(m + 1));
        }
        this.rows = new ArrayList<List<Object>>(dbCvo.getRowCount());
        while (rs.next()) {
            ArrayList<Object> currentRow = new ArrayList<Object>(this.titles.size());
            for (int m = 1; m <= columnCount; ++m) {
                int ct = rsmd.getColumnType(m);
                Object value = null;
                value = ct == 2005 ? RsqlRvo.getClobColumn(rs, m) : rs.getObject(m);
                currentRow.add(value);
            }
            if (dbCvo._isRowConsumer()) {
                if (null == dbCvo.getRowConsumer()) continue;
                dbCvo.getRowConsumer().accept(currentRow);
                continue;
            }
            this.rows.add(currentRow);
        }
        this.setRowCount(dbCvo.getRowCount());
        this.setEffectRowCount(this.rows.size());
        if (this.getRecordCount() == 0) {
            this.setRecordCount(this.getEffectRowCount());
        }
        this.setPagination(dbCvo.getPagination());
    }

    private static String getClobColumn(ResultSet rs, int columnIndex) {
        try {
            int c;
            Clob clob = rs.getClob(columnIndex);
            if (null == clob) {
                return "null";
            }
            StringBuilder ret = new StringBuilder();
            Reader is = clob.getCharacterStream();
            if (null == is) {
                return "null";
            }
            char[] cbuf = new char[256];
            while ((c = is.read(cbuf)) > 0) {
                ret.append(cbuf, 0, c);
            }
            return ret.toString();
        }
        catch (Exception e) {
            return "\u53d1\u751f\u5f02\u5e38\uff0c\u65e0\u6cd5\u8bfb\u53d6CLOB\u7684\u5185\u5bb9\uff01";
        }
    }

    @Deprecated
    private void setValue(String poolName, Class<?> clazz, String expr, Object targetbean, Object value, int rowIndex, ReflectFeatureStatus status) {
        if (null == value || "RN".equals(expr) || expr.startsWith("RMX_")) {
            return;
        }
        Method setter = SqlType.getSetters(clazz, FieldType.TBase).get(expr);
        if (null != setter) {
            ReflectUtil.invokeSetterWithDefaultTypeCoventer(targetbean, setter, value, status);
            return;
        }
        setter = SqlType.getSetters(clazz, FieldType.TObject).get(expr);
        if (null != setter) {
            Object pk = value;
            Class fieldType = (Class)SqlType.getFields(clazz, FieldType.TObject).get(expr);
            Object objectValue = ReflectUtil.invokeMethod(SqlType.getGetters(clazz, FieldType.TObject).get(expr), targetbean, new Object[0]);
            if (null == objectValue && !"-1".equals(pk)) {
                objectValue = this.rsqlCvo.getContainer().createDBBean(fieldType);
                ((Modelable)objectValue)._setDataStatus("part");
                ((Modelable)objectValue).setId(pk.toString());
            }
            ReflectUtil.invokeMethod(setter, targetbean, objectValue);
            return;
        }
        Matcher matcher = simpleChian.matcher(expr);
        if (matcher.find()) {
            String exprNext;
            int idx = expr.indexOf(46);
            String exprHead = expr.substring(0, idx);
            Object beanHead = ReflectUtil.invokeMethod(SqlType.getGetters(clazz, FieldType.TObject).get(exprHead), targetbean, new Object[0]);
            if (null == beanHead) {
                Object beanHeadId = this.getCell(rowIndex, exprHead + ".id");
                beanHeadId = null == beanHeadId ? "-1" : beanHeadId;
                this.setValue(poolName, clazz, exprHead, targetbean, beanHeadId, rowIndex, status);
                beanHead = ReflectUtil.invokeGetter(exprHead, targetbean);
            }
            if ((exprNext = expr.substring(idx + 1)).length() > 0) {
                Class fieldType = (Class)SqlType.getFields(clazz, FieldType.TObject).get(exprHead);
                if (null != beanHead) {
                    this.setValue(poolName, fieldType, exprNext, beanHead, value, rowIndex, status);
                }
            }
        } else {
            throw new InvalidCharacterException("\u542b\u6709\u65e0\u6548\u5b57\u7b26" + expr + "\uff0c\u65e0\u6cd5\u4e3abean\u8bbe\u7f6evalue");
        }
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Object getCell(int rowNO, int columnNO) {
        if (null != this.rows && null != this.titles && columnNO < this.titles.size()) {
            return this.rows.get(rowNO).get(columnNO);
        }
        return null;
    }

    @Override
    public Object getCell(int rowNO, ColumnPredicate<T> cp, AggregateFunction aggregateFunction) {
        Param<Object> fieldNameParam = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> cp.init((Modelable)bean), fieldName -> {
            fieldNameParam.param = fieldName;
            Object cfr_ignored_0 = fieldNameParam.param;
        });
        return this.getCell(rowNO, Select.aliasAggregateFunction(aggregateFunction, (String)fieldNameParam.param));
    }

    @Override
    public Object getCell(int rowNO, ColumnPredicate<T> cp) {
        Param<Object> fieldNameParam = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> cp.init((Modelable)bean), fieldName -> {
            fieldNameParam.param = fieldName;
            Object cfr_ignored_0 = fieldNameParam.param;
        });
        return this.getCell(rowNO, (String)fieldNameParam.param);
    }

    @Override
    public Object getCell(int rowIndex, String needColumnName) {
        int index = this.getTitleIndex(needColumnName);
        if (index < 0) {
            return null;
        }
        return this.rows.get(rowIndex).get(index);
    }

    @Override
    public List<Object> getCells(int columnIndex, String columnValue, int needColumnIndex) {
        List<List<Object>> rows = this.getRows(columnIndex, columnValue);
        ArrayList<Object> cells = new ArrayList<Object>();
        if (needColumnIndex >= 0 && null != rows) {
            for (List<Object> row : rows) {
                cells.add(row.get(needColumnIndex));
            }
        }
        cells.trimToSize();
        return cells;
    }

    @Override
    public List<Object> getCells(int columnIndex, String columnValue, String needColumnName) {
        return this.getCells(columnIndex, columnValue, this.getTitleIndex(needColumnName));
    }

    @Override
    public List<Object> getCells(String columnName, String columnValue, int needColumnIndex) {
        return this.getCells(this.getTitleIndex(columnName), columnValue, needColumnIndex);
    }

    @Override
    public List<Object> getCells(String columnName, String columnValue, String needColumnName) {
        return this.getCells(this.getTitleIndex(columnName), columnValue, this.getTitleIndex(needColumnName));
    }

    @Override
    public List<Object> getCells(ColumnPredicate<T> cp, String columnValue, ColumnPredicate<T> needColumnNameCp, AggregateFunction aggregateFunction) {
        Param<Object> columnName = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> cp.init((Modelable)bean), fieldName -> {
            columnName.param = fieldName;
            Object cfr_ignored_0 = columnName.param;
        });
        Param<Object> needColumnName = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> cp.init((Modelable)bean), fieldName -> {
            needColumnName.param = fieldName;
            Object cfr_ignored_0 = needColumnName.param;
        });
        return this.getCells(this.getTitleIndex((String)columnName.param), columnValue, this.getTitleIndex(Select.aliasAggregateFunction(aggregateFunction, (String)needColumnName.param)));
    }

    @Override
    public Object getCell(ColumnPredicate<T> columnCp, String columnValue, ColumnPredicate<T> needColumnNameCp, AggregateFunction aggregateFunction) {
        Param<Object> columnName = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> columnCp.init((Modelable)bean), fieldName -> {
            columnName.param = fieldName;
            Object cfr_ignored_0 = columnName.param;
        });
        Param<Object> needColumnName = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> needColumnNameCp.init((Modelable)bean), fieldName -> {
            needColumnName.param = fieldName;
            Object cfr_ignored_0 = needColumnName.param;
        });
        return this.getCells(this.getTitleIndex((String)columnName.param), columnValue, this.getTitleIndex(Select.aliasAggregateFunction(aggregateFunction, (String)needColumnName.param))).get(0);
    }

    @Override
    public List<Object> getColumn(int index) {
        ArrayList<Object> column = new ArrayList<Object>();
        int curCount = this.getEffectRowCount();
        for (int i = 0; i < curCount; ++i) {
            column.add(this.getCell(i, index));
        }
        column.trimToSize();
        return column;
    }

    @Override
    public List<T> getColumn(int index, Class<T> clazz) {
        ArrayList<Modelable> column = new ArrayList<Modelable>();
        int curCount = this.getEffectRowCount();
        for (int i = 0; i < curCount; ++i) {
            column.add((Modelable)ReflectUtil.caseObject(clazz, this.getCell(i, index), new Object[0]));
        }
        column.trimToSize();
        return column;
    }

    @Override
    public List<Object> getColumn(String needColumnName) {
        int index = this.getTitleIndex(needColumnName);
        if (index < 0) {
            return null;
        }
        return this.getColumn(index);
    }

    @Override
    public int getEffectRowCount() {
        return this.effectRowCount;
    }

    @Override
    public List<Map<String, Object>> getGridData() {
        return this.getMapRows();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public TreeMap<String, String> getMapFromColumns(String keyColumn, String valueColumn) {
        return this.getMapFromColumns(keyColumn, valueColumn, null, null);
    }

    @Override
    public TreeMap<String, String> getMapFromColumns(ColumnPredicate<T> keyCp, ColumnPredicate<T> valueCp, AggregateFunction valueAggregateFunction) {
        Param<Object> keyParam = new Param<Object>(null);
        Param<Object> valueParam = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> keyCp.init((Modelable)bean), fieldName -> {
            keyParam.param = fieldName;
            Object cfr_ignored_0 = keyParam.param;
        });
        ReflectUtil.eachFieldWhenGet(this.rsqlCvo.getBeanClass(), bean -> valueCp.init((Modelable)bean), fieldName -> {
            valueParam.param = fieldName;
            Object cfr_ignored_0 = valueParam.param;
        });
        return this.getMapFromColumns((String)keyParam.param, Select.aliasAggregateFunction(valueAggregateFunction, (String)valueParam.param));
    }

    @Override
    public TreeMap<String, String> getMapFromColumns(String keyColumn, String valueColumn, String restrainColumn, String restrainValue) {
        int keyIndex = this.getTitleIndex(keyColumn);
        int valueIndex = this.getTitleIndex(valueColumn);
        if (keyIndex < 0 || valueIndex < 0) {
            return null;
        }
        List<List<Object>> curRows = null == restrainColumn && null == restrainValue ? this.rows : this.getRows(restrainColumn, restrainValue);
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (null != curRows) {
            for (List<Object> row : curRows) {
                map.put(String.valueOf(row.get(keyIndex)), String.valueOf(row.get(valueIndex)));
            }
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getMapRows() {
        if (null == this.rows) {
            return new ArrayList<Map<String, Object>>();
        }
        ReslutList<Map<String, Object>> alist = new ReslutList<Map<String, Object>>();
        boolean hasBeanClass = null != this.beanClass;
        Map<String, Type> fields = hasBeanClass ? SqlType.getFields(this.beanClass, FieldType.TObject) : null;
        HashMap<String, Integer> objectFields = new HashMap<String, Integer>(4);
        int size = this.titles.size();
        for (int tIdx = 0; tIdx < size; ++tIdx) {
            String title = this.titles.get(tIdx);
            if (!hasBeanClass || !fields.containsKey(title)) continue;
            objectFields.put(title, tIdx);
        }
        for (List<Object> row : this.rows) {
            HashMap<String, Object> tcMap = new HashMap<String, Object>();
            int idx = 0;
            for (String title : this.titles) {
                if (objectFields.containsKey(title)) {
                    HashMap<String, Object> objMap = new HashMap<String, Object>(4);
                    objMap.put("id", row.get(idx++));
                    objMap.put("_dataStatus", "part");
                    tcMap.put(title, objMap);
                    continue;
                }
                tcMap.put(title, row.get(idx++));
            }
            alist.add(tcMap);
        }
        alist.trimToSize();
        return alist;
    }

    @Override
    public int getPagination() {
        return this.pagination;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public int getRecords() {
        return this.getRecordCount();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public List<List<Object>> getRows() {
        return this.rows;
    }

    @Override
    public List<List<Object>> getRows(int columnIndex, String columnValue) {
        if (columnIndex < 0) {
            return null;
        }
        if (null == this.mapRowsCache) {
            this.mapRowsCache = new HashMap<Integer, Map<String, List<List<Object>>>>();
        }
        Map<String, List<List<Object>>> curMapRowsCache = this.mapRowsCache.get(columnIndex);
        String curKey = columnIndex + "_" + columnValue;
        if (null != curMapRowsCache) {
            List<List<Object>> needRows = curMapRowsCache.get(curKey);
            return needRows == null || needRows.size() == 0 ? null : needRows;
        }
        curMapRowsCache = new HashMap<String, List<List<Object>>>();
        this.mapRowsCache.put(columnIndex, curMapRowsCache);
        for (List<Object> row : this.rows) {
            Object v = row.get(columnIndex);
            String cycKey = columnIndex + "_" + v;
            List<List<Object>> cycRows = curMapRowsCache.get(cycKey);
            if (cycRows == null) {
                cycRows = new ArrayList<List<Object>>();
                curMapRowsCache.put(cycKey, cycRows);
            }
            cycRows.add(row);
            cycRows = null;
            cycKey = null;
        }
        List<List<Object>> needRows = curMapRowsCache.get(curKey);
        return needRows == null || needRows.size() == 0 ? null : needRows;
    }

    @Override
    public List<List<Object>> getRows(String columnName, String columnValue) {
        return this.getRows(this.getTitleIndex(columnName), columnValue);
    }

    @Override
    public int getTitleIndex(String columnName) {
        int i;
        columnName = columnName.toLowerCase();
        int max = 0;
        max = this.titles.size();
        for (i = 0; i < max && !this.titles.get(i).toLowerCase().equals(columnName); ++i) {
        }
        return i == max ? -1 : i;
    }

    @Override
    public List<String> getTitles() {
        return this.titles;
    }

    @Override
    public Map<String, String> getUserData() {
        return new HashMap<String, String>();
    }

    @Override
    public void assignRow(T bean) {
        Class<?> clazz = bean.getClass();
        this.obtainBeans(clazz, true, bean);
    }

    @Override
    public T obtainBean() {
        List<T> beans = this.obtainBeans();
        return (T)(beans.size() > 0 ? (Modelable)beans.get(0) : null);
    }

    @Override
    public List<T> obtainBeans() {
        List<Object> a = this.obtainBeans(this.beanClass, true, null);
        return a;
    }

    @Override
    public Map<String, String> obtainMap(String keyColumn, String valueColumn) {
        return this.getMapFromColumns(keyColumn, valueColumn);
    }

    @Override
    public Map<String, String> obtainMap(String keyColumn, String valueColumn, String restrainColumn, String restrainValue) {
        return this.getMapFromColumns(keyColumn, valueColumn, restrainColumn, restrainValue);
    }

    @Override
    public <O> List<O> obtainObjects(Class<O> clazz) {
        return this.obtainBeans(clazz, false, null);
    }

    @Override
    public Map<String, T> obtainObjectsMap(String columnName, Class<T> clazz) {
        List<T> beans = this.obtainObjects((Class)clazz);
        HashMap<String, Modelable> ret = new HashMap<String, Modelable>();
        for (Modelable bean : beans) {
            ret.put(ReflectUtil.invokeGetter(columnName, bean).toString(), bean);
        }
        return ret;
    }

    @Override
    public Map<String, T> obtainObjectsMap(String columnName) {
        List<T> beans = this.obtainObjects((Class)this.beanClass);
        HashMap<String, Modelable> ret = new HashMap<String, Modelable>();
        for (Modelable bean : beans) {
            ret.put(ReflectUtil.invokeGetter(columnName, bean).toString(), bean);
        }
        return ret;
    }

    public void setBeanClass(Class<T> beanClass) {
        this.beanClass = beanClass;
    }

    public void setEffectRowCount(int effectRowCount) {
        this.effectRowCount = effectRowCount;
    }

    public void setId(String id) {
        this.id = id;
    }

    private <O> List<O> obtainBeans(Class<O> clazz, boolean returnModel, O targetBean) {
        if (this.rows == null) {
            return new ArrayList();
        }
        this.rsqlCvo.getContainer().setLocalAutoStoreObjectFlied(false);
        this.rsqlCvo.getContainer().setLocalAutoFecthObjectFiled(false);
        ArrayList<O> list = new ArrayList<O>();
        int rowCount = this.rows.size();
        int columnCount = this.titles.size();
        Container spaceConfig = this.rsqlCvo.getContainer();
        Method method = ReflectUtil.getMethod(Container.class, "createDBBean", Class.class);
        boolean isModel = Modelable.class.isAssignableFrom(clazz);
        boolean _returnModel = returnModel && isModel;
        Node rootNode = new Node(clazz);
        this.titles.forEach(title -> rootNode.addIndex((String)title));
        HashMap<String, O> map = new HashMap<String, O>();
        boolean needAdd = true;
        for (int i = 0; i < rowCount; ++i) {
            Object bean;
            List<Object> row = this.rows.get(i);
            if (null != targetBean) {
                bean = targetBean;
            } else {
                bean = map.get(this.getCell(i, "id"));
                needAdd = null == bean;
                if (needAdd) {
                    if (_returnModel) {
                        O bean1 = this.rsqlCvo.getContainer().createDBBean(clazz);
                        bean = bean1;
                    } else {
                        bean = ReflectUtil.invokeNewInstance(clazz);
                    }
                    map.put(String.valueOf(this.getCell(i, "id")), bean);
                }
            }
            if (isModel) {
                ((ModelableImpl)bean)._setDbRvo(this);
                ((ModelableImpl)bean)._setRowNo(i);
            }
            if (returnModel) {
                rootNode.start(bean, this, i, this.rsqlCvo.getContainer(), method);
            } else {
                rootNode.start(bean, this, i, null, null);
            }
            for (int j = 0; j < columnCount; ++j) {
                String expr = this.titles.get(j);
                Object value = row.get(j);
                if (null == value || "RN".equals(expr) || expr.startsWith("RMX_")) continue;
                rootNode.eval(expr, value);
            }
            rootNode.evalEnd();
            if (_returnModel) {
                ((Modelable)bean)._setDataStatus(this.rsqlCvo._getRootColumn().hasAnyColumn() ? "part" : "managed");
            }
            if (null != targetBean) {
                return list;
            }
            if (!needAdd) continue;
            list.add(bean);
        }
        list.trimToSize();
        this.rsqlCvo.getContainer().setLocalAutoStoreObjectFlied(true);
        this.rsqlCvo.getContainer().setLocalAutoFecthObjectFiled(true);
        return list;
    }

    protected void setPagination(int pageCount) {
        this.pagination = pageCount;
    }

    protected void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    protected void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public <M extends Modelable> List<M> obtainBeans(Class<M> modelClass) {
        return this.obtainBeans(modelClass, true, null);
    }

    @Override
    public List<?> obtainObjects() {
        List<T> list = this.obtainObjects((Class)this.beanClass);
        return list;
    }

    @Override
    public BeanVo<T> obtainBeanVo(Class<T> clazz) {
        BeanVo<T> beanVo = new BeanVo<T>();
        beanVo.setBeans(this.obtainObjects((Class)clazz));
        this.setPagination(this.getPagination());
        this.setRowCount(this.getRowCount());
        this.setRecordCount(this.getRecordCount());
        return beanVo;
    }

    @Override
    public MapVo obtainMapVo() {
        MapVo mapVo = new MapVo();
        mapVo.setRows(this.getMapRows());
        this.setPagination(this.getPagination());
        this.setRowCount(this.getRowCount());
        this.setRecordCount(this.getRecordCount());
        return null;
    }
}

