/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util.excelutils;

import cn.remex.RemexConstants;
import cn.remex.core.util.Arith;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.excelutils.bean.ExcelRead;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private Workbook wb = null;
    private Sheet sheet = null;

    public static String[][] getData(File file, int sheet, int startRow, Consumer<Double> consumer) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int rowSize = 0;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            FileInputStream inp = new FileInputStream(file);
            XSSFWorkbook wb = null;
            try {
                wb = new XSSFWorkbook((InputStream)inp);
            }
            catch (Exception e) {
                wb = new HSSFWorkbook((InputStream)inp);
            }
            Cell cell = null;
            Sheet st = wb.getSheetAt(sheet);
            int count = st.getLastRowNum();
            int index = 0;
            for (int rowIndex = startRow; rowIndex <= st.getLastRowNum(); ++rowIndex) {
                if (consumer != null && index % 10000 == 0) {
                    consumer.accept(Arith.div(index, count, 2));
                }
                ++index;
                Row row = st.getRow(rowIndex);
                if (row == null) continue;
                int tempRowSize = row.getLastCellNum() + 1;
                if (tempRowSize > rowSize) {
                    rowSize = tempRowSize;
                }
                Object[] values = new String[rowSize];
                Arrays.fill(values, "");
                boolean hasValue = false;
                for (int columnIndex = 0; columnIndex <= row.getLastCellNum(); ++columnIndex) {
                    cell = row.getCell(columnIndex);
                    String value = "";
                    if (Judgment.nullOrBlank(cell)) continue;
                    switch (cell.getCellType()) {
                        case 1: {
                            value = cell.getStringCellValue();
                            break;
                        }
                        case 0: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                Date date = cell.getDateCellValue();
                                if (date != null) {
                                    value = new SimpleDateFormat("yyyy-MM-dd hh:mm:dd").format(date);
                                    break;
                                }
                                value = "";
                                break;
                            }
                            value = new DecimalFormat("0").format(cell.getNumericCellValue());
                        }
                    }
                    if (columnIndex == 0 && value.trim().equals("")) break;
                    values[columnIndex] = ExcelUtils.rightTrim(value);
                    hasValue = true;
                }
                if (!hasValue) continue;
                result.add(values);
            }
            in.close();
        }
        catch (Exception e) {
            RemexConstants.logger.error((Object)"excel \u8868\u683c\u89e3\u6790\u9519\u8bef\uff01", (Throwable)e);
            throw new Error("\u8868\u683c\u89e3\u6790\u9519\u8bef\uff01");
        }
        String[][] returnArray = new String[result.size()][rowSize];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = (String[])result.get(i);
        }
        return ExcelUtils.rmBlack(returnArray);
    }

    public static ExcelRead getData(File file, int sheet, int tiltleRow, int dataStartRow, Consumer<Double> consumer) {
        ExcelRead excelRead = new ExcelRead();
        String[][] datas = ExcelUtils.getData(file, sheet, tiltleRow, consumer);
        String[] titles = datas[0];
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        dataList.addAll(Arrays.asList(datas).subList(1, datas.length));
        excelRead.setTitles(titles);
        excelRead.setList(dataList);
        return excelRead;
    }

    public static ExcelRead getData(File file, int sheet, int tiltleRow, int dataStartRow) {
        return ExcelUtils.getData(file, sheet, tiltleRow, dataStartRow, null);
    }

    public static String rightTrim(String str) {
        if (Judgment.nullOrBlank(str)) {
            return "";
        }
        int length = str.length();
        for (int i = length - 1; i >= 0 && str.charAt(i) == ' '; --i) {
            --length;
        }
        return str.substring(0, length);
    }

    private static String[][] rmBlack(String[][] data) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        int rowSize = 0;
        for (String[] strings : data) {
            int black = 0;
            rowSize = strings.length;
            for (String string : strings) {
                if (!Judgment.nullOrBlank(string)) continue;
                ++black;
            }
            if (black == strings.length) continue;
            list.add(strings);
        }
        String[][] str = new String[list.size()][rowSize];
        for (int i = 0; i < str.length; ++i) {
            str[i] = (String[])list.get(i);
        }
        return str;
    }

    public boolean getSheet(URL srcXlsPath, String sheetName) {
        try {
            if (Judgment.nullOrBlank(this.wb)) {
                try {
                    this.wb = new XSSFWorkbook(srcXlsPath.openStream());
                }
                catch (Exception e) {
                    this.wb = new HSSFWorkbook(srcXlsPath.openStream());
                }
            }
            this.sheet = this.wb.getSheet(sheetName);
            if (Judgment.nullOrBlank(this.sheet)) {
                this.sheet = this.wb.createSheet(sheetName);
            }
        }
        catch (IOException e) {
            RemexConstants.logger.error((Object)("\u56db\u516d\u7ea7\u5fae\u4fe1\u2014>\u4e0b\u8f7d\u62a5\u540d\u4fe1\u606f-\u83b7\u53d6\u6a21\u677f\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        return true;
    }

    public Row getRow(int rowIndex) {
        Row row = this.sheet.getRow(rowIndex);
        if (Judgment.nullOrBlank(row)) {
            row = this.sheet.createRow(rowIndex);
        }
        return row;
    }

    public void setCellValue(int rowIndex, int cellnum, String value) {
        Cell cell = this.getRow(rowIndex).getCell(cellnum);
        if (Judgment.nullOrBlank(cell)) {
            cell = this.getRow(rowIndex).createCell(cellnum);
        }
        cell.setCellValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToNewFile(String outputFile) {
        FileOutputStream out = null;
        try {
            File f = new File(outputFile.substring(0, outputFile.lastIndexOf("/")));
            if (!f.exists() && !f.isDirectory()) {
                f.mkdirs();
            }
            out = new FileOutputStream(outputFile);
            this.wb.write((OutputStream)out);
        }
        catch (IOException e) {
            RemexConstants.logger.error((Object)("\u56db\u516d\u7ea7\u5fae\u4fe1\u2014>\u4e0b\u8f7d\u62a5\u540d\u4fe1\u606f-\u4fdd\u5b58excel\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

