/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageUtil {
    public static void main(String[] args) throws Exception {
        String packageName = "";
        List<String> classNames = PackageUtil.getClassName(packageName, true);
        if (classNames != null) {
            for (String className : classNames) {
                System.out.println(className);
            }
        }
    }

    public static Set<Class<?>> getClasses(String packOrJar) {
        String pckgPre;
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = packOrJar;
        String packageDirName = packageName.replace('.', '/');
        String pckgDirPre = packageName.replace('.', '/');
        String string = pckgPre = packageName.length() > 0 ? packageName + "." : packageName;
        if (packOrJar.indexOf(".jar!") > 0) {
            String urljardir = Thread.currentThread().getContextClassLoader().getResource("/").toString().replaceAll("/classes/", "") + packOrJar;
            packageDirName = urljardir.substring(0, urljardir.indexOf("!"));
            pckgPre = urljardir.substring(urljardir.indexOf("!") + 1);
            pckgDirPre = pckgPre.replace('.', '/');
        }
        try {
            Enumeration<URL> dirse = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            Vector<URL> v = new Vector<URL>();
            while (dirse.hasMoreElements()) {
                v.add(dirse.nextElement());
            }
            if (packOrJar.indexOf(".jar!") > 0) {
                v.add(new URL("jar:" + packageDirName + "!/"));
            }
            for (URL url : v) {
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackageUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(pckgDirPre)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        String pckgPre = packageName.length() > 0 ? packageName + "." : packageName;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                PackageUtil.findAndAddClassesInPackageByFile(pckgPre + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(pckgPre + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getClassName(String packageName) {
        return PackageUtil.getClassName(packageName, true);
    }

    public static List<String> getClassName(String packageName, boolean childPackage) {
        ArrayList<String> fileNames = new ArrayList();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace(".", "/");
        try {
            Enumeration<URL> urls = loader.getResources(packagePath);
            if (urls.hasMoreElements()) {
                do {
                    URL url;
                    String type;
                    if ((type = (url = urls.nextElement()).getProtocol()).equals("file")) {
                        fileNames.addAll(PackageUtil.getClassNameByFile(url.getPath(), null, childPackage));
                        continue;
                    }
                    if (!type.equals("jar")) continue;
                    fileNames.addAll(PackageUtil.getClassNameByJar(url.getPath(), childPackage));
                } while (urls.hasMoreElements());
            } else {
                fileNames = PackageUtil.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage);
            }
            return fileNames;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {
        File[] childFiles;
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(PackageUtil.getClassNameByFile(childFile.getPath(), myClassName, childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace("\\", ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(PackageUtil.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

