/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.RemexConstants;
import cn.remex.core.exception.FileException;
import cn.remex.core.exception.RIOException;
import cn.remex.core.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;

public class FileHelper {
    private static final int BUFFER_SIZE = 16384;

    public static void copy(Object src, Object dst) {
        File srcFile;
        Assert.isTrue(null != src && null != dst, "ERROR", "\u8981\u590d\u5236\u7684\u6587\u4ef6\u5fc5\u987b\u4e3aFile.class\u7c7b\u578b\u6216\u8005String.class\u7c7b\u578b\uff0c\u4e14\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        File file = src instanceof String ? FileHelper.createFile((String)src) : (srcFile = src instanceof File ? (File)src : null);
        File dstFile = dst instanceof String ? FileHelper.createFile((String)dst) : (dst instanceof File ? (File)dst : null);
        Assert.isTrue(null != src && null != dst, "ERROR", "\u8981\u590d\u5236\u7684\u6587\u4ef6\u5fc5\u987b\u4e3aFile.class\u7c7b\u578b\u6216\u8005String.class\u7c7b\u578b\uff0c\u4e14\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        FileHelper.copy(srcFile, dstFile);
    }

    public static File createFile(String truePath) {
        String finalPath = truePath.toString();
        int i = -1;
        i = finalPath.lastIndexOf(File.separatorChar);
        String finalContentPath = finalPath.substring(0, i >= 0 ? i : finalPath.lastIndexOf("/"));
        File contentPath = new File(finalContentPath);
        if (!contentPath.exists()) {
            contentPath.mkdirs();
        }
        if (!contentPath.exists()) {
            throw new FileException("\u6587\u4ef6\u8def\u5f84\u521b\u5efa\u5931\u8d25\uff01");
        }
        File myFilePath = new File(finalPath);
        if (!myFilePath.exists()) {
            try {
                myFilePath.createNewFile();
            }
            catch (IOException e) {
                throw new FileException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25!", e);
            }
        }
        return myFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(src), 16384);
            out = new BufferedOutputStream(new FileOutputStream(dst), 16384);
            byte[] buffer = new byte[16384];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static InputStream openStream(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new FileException("url\uff0c\u6253\u5f00\u5931\u8d25\uff01");
        }
    }

    public static File saveFile(String filePath, InputStream inputStream) {
        File file = FileHelper.createFile(filePath);
        byte[] buffer = new byte[1024];
        int count = 0;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            inputStream = new BufferedInputStream(inputStream);
            while ((count = inputStream.read(buffer)) != -1) {
                fileOutputStream.write(buffer, 0, count);
            }
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            throw new RIOException("\u6587\u4ef6\u4fdd\u5b58\u5f02\u5e38", e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveFileContent(String fileName, Object fileContent) {
        FileHelper.saveFileContent(fileName, fileContent, null);
    }

    public static void saveFileContent(String fileName, Object fileContent, String charset) {
        FilterOutputStream bosFile = null;
        try {
            FileHelper.createFilePath(fileName);
            bosFile = new BufferedOutputStream(new FileOutputStream(fileName));
            if (fileContent instanceof String) {
                bosFile.write(null == charset ? fileContent.toString().getBytes() : fileContent.toString().getBytes(charset));
            } else if (fileContent instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)fileContent).writeTo(bosFile);
            }
            bosFile.close();
            if (RemexConstants.logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder("\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff0c\u8def\u5f84\uff1a\u3010").append(fileName).append("\u3011");
                RemexConstants.logger.debug((Object)msg);
            }
        }
        catch (Exception e) {
            String msg = "\u4fdd\u5b58\u62a5\u6587\u5931\u8d25!\u62a5\u6587\u8def\u5f84\u662f:" + fileName;
            RemexConstants.logger.error((Object)msg, (Throwable)e);
            throw new RIOException(msg, e);
        }
        finally {
            if (bosFile != null) {
                try {
                    bosFile.close();
                }
                catch (IOException e) {
                    RemexConstants.logger.error((Object)e);
                }
            }
        }
    }

    public static boolean createFilePath(String truePath) {
        return FileHelper.createFile(truePath).exists();
    }

    public static String getFileContent(String fileName) {
        return FileHelper.getFileContent(fileName, System.getProperty("file.encoding"));
    }

    public static String getFileContent(String fileName, String charset) {
        String tresult = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            int size = fis.available();
            byte[] b = new byte[size];
            fis.read(b);
            fis.close();
            tresult = new String(b, charset);
        }
        catch (Exception e) {
            throw new RIOException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff01", e);
        }
        return tresult;
    }

    public static String getFileContent(Object o, String propertyFile) {
        InputStream is = o.getClass().getResourceAsStream(propertyFile);
        InputStreamReader ir = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(ir);
        StringBuffer content = new StringBuffer();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line);
            }
        }
        catch (IOException e) {
            throw new RIOException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff01", e);
        }
        return content.toString();
    }

    public static String getContentType(File file) {
        try {
            return Files.probeContentType(file.toPath());
        }
        catch (IOException e) {
            throw new FileException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", e);
        }
    }

    public static String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }
}

