/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.ObjectUtils;
import cn.remex.core.util.Param;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;

public abstract class CollectionUtils {
    public static List<Object> arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static boolean contains(Enumeration<?> enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Iterator<?> iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (Object name : candidates) {
            if (!source.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean containsInstance(Collection<?> collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static Object findFirstMatch(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (Class<?> type : types) {
            Object value = CollectionUtils.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?> type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Object value = null;
        for (Object obj : collection) {
            if (type != null && !type.isInstance(obj)) continue;
            if (value != null) {
                return null;
            }
            value = obj;
        }
        return value;
    }

    public static boolean hasUniqueObject(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static void mergeArrayIntoCollection(Object array, Collection<Object> collection) {
        Object[] arr;
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        for (Object element : arr = ObjectUtils.toObjectArray(array)) {
            collection.add(element);
        }
    }

    public static void mergePropertiesIntoMap(Properties props, Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                map.put(key, props.getProperty(key));
            }
        }
    }

    public static <T> Map<Object, T> listToMap(List<T> list, String key) {
        HashMap<Object, T> map = new HashMap<Object, T>();
        for (T o : list) {
            map.put(ReflectUtil.invokeGetter(key, o), o);
        }
        return map;
    }

    public static void invokeListField(Object bean, String[] fields, String[] pids, int level) {
        Object subBean = bean;
        if (fields.length <= level) {
            return;
        }
        String r = fields[level];
        ArrayList sbs = (ArrayList)ReflectUtil.invokeGetter(r, subBean);
        if (level < pids.length) {
            sbs = new ArrayList();
            Object o = CollectionUtils.listToMap(sbs, "id").get(pids[level]);
            sbs.add(o);
        }
        for (Object sb : sbs) {
            CollectionUtils.invokeListField(sb, fields, pids, level + 1);
        }
    }

    public static <T> Map<String, String> listToMap(List<T> list, String keyName, String valueName) {
        HashMap<String, String> map = new HashMap<String, String>();
        Assert.notNull(list, "ERROR", "list\u4e0d\u80fd\u4e3a\u7a7a" + keyName);
        if (list.size() == 0) {
            return map;
        }
        T o = list.get(0);
        Assert.notNull(ReflectUtil.getGetter(o.getClass(), keyName), "ERROR", "list\u8f6cmap\u65f6key\u5fc5\u987b\u4e3abean\u7684\u5c5e\u6027" + keyName);
        Assert.notNull(ReflectUtil.getGetter(o.getClass(), valueName), "ERROR", "list\u8f6cmap\u65f6value\u5fc5\u987b\u4e3abean\u7684\u5c5e\u6027" + valueName);
        for (T t : list) {
            String key = (String)ReflectUtil.invokeGetter(keyName, t);
            String value = (String)ReflectUtil.invokeGetter(valueName, t);
            map.put(key, value);
        }
        return map;
    }

    public static <T> List<T> mapToList(Map<Object, T> map) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object key : map.keySet()) {
            list.add(map.get(key));
        }
        return list;
    }

    public static <T> String obtainColumnStr(List<T> list, Consumer<T> cp) {
        if (null == list || list.size() == 0) {
            return "";
        }
        Param<Object> fieldNameParam = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(list.get(0), bean -> cp.accept(bean), fieldName -> {
            fieldNameParam.param = fieldName;
            Object cfr_ignored_0 = fieldNameParam.param;
        });
        StringBuilder sb = new StringBuilder();
        for (T t : list) {
            sb.append(ReflectUtil.invokeGetter((String)fieldNameParam.param, t)).append(",");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }
}

