/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.reflect;

import cn.remex.RemexConstants;
import cn.remex.core.CoreSvo;
import cn.remex.core.aop.AOPCaller;
import cn.remex.core.aop.AOPFactory;
import cn.remex.core.reflect.CodeMapper;
import cn.remex.core.reflect.ReflectConfigure;
import cn.remex.core.reflect.ReflectContext;
import cn.remex.core.reflect.ReflectFeatureStatus;
import cn.remex.core.reflect.ReflectionException;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.ReadOnlyMap;
import cn.remex.core.util.StringHelper;
import cn.remex.core.util.date.DateHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.sf.cglib.proxy.MethodProxy;

public class ReflectUtil
implements RemexConstants {
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Field>> AllField = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, List<Method>>> AllMethods = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> AllGetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> AllSetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> AllUserGetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Class<?>, ReadOnlyMap<String, Method>> AllUserSetter = new ReadOnlyMap();
    private static final ReadOnlyMap<Type, Class<?>[]> ParameterClasses = new ReadOnlyMap();
    private static final ArrayList<Class<?>> SimpleType = new ArrayList();
    private static final ArrayList<Class<?>> NumeralTypes = new ArrayList();
    protected static AOPFactory AopBeanFactory = new AOPFactory(new AOPCaller(null){
        private static final long serialVersionUID = 4420894044903576950L;

        @Override
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            String name = method.getName();
            boolean isGet = name.startsWith("get");
            if ((isGet || name.startsWith("is")) && method.getParameterTypes().length == 0) {
                Consumer fieldNameConsumer = (Consumer)CoreSvo.valLocal(String.valueOf(obj.hashCode()));
                fieldNameConsumer.accept(StringHelper.lowerFirstLetter(name.substring(isGet ? 3 : 2)));
                return null;
            }
            return proxy.invokeSuper(obj, args);
        }
    });
    private static Class<?> ModelableClass;
    private static boolean modelableSupport;
    private static Map<Method, Type> NoSuchSetter;

    public static String hashCodeWithOrder(Class<?> c1, Class<?> c2, String ... extraType) {
        Class<?> clazz1 = null;
        Class<?> clazz2 = null;
        try {
            clazz1 = Class.forName(StringHelper.getClassName(c1));
            clazz2 = Class.forName(StringHelper.getClassName(c2));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        int hc1 = clazz1.hashCode();
        int hc2 = clazz2.hashCode();
        StringBuilder ret = new StringBuilder().append(hc1).append(hc2);
        if (extraType != null) {
            for (String s : extraType) {
                ret.append(null == s ? 0 : s.hashCode());
            }
        } else {
            ret.append(0);
        }
        return ret.toString();
    }

    public static String hashCode(Class<?> c1, Class<?> c2) {
        return ReflectUtil.hashCode(c1, c2, null);
    }

    public static String hashCode(Class<?> c1, Class<?> c2, String extraType) {
        Class<?> clazz1 = null;
        Class<?> clazz2 = null;
        try {
            clazz1 = Class.forName(StringHelper.getClassName(c1));
            clazz2 = Class.forName(StringHelper.getClassName(c2));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        int hc1 = clazz1.hashCode();
        int hc2 = clazz2.hashCode();
        int hc3 = extraType == null ? 0 : extraType.hashCode();
        return hc1 > hc2 ? String.valueOf(hc1) + String.valueOf(hc2) + hc3 : String.valueOf(hc2) + String.valueOf(hc1) + hc3;
    }

    public static final boolean baseTypeEqual(Type type1, Type type2) {
        return !(type1 != type2 && (type1 != Integer.TYPE && type1 != Integer.class || type2 != Integer.TYPE && type2 != Integer.class) && (type1 != Double.TYPE && type1 != Double.class || type2 != Double.TYPE && type2 != Double.class) && (type1 != Long.TYPE && type1 != Long.class || type2 != Long.TYPE && type2 != Long.class) && (type1 != Float.TYPE && type1 != Float.class || type2 != Float.TYPE && type2 != Float.class) && (type1 != Short.TYPE && type1 != Short.class || type2 != Short.TYPE && type2 != Short.class) && (type1 != Byte.TYPE && type1 != Byte.class || type2 != Byte.TYPE && type2 != Byte.class) && (type1 != Character.TYPE && type1 != Character.class || type2 != Character.TYPE && type2 != Character.class));
    }

    public static Object caseObject(Type type, Object o, Object ... instanceArgs) {
        if (null == o || o.getClass() == type) {
            if (null == o && (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type))) {
                return false;
            }
            return o;
        }
        Class<?> sc = o.getClass();
        if (type == String.class) {
            if (sc == String[].class) {
                StringBuilder ret = new StringBuilder();
                for (String v : (String[])o) {
                    ret.append(v).append(",");
                }
                ret.deleteCharAt(ret.length() - 1);
                return ret.toString();
            }
            return o.toString();
        }
        if (type == String.class && o instanceof Date) {
            return DateHelper.formatDate(DateHelper.dateToLocalDate((Date)o), new String[0]);
        }
        if (o.getClass().isArray() && !((Class)type).isArray()) {
            Object[] os = (Object[])o;
            if (os.length == 1) {
                return ReflectUtil.caseObject(type, os[0], new Object[0]);
            }
            throw new ReflectionException("\u65e0\u6cd5\u5c06\u5305\u542b\u4e24\u4e2a\u5143\u7d20\u7684\u6570\u7ec4\u8f6c\u5316\u4e3a\u4e00\u4e2a\u5bf9\u8c61\uff01CaseObject\u5931\u8d25\uff01");
        }
        if (Class.class.isAssignableFrom(type.getClass()) && ((Class)type).isAssignableFrom(o.getClass())) {
            return o;
        }
        if (Enum.class.isAssignableFrom((Class)type)) {
            return Judgment.nullOrBlank(o) ? null : Enum.valueOf((Class)type, String.valueOf(o));
        }
        if (o instanceof String && modelableSupport && ModelableClass.isAssignableFrom((Class)type)) {
            if (Judgment.nullOrBlank(o)) {
                return null;
            }
            Object t = instanceArgs == null || instanceArgs.length == 0 || instanceArgs[0] == null ? ReflectUtil.invokeNewInstance((Class)type) : ReflectUtil.invokeMethod((Method)instanceArgs[1], instanceArgs[0], Arrays.copyOfRange(instanceArgs, 2, instanceArgs.length));
            ReflectUtil.invokeSetter("id", t, o);
            return t;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (sc == Boolean.TYPE || sc == Boolean.class) {
                return o;
            }
            return "1".equals(o) || "on".equals(o) || "yes".equals(o) || "true".equals(o) || "On".equals(o) || "Yes".equals(o) || "True".equals(o) || "ON".equals(o) || "YES".equals(o) || "TRUE".equals(o) || Boolean.parseBoolean(o.toString());
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (sc == Integer.TYPE || sc == Integer.class) {
                return o;
            }
            String str = o.toString();
            return Double.valueOf(str.equals("") ? "0" : str).intValue();
        }
        if (type == Double.TYPE || type == Double.class) {
            if (sc == Double.TYPE || sc == Double.class) {
                return o;
            }
            String str = o.toString();
            return (double)Double.valueOf(str.equals("") ? "0" : str);
        }
        if (type == Long.TYPE || type == Long.class) {
            if (sc == Long.TYPE || sc == Long.class) {
                return o;
            }
            String str = o.toString();
            return Double.valueOf(str.equals("") ? "0" : str).longValue();
        }
        if (type == Float.TYPE || type == Float.class) {
            if (sc == Float.TYPE || sc == Float.class) {
                return o;
            }
            String str = o.toString();
            return Float.valueOf(Double.valueOf(str.equals("") ? "0" : str).floatValue());
        }
        if (type == Short.TYPE || type == Short.class) {
            if (sc == Short.TYPE || sc == Short.class) {
                return o;
            }
            String str = o.toString();
            return Double.valueOf(str.equals("") ? "0" : str).shortValue();
        }
        if (type == Byte.TYPE || type == Byte.class) {
            if (sc == Byte.TYPE || sc == Byte.class) {
                return o;
            }
            String str = o.toString();
            return Double.valueOf(str.equals("") ? "0" : str).byteValue();
        }
        if (type == Character.TYPE || type == Character.class) {
            if (sc == Character.TYPE || sc == Character.class) {
                return o;
            }
            String str = o.toString();
            if (str.length() == 0) {
                return 0;
            }
            return Character.valueOf(o.toString().toCharArray()[0]);
        }
        throw new ReflectionException("\u6307\u5b9a\u7684\u7c7b\u578b\u4e0d\u5408\u6cd5,\u5e94\u4e3a\u57fa\u7840\u7c7b\u578b/\u5bf9\u8c61\u4e3a\u7c7b\u578b\u7684\u5b50\u7c7b/\u63a5\u53e3\u7684\u5b9e\u73b0\u3002");
    }

    public static boolean isSimpleType(Class<?> c) {
        return SimpleType.contains(c) || Enum.class.isAssignableFrom(c);
    }

    public static boolean isNumeralType(Class<?> c) {
        return NumeralTypes.contains(c);
    }

    public static boolean isBaseType(Class<?> c) {
        return c == Integer.TYPE || c == Long.TYPE || c == Boolean.TYPE || c == Byte.TYPE || c == Character.TYPE || c == Short.TYPE || c == Float.TYPE || c == Double.TYPE;
    }

    public static boolean evaluateEqual(Type type1, Type type2) {
        if (type1 instanceof Class && type2 instanceof Class && type1 == type2) {
            return true;
        }
        try {
            Type[] at2;
            Class rt1 = (Class)ReflectUtil.invokeMethod("getRawType", (Object)type1, new Object[0]);
            Class rt2 = (Class)ReflectUtil.invokeMethod("getRawType", (Object)type2, new Object[0]);
            if (rt1 != rt2) {
                return false;
            }
            Type[] at1 = ReflectUtil.getActualTypeArguments(type1);
            if (at1.length != (at2 = ReflectUtil.getActualTypeArguments(type2)).length) {
                return false;
            }
            for (int i = 0; i < at1.length; ++i) {
                if (at1[i] == at2[i]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object invokeMethod(String methodName, Object target, Object ... args) {
        try {
            Class[] parameterTypes = null;
            if (null != args) {
                ArrayList parameterTypeArr = null;
                parameterTypeArr = new ArrayList(4);
                for (Object arg : args) {
                    parameterTypeArr.add(arg.getClass());
                }
                parameterTypes = parameterTypeArr.toArray(new Class[0]);
            }
            Method method = target.getClass().getMethod(methodName, parameterTypes);
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Type[] getActualTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("\u672a\u627e\u5230\u6b64\u65b9\u6cd5: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("\u65e0\u6743\u8bbf\u95ee\u6b64\u65b9\u6cd5: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectUtil.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        ReflectUtil.handleUnexpectedException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectUtil.rethrowRuntimeException(ex.getTargetException());
    }

    public static void handleUnexpectedException(Throwable ex) {
        IllegalStateException isex = new IllegalStateException(ex);
        throw isex;
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ReflectUtil.handleUnexpectedException(ex);
    }

    public static ReadOnlyMap<String, Field> getAllFields(Class<?> clazz) {
        Field[] AutualFields;
        ReadOnlyMap<String, Field> fields = (ReadOnlyMap<String, Field>)AllField.get(clazz);
        if (null != fields) {
            return fields;
        }
        fields = new ReadOnlyMap<String, Field>();
        if (Object.class != clazz.getSuperclass()) {
            Class<?> sup = clazz.getSuperclass();
            ReadOnlyMap<String, Field> supFields = ReflectUtil.getAllFields(sup);
            fields.putAll(supFields);
        }
        for (Field f : AutualFields = clazz.getDeclaredFields()) {
            fields.put(f.getName(), f);
        }
        AllField.put(clazz, fields);
        return fields;
    }

    public static Map<String, Method> getAllUserSetters(Class<?> clazz) {
        ReadOnlyMap setters = (ReadOnlyMap)AllUserSetter.get(clazz);
        if (null != setters) {
            return setters;
        }
        ReflectUtil.obtainUserGettersAndSetters(clazz);
        setters = (ReadOnlyMap)AllUserSetter.get(clazz);
        return setters;
    }

    private static void obtainUserGettersAndSetters(Class<?> clazz) {
        Map<String, Method> _as = ReflectUtil.getAllSetters(clazz);
        Map<String, Method> _ag = ReflectUtil.getAllGetters(clazz);
        ReadOnlyMap<String, Method> setters = new ReadOnlyMap<String, Method>();
        ReadOnlyMap<String, Method> getters = new ReadOnlyMap<String, Method>();
        for (String field : _as.keySet()) {
            if (!_ag.containsKey(field)) continue;
            setters.put(field, _as.get(field));
            getters.put(field, _ag.get(field));
        }
        AllUserSetter.put(clazz, setters);
        AllUserGetter.put(clazz, getters);
    }

    public static Map<String, Method> getAllSetters(Class<?> clazz) {
        ReadOnlyMap<String, Method> setters = (ReadOnlyMap<String, Method>)AllSetter.get(clazz);
        if (null != setters) {
            return setters;
        }
        Method[] methods = clazz.getMethods();
        setters = new ReadOnlyMap<String, Method>();
        for (Method m : methods) {
            if (!m.getName().startsWith("set") || m.getGenericParameterTypes().length != 1 || m.getReturnType() != Void.TYPE) continue;
            String fieldName = StringHelper.lowerFirstLetter(m.getName().substring(3));
            if (null != ReflectUtil.getGetter(clazz, fieldName) && ReflectUtil.getGetter(clazz, fieldName).getReturnType() != m.getGenericParameterTypes()[0]) {
                try {
                    m = clazz.getMethod(m.getName(), ReflectUtil.getGetter(clazz, fieldName).getReturnType());
                }
                catch (Exception e) {
                    logger.warn((Object)("\u5728\u521d\u59cb\u5316" + clazz.getName() + "\u65f6\uff0c\u6ca1\u6709\u627e\u5230\u4e0egetter\u65b9\u6cd5\u76f8\u5339\u914d\u7c7b\u578b\u7684set\u65b9\u6cd5\uff0c\u8fd9\u662f\u4e00\u4e2a\u91cd\u8981\u63d0\u793a\u3002setter\u4e3a" + m.toGenericString() + ";getter\u4e3a" + ReflectUtil.getGetter(clazz, fieldName).toGenericString()));
                }
            }
            setters.put(fieldName, m);
        }
        AllSetter.put(clazz, setters);
        return setters;
    }

    public static Map<String, Method> getAllGetters(Class<?> clazz) {
        ReadOnlyMap<String, Method> getters = (ReadOnlyMap<String, Method>)AllGetter.get(clazz);
        if (null != getters) {
            return getters;
        }
        Method[] methods = clazz.getMethods();
        getters = new ReadOnlyMap<String, Method>();
        for (Method m : methods) {
            if (m.getGenericParameterTypes().length != 0) continue;
            if (m.getName().startsWith("get")) {
                getters.put(StringHelper.lowerFirstLetter(m.getName().substring(3)), m);
                continue;
            }
            if (!m.getName().startsWith("is") || m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class) continue;
            getters.put(StringHelper.lowerFirstLetter(m.getName().substring(2)), m);
        }
        AllGetter.put(clazz, getters);
        return getters;
    }

    public static Method getGetter(Class<?> clazz, String fieldName) {
        return ReflectUtil.getAllGetters(clazz).get(fieldName);
    }

    public static Map<String, Method> getAllUserGetters(Class<?> clazz) {
        ReadOnlyMap getters = (ReadOnlyMap)AllUserGetter.get(clazz);
        if (null != getters) {
            return getters;
        }
        ReflectUtil.obtainUserGettersAndSetters(clazz);
        getters = (ReadOnlyMap)AllUserGetter.get(clazz);
        return getters;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return (Field)ReflectUtil.getAllFields(clazz).get(fieldName);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypeArr) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, parameterTypeArr);
        }
        catch (Exception e) {
            ReflectUtil.handleReflectionException(e);
        }
        return method;
    }

    public static Class<?> getListActualType(Type type) {
        return ReflectUtil.obtainParameterClasses(type)[0];
    }

    public static Class<?>[] obtainParameterClasses(Type type) {
        try {
            Class[] curParameterClasses = (Class[])ParameterClasses.get(type);
            if (null != curParameterClasses) {
                return curParameterClasses;
            }
            Type[] types = ReflectUtil.getActualTypeArguments(type);
            ArrayList<Class> curParameterClassesList = new ArrayList<Class>();
            for (Type parameterType : types) {
                if (parameterType instanceof ParameterizedType) {
                    curParameterClassesList.add((Class)((ParameterizedType)parameterType).getRawType());
                    continue;
                }
                curParameterClassesList.add((Class)parameterType);
            }
            curParameterClasses = curParameterClassesList.toArray(new Class[0]);
            ParameterClasses.put(type, curParameterClasses);
            return curParameterClasses;
        }
        catch (Exception e) {
            ReflectUtil.handleUnexpectedException(e);
            return new Class[0];
        }
    }

    public static Method getSetter(Class<?> clazz, String fieldName) {
        return ReflectUtil.getAllSetters(clazz).get(fieldName);
    }

    public static Map<String, Method> getSettersInContext(Class<?> clazz, Map<String, Object> context) {
        HashMap<String, Method> retSetters = new HashMap<String, Method>();
        Map<String, Method> setters = ReflectUtil.getAllSetters(clazz);
        Map<String, Object> map = setters.size() < context.size() ? setters : context;
        for (String key : map.keySet()) {
            if (!setters.containsKey(key)) continue;
            retSetters.put(key, setters.get(key));
        }
        return retSetters;
    }

    public static <T> T createAopBean(Class<T> beanClass) {
        return AopBeanFactory.getBean(beanClass);
    }

    public static void eachFieldWhenGet(Object o, Consumer aopBeanConsumer, Consumer<String> fieldNameConsumer) {
        Object aopBean;
        if (o instanceof Class) {
            aopBean = AopBeanFactory.getBean((Class)o);
        } else if (o.getClass().toString().indexOf("$$EnhancerByCGLIB$$") > 0) {
            try {
                aopBean = AopBeanFactory.getBean(Class.forName(StringHelper.getClassName(o.getClass())));
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException("\u4e3a\u5df2\u662f\u4ee3\u7406\u7684\u7c7b\u578b\u4ea7\u751f\u4e00\u4e2a\u7528\u4e8e\u6355\u83b7\u5c5e\u6027\u7684AOPBEAN\u5931\u8d25\u3002");
            }
        } else {
            aopBean = AopBeanFactory.getBean(o.getClass());
        }
        CoreSvo.putLocal(String.valueOf(aopBean.hashCode()), fieldNameConsumer);
        aopBeanConsumer.accept(aopBean);
        CoreSvo.putLocal(String.valueOf(aopBean.hashCode()), null);
    }

    public static <T> T invokeNewInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ReflectionException("\u8be5\u5c5e\u6027\u6240\u5bf9\u5e94\u7684\u7c7b\u6ca1\u6709\u9ed8\u8ba4\u6784\u9020\u51fd\u6570\uff0c" + clazz.toString());
        }
    }

    public static <T> T invokeNewInstance(String classFullName) {
        try {
            return (T)Class.forName(classFullName).newInstance();
        }
        catch (Exception e) {
            throw new ReflectionException("\u521b\u5efa\u7c7b\u7684\u5b9e\u4f8b\u5931\u8d25:" + classFullName);
        }
    }

    public static Object invokeGetter(String fieldName, Object target) {
        Method getter = ReflectUtil.getAllGetters(target.getClass()).get(fieldName);
        if (null == getter) {
            throw new ReflectionException("\u76ee\u6807" + target + "\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u5bf9\u5e94\u7684getter\uff1a" + fieldName);
        }
        return ReflectUtil.invokeMethod(getter, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        if (null == method) {
            throw new ReflectionException("\u8c03\u7528\u76ee\u6807" + target + "\u7684\u65b9\u6cd5\u65f6\uff0cMethod\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object applyMethod(Method method, Object target, Object[] params) {
        if (null == method) {
            throw new ReflectionException("\u8c03\u7528\u76ee\u6807" + target + "\u7684\u65b9\u6cd5\u65f6\uff0cMethod\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            return method.invoke(target, params);
        }
        catch (Exception ex) {
            ReflectUtil.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void invokeSetter(String fieldName, Object target, Object value) {
        Method setter = ReflectUtil.getAllSetters(target.getClass()).get(fieldName);
        if (null == setter) {
            throw new ReflectionException("\u76ee\u6807" + target + "\u4e2d\u6ca1\u6709\u8be5\u5c5e\u6027\u5bf9\u5e94\u7684setter\uff1a" + fieldName);
        }
        ReflectUtil.invokeMethod(setter, target, value);
    }

    public static void invokeSetterIgnoreNoSetter(String fieldName, Object target, Object value) {
        Class<?> clazz = target.getClass();
        Map<String, Method> allSetters = ReflectUtil.getAllSetters(clazz);
        if (allSetters.containsKey(fieldName)) {
            ReflectUtil.invokeSetterWithDefaultTypeCoventer(target, allSetters.get(fieldName), value, new ReflectFeatureStatus(null));
        }
    }

    public static void invokeSetterWithDefaultTypeCoventer(Object dest, String field, Object value) {
        ReflectUtil.invokeSetterWithDefaultTypeCoventer(dest, ReflectUtil.getSetter(dest.getClass(), field), value, null);
    }

    public static void invokeSetterWithDefaultTypeCoventer(Object dest, Method setter, Object value, ReflectFeatureStatus status) {
        Class<?> pt = setter.getParameterTypes()[0];
        if ((null == status || !status.isSPFeatureOn) && null != value && ReflectUtil.isSimpleType(pt)) {
            ReflectUtil.invokeMethod(setter, dest, ReflectUtil.caseObject(pt, value, new Object[0]));
            if (null != status && status.isDebugEnabled) {
                logger.debug((Object)("SetValue: [" + setter.getName() + (setter.getName().length() < 15 ? "]\t\t" : "]\t") + " with [" + value + "] for " + dest.getClass().getSimpleName()));
            }
            return;
        }
        if (pt == String.class && (status.ConvertNull2EmptyString && null == value || status.ConvertZero2EmptyString && null != value && ReflectUtil.isNumeralType(value.getClass()) && 0.0 - Double.valueOf(value.toString()) == 0.0)) {
            value = "";
        }
        if (status.IgnoreEmptyStringValue && "".equals(value) && pt == String.class) {
            if (status.isDebugEnabled) {
                logger.debug((Object)("SetValue: [" + setter.getName() + (setter.getName().length() < 15 ? "]\t\t" : "]\t") + " ignore [EMPTYSTRING] for " + dest.getClass().getSimpleName()));
            }
        } else if (null != value || status.EnableNullValue) {
            Object nValue;
            if (NoSuchSetter.containsKey(setter) && null != value && NoSuchSetter.get(setter) == value.getClass()) {
                logger.debug((Object)("-----\u76ee\u6807\u5bf9\u8c61" + dest + "set\u65b9\u6cd5\u65e0\u6b64\u91cd\u8f7d\uff1a" + setter.getName() + "(" + value.getClass() + ")"));
                return;
            }
            if (ReflectUtil.isSimpleType(pt) || !status.enableDeeplyCopy && !Collection.class.isAssignableFrom(pt) && !Map.class.isAssignableFrom(pt)) {
                nValue = ReflectUtil.caseObject(pt, value, new Object[0]);
            } else {
                if (!status.enableDeeplyCopy) {
                    return;
                }
                if (Collection.class.isAssignableFrom(pt) && value instanceof Collection) {
                    Object[] arr_f;
                    int arr_f_len;
                    Collection field = (Collection)ReflectUtil.invokeGetter(StringHelper.lowerFirstLetter(setter.getName().substring(3)), dest);
                    if (null == field) {
                        field = (Collection)ReflectUtil.invokeNewInstance(value.getClass());
                    }
                    Type pt2 = setter.getGenericParameterTypes()[0];
                    Class<?> targetItemClass = ReflectUtil.obtainCollectionRawType(pt2);
                    Collection collection = (Collection)value;
                    Object[] arr_c = collection.toArray();
                    int arr_c_len = arr_c.length;
                    int max = arr_c_len > (arr_f_len = (arr_f = field.toArray()).length) ? arr_c_len : arr_f_len;
                    boolean itemIsSimple = ReflectUtil.isSimpleType(targetItemClass) || Enum.class.isAssignableFrom(targetItemClass);
                    Object[] arr_f_new = new Object[max];
                    for (int i = 0; i < max; ++i) {
                        if (i < arr_c_len && null != arr_c[i]) {
                            if (!itemIsSimple) {
                                Object curItem = i >= arr_f_len || null == arr_f[i] ? ReflectUtil.invokeNewInstance(targetItemClass) : arr_f[i];
                                ReflectUtil.copyProperties(curItem, arr_c[i], status.features);
                                arr_f_new[i] = curItem;
                                continue;
                            }
                            arr_f_new[i] = arr_f[i];
                            continue;
                        }
                        if (i >= arr_f_len || status.RemoveTargetGatherItemWhenSourceExclude) continue;
                        arr_f_new[i] = arr_f[i];
                    }
                    field.clear();
                    for (Object item : arr_f_new) {
                        if (null == item) continue;
                        field.add(item);
                    }
                    value = field;
                } else if (Map.class.isAssignableFrom(pt) && value instanceof Map) {
                    Map field = (Map)ReflectUtil.invokeGetter(StringHelper.lowerFirstLetter(setter.getName().substring(3)), dest);
                    if (null == field) {
                        field = (Map)ReflectUtil.invokeNewInstance(value.getClass());
                    }
                    Map map = (Map)value;
                    Type pt2 = setter.getGenericParameterTypes()[0];
                    Class targetValueClass = (Class)ReflectUtil.getActualTypeArguments(pt2)[1];
                    boolean valueIsSimple = ReflectUtil.isSimpleType(targetValueClass) || Enum.class.isAssignableFrom(targetValueClass);
                    for (Object key : map.keySet()) {
                        Object item_m = map.get(key);
                        Object item_f = field.get(key);
                        if (null == item_m && null == item_f) continue;
                        if (null != item_m) {
                            if (valueIsSimple) {
                                item_f = item_m;
                            } else {
                                if (null == item_f) {
                                    item_f = ReflectUtil.invokeNewInstance(targetValueClass);
                                }
                                ReflectUtil.copyProperties(item_f, item_m, status.features);
                            }
                            field.put(key, item_f);
                            continue;
                        }
                        throw new ReflectionException("\u6df1\u5ea6\u590d\u5236\u65f6\uff0cmap\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u5219\uff01");
                    }
                    if (status.RemoveTargetGatherItemWhenSourceExclude) {
                        ArrayList keys = new ArrayList();
                        for (Object key : field.keySet()) {
                            if (map.containsKey(key)) continue;
                            keys.add(key);
                        }
                        for (Object key : keys) {
                            field.remove(key);
                        }
                    }
                    value = field;
                } else {
                    Object object = ReflectUtil.invokeGetter(StringHelper.lowerFirstLetter(setter.getName().substring(3)), dest);
                    if (null == object) {
                        object = ReflectUtil.invokeNewInstance(pt);
                    }
                    ReflectUtil.copyProperties(object, value, status.features);
                    value = object;
                }
                nValue = value;
            }
            try {
                ReflectUtil.invokeMethod(setter, dest, nValue);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("-----\u76ee\u6807\u5bf9\u8c61" + dest + "set\u65b9\u6cd5\u6709\u91cd\u8f7d\uff1a" + setter.getName() + "(" + setter.getParameterTypes()[0] + ")"));
                try {
                    if (null != value) {
                        setter = dest.getClass().getMethod(setter.getName(), value.getClass());
                    }
                }
                catch (NoSuchMethodException e1) {
                    NoSuchSetter.put(setter, value.getClass());
                    logger.warn((Object)("-----\u76ee\u6807\u5bf9\u8c61" + dest + "set\u65b9\u6cd5\u4e2d\u65e0\u6cd5\u627e\u5230\u5982\u6b64\u91cd\u8f7d\uff1a" + setter.getName() + "(" + value.getClass() + ")"));
                    return;
                }
                ReflectUtil.invokeMethod(setter, dest, ReflectUtil.caseObject(pt, value, new Object[0]));
            }
            if (status.isDebugEnabled) {
                logger.debug((Object)("SetValue: [" + setter.getName() + (setter.getName().length() < 15 ? "]\t\t" : "]\t") + " with [" + value + "] for " + dest.getClass().getSimpleName()));
            }
        } else if (status.isDebugEnabled) {
            logger.debug((Object)("SetValue: [" + setter.getName() + (setter.getName().length() < 15 ? "]\t\t" : "]\t") + " ignore [null] for " + dest.getClass().getSimpleName()));
        }
    }

    public static Class<?> obtainClass(Type type) {
        Class clazz = type instanceof Class ? (Class)type : (Class)ReflectUtil.invokeMethod("getRawType", (Object)type, new Object[0]);
        return clazz;
    }

    public static Class<?> obtainCollectionRawType(Type type) {
        Class<?> clazz = ReflectUtil.getListActualType(type);
        return clazz;
    }

    public static void setProperties(Object target, Map<String, Object> source, SPFeature ... features) {
        Map<String, Object> containsMap;
        Map<String, Object> forMap;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("=====\u5373\u5c06\u4eceMap" + source + "\u8d4b\u503c\u7ed9" + target));
        }
        Map<String, Method> setters = ReflectUtil.getSettersInContext(target.getClass(), source);
        if (source.size() > setters.size()) {
            forMap = setters;
            containsMap = source;
        } else {
            containsMap = setters;
            forMap = source;
        }
        ReflectFeatureStatus status = new ReflectFeatureStatus(features);
        for (String key : forMap.keySet()) {
            if (!containsMap.containsKey(key)) continue;
            try {
                ReflectUtil.invokeSetterWithDefaultTypeCoventer(target, setters.get(key), source.get(key), status);
            }
            catch (Exception e) {
                ReflectUtil.handleReflectionException(e);
            }
        }
    }

    public static void copyProperties(Object target, Object source, String fieldMapType, String valueMapType, SPFeature ... features) {
        Assert.notNull(target, "ERROR", "\u5165\u53c2\u9519\u8bef!\u76ee\u6807\u5bf9\u8c61\u4e3a\u7a7a!");
        Assert.notNull(source, "ERROR", "\u5165\u53c2\u9519\u8bef!\u6e90\u5bf9\u8c61\u4e3a\u7a7a!");
        ReflectUtil.copyProperties(target, source, ReflectConfigure.obtainReflectContext(target.getClass(), source.getClass(), fieldMapType, valueMapType), features);
    }

    public static void copyProperties(Object target, Object source, String fieldMapType, SPFeature ... features) {
        ReflectUtil.copyProperties(target, source, ReflectConfigure.obtainReflectContext(target.getClass(), source.getClass(), fieldMapType, null), features);
    }

    public static void copyProperties(Object target, Object source, SPFeature ... features) {
        ReflectUtil.copyProperties(target, source, ReflectConfigure.obtainReflectContext(target.getClass(), source.getClass(), null, null), features);
    }

    public static void copyProperties(Object target, Object source, Map<String, String> methodMap, SPFeature ... features) {
        ReflectUtil.copyProperties(target, source, methodMap, null, features);
    }

    public static void copyProperties(Object target, Object source, Map<String, String> methodMap, Map<String, CodeMapper.CodeMapItem> valueMap, SPFeature ... features) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("=====\u5373\u5c06\u4ece\u6e90\u5bf9\u8c61" + source + "\u67e5\u627e\u4e0e\u76ee\u6807\u5bf9\u8c61" + target + "set\u65b9\u6cd5\u5bf9\u5e94\u7684get\u65b9\u6cd5\u8fdb\u884c\u8d4b\u503c\u3002"));
        }
        Assert.notNull(target, "ERROR", "\u590d\u5236\u65f6\u76ee\u6807\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(source, "ERROR", "\u590d\u5236\u65f6\u6765\u6e90\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isSimpleBean(target, "ERROR", "\u590d\u5236\u65f6\u76ee\u6807\u5bf9\u8c61\u5fc5\u987b\u662f\u7b80\u5355\u7684Object\u5bf9\u8c61\uff0c\u4e0d\u80fd\u4e3aMap\u6216\u8005Collection\uff01");
        Assert.isSimpleBean(source, "ERROR", "\u590d\u5236\u65f6\u6765\u6e90\u5bf9\u8c61\u5fc5\u987b\u662f\u7b80\u5355\u7684Object\u5bf9\u8c61\uff0c\u4e0d\u80fd\u4e3aMap\u6216\u8005Collection\uff01");
        ReflectFeatureStatus status = new ReflectFeatureStatus(features);
        status.enableMethodMap = null != methodMap && methodMap.size() > 0;
        status.enableCodeMap = null != valueMap && valueMap.size() > 0;
        Map<String, Method> origGetters = ReflectUtil.getAllGetters(source.getClass());
        Map<String, Method> destSetters = ReflectUtil.getAllSetters(target.getClass());
        if (!status.CopyIdAndDataStatus && modelableSupport && ModelableClass.isAssignableFrom(target.getClass())) {
            HashMap<String, Method> destSettersNoIdAndDataStatus = new HashMap<String, Method>();
            destSettersNoIdAndDataStatus.putAll(destSetters);
            destSettersNoIdAndDataStatus.remove("id");
            destSettersNoIdAndDataStatus.remove("dataStatus");
            destSetters = destSettersNoIdAndDataStatus;
        }
        Iterator<String> iterator = destSetters.keySet().iterator();
        while (iterator.hasNext()) {
            CodeMapper.CodeMapItem codeMapItem;
            String setKey;
            String getKey = setKey = iterator.next();
            if (status.enableMethodMap && methodMap.containsKey(setKey)) {
                getKey = methodMap.get(setKey);
            }
            if (!origGetters.containsKey(getKey)) continue;
            Object value = ReflectUtil.invokeMethod(origGetters.get(getKey), source, new Object[0]);
            if (status.enableCodeMap && (codeMapItem = valueMap.get(setKey)) != null) {
                value = codeMapItem.obtainCode(value);
            }
            ReflectUtil.invokeSetterWithDefaultTypeCoventer(target, destSetters.get(setKey), value, status);
        }
    }

    private static void copyProperties(Object target, Object source, ReflectContext reflectContext, SPFeature ... features) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("=====\u5373\u5c06\u4ece\u6e90\u5bf9\u8c61" + source + "\u67e5\u627e\u4e0e\u76ee\u6807\u5bf9\u8c61" + target + "set\u65b9\u6cd5\u5bf9\u5e94\u7684get\u65b9\u6cd5\u8fdb\u884c\u8d4b\u503c\u3002"));
        }
        Assert.notNull(target, "ERROR", "\u590d\u5236\u65f6\u76ee\u6807\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(source, "ERROR", "\u590d\u5236\u65f6\u6765\u6e90\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isSimpleBean(target, "ERROR", "\u590d\u5236\u65f6\u76ee\u6807\u5bf9\u8c61\u5fc5\u987b\u662f\u7b80\u5355\u7684Object\u5bf9\u8c61\uff0c\u4e0d\u80fd\u4e3aMap\u6216\u8005Collection\uff01");
        Assert.isSimpleBean(source, "ERROR", "\u590d\u5236\u65f6\u6765\u6e90\u5bf9\u8c61\u5fc5\u987b\u662f\u7b80\u5355\u7684Object\u5bf9\u8c61\uff0c\u4e0d\u80fd\u4e3aMap\u6216\u8005Collection\uff01");
        ReflectFeatureStatus status = new ReflectFeatureStatus(features);
        status.enableMethodMap = reflectContext.enableFieldMap;
        Map<String, String> methodMap = status.enableMethodMap ? reflectContext.getFieldMap() : null;
        status.enableCodeMap = reflectContext.enableCodeMap;
        Map<String, Map<String, String>> codeMap = status.enableCodeMap ? reflectContext.getCodeMap() : null;
        Map<String, Method> origGetters = ReflectUtil.getAllGetters(source.getClass());
        Map<String, Method> destSetters = ReflectUtil.getAllSetters(target.getClass());
        if (!status.CopyIdAndDataStatus && modelableSupport && ModelableClass.isAssignableFrom(target.getClass())) {
            HashMap<String, Method> destSettersNoIdAndDataStatus = new HashMap<String, Method>();
            destSettersNoIdAndDataStatus.putAll(destSetters);
            destSettersNoIdAndDataStatus.remove("id");
            destSettersNoIdAndDataStatus.remove("dataStatus");
            destSetters = destSettersNoIdAndDataStatus;
        }
        Iterator<String> iterator = destSetters.keySet().iterator();
        while (iterator.hasNext()) {
            String targetValue;
            String setKey;
            String getKey = setKey = iterator.next();
            if (status.enableMethodMap && methodMap.containsKey(setKey)) {
                getKey = methodMap.get(setKey);
            }
            if (!origGetters.containsKey(getKey)) continue;
            Object value = ReflectUtil.invokeMethod(origGetters.get(getKey), source, new Object[0]);
            if (status.enableCodeMap && codeMap.containsKey(setKey) && null != (targetValue = codeMap.get(setKey).get(value))) {
                value = targetValue;
            }
            ReflectUtil.invokeSetterWithDefaultTypeCoventer(target, destSetters.get(setKey), value, status);
        }
    }

    public static <T> List<T> copyList(List<T> orgnList, SPFeature ... features) {
        if (null == orgnList) {
            return null;
        }
        if (orgnList.size() == 0) {
            return new ArrayList();
        }
        Class<?> itemClazz = orgnList.get(0).getClass();
        ArrayList retList = new ArrayList();
        orgnList.forEach(d -> {
            Object fafdp = ReflectUtil.invokeNewInstance(itemClazz);
            ReflectUtil.copyProperties(fafdp, d, features);
            retList.add(fafdp);
        });
        return retList;
    }

    public static void setProperties(Object target, Object source, Method getValueMethod, SPFeature[] features, Map<String, String> methodKeyMap, String ... namePreffixs) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("=====\u5373\u5c06\u4ece\u6e90\u5bf9\u8c61" + source + "\u901a\u8fc7\u65b9\u6cd5" + getValueMethod.getName() + "\u53d6\u503c\u7ed9" + target));
        }
        Assert.notNull(target, "ERROR", "\u901a\u8fc7Map\u5bf9\u76ee\u6807\u5bf9\u8c61\u8bbe\u7f6e\u5c5e\u6027\u65f6\uff0c\u76ee\u6807\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(source, "ERROR", "\u901a\u8fc7Map\u5bf9\u76ee\u6807\u5bf9\u8c61\u8bbe\u7f6e\u5c5e\u6027\u65f6\uff0c\u6765\u6e90\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(getValueMethod, "ERROR", "\u4ece\u6765\u6e90\u5bf9\u8c61\u83b7\u53d6\u503c\u5f97\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        ReflectFeatureStatus status = new ReflectFeatureStatus(features);
        status.enableMethodMap = null != methodKeyMap && methodKeyMap.size() > 0;
        Map<String, Method> setters = ReflectUtil.getAllSetters(target.getClass());
        for (String key : setters.keySet()) {
            try {
                Object value = null;
                Method setter = setters.get(key);
                if (status.enableMethodMap && methodKeyMap.containsKey(key)) {
                    key = methodKeyMap.get(key);
                }
                if (status.IgnoreCase) {
                    key = key.toUpperCase();
                }
                if (status.JustUseNamePreffix) {
                    String namePreffix;
                    String[] stringArray = namePreffixs;
                    int n = stringArray.length;
                    for (int i = 0; i < n && (value = ReflectUtil.invokeMethod(getValueMethod, source, (namePreffix = stringArray[i]) + StringHelper.upperFirstLetter(key))) == null; ++i) {
                    }
                } else {
                    value = ReflectUtil.invokeMethod(getValueMethod, source, key);
                }
                ReflectUtil.invokeSetterWithDefaultTypeCoventer(target, setter, value, status);
            }
            catch (Exception e) {
                ReflectUtil.handleReflectionException(e);
            }
        }
    }

    public static void setProperties(Object target, Object source, String getValueMethodName, String ... nameFixs) {
        SPFeature[] features = null;
        ReflectUtil.setProperties(target, source, getValueMethodName, features, nameFixs);
    }

    public static void setProperties(Object target, Object source, String getValueMethodName, SPFeature feature, String ... nameFixs) {
        SPFeature[] features = new SPFeature[]{feature};
        ReflectUtil.setProperties(target, source, getValueMethodName, features, nameFixs);
    }

    public static void setProperties(Object target, Object source, String getValueMethodName, SPFeature[] features, String ... nameFixs) {
        try {
            ReflectUtil.setProperties(target, source, source.getClass().getMethod(getValueMethodName, String.class), features, null, nameFixs);
        }
        catch (Exception e) {
            ReflectUtil.handleReflectionException(e);
        }
    }

    public static void setProperties(Object target, Object source, String getValueMethodName, Map<String, String> methodKeyMap, String ... nameFixs) {
        SPFeature[] features = null;
        ReflectUtil.setProperties(target, source, getValueMethodName, features, methodKeyMap, nameFixs);
    }

    public static void setProperties(Object target, Object source, String getValueMethodName, Class paramType, Map<String, String> methodKeyMap, String ... nameFixs) {
        SPFeature[] features = null;
        try {
            ReflectUtil.setProperties(target, source, source.getClass().getMethod(getValueMethodName, paramType), features, methodKeyMap, nameFixs);
        }
        catch (Exception e) {
            ReflectUtil.handleReflectionException(e);
        }
    }

    public static void setProperties(Object target, Object source, String getValueMethodName, SPFeature feature, Map<String, String> methodKeyMap, String ... nameFixs) {
        SPFeature[] features = new SPFeature[]{feature};
        ReflectUtil.setProperties(target, source, getValueMethodName, features, methodKeyMap, nameFixs);
    }

    public static void setProperties(Object target, Object source, String getValueMethodName, SPFeature[] features, Map<String, String> methodKeyMap, String ... nameFixs) {
        try {
            ReflectUtil.setProperties(target, source, source.getClass().getMethod(getValueMethodName, String.class), features, methodKeyMap, nameFixs);
        }
        catch (Exception e) {
            ReflectUtil.handleReflectionException(e);
        }
    }

    public static void convertNull2String(Object target) {
        Map<String, Method> getters = ReflectUtil.getAllGetters(target.getClass());
        for (String key : getters.keySet()) {
            Method getter = getters.get(key);
            if (null != ReflectUtil.invokeMethod(getter, target, new Object[0]) || getter.getReturnType() != String.class) continue;
            ReflectUtil.invokeSetter(key, target, "");
        }
    }

    public static <T extends Annotation> T getMethodAnnotation(Class<?> clazz, String methodName, Class<T> annotationClass) {
        T anno;
        Method m = ReflectUtil.getMethod(clazz, methodName);
        if (null != m && null != (anno = m.getAnnotation(annotationClass))) {
            return anno;
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method method = null;
        try {
            List methods = (List)ReflectUtil.getAllMethods(clazz).get(methodName);
            if (null == methods || methods.size() == 0) {
                return null;
            }
            method = (Method)methods.get(0);
        }
        catch (Exception e) {
            ReflectUtil.handleReflectionException(e);
        }
        return method;
    }

    public static ReadOnlyMap<String, List<Method>> getAllMethods(Class<?> clazz) {
        ReadOnlyMap<String, List<Method>> methods = (ReadOnlyMap<String, List<Method>>)AllMethods.get(clazz);
        if (null != methods) {
            return methods;
        }
        Method[] methodArr = clazz.getMethods();
        methods = new ReadOnlyMap<String, List<Method>>();
        for (Method m : methodArr) {
            ArrayList<Method> ml = (ArrayList<Method>)methods.get(m.getName());
            if (ml == null) {
                ml = new ArrayList<Method>();
                methods.put(m.getName(), ml);
            }
            if (ml.contains(m)) continue;
            ml.add(m);
        }
        AllMethods.put(clazz, methods);
        return methods;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        return clazz.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        return method.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        T anno;
        Field f = ReflectUtil.getField(clazz, fieldName);
        Method m = ReflectUtil.getGetter(clazz, fieldName);
        if (null != m && null != (anno = m.getAnnotation(annotationClass))) {
            return anno;
        }
        m = ReflectUtil.getSetter(clazz, fieldName);
        if (null != m && null != (anno = m.getAnnotation(annotationClass))) {
            return anno;
        }
        if (null != f && null != (anno = f.getAnnotation(annotationClass))) {
            return anno;
        }
        return null;
    }

    static {
        modelableSupport = false;
        NoSuchSetter = new HashMap<Method, Type>();
        NumeralTypes.add(Integer.TYPE);
        NumeralTypes.add(Long.TYPE);
        NumeralTypes.add(Double.TYPE);
        NumeralTypes.add(Float.TYPE);
        NumeralTypes.add(Short.TYPE);
        NumeralTypes.add(Integer.class);
        NumeralTypes.add(Long.class);
        NumeralTypes.add(Double.class);
        NumeralTypes.add(Float.class);
        NumeralTypes.add(Short.class);
        SimpleType.addAll(NumeralTypes);
        SimpleType.add(Boolean.TYPE);
        SimpleType.add(Character.TYPE);
        SimpleType.add(Byte.TYPE);
        SimpleType.add(Boolean.class);
        SimpleType.add(Character.class);
        SimpleType.add(Byte.class);
        SimpleType.add(String.class);
        try {
            ModelableClass = Class.forName("cn.remex.db.rsql.model.Modelable");
            modelableSupport = true;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"ReflectUtil\u6ca1\u6709\u627e\u5230Modelable\u7c7b\u578b\uff0c\u6545\u65e0\u6cd5\u63d0\u4f9b\u76f8\u5173\u529f\u80fd!", (Throwable)e);
        }
    }

    public static enum SPFeature {
        ConvertNull2EmptyString,
        ConvertZero2EmptyString,
        EnableNullValue,
        IgnoreEmptyStringValue,
        JustUseNamePreffix,
        IgnoreCase,
        CopyIdAndDataStatus,
        CopyId,
        CopyDataStatus,
        DeeplyCopy,
        RemoveTargetGatherItemWhenSourceExclude;

    }
}

