/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.quartz;

import cn.remex.core.quartz.QuartzException;
import cn.remex.core.quartz.SchedulerJobDate;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class SchedulerTask {
    private Class jobClassName = null;
    private String cronExpression = null;
    private SchedulerJobDate endDateInfo = null;
    private int intervalTime = 0;
    private String intervalType = "day";
    private String jobName = "";
    private Calendar startDate = Calendar.getInstance();
    private String triggerName = "";
    protected Map<String, Object> jobParams = new HashMap<String, Object>();

    public SchedulerTask(Class<?> jobClassName, String intervalType, Date startDate) {
        this.jobClassName = jobClassName;
        this.jobName = jobClassName.getSimpleName() + "_Job";
        this.triggerName = jobClassName.getSimpleName() + "_Trigger";
        this.intervalType = intervalType;
        this.startDate.setTime(startDate);
    }

    public SchedulerTask(Class<?> jobClassName, String cronExpression) {
        this.jobClassName = jobClassName;
        this.jobName = jobClassName.getSimpleName() + "_Job";
        this.triggerName = jobClassName.getSimpleName() + "_Trigger";
        this.intervalType = "cron";
        this.cronExpression = cronExpression;
    }

    public Trigger obtainTrigger(String group) {
        Trigger trigger = null;
        int year = this.startDate.get(1);
        int month = this.startDate.get(2);
        int day = this.startDate.get(5);
        int weekDay = this.startDate.get(7);
        int hour = this.startDate.get(11);
        int minute = this.startDate.get(12);
        if ("day".equalsIgnoreCase(this.intervalType)) {
            trigger = TriggerUtils.makeDailyTrigger((String)this.triggerName, (int)hour, (int)minute);
        } else if ("week".equalsIgnoreCase(this.intervalType)) {
            trigger = TriggerUtils.makeWeeklyTrigger((String)this.triggerName, (int)weekDay, (int)hour, (int)minute);
        } else if ("month".equalsIgnoreCase(this.intervalType)) {
            trigger = TriggerUtils.makeMonthlyTrigger((String)this.triggerName, (int)day, (int)hour, (int)minute);
        } else if ("once".equalsIgnoreCase(this.intervalType)) {
            this.startDate.set(13, 1);
            trigger = new SimpleTrigger(this.triggerName, group, this.startDate.getTime(), null, 0, 0L);
        } else if ("sec".equalsIgnoreCase(this.intervalType) || "min".equalsIgnoreCase(this.intervalType)) {
            GregorianCalendar cal;
            if ((cal = new GregorianCalendar(year, --month, day, hour, minute)).getTimeInMillis() < System.currentTimeMillis()) {
                return null;
            }
            trigger = "sec".equalsIgnoreCase(this.intervalType) ? TriggerUtils.makeSecondlyTrigger((int)this.intervalTime) : TriggerUtils.makeMinutelyTrigger((int)this.intervalTime);
            trigger.setName(this.triggerName);
            trigger.setStartTime(cal.getTime());
            if (this.endDateInfo != null) {
                year = this.endDateInfo.getYear();
                month = this.endDateInfo.getMonth() - 1;
                day = this.endDateInfo.getDay();
                hour = this.endDateInfo.getHour();
                minute = this.endDateInfo.getMinute();
                GregorianCalendar cal2 = new GregorianCalendar(year, month, day, hour, minute);
                trigger.setEndTime(cal2.getTime());
            }
        } else if ("cron".equals(this.intervalType)) {
            trigger = new CronTrigger();
            trigger.setName(this.triggerName);
            try {
                ((CronTrigger)trigger).setCronExpression(this.cronExpression);
                trigger.setStartTime(this.startDate.getTime());
            }
            catch (ParseException e) {
                throw new QuartzException("\u521b\u5efaday\u7c7b\u578b\uff0c\u51fa\u53d1\u5c0f\u65f6\u5185\uff0c\u6bcf30\u79d2\u542f\u52a8\u4e00\u6b21", e);
            }
        } else {
            throw new QuartzException("\u5fc5\u987b\u6307\u5b9a\u4efb\u52a1\u7684\u7c7b\u578b\uff0c\u652f\u6301day/week/month/once/sec/min");
        }
        return trigger;
    }

    public JobDetail obtainJobDetail(String group) {
        JobDetail detail = new JobDetail(this.jobName, group, this.jobClassName);
        JobDataMap dataMap = detail.getJobDataMap();
        dataMap.put("JOBNAME", this.jobName);
        dataMap.putAll(this.jobParams);
        return detail;
    }

    public void putJobParams(String key, Object param) {
        this.jobParams.put(key, param);
    }

    public SchedulerTask assignJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public SchedulerTask assignTriggerName(String triggerName) {
        this.triggerName = triggerName;
        return this;
    }

    public SchedulerTask delayStart(int delaySecond) {
        this.startDate.setTime(new Date(new Date().getTime() + (long)(delaySecond * 1000)));
        return this;
    }

    public Class getJobClassName() {
        return this.jobClassName;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public SchedulerJobDate getEndDateInfo() {
        return this.endDateInfo;
    }

    public int getIntervalTime() {
        return this.intervalTime;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setJobClassName(Class jobClassName) {
        this.jobClassName = jobClassName;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setEndDateInfo(SchedulerJobDate endDateInfo) {
        this.endDateInfo = endDateInfo;
    }

    public void setIntervalTime(int intervalTime) {
        this.intervalTime = intervalTime;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }
}

