/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.quartz;

import cn.remex.core.quartz.QuartzException;
import cn.remex.core.quartz.SchedulerTask;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerHandler {
    private static Map<String, SchedulerHandler> SchedulerHandlers = new HashMap<String, SchedulerHandler>();
    private static StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
    private List<SchedulerTask> schedulerTasks;
    private Scheduler scheduler;
    private String group = "DefaultGroup";

    public static SchedulerHandler getDefaultSchedulerHandler() {
        return SchedulerHandler.getSchedulerHandler("default");
    }

    public static SchedulerHandler getSchedulerHandler(String SchedulerHandlerName) {
        SchedulerHandler schedulerHandler = SchedulerHandlers.get(SchedulerHandlerName);
        if (null == schedulerHandler) {
            schedulerHandler = new SchedulerHandler(SchedulerHandlerName);
            SchedulerHandlers.put(SchedulerHandlerName, schedulerHandler);
            schedulerHandler.group = SchedulerHandlerName;
        }
        return schedulerHandler;
    }

    private SchedulerHandler(String group) {
        try {
            this.scheduler = schedulerFactory.getScheduler();
            this.schedulerTasks = new Vector<SchedulerTask>();
            this.group = group;
        }
        catch (SchedulerException e) {
            throw new QuartzException("\u521b\u5efaSchedulerHandler\u5931\u8d25\uff01", e);
        }
    }

    public boolean addJob(SchedulerTask task) {
        if (this.schedulerTasks.contains(task)) {
            throw new QuartzException("\u4efb\u52a1\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        try {
            JobDetail jobdtl = task.obtainJobDetail(this.group);
            if (jobdtl == null) {
                return false;
            }
            Trigger trigger = task.obtainTrigger(this.group);
            if (trigger == null) {
                return false;
            }
            this.scheduler.scheduleJob(jobdtl, trigger);
        }
        catch (SchedulerException e) {
            throw new QuartzException("\u4efb\u52a1\u5b89\u6392\u5931\u8d25\uff01", e);
        }
        this.schedulerTasks.add(task);
        return true;
    }

    public void againStart() {
        try {
            for (SchedulerTask temp : this.schedulerTasks) {
                if (temp.getJobName().equalsIgnoreCase("RestartMinTrigger")) continue;
                this.addJob(temp);
            }
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new QuartzException("\u91cd\u65b0\u542f\u52a8\u65e5\u7a0b\u5931\u8d25\uff01", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteJob(SchedulerTask task) {
        boolean b = false;
        try {
            this.scheduler.pauseTrigger(task.getTriggerName(), this.group);
            b = this.scheduler.deleteJob(task.getJobName(), this.group);
        }
        catch (SchedulerException e) {
            boolean bl = b;
            return bl;
        }
        finally {
            this.schedulerTasks.remove(task);
        }
        return b;
    }

    public boolean onceJob(Class<?> jobClass, Date date, Object ... jobParams) {
        SchedulerTask task = new SchedulerTask(jobClass, "once", date);
        if (null != jobParams && 0 < jobParams.length && jobParams.length % 2 == 0) {
            int s = jobParams.length;
            for (int i = 0; i < s; i += 2) {
                task.putJobParams(jobParams[i].toString(), jobParams[i + 1]);
            }
        }
        return this.addJob(task) && this.schedulerTasks.remove(task);
    }

    public void restart() {
        this.stop();
        this.againStart();
    }

    public void start() {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new QuartzException("\u542f\u52a8\u65e5\u7a0b\u5931\u8d25\uff01", e);
        }
    }

    public void start(Collection<SchedulerTask> tasks) {
        if (tasks != null) {
            for (SchedulerTask temp : tasks) {
                this.addJob(temp);
            }
        }
        this.start();
    }

    public void stop() {
        if (this.scheduler != null) {
            SchedulerHandlers.remove(this.group);
            try {
                this.scheduler.shutdown(true);
            }
            catch (SchedulerException e) {
                throw new QuartzException("\u505c\u6b62\u65e5\u7a0b\u5931\u8d25\uff01", e);
            }
            finally {
                this.scheduler = null;
            }
        }
    }
}

