/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.net;

import cn.remex.RemexConstants;
import cn.remex.core.exception.NetException;
import cn.remex.core.exception.RIOException;
import cn.remex.core.exception.StringHandleException;
import cn.remex.core.net.HttpCosumerEntity;
import cn.remex.core.util.Assert;
import cn.remex.core.util.FileHelper;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.core.util.StringHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Consumer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public final class HttpHelper {
    public static String send(String url, String requestBody) {
        return HttpHelper.sendBackStr(url, "UTF-8", null, null, requestBody);
    }

    private static String sendBackStr(String url, String charset, String httpMethod, String contextType, String requestBody) {
        Param param = new Param();
        HttpHelper.doHttpSend(url, charset, httpMethod, contextType, httpCosumerEntity -> {
            try {
                StringHelper.writeToStream(requestBody, charset, httpCosumerEntity.getOutputStream());
                param.param = StringHelper.readFromStream(charset, httpCosumerEntity.getInputStream());
            }
            catch (Exception e) {
                throw new NetException("HttpPost\u5931\u8d25\uff0curl\u4e3a\uff1a" + url, e);
            }
        });
        return (String)param.param;
    }

    public static void send(String url, String charset, String httpMethod, String contextType, Consumer<HttpCosumerEntity> httpCosumerEntityConsumer) {
        Assert.notNull(httpCosumerEntityConsumer, "ERROR", "http\u8bf7\u6c42\u6d88\u8d39\u4e0d\u80fd\u4e0d\u4e3a\u7a7a\uff01");
        HttpHelper.doHttpSend(url, charset, httpMethod, contextType, httpCosumerEntityConsumer);
    }

    public static void send(String url, Consumer<HttpCosumerEntity> httpCosumerEntityConsumer) {
        Assert.notNull(httpCosumerEntityConsumer, "ERROR", "http\u8bf7\u6c42\u6d88\u8d39\u4e0d\u80fd\u4e0d\u4e3a\u7a7a\uff01");
        HttpHelper.doHttpSend(url, "UTF-8", null, null, httpCosumerEntityConsumer);
    }

    public static File sendReturnFile(String url, String requestBody, String filePath) {
        Assert.notNull(filePath, "ERROR", "http\u8bf7\u6c42\u4fdd\u5b58\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Param param = new Param();
        HttpHelper.doHttpSend(url, "UTF-8", null, null, httpCosumerEntity -> {
            StringHelper.writeToStream(requestBody, "UTF-8", httpCosumerEntity.getOutputStream());
            param.param = FileHelper.saveFile(filePath, httpCosumerEntity.getInputStream());
        });
        return (File)param.param;
    }

    public static String obtainHttpPack(InputStream input) {
        byte[] buffer = new byte[1024];
        int count = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BufferedInputStream bfInput = new BufferedInputStream(input);
            while ((count = bfInput.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new RIOException("\u4eceHttpServletRequest\u4e2d\u8bfb\u53d6\u6d41\u5f02\u5e38\uff01", e);
        }
        try {
            String content = baos.toString("UTF-8");
            return content;
        }
        catch (UnsupportedEncodingException e) {
            throw new StringHandleException("\u8bfb\u53d6Post\u8bf7\u6c42\u62a5\u6587\u65f6\uff0c\u8fdb\u884cUTF-8\u8f6c\u7801\u53d1\u751f\u5f02\u5e38!", e);
        }
    }

    public static void writeToResponse(String content, HttpServletResponse response) {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        ByteArrayInputStream in = null;
        Object outp = null;
        try {
            in = new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new StringHandleException("\u5b57\u7b26\u7f16\u7801\u4e0d\u53d7\u652f\u6301", e);
        }
        HttpHelper.writeToResponse(in, response);
    }

    public static void writeToResponse(File file, HttpServletResponse response) {
        FileInputStream in = null;
        Object outp = null;
        try {
            in = new FileInputStream(file);
            HttpHelper.writeToResponse(in, response);
        }
        catch (FileNotFoundException e) {
            RemexConstants.logger.warn((Object)"writeToResponse\u65f6\uff0c\u65e0\u6cd5\u6253\u5f00\u6587\u4ef6", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToResponse(InputStream in, HttpServletResponse response) {
        ServletOutputStream outp = null;
        try {
            int i;
            outp = response.getOutputStream();
            byte[] b = new byte[1024];
            while ((i = in.read(b)) > 0) {
                outp.write(b, 0, i);
            }
            outp.flush();
        }
        catch (FileNotFoundException e) {
            RemexConstants.logger.warn((Object)"writeToResponse\u65f6\uff0c\u65e0\u6cd5\u6253\u5f00\u6587\u4ef6", (Throwable)e);
        }
        catch (IOException e) {
            RemexConstants.logger.warn((Object)"writeToResponse\u65f6\uff0c\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    RemexConstants.logger.warn((Object)"writeToResponse\u6d41\u5173\u95ed\u5931\u8d25");
                }
            }
            if (outp != null) {
                try {
                    outp.close();
                    outp = null;
                }
                catch (IOException e) {
                    RemexConstants.logger.warn((Object)"writeToResponse\u6d41\u5173\u95ed\u5931\u8d25");
                }
            }
        }
    }

    private static void doHttpSend(String url, String charset, String httpMethod, String contextType, Consumer<HttpCosumerEntity> httpCosumerEntityConsumer) {
        HttpURLConnection httpConnection = null;
        try {
            httpConnection = (HttpURLConnection)new URL(url).openConnection();
            httpConnection.setRequestMethod(Judgment.nullOrBlank(httpMethod) ? "POST" : httpMethod);
            httpConnection.setRequestProperty("Content-Type", Judgment.nullOrBlank(contextType) ? "text/html" : contextType);
            httpConnection.setRequestProperty("contentType", Judgment.nullOrBlank(contextType) ? "text/html" : contextType);
            httpConnection.setRequestProperty("Accept-Charset", charset);
            httpConnection.setDoOutput(true);
            httpConnection.setDoInput(true);
            httpConnection.setAllowUserInteraction(true);
            httpConnection.connect();
            HttpCosumerEntity httpCosumerEntity = new HttpCosumerEntity(httpConnection);
            httpCosumerEntityConsumer.accept(httpCosumerEntity);
        }
        catch (Exception e) {
            throw new NetException("HttpPost\u5931\u8d25\uff0curl\u4e3a\uff1a" + url, e);
        }
        finally {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
        }
    }
}

