/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.exception;

public class NestedException
extends RuntimeException {
    private static final long serialVersionUID = -5222171049433335216L;
    private String errorCode;

    public NestedException(String errorCode, String msg) {
        super(msg);
        this.errorCode = errorCode;
    }

    public NestedException(String errorCode, String msg, Throwable cause) {
        super(msg, cause);
        this.errorCode = errorCode;
    }

    public boolean contains(Class<?> exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof NestedException) {
            return ((NestedException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }

    @Override
    public String getMessage() {
        return NestedException.buildMessage(super.getMessage(), this.getCause());
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public Throwable getRootCause() {
        Throwable rootCause = null;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static String buildMessage(String message, Throwable cause) {
        if (cause != null) {
            StringBuffer buf = new StringBuffer();
            if (message != null) {
                buf.append(message).append("\r\n");
            }
            buf.append("Caused by: ").append(cause);
            return buf.toString();
        }
        return message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Deprecated
    public NestedException(String msg) {
        super(msg);
    }

    @Deprecated
    public NestedException(String msg, Throwable cause) {
        super(msg, cause);
    }
}

