/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.cache;

import cn.remex.RemexConstants;
import cn.remex.core.cache.DataCacheCloneable;
import cn.remex.core.cache.PoolNotSupportedBeansException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DataCachePool<T extends DataCacheCloneable>
implements RemexConstants {
    private static Map<String, Map<Object, Object>> caches = new HashMap<String, Map<Object, Object>>();
    private int curCount = 1;
    private int maxCount = 16;
    private Vector<T> vector = new Vector();

    private DataCachePool(T t) {
        this.vector.addElement(t);
        try {
            this.vector.addElement((DataCacheCloneable)t.clone());
            ++this.curCount;
            this.vector.addElement((DataCacheCloneable)t.clone());
            ++this.curCount;
        }
        catch (CloneNotSupportedException e) {
            throw new PoolNotSupportedBeansException(t.getClass());
        }
    }

    public static Object get(String type, Object key) {
        Map<Object, Object> cache = caches.get(type);
        return null == cache ? null : caches.get(type).get(key);
    }

    public static void put(String type, Object key, Object value) {
        Map<Object, Object> cache = caches.get(type);
        if (null == cache) {
            cache = new HashMap<Object, Object>();
            caches.put(type, cache);
        }
        cache.put(key, value);
    }

    public static void reset() {
        caches = new HashMap<String, Map<Object, Object>>();
    }

    public static synchronized <PT extends DataCacheCloneable> DataCachePool<PT> createPool(PT t) {
        return new DataCachePool<PT>(t);
    }

    public synchronized void add(T t) {
        if (loggerDebug) {
            logger.debug((Object)(t.getClass() + "\u56de\u6536\u4e2d,\u5f53\u524d\u603b\u6570:" + this.curCount + ";" + t.toString()));
        }
        if (this.vector.size() >= this.maxCount) {
            --this.curCount;
        } else {
            this.vector.add(t);
        }
    }

    public synchronized T get() {
        DataCacheCloneable t = null;
        if (this.vector.size() > 1) {
            t = (DataCacheCloneable)this.vector.firstElement();
            this.vector.removeElementAt(0);
        } else {
            try {
                t = (DataCacheCloneable)((DataCacheCloneable)this.vector.firstElement()).clone();
                ++this.curCount;
            }
            catch (CloneNotSupportedException e) {
                t = null;
            }
        }
        return (T)t;
    }

    public int size() {
        return this.vector.size();
    }
}

