/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core;

import cn.remex.RemexConstants;
import cn.remex.core.util.Assert;
import cn.remex.core.util.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CoreSvo {
    public static final ThreadLocal<Map<String, Object>> localParams = new ThreadLocal();
    public static final String HTTP_REQUEST_KEY = "CORESVO_HTTP_REQUEST";
    public static final String HTTP_RESPONSE_KEY = "CORESVO_HTTP_RESPONSE";
    public static final String HTTP_COOKIES = "CORESVO_HTTP_COOKIES";
    public static final String HTTP_SESSION = "CORESVO_HTTP_SESSION";

    public static void initHttp(HttpServletRequest request, HttpServletResponse response) {
        CoreSvo.putLocal(HTTP_REQUEST_KEY, request);
        CoreSvo.putLocal(HTTP_RESPONSE_KEY, response);
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        if (null != request.getCookies()) {
            for (Cookie cookie : request.getCookies()) {
                cookies.put(cookie.getName(), cookie);
            }
        }
        CoreSvo.putLocal(HTTP_COOKIES, cookies);
        CoreSvo.putLocal(HTTP_SESSION, request.getSession());
    }

    public static void putLocal(String key, Object value) {
        Map<String, Object> map = localParams.get();
        if (null == map) {
            map = new HashMap<String, Object>();
            localParams.set(map);
        }
        map.put(key, value);
    }

    public static void destoryHttp() {
        CoreSvo.putLocal(HTTP_REQUEST_KEY, null);
        CoreSvo.putLocal(HTTP_RESPONSE_KEY, null);
        CoreSvo.putLocal(HTTP_COOKIES, null);
        CoreSvo.putLocal(HTTP_SESSION, null);
    }

    public static Object valSession(String key) {
        HttpSession session = (HttpSession)CoreSvo.valLocal(HTTP_SESSION);
        Assert.notNull(session, "ERROR", "\u6ca1\u6709\u521d\u59cb\u5316Cookies\u4f1a\u8bdd\u5bb9\u5668\uff0c\u8bf7\u8c03\u7528CoreSvo.initHttp()\uff01");
        return session.getAttribute(key);
    }

    public static Object valLocal(String key) {
        Map<String, Object> map = localParams.get();
        if (null == map) {
            map = new HashMap<String, Object>();
            localParams.set(map);
        }
        return map.get(key);
    }

    public static void putSession(String key, String value) {
        HttpSession session = (HttpSession)CoreSvo.valLocal(HTTP_SESSION);
        Assert.notNull(session, "ERROR", "\u6ca1\u6709\u521d\u59cb\u5316Cookies\u4f1a\u8bdd\u5bb9\u5668\uff0c\u8bf7\u8c03\u7528CoreSvo.initHttp()\uff01");
        session.setAttribute(key, (Object)value);
    }

    public static String valCookieValue(String key) {
        Cookie cookie = CoreSvo.valCookie(key);
        String string = cookie != null ? StringHelper.urlDecode(cookie.getValue(), "UTF-8") : null;
        return string;
    }

    public static Cookie valCookie(String key) {
        if (CoreSvo.valLocal(HTTP_REQUEST_KEY) == null) {
            RemexConstants.logger.warn((Object)"\u5728\u975eHTTP\u73af\u5883\u4e2d\u83b7\u53d6cookie\u5931\u8d25\uff0c\u76f4\u63a5\u8fd4\u56denull");
            return null;
        }
        Map cookies = (Map)CoreSvo.valLocal(HTTP_COOKIES);
        return (Cookie)cookies.get(key);
    }

    public static void putCookie(String name, String value) {
        try {
            String v = value != null ? URLEncoder.encode(value, "UTF-8") : value;
            Cookie cookie = new Cookie(name, v);
            cookie.setPath("/");
            cookie.setVersion(1);
            Map cookies = (Map)CoreSvo.valLocal(HTTP_COOKIES);
            cookies.put(name, cookie);
            CoreSvo.putCookie(cookie);
        }
        catch (UnsupportedEncodingException e) {
            RemexConstants.logger.error((Object)"Cookies\u8bbe\u7f6e\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static void putCookie(Cookie cookie) {
        HttpServletResponse response = (HttpServletResponse)CoreSvo.valLocal(HTTP_RESPONSE_KEY);
        Assert.notNull(response, "ERROR", "\u6ca1\u6709\u521d\u59cb\u5316Cookies\u4f1a\u8bdd\u5bb9\u5668\uff0c\u8bf7\u8c03\u7528CoreSvo.initHttp()\uff01");
        Map cookies = (Map)CoreSvo.valLocal(HTTP_COOKIES);
        if (null == cookie.getValue()) {
            cookies.remove(cookie.getName());
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        } else {
            cookies.put(cookie.getName(), cookie);
            response.addCookie(cookie);
        }
    }
}

