/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.contrib.service;

import cn.remex.RemexConstants;
import cn.remex.contrib.appbeans.DataRvo;
import cn.remex.contrib.auth.AuthenticateBtx;
import cn.remex.contrib.service.WeiXinService;
import cn.remex.core.CoreSvo;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.MapHelper;
import cn.remex.db.Database;
import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.model.SysMenu;
import cn.remex.db.model.cert.AuthRole;
import cn.remex.db.model.cert.AuthUser;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.sql.Sort;
import cn.remex.db.sql.SqlColumn;
import cn.remex.db.sql.WhereGroupOp;
import cn.remex.db.sql.WhereRuleOper;
import cn.remex.web.service.BsRvo;
import cn.remex.web.service.BusinessService;
import cn.remex.wechat.WeChat;
import cn.remex.wechat.beans.ticket.QrcodeUrl;
import cn.remex.wechat.models.WeChatNotify;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

@BusinessService
public class UserService {
    @BusinessService
    public BsRvo updateUserStatus(String statusBean) {
        AuthUser curUser = AuthenticateBtx.obtainCurUser();
        curUser.setStatusBean(statusBean);
        Database.getSession().store(curUser);
        return new BsRvo("SUCCESS", "OK");
    }

    @BusinessService
    public BsRvo userProfile() {
        String UID = CoreSvo.valCookieValue("UID");
        Assert.notNullAndEmpty(UID, "ACCOUNT_NOT_AUTH", "\u8bf7\u5148\u767b\u5f55!");
        AuthUser curUser = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getUsername, WhereRuleOper.eq, (Object)UID).withList(AuthUser::getRoles, l -> l.withList(AuthRole::getMenus, SqlColumn::withBase).withList(AuthRole::getModules, SqlColumn::withBase)).rowCount(1000).ready().queryBean();
        Assert.notNullAndEmpty(curUser, "ACCOUNT_ERROR", "\u7528\u6237\u4fe1\u606f\u9519\u8bef!");
        HashMap menus = new HashMap();
        if (!Judgment.nullOrBlank(curUser.getRoles())) {
            curUser.getRoles().forEach(r -> {
                if (r.getMenus() != null) {
                    r.getMenus().forEach(m -> {
                        HashMap<String, String> m2 = new HashMap<String, String>();
                        m2.put("id", m.getId());
                        m2.put("nodeName", m.getNodeName());
                        m2.put("nodeUri", m.getNodeUri());
                        m2.put("icon", m.getIcon());
                        menus.put(m.getId(), m2);
                    });
                    r.setMenus(null);
                }
            });
        }
        HashMap<String, Serializable> profile = new HashMap<String, Serializable>();
        profile.put("menus", menus);
        profile.put("curUser", curUser);
        return new BsRvo("SUCCESS", "Query UserProfile Finished.", profile);
    }

    @BusinessService(cachedArgIndexs={0})
    public BsRvo homeMenus(String rootMenu) {
        DbCvo<SysMenu> dbCvo = Database.createDbCvo(SysMenu.class).orderBy(SysMenu::getNodeOrder, Sort.ASC).filterByModel(SysMenu::getSupMenu, sup -> sup.filterBy(SysMenu::getNodeName, WhereRuleOper.eq, (Object)(Judgment.nullOrBlank(rootMenu) ? "ROOTMENU" : rootMenu))).withModel(SysMenu::getSupMenu, c -> c.withBase(ModelableImpl::getId)).withBase().withList(SysMenu::getSubMenus, sm -> sm.withBase().withList(SysMenu::getSubMenus, SqlColumn::withBase)).rowCount(1000);
        DbRvo<SysMenu> dbRvo = dbCvo.ready().query();
        return new DataRvo(dbRvo);
    }

    @BusinessService(needAuth=false)
    public BsRvo logout(String username, String password, String redirect) {
        AuthenticateBtx.clearToken();
        return new BsRvo("SUCCESS", "\u9000\u51fa\u767b\u5f55", null, RemexConstants.ResponseContentType.redirect, "./login.html");
    }

    @BusinessService
    public BsRvo resetPassword(String oldPassword, String newPassword) {
        if (Judgment.nullOrBlank(oldPassword) || Judgment.nullOrBlank(newPassword)) {
            return new BsRvo("ACCOUNT_PASSWORD_INVALID", "\u539f\u5bc6\u7801/\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        AuthUser authUser = AuthenticateBtx.obtainCurUser();
        if (authUser.getPassword().equals(oldPassword)) {
            authUser.setPassword(newPassword);
            Database.getSession().store(authUser);
            AuthenticateBtx.clearToken();
            return new BsRvo("SUCCESS", "\u6210\u529f");
        }
        return new BsRvo("ACCOUNT_PASSWORD_NOTMATCH", "\u539f\u5bc6\u7801\u4e0d\u80fd\u6b63\u786e\uff01");
    }

    @BusinessService
    public BsRvo modifyMobile(String oldPassword, String mobile) {
        Assert.notNullAndEmpty(oldPassword, "ACCOUNT_PASSWORD_INVALID", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNullAndEmpty(mobile, "FAIL", "\u624b\u673a\u4e0d\u80fd\u4e3a\u7a7a!");
        AuthUser authUser = AuthenticateBtx.obtainCurUser();
        if (authUser.getPassword().equals(oldPassword)) {
            authUser.setMobile(mobile);
            Database.getSession().store(authUser);
            return new BsRvo("SUCCESS", "\u6210\u529f");
        }
        return new BsRvo("ACCOUNT_PASSWORD_NOTMATCH", "\u539f\u5bc6\u7801\u4e0d\u80fd\u6b63\u786e\uff01");
    }

    @BusinessService(needAuth=false)
    public BsRvo login(String username, String password, String redirect) {
        Assert.notNullAndEmpty(username, "ACCOUNT_USERNAME_INVALID", "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNullAndEmpty(password, "ACCOUNT_PASSWORD_INVALID", "\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<AuthUser> authUsers = Database.createDbCvo(AuthUser.class).withList(AuthUser::getRoles, r -> r.withList(AuthRole::getModules, SqlColumn::withBase)).withBase().filterBy(AuthUser::getPassword, WhereRuleOper.eq, (Object)password).filterByGroup(g -> g.filterOper(WhereGroupOp.OR).filterBy(AuthUser::getUsername, WhereRuleOper.eq, username).filterBy(AuthUser::getMobile, WhereRuleOper.eq, username)).ready().query().obtainObjects(AuthUser.class);
        if (authUsers.size() == 1) {
            Map<String, String> tokeMap = AuthenticateBtx.placeToken(authUsers.get(0));
            ArrayList modules = new ArrayList();
            if (authUsers.get(0).getRoles() != null) {
                authUsers.get(0).getRoles().forEach(role -> {
                    if (role.getModules() != null) {
                        role.getModules().forEach(moduel -> modules.add(moduel));
                    }
                });
            }
            return new BsRvo("SUCCESS", "\u767b\u5f55\u6210\u529f", MapHelper.toMap(tokeMap, "statusBean", authUsers.get(0).getStatusBean(), "modules", modules));
        }
        if (authUsers.size() > 1) {
            AuthenticateBtx.clearToken();
            return new BsRvo("ACCOUNT_ERROR", "\u8d26\u53f7\u5f02\u5e38");
        }
        AuthenticateBtx.clearToken();
        return new BsRvo("FAIL", "\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
    }

    @BusinessService(needAuth=false)
    public BsRvo obtainWeixinLoginUrl() {
        QrcodeUrl qrcodeUrl = new QrcodeUrl(WeChat.getWeChatApp().qrcode_create_scene("100", "120"));
        Assert.notNullAndEmpty(qrcodeUrl.getTicketUrl(), "FAIL", "\u901a\u8fc7\u5fae\u4fe1\u767b\u5f55\u65f6\uff0c\u83b7\u53d6\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5931\u8d25");
        return new BsRvo("SUCCESS", "\u4ee5\u83b7\u53d6\u5230\u7ed1\u5b9a\u5fae\u4fe1\u7684\u4e8c\u7ef4\u7801", qrcodeUrl);
    }

    @BusinessService(needAuth=false)
    public BsRvo loginByWeixin(String ticket) {
        Assert.notNullAndEmpty(ticket, "FAIL", "Ticket\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        WeChatNotify weChatNotify = Database.createDbCvo(WeChatNotify.class).filterBy(WeChatNotify::getTicket, WhereRuleOper.eq, (Object)ticket).filterBy(WeChatNotify::getMsgTime, WhereRuleOper.gt, (Object)(new Date().getTime() / 1000L - 180L)).ready().queryBean();
        if (Judgment.nullOrBlank(weChatNotify)) {
            return new BsRvo("FAIL", "\u672a\u626b\u63cf\u4e8c\u7ef4\u7801");
        }
        if (new Date().getTime() / 1000L - weChatNotify.getMsgTime() > 300L) {
            return new BsRvo("FAIL", "\u626b\u63cf\u8d85\u65f6");
        }
        AuthUser curAuthUser = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getOpenid, WhereRuleOper.eq, (Object)weChatNotify.getFromUserName()).ready().queryBean();
        if (Judgment.nullOrBlank(curAuthUser)) {
            return new BsRvo("FAIL", "\u8bf7\u4f7f\u7528\u7ed1\u5b9a\u7684\u5fae\u4fe1\u53f7\u626b\u63cf\u4e8c\u7ef4\u7801");
        }
        AuthenticateBtx.placeToken(curAuthUser);
        return new BsRvo("SUCCESS", "\u767b\u5f55\u6210\u529f", "/");
    }

    @BusinessService
    public BsRvo bindWeixin() {
        Assert.nullOrEmpty(AuthenticateBtx.obtainCurUser().getOpenid(), "WEIXIN_HAS_BIND", "\u5df2\u7ecf\u7ed1\u5b9a");
        QrcodeUrl aa = new QrcodeUrl(WeChat.getWeChatApp().qrcode_create_limitScene(AuthenticateBtx.obtainCurUser().getId()));
        Assert.notNullAndEmpty(aa.getTicketUrl(), "FAIL", "\u7ed1\u5b9a\u5fae\u4fe1\u65f6\uff0c\u83b7\u53d6\u5fae\u4fe1\u4e8c\u7ef4\u7801\u5931\u8d25");
        return new BsRvo("SUCCESS", "\u4ee5\u83b7\u53d6\u5230\u7ed1\u5b9a\u5fae\u4fe1\u7684\u4e8c\u7ef4\u7801", aa);
    }

    @BusinessService
    public BsRvo checkBindWeixin(String ticket, String createTime) {
        Assert.notNullAndEmpty(ticket, "FAIL", "Ticket\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        WeChatNotify weChatNotify = Database.createDbCvo(WeChatNotify.class).filterBy(WeChatNotify::getTicket, WhereRuleOper.eq, (Object)ticket).filterBy(WeChatNotify::getMsgTime, WhereRuleOper.gt, (Object)(Long.parseLong(createTime) / 1000L)).ready().queryBean();
        if (Judgment.nullOrBlank(weChatNotify)) {
            return new BsRvo("WEIXIN_NOT_BIND", "\u672a\u626b\u63cf\u4e8c\u7ef4\u7801");
        }
        RemexConstants.logger.info((Object)("\u68c0\u67e5\u7528\u6237\u72b6\u6001, openId:" + weChatNotify.getFromUserName()));
        AuthUser curAuthUser = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getOpenid, WhereRuleOper.eq, (Object)weChatNotify.getFromUserName()).ready().queryBean();
        if (null == curAuthUser || !curAuthUser.getId().equals(AuthenticateBtx.obtainCurUser().getId())) {
            return new BsRvo("OPENID_INVALID", "\u626b\u63cf\u7684\u5fae\u4fe1\u53f7\u65e0\u6548\uff0c\u53ef\u80fd\u5df2\u7ecf\u7ed1\u5b9a\u5176\u4ed6\u8d26\u53f7");
        }
        if (!Judgment.nullOrBlank(curAuthUser.getOpenid())) {
            return new BsRvo("WEIXIN_HAS_BIND", "\u5fae\u4fe1\u5df2\u7ed1\u5b9a");
        }
        return new BsRvo("WEIXIN_NOT_BIND", "\u5fae\u4fe1\u672a\u7ed1\u5b9a");
    }

    @BusinessService
    public BsRvo unbindWeixin(String password) {
        Assert.notNullAndEmpty(password, "FAIL", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AuthenticateBtx.refreshCurUser();
        AuthUser loginUser = AuthenticateBtx.obtainCurUser();
        if (password.equals(loginUser.getPassword())) {
            WeiXinService.dismissedBindUser(loginUser.getOpenid());
            AuthenticateBtx.refreshCurUser();
            return new BsRvo("SUCCESS", "\u89e3\u9664\u7ed1\u5b9a\u6210\u529f", "");
        }
        return new BsRvo("ACCOUNT_PASSWORD_NOTMATCH", "\u539f\u5bc6\u7801\u4e0d\u80fd\u6b63\u786e\uff01");
    }

    public static LoginApiBean loginAndStoreByUsernameApi(RemexConstants.UserType type, String username, Function<AuthUser, AuthUser> createUserFunction, Consumer<AuthUser> successConsumer) {
        AuthUser authUser;
        Assert.notNullAndEmpty((Object)type, "FAIL", "\u901a\u7528\u767b\u5f55API\uff0c\u5fc5\u987b\u6307\u5b9a\u767b\u5f55\u7c7b\u578b");
        Assert.notNullAndEmpty(username, "FAIL", "\u901a\u7528\u767b\u5f55API\uff0c\u5fc5\u987b\u6307\u5b9a\u767b\u5f55\u7528\u6237\u540d");
        DbRvo<AuthUser> authUserRvo = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getUserType, WhereRuleOper.eq, (Object)type).filterBy(AuthUser::getUsername, WhereRuleOper.eq, (Object)username).ready().query();
        Assert.isTrue(authUserRvo.getRecordCount() <= 1, "FAIL", "\u6570\u636e\u9519\u8bef\u7528\u6237\u540d\u5b58\u5728\u591a\u4e2a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        boolean hasBindWeiXin = false;
        if (authUserRvo.getRecordCount() == 1) {
            authUser = authUserRvo.obtainBean();
        } else if (null != createUserFunction && authUserRvo.getRecordCount() == 0) {
            authUser = new AuthUser();
            authUser.setUsername(username);
            authUser.setUserType(type);
            authUser = createUserFunction.apply(authUser);
            Database.insert(AuthUser.class).assignBean(authUser).execute().assertTrue(rvo -> rvo.getEffectRowCount() == 1, "FAIL", "\u521b\u5efa\u7528\u6237\u5931\u8d25");
        } else {
            return new LoginApiBean(false, false, "\u767b\u5f55\u5931\u8d25", null);
        }
        if (null != successConsumer) {
            successConsumer.accept(authUser);
        }
        String openid = CoreSvo.valCookieValue("openId");
        Assert.isTrue(Judgment.nullOrBlank(authUser.getOpenid()) || Judgment.nullOrBlank(openid), "WEIXIN_CANNOT_BIND", "\u8be5\u8d26\u53f7\u5df2\u88ab\u5176\u4ed6\u5fae\u4fe1\u7ed1\u5b9a\uff0c\u767b\u5f55\u5931\u8d25\uff01");
        if ((Judgment.nullOrBlank(authUser.getOpenid()) || Judgment.nullOrBlank(authUser.getUnionid())) && !Judgment.nullOrBlank(openid)) {
            hasBindWeiXin = WeiXinService.bindUser(openid, authUser);
        }
        if (authUser._getModifyFileds() != null || "beanNew".equals(authUser._getDataStatus())) {
            Database.getSession().store(authUser);
        }
        AuthenticateBtx.placeToken(authUser);
        return new LoginApiBean(true, hasBindWeiXin, "\u767b\u5f55\u6210\u529f", AuthenticateBtx.placeToken(authUser));
    }

    public static class LoginApiBean {
        private boolean status;
        private boolean weixinBinded;
        private String msg;
        private String openid;
        private Map params;

        public LoginApiBean(boolean status, boolean weixinBinded, String msg, Map<String, ?> params) {
            this.status = status;
            this.weixinBinded = weixinBinded;
            this.msg = msg;
            this.params = params;
        }

        public BsRvo toCommLoginBsRvo() {
            return new BsRvo(this.isStatus() ? "SUCCESS" : "FAIL", this.getMsg());
        }

        public BsRvo toWeixinEnterLoginBsRvo(Object ... keyAndValue) {
            Assert.isTrue(keyAndValue != null && keyAndValue.length % 2 == 0, "ERROR", "toWeixinBsRvo\u529f\u80fd\u7684\u53c2\u6570\u5fc5\u987b\u4e3akey-value\u6210\u5bf9\u51fa\u73b0");
            if (this.params == null) {
                this.params = new HashMap();
            }
            this.params.put("weixinBindStatus", Judgment.nullOrBlank(this.openid) ? "NOT_BINDED" : "HAS_BINDED");
            if (keyAndValue != null) {
                int c = keyAndValue.length / 2;
                for (int i = 0; i < c; ++i) {
                    this.params.put(keyAndValue[i].toString(), keyAndValue[i + 1]);
                    ++i;
                }
            }
            return new BsRvo(this.isStatus() ? "SUCCESS" : "FAIL", this.getMsg(), this.params);
        }

        public boolean isStatus() {
            return this.status;
        }

        public void setStatus(boolean status) {
            this.status = status;
        }

        public boolean isWeixinBinded() {
            return this.weixinBinded;
        }

        public void setWeixinBinded(boolean weixinBinded) {
            this.weixinBinded = weixinBinded;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

