/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.wechat.wechatservice;

import cn.remex.RemexConstants;
import cn.remex.core.RemexApplication;
import cn.remex.core.util.Assert;
import cn.remex.core.util.FileHelper;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.MapHelper;
import cn.remex.core.util.XmlHelper;
import cn.remex.web.service.BsRvo;
import cn.remex.web.service.BusinessService;
import cn.remex.wechat.WeChat;
import cn.remex.wechat.beans.paymch.PayNotify;
import cn.remex.wechat.event.WeChatPayNotifyEvent;
import cn.remex.wechat.utils.Signature;
import cn.remex.wechat.wechatservice.bean.WeChatPayNotifyOuter;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.stereotype.Component;

@BusinessService
@Component
public class WeChatPayNotify {
    @BusinessService(bodyParamName="xml", needAuth=false)
    public BsRvo payNotify(String xml) {
        RemexConstants.logger.info((Object)("\u6536\u5230\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\uff1a" + xml));
        WeChatPayNotifyOuter weChatPayNotifyOuter = new WeChatPayNotifyOuter();
        String respXmlPath = "RESPONSE_ERROR_" + String.valueOf(System.currentTimeMillis());
        if (Judgment.nullOrBlank(xml)) {
            weChatPayNotifyOuter.setReturn_code("FAIL ");
            weChatPayNotifyOuter.setReturn_msg("\u63a5\u6536\u4fe1\u606f\u4e3a\u7a7a");
            RemexConstants.logger.info((Object)"\u6536\u5230\u5fae\u4fe1\u652f\u4ed8\u901a\u77e5\u6d88\u606f\u4e3aEMPTY");
        } else {
            PayNotify payNotify = XmlHelper.unmarshall(PayNotify.class, xml);
            if (!Judgment.nullOrBlank(payNotify)) {
                Map<String, String> map = MapHelper.objectToFlat(payNotify);
                if (Signature.validateSign(map, WeChat.getWeChatApp().getKey())) {
                    this.saveXMLFile(xml, "PAY", payNotify.getOut_trade_no());
                    respXmlPath = payNotify.getOut_trade_no() + "response";
                    try {
                        RemexApplication.publishEvent(new WeChatPayNotifyEvent("WeChatPayNotifyEvent", payNotify));
                        weChatPayNotifyOuter.setReturn_code("SUCCESS");
                    }
                    catch (Throwable throwable) {
                        RemexConstants.logger.error((Object)"CET\u62a5\u540d\u652f\u4ed8\u5fae\u4fe1\u7aef\u56de\u8c03\u65f6\uff0c\u7cfb\u7edf\u5904\u7406\u51fa\u73b0\u5f02\u5e38\u3002", throwable);
                        weChatPayNotifyOuter.setReturn_code("FAIL");
                        weChatPayNotifyOuter.setReturn_msg(throwable.toString());
                    }
                } else {
                    weChatPayNotifyOuter.setReturn_code("FAIL");
                    weChatPayNotifyOuter.setReturn_msg("\u7b7e\u540d\u5931\u8d25");
                }
            } else {
                weChatPayNotifyOuter.setReturn_code("FAIL");
                weChatPayNotifyOuter.setReturn_msg("\u89e3\u6790\u62a5\u6587\u4f53\u4e3a\u7a7a");
            }
        }
        String respXml = XmlHelper.marshall(weChatPayNotifyOuter);
        this.saveXMLFile(respXml, "PAY", respXmlPath);
        return new BsRvo("SUCCESS", "OK", respXml, RemexConstants.ResponseContentType.text, null);
    }

    private boolean saveXMLFile(String xml, String type, String fileName) {
        String curSystem = System.getProperty("os.name");
        String baseXmlFilePath = null;
        if (curSystem.toUpperCase().startsWith("WIN")) {
            baseXmlFilePath = WeChat.WIN_PATH;
        } else if (curSystem.toUpperCase().startsWith("LINUX")) {
            baseXmlFilePath = WeChat.LINUX_PATH;
        }
        Assert.notNull(baseXmlFilePath, "ERROR", "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LocalDateTime localDateTime = LocalDateTime.now().withNano(0);
        DateTimeFormatter f = DateTimeFormatter.ofPattern("HHmmss");
        FileHelper.saveFileContent(baseXmlFilePath + File.separator + type + File.separator + localDateTime.toLocalDate().toString() + File.separator + fileName + ".xml", xml);
        return true;
    }
}

