/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.wechat.wechatservice;

import cn.remex.RemexConstants;
import cn.remex.core.RemexApplication;
import cn.remex.core.util.Assert;
import cn.remex.core.util.FileHelper;
import cn.remex.core.util.Judgment;
import cn.remex.web.service.BsRvo;
import cn.remex.web.service.BusinessService;
import cn.remex.wechat.WeChat;
import cn.remex.wechat.config.WeChatApp;
import cn.remex.wechat.event.WeChatClickEvent;
import cn.remex.wechat.event.WeChatEvent;
import cn.remex.wechat.event.WeChatScanEvent;
import cn.remex.wechat.event.WeChatSubscribeEvent;
import cn.remex.wechat.event.WeChatTextEvent;
import cn.remex.wechat.event.WeChatUnsubscribeEvent;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

@BusinessService
public class WeChatCommService {
    @BusinessService(bodyParamName="xml", needAuth=false)
    public BsRvo dispatchWeChat(String appid, String agentid, String signature, String msg_signature, String timestamp, String nonce, String echoStr, String echostr, String xml) {
        WeChatApp curWeChatApp = WeChat.getWeChatApp(appid, agentid);
        signature = Judgment.nullOrBlank(signature) ? msg_signature : signature;
        String string = echostr = Judgment.nullOrBlank(echostr) ? echoStr : echostr;
        if (!Judgment.nullOrBlank(echostr)) {
            String ret_echostr = curWeChatApp.verifyURL(signature, timestamp, nonce, echostr);
            RemexConstants.logger.info((Object)"\u5fae\u4fe1->\u9a8c\u8bc1\u8bf7\u6c42\uff01");
            return new BsRvo("SUCCESS", "OK", ret_echostr, RemexConstants.ResponseContentType.text, null);
        }
        if (!Judgment.nullOrBlank(xml)) {
            String resXml = this.XmlOperation(curWeChatApp, signature, timestamp, nonce, xml);
            return new BsRvo("SUCCESS", "OK", resXml, RemexConstants.ResponseContentType.text, null);
        }
        RemexConstants.logger.info((Object)"\u5fae\u4fe1->\u9519\u8bef\u8bf7\u6c42\uff01");
        return new BsRvo("SUCCESS", "OK", "\u8bf7\u6c42\u9519\u8bef", RemexConstants.ResponseContentType.text, null);
    }

    private String XmlOperation(WeChatApp curWeChatApp, String signature, String timeStamp, String nonce, String reqXml) {
        String resXml = "";
        try {
            reqXml = curWeChatApp.decryptMsg(signature, timeStamp, nonce, reqXml);
            RemexConstants.logger.info((Object)("\u5fae\u4fe1->\u56de\u8c03\u4fe1\u606f\uff01 \u4e3a\uff1a" + reqXml));
            Document document = DocumentHelper.parseText((String)reqXml);
            String msgType = document.getRootElement().elementText("MsgType");
            String fromUserName = document.getRootElement().elementText("FromUserName");
            String toUserName = document.getRootElement().elementText("ToUserName");
            long createTime = Long.parseLong(document.getRootElement().elementText("CreateTime"));
            String event = document.getRootElement().elementText("Event");
            String eventKey = document.getRootElement().elementText("EventKey");
            String ticket = document.getRootElement().elementText("Ticket");
            Assert.notNullAndEmpty(msgType, "FAIL", "\u5fae\u4fe1\u56de\u8c03\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\uff01");
            this.saveXMLFile(reqXml, msgType, null, fromUserName);
            Element re = DocumentHelper.createElement((String)"xml");
            Document doc = DocumentHelper.createDocument((Element)re);
            re.addElement("FromUserName").addText(document.getRootElement().elementText("ToUserName"));
            re.addElement("ToUserName").addText(fromUserName);
            re.addElement("CreateTime").addText(new Date().getTime() / 1000L + "");
            RemexApplication.publishEvent(new WeChatEvent("wechat", msgType, fromUserName, toUserName, createTime, event, eventKey, ticket, document));
            switch (msgType) {
                case "event": {
                    String openId = fromUserName;
                    switch (event) {
                        case "subscribe": {
                            String[] eventKeyParts = null;
                            RemexApplication.publishEvent(new WeChatSubscribeEvent("subscribe", openId, !Judgment.nullOrBlank(eventKey) && (eventKeyParts = eventKey.split("_")).length > 1 ? eventKeyParts[1] : null));
                            re.addElement("MsgType").addText("text");
                            re.addElement("Content").addText(curWeChatApp.getSubscribeMsg());
                            resXml = doc.asXML();
                            break;
                        }
                        case "SCAN": {
                            RemexApplication.publishEvent(new WeChatScanEvent("SCAN", openId, eventKey, ticket));
                            break;
                        }
                        case "unsubscribe": {
                            RemexApplication.publishEvent(new WeChatUnsubscribeEvent("unsubscribe", openId, eventKey));
                            break;
                        }
                        case "TEMPLATESENDJOBFINISH": {
                            break;
                        }
                        case "click": 
                        case "CLICK": {
                            RemexApplication.publishEvent(new WeChatClickEvent("CLICK", fromUserName, toUserName, createTime, event, eventKey, document));
                        }
                    }
                    this.saveXMLFile(reqXml, msgType, event, fromUserName);
                    break;
                }
                case "text": {
                    String content = document.getRootElement().elementText("Content");
                    String msgId = document.getRootElement().elementText("MsgId");
                    RemexApplication.publishEvent(new WeChatTextEvent("wechatTextEvent", fromUserName, content, createTime, msgId));
                }
                default: {
                    re.addElement("MsgType").addText("transfer_customer_service");
                    resXml = doc.asXML();
                    break;
                }
            }
        }
        catch (DocumentException e) {
            RemexConstants.logger.error((Object)"\u5fae\u4fe1->XML \u89e3\u6790\u9519\u8bef\uff01\uff01", (Throwable)e);
        }
        RemexConstants.logger.info((Object)("\u5fae\u4fe1->\u54cd\u5e94\u5fae\u4fe1\u4fe1\u606f\uff1a" + resXml));
        return resXml;
    }

    private boolean saveXMLFile(String xml, String type, String evenType, String fileName) {
        String curSystem = System.getProperty("os.name");
        String baseXmlFilePath = null;
        if (curSystem.toUpperCase().startsWith("WIN")) {
            baseXmlFilePath = WeChat.WIN_PATH;
        } else if (curSystem.toUpperCase().startsWith("LINUX")) {
            baseXmlFilePath = WeChat.LINUX_PATH;
        }
        Assert.notNull(baseXmlFilePath, "ERROR", "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LocalDateTime localDateTime = LocalDateTime.now().withNano(0);
        DateTimeFormatter f = DateTimeFormatter.ofPattern("HHmmss");
        StringBuilder xmlFilePath = new StringBuilder(baseXmlFilePath + File.separator + type + File.separator);
        if (!Judgment.nullOrBlank(evenType)) {
            xmlFilePath.append(evenType).append(File.separator);
        }
        xmlFilePath.append(localDateTime.toLocalDate().toString()).append(File.separator).append(localDateTime.toLocalTime().format(f)).append("-").append(fileName).append(".xml");
        FileHelper.saveFileContent(xmlFilePath.toString(), xml);
        return true;
    }
}

