/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.wechat.utils;

import cn.remex.RemexConstants;
import cn.remex.core.net.HttpHelper;
import cn.remex.core.util.Assert;
import cn.remex.core.util.JsonHelper;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.StringHelper;
import cn.remex.core.util.XmlHelper;
import cn.remex.wechat.WeChat;
import cn.remex.wechat.beans.WeChatReqXml;
import cn.remex.wechat.beans.WeChatResXml;
import cn.remex.wechat.beans.WeChatResult;
import cn.remex.wechat.config.WeChatApp;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.function.Consumer;

public class WeChatUtils {
    public static <R extends WeChatResXml, P extends WeChatReqXml> R invokeApiReturnXml(WeChatApp app, P requestXmlBean, Class<R> returnType, WeChatApi weChatApi, String ... args) {
        String requestBody = XmlHelper.marshall(requestXmlBean);
        String result = WeChatUtils.requestServiceReturnString(app, requestBody, weChatApi, args);
        Assert.notNullAndEmpty(result, "FAIL", "\u5fae\u4fe1\u652f\u4ed8\u54cd\u5e94\u4e3aEMPTY\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u652f\u4ed8\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        WeChatResXml r = (WeChatResXml)XmlHelper.unmarshall(returnType, result);
        Assert.isTrue(r != null && ("SUCCESS".equals(r.getErr_code()) || "SUCCESS".equals(r.getReturn_code())), "WEIXIN_CONFIG_ERROR", "\u8c03\u7528\u5fae\u4fe1\u670d\u52a1\u9519\u8bef:" + (Judgment.nullOrBlank(r.getErr_code_des()) ? r.getReturn_msg() : r.getErr_code_des()));
        return (R)r;
    }

    public static <T extends WeChatResult> T invokeApiReturnBean(WeChatApp app, String requestBody, Class<T> returnType, WeChatApi weChatApi, String ... args) {
        String result = WeChatUtils.requestServiceReturnString(app, requestBody, weChatApi, args);
        WeChatResult t = (WeChatResult)JsonHelper.toJavaObject(result, returnType);
        Assert.isTrue(t != null && (Judgment.nullOrBlank(t.getErrcode()) || "0".equals(t.getErrcode())), "WEIXIN_CONFIG_ERROR", "\u8c03\u7528\u5fae\u4fe1\u670d\u52a1\u9519\u8bef:" + (t != null ? t.getErrmsg() : "Reaponse Bean is NULL"));
        return (T)t;
    }

    public static JsonNode invokeApiReturnJson(WeChatApp app, String requestBody, WeChatApi weChatApi, String ... args) {
        String result = WeChatUtils.requestServiceReturnString(app, requestBody, weChatApi, args);
        JsonNode jsonNode = JsonHelper.toJsonNode(result);
        String errcode = JsonHelper.readString(jsonNode, "errcode");
        Assert.isTrue(Judgment.nullOrBlank(errcode) || "0".equals(errcode), "WEIXIN_CONFIG_ERROR", "\u8c03\u7528\u5fae\u4fe1\u670d\u52a1\u9519\u8bef:" + result);
        return jsonNode;
    }

    public static void invokeApiHandleStream(WeChatApp app, String requestBody, Consumer<InputStream> consumer, WeChatApi weChatApi, String ... args) {
        String url = String.format(WeChat.getApiUrl(app.getType(), weChatApi), args);
        RemexConstants.logger.info((Object)("\u5fae\u4fe1->API[" + (Object)((Object)weChatApi) + "],url=" + url + ";\u5904\u7406\u6d41"));
        HttpHelper.send(url, "UTF-8", null, null, httpCosumerEntity -> {
            StringHelper.writeToStream(requestBody, "UTF-8", httpCosumerEntity.getOutputStream());
            consumer.accept(httpCosumerEntity.getInputStream());
        });
        RemexConstants.logger.info((Object)("\u5fae\u4fe1->API[" + (Object)((Object)weChatApi) + "],url=" + url + ";\u5904\u7406\u6d41\u5b8c\u6210"));
    }

    private static String requestServiceReturnString(WeChatApp app, String requestBody, WeChatApi weChatApi, String ... args) {
        String url = String.format(WeChat.getApiUrl(app.getType(), weChatApi), args);
        RemexConstants.logger.info((Object)("\u5fae\u4fe1->API[" + (Object)((Object)weChatApi) + "],url=" + url + ";requestBody=" + requestBody));
        String result = HttpHelper.send(url, requestBody);
        RemexConstants.logger.info((Object)("\u5fae\u4fe1->API[" + (Object)((Object)weChatApi) + "]:responseBody=" + result));
        return result;
    }

    public static enum WeChatApi {
        access_token,
        jsapi_ticket,
        oauth2_authorize,
        menu_create,
        media_get,
        oauth2_access_token,
        userid_to_openid,
        getuserinfo,
        get_login_info,
        customMsgSend,
        templatMsgSend,
        pulluserInfo,
        userInfo,
        qrcode_create,
        showqrcode,
        payUnifiedorder;

    }
}

