/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.view;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Judgment;
import cn.remex.db.model.view.JqgColModel;
import cn.remex.db.view.EditType;
import cn.remex.db.view.Element;
import cn.remex.db.view.ElementDefault;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class ViewUtil {
    public static final Element DefaultElement = ReflectUtil.getAnnotation(ElementDefault.class, "defaultElement", Element.class);
    public static final String DefaultLabel = "\u672a\u8bbe\u7f6e";
    public static final ArrayList<String> NoRefColumn = new ArrayList();

    public static void buildCommConfig(Class<?> ormBeanClass, String fieldName, JqgColModel colModel) {
        Element e = ReflectUtil.getAnnotation(ormBeanClass, fieldName, Element.class);
        if (e == null) {
            e = DefaultElement;
        }
        colModel.setName(fieldName);
        colModel.setFieldName(fieldName);
        colModel.setBeanClassName(fieldName);
        colModel.setIdx(fieldName);
        colModel.setWidth(e.width());
        colModel.setHidden(e.hidden());
        colModel.setLabel(e.label().equals(DefaultLabel) ? fieldName : e.label());
        colModel.setColModelIndex(e.colModelIndex());
    }

    public static void buildEditConfig(Class<?> ormBeanClass, String fieldName, Type fieldType, JqgColModel colModel) {
        Element e = ReflectUtil.getAnnotation(ormBeanClass, fieldName, Element.class);
        if (e == null) {
            e = DefaultElement;
        }
        colModel.setEditable(e.editable());
        EditType et = e.edittype();
        if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
            et = EditType.checkbox;
        }
        switch (et) {
            case text: {
                colModel.setEdittype(EditType.text.toString());
                break;
            }
            case CodeRef: {
                colModel.setEdittype(EditType.CodeRef.toString());
                String codeType = Judgment.nullOrBlank(e.CodeRefCodeType()) ? fieldName : e.CodeRefCodeType();
                colModel.setEditoptions("{beanName:'" + e.CodeRefBean().getSimpleName() + "',typeColumn:'" + e.CodeRefTypeColumn() + "',codeColumn:'" + e.CodeRefCodeColumn() + "',descColumn:'" + e.CodeRefDescColumn() + "',codeType:'" + codeType + "'}");
                break;
            }
            case EnumRef: {
                colModel.setEdittype(EditType.EnumRef.toString());
                colModel.setEditoptions("{beanName:'" + ((Class)fieldType).getName() + "'}");
                break;
            }
            case custom: {
                colModel.setEdittype(EditType.custom.toString());
                colModel.setEditoptions("{custom_element: RJQ.RefEle, custom_value:RJQ.RefVal,autoSearch:true,custom_type:'" + (Object)((Object)e.refType()) + "',beanName:'" + e.refClass().getSimpleName() + "'}");
                break;
            }
            case checkbox: {
                colModel.setEdittype("checkbox");
                colModel.setEditoptions("{value:'true:false'}");
                break;
            }
            case select: {
                colModel.setEdittype("select");
                colModel.setEditoptions(e.editoptions());
                break;
            }
        }
    }

    public static void buildRefDisplayColumn(String fieldName, Type fieldType, JqgColModel colModel) {
        colModel.setFieldName(fieldName);
        colModel.setLabel(fieldName);
        colModel.setName(fieldName + ".name");
        colModel.setIdx(fieldName);
        colModel.setEditable(true);
        colModel.setWidth(80);
        colModel.setEdittype(EditType.custom.toString());
        colModel.setEditoptions("{custom_element: RJQ.RefEle, custom_value:RJQ.RefVal,autoSearch:true,custom_type:'dbList',beanName:'" + ((Class)fieldType).getSimpleName() + "'}");
        colModel.setColModelIndex(colModel.getColModelIndex());
    }

    static {
        NoRefColumn.add("createOperator");
        NoRefColumn.add("modifyOperator");
        NoRefColumn.add("ownership");
    }
}

