/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.sql;

import cn.remex.core.exception.IllegalArgumentException;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.db.DbCvo;
import cn.remex.db.lambdaapi.ColumnPredicate;
import cn.remex.db.lambdaapi.ListColumnPredicate;
import cn.remex.db.lambdaapi.ModelColumnPredicate;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.sql.Expression;
import cn.remex.db.sql.NamedParam;
import cn.remex.db.sql.SqlColumn;
import cn.remex.db.sql.WhereGroupOp;
import cn.remex.db.sql.WhereRule;
import cn.remex.db.sql.WhereRuleOper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Where<T extends Modelable, NT extends Modelable>
implements Serializable {
    private static final long serialVersionUID = -8929994826268738990L;
    private DbCvo<T> superDbCvo;
    private Where<T, NT> superWhere;
    private boolean search = false;
    private List<WhereRule> allRules = new ArrayList<WhereRule>();
    private boolean filter = false;
    private WhereGroupOp groupOp = WhereGroupOp.AND;
    private List<Where<T, NT>> groups = new ArrayList<Where<T, NT>>();
    private String nd;
    private List<WhereRule> rules = new ArrayList<WhereRule>();
    private String searchField;
    private WhereRuleOper searchOper;
    private String searchString;

    private static void putNameParam(List<WhereRule> allRules, WhereRule rule, List<NamedParam> namedParams, Param<Integer> paramIndex, String nameParam) {
        namedParams.add(new NamedParam((Integer)paramIndex.param, nameParam, 1, null));
        rule.setParamName(nameParam);
        allRules.add(rule);
    }

    private static <T extends Modelable> String ruleToSQL(String tableName, Param<Integer> tableIndex, WhereRule rule, List<NamedParam> namedParams, Param<Integer> paramIndex, List<WhereRule> allRules, DbCvo<T> dbCvo) {
        boolean isModelOrListField;
        Object ruleSubSelect;
        Object[] objectArray;
        Dialect dialect = RDBManager.getLocalSpaceConfig(dbCvo._getSpaceName()).getDialect();
        String sField = rule.getField();
        String rightPart = null;
        String sOper = rule.getOp();
        if (sField.trim().length() == 0 || sOper.trim().length() == 0) {
            return "";
        }
        WhereRuleOper ruleOper = WhereRuleOper.valueOf(sOper.trim());
        String percent = dialect.quoteAsString("%");
        String aliasName = tableName;
        if (rule.getData() instanceof SqlColumn) {
            SqlColumn sqlColumn = (SqlColumn)rule.getData();
            rightPart = dialect.quoteKey(aliasName) + "." + dialect.quoteKey(sqlColumn.getFieldAliasName());
        } else if (rule.getData() instanceof Expression) {
            rightPart = ((Expression)rule.getData()).formatForWhereRule(rule.getField());
        } else if (rule.getData() instanceof DbCvo) {
            DbCvo subQuery = (DbCvo)rule.getData();
            subQuery._setParamIndex(paramIndex);
            objectArray = tableIndex;
            Integer n = (Integer)objectArray.param;
            objectArray.param = (Integer)objectArray.param + 1;
            Integer n2 = objectArray.param;
            subQuery._setTableAliasName("SS" + n);
            subQuery._setNamedParams(dbCvo._getNamedParams());
            subQuery._initForRsqlDao();
            subQuery.getParameters().forEach(dbCvo::$S);
            rightPart = subQuery._getPrettySqlString();
        } else if (null != rule.getData() && Object[].class.isAssignableFrom(rule.getData().getClass()) && (ruleOper == WhereRuleOper.inSubSelect || ruleOper == WhereRuleOper.notInSubSelect)) {
            ruleSubSelect = new StringBuilder();
            for (Object arg : (Object[])rule.getData()) {
                ((StringBuilder)ruleSubSelect).append(dialect.quoteAsString(arg)).append(",");
            }
            ((StringBuilder)ruleSubSelect).deleteCharAt(((StringBuilder)ruleSubSelect).length() - 1);
            rightPart = ((StringBuilder)ruleSubSelect).toString();
        } else if (ruleOper == WhereRuleOper.isNull || ruleOper == WhereRuleOper.notNull) {
            rightPart = null;
        } else {
            ruleSubSelect = paramIndex;
            objectArray = (Integer)((Param)ruleSubSelect).param;
            ((Param)ruleSubSelect).param = (Integer)((Param)ruleSubSelect).param + 1;
            Integer n = ((Param)ruleSubSelect).param;
            rightPart = ":" + rule.getField() + paramIndex.param;
            Where.putNameParam(allRules, rule, namedParams, paramIndex, rule.getField() + paramIndex.param);
        }
        boolean bl = isModelOrListField = sField.indexOf(46) > 0;
        if (isModelOrListField) {
            String parentField = sField.substring(0, sField.lastIndexOf(46));
            Param<Object> aliasNameParam = new Param<Object>(null);
            dbCvo._getRootColumn().anySubColumnMatch(p -> !Judgment.nullOrBlank(p.getFieldAliasName()) && parentField.equals(p.getFieldAliasName()), c -> {
                aliasNameParam.param = c.getAliasName();
                Object cfr_ignored_0 = aliasNameParam.param;
            });
            Assert.notNullAndEmpty(aliasNameParam.param, "RSQL_SQL_ERROR", "where \u67e5\u8be2\u7684\u5217\u4e0d\u660e\u786e:" + parentField);
            aliasName = (String)aliasNameParam.param;
        }
        String fullField = dialect.quoteKey(aliasName) + "." + dialect.quoteKey(isModelOrListField ? sField.substring(sField.lastIndexOf(46) + 1) : sField);
        StringBuilder cont = new StringBuilder();
        switch (ruleOper) {
            case eq: {
                cont.append(fullField).append("= ").append(rightPart).append(" ");
                break;
            }
            case ne: {
                cont.append(fullField).append(" !=  ").append(rightPart).append(" ");
                break;
            }
            case lt: {
                cont.append(fullField).append(" <  ").append(rightPart).append(" ");
                break;
            }
            case le: {
                cont.append(fullField).append(" <=  ").append(rightPart).append(" ");
                break;
            }
            case gt: {
                cont.append(fullField).append(" >  ").append(rightPart).append(" ");
                break;
            }
            case ge: {
                cont.append(fullField).append(" >=  ").append(rightPart).append(" ");
                break;
            }
            case bw: {
                cont.append(fullField).append(" LIKE  ").append(dialect.concat(rightPart, percent)).append(" ");
                break;
            }
            case bn: {
                cont.append(fullField).append(" NOT LIKE  ").append(dialect.concat(rightPart, percent)).append(" ");
                break;
            }
            case ew: {
                cont.append(fullField).append(" LIKE ").append(dialect.concat(percent, rightPart)).append(" ");
                break;
            }
            case en: {
                cont.append(fullField).append(" NOT LIKE ").append(dialect.concat(percent, rightPart)).append(" ");
                break;
            }
            case cn: {
                cont.append(fullField).append(" LIKE ").append(dialect.concat(percent, rightPart, percent)).append(" ");
                break;
            }
            case nc: {
                cont.append(fullField).append(" NOT LIKE ").append(dialect.concat(percent, rightPart, percent)).append(" ");
                break;
            }
            case in: {
                cont.append(" ").append(rightPart).append(" LIKE ").append(dialect.concat(percent, fullField, percent)).append(" ");
                break;
            }
            case ni: {
                cont.append(" ").append(rightPart).append(" NOT LIKE ").append(dialect.concat(percent, fullField, percent)).append(" ");
                break;
            }
            case isNull: {
                cont.append(fullField).append(" IS NULL ");
                break;
            }
            case notNull: {
                cont.append(fullField).append(" IS NOT NULL ");
                break;
            }
            case inSubSelect: {
                cont.append(fullField).append(" IN ( ").append(rightPart).append(" ) ");
                break;
            }
            case notInSubSelect: {
                cont.append(fullField).append("NOT IN ( ").append(rightPart).append(" ) ");
                break;
            }
            case existSubSelect: {
                cont.append(" EXISTS ( ").append(rightPart).append(" ) ");
                break;
            }
            case notExistSubSelect: {
                cont.append(" NOT EXISTS ( ").append(rightPart).append(" ) ");
                break;
            }
            default: {
                Assert.isTrue(false, "RSQL_SQL_ERROR", "Where \u5b50\u53e5\u4e2d\u6bd4\u8f83\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef");
            }
        }
        return cont.toString();
    }

    private static void writeSQL(StringBuilder result, Where where, String beanName, Param<Integer> tableIndex, List<NamedParam> namedParams, Param<Integer> paramIndex, List<WhereRule> allRules, DbCvo dbCvo) {
        int j;
        int gos;
        int s;
        boolean hasGroups;
        String groupOp = where.getGroupOp().toString();
        int rs = 0;
        int gs = 0;
        boolean hasRules = where.rules != null && (rs = where.rules.size()) > 0;
        boolean bl = hasGroups = where.groups != null && (gs = where.groups.size()) > 0;
        if (hasRules) {
            s = rs;
            gos = s - 1;
            for (j = 0; j < s; ++j) {
                WhereRule rule = where.rules.get(j);
                result.append(Where.ruleToSQL(beanName, tableIndex, rule, namedParams, paramIndex, allRules, dbCvo));
                if (j >= gos) continue;
                result.append(" ").append(groupOp).append(" ");
            }
        }
        if (hasRules && hasGroups) {
            result.append(" ").append(groupOp).append(" ");
        }
        if (hasGroups) {
            s = gs;
            gos = s - 1;
            for (j = 0; j < s; ++j) {
                result.append(" (");
                Where group = where.groups.get(j);
                group.setSearch(where.search);
                Where.writeSQL(result, group, beanName, tableIndex, namedParams, paramIndex, allRules, dbCvo);
                result.append(") ");
                if (j >= gos) continue;
                result.append(" ").append(groupOp).append(" ");
            }
        }
    }

    public Where<T, NT> filterByGroup(Consumer<Where<T, NT>> groupConsumer) {
        Where<T, NT> group = new Where<T, NT>();
        group.setSuperDbCvo(this.superDbCvo);
        group.setSuperWhere(this);
        this.addGroup(group);
        groupConsumer.accept(group);
        return this;
    }

    public DbCvo<T> end() {
        return this.superDbCvo;
    }

    public Where<T, NT> endGroup() {
        return this.superWhere;
    }

    public Where<T, NT> filterBy(ColumnPredicate<NT> wp, WhereRuleOper oper, String value) {
        ReflectUtil.eachFieldWhenGet(this.superDbCvo._obtainAOPBean(), b -> wp.init((Modelable)b), s -> this.addRule((String)s, oper, value));
        return this;
    }

    public <SSB extends ModelableImpl> Where<T, NT> filterBy(ColumnPredicate<T> wp, WhereRuleOper oper, Class<SSB> subSelectBeanClass, Consumer<DbCvo<SSB>> subSelectSqlColumnConsumer) {
        DbCvo subSelectDbCvo = new DbCvo(this.superDbCvo._getSpaceName(), subSelectBeanClass, true);
        subSelectSqlColumnConsumer.accept(subSelectDbCvo);
        ReflectUtil.eachFieldWhenGet(this.superDbCvo._obtainAOPBean(), b -> wp.init((Modelable)b), fieldName -> this.addSubSelectRule((String)fieldName, oper, subSelectDbCvo));
        return this;
    }

    public <ST extends Modelable> Where<T, NT> filterByModel(ModelColumnPredicate<T, T, ST> mcp, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.superDbCvo.withModel(mcp, sqlColumn -> {
            sqlColumn._setSwitchFilterToDbCvo(true);
            sqlColumnConsumer.accept((SqlColumn)sqlColumn);
            sqlColumn._setSwitchFilterToDbCvo(false);
        });
        return this;
    }

    public <ST extends Modelable> Where<T, NT> filterByList(ListColumnPredicate<T, T, ST> mcp, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.superDbCvo.withList(mcp, sqlColumn -> {
            sqlColumn._setSwitchFilterToDbCvo(true);
            sqlColumnConsumer.accept((SqlColumn)sqlColumn);
            sqlColumn._setSwitchFilterToDbCvo(false);
        });
        return this;
    }

    public Where<T, NT> filterOper(WhereGroupOp whereGroupOp) {
        this.setGroupOp(whereGroupOp);
        return this;
    }

    public void addGroup(Where where) {
        this.search = true;
        this.groups.add(where);
    }

    public void addRule(String field, WhereRuleOper ruleOper, Object value) {
        this.search = true;
        this.rules.add(new WhereRule(field, ruleOper, value));
    }

    public void addSubSelectRule(String field, WhereRuleOper ruleOper, DbCvo ruleDbCvo) {
        this.search = true;
        this.rules.add(new WhereRule(field, ruleOper, ruleDbCvo));
    }

    public void addSubSelectRule(String field, WhereRuleOper ruleOper, Object ... args) {
        this.search = true;
        this.rules.add(new WhereRule(field, ruleOper, args));
    }

    public List<WhereRule> getAllRules() {
        return this.allRules;
    }

    public WhereGroupOp getGroupOp() {
        return this.groupOp;
    }

    public List<Where<T, NT>> getGroups() {
        return this.groups;
    }

    public String getNd() {
        return this.nd;
    }

    public List<WhereRule> getRules() {
        return this.rules;
    }

    public String getSearchField() {
        return this.searchField;
    }

    public WhereRuleOper getSearchOper() {
        return this.searchOper;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isSearch() {
        this.search = this.isFilter() || this.searchString != null;
        return this.search;
    }

    public boolean isFilter() {
        this.filter = this.rules != null && this.rules.size() > 0 || this.groups != null && this.groups.size() > 0;
        return this.filter;
    }

    public void setSearch(boolean search) {
        this.search = search;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public void setGroupOp(WhereGroupOp groupOp) {
        this.groupOp = groupOp;
    }

    public void setGroups(List<Where<T, NT>> groups) {
        this.groups = groups;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public void setRules(List<WhereRule> rules) {
        this.rules = rules;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public void setSearchOper(WhereRuleOper searchOper) {
        this.searchOper = searchOper;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String toSQL(boolean needWhere, String beanName, List<NamedParam> namedParams, Param<Integer> paramIndex, Param<Integer> tableIndex, DbCvo dbCvo) {
        this.optimize();
        StringBuilder result = new StringBuilder(needWhere ? " WHERE " : " ");
        if (!this.isSearch()) {
            return "";
        }
        if (!this.isFilter()) {
            if (this.getSearchField() != null && this.getSearchOper() != null && this.getSearchString() != null) {
                throw new IllegalArgumentException("\u73b0\u5728\u9879\u76ee\u5df2\u7ecf\u5220\u9664\u4e86\u5bf9\u7b80\u5355\u5b57\u6bb5\u641c\u7d22\u7684\u652f\u6301\u4e86\uff01");
            }
            throw new IllegalArgumentException("\u8bbe\u7f6e\u4e86\u672c\u6b21\u67e5\u8be2\u9700\u8981\u8fdb\u884cwhere\u641c\u7d22\uff0c\u4f46\u6ca1\u6709\u8bbe\u7f6e\u89c4\u5219\uff01");
        }
        Where.writeSQL(result, this, beanName, tableIndex, namedParams, paramIndex, this.allRules, dbCvo);
        return result.toString();
    }

    public void setSuperDbCvo(DbCvo<T> superDbCvo) {
        this.superDbCvo = superDbCvo;
    }

    public Where<T, NT> getSuperWhere() {
        return this.superWhere;
    }

    public void setSuperWhere(Where<T, NT> superWhere) {
        this.superWhere = superWhere;
    }

    public DbCvo<T> getSuperDbCvo() {
        return this.superDbCvo;
    }

    public Where<T, NT> everyRule(Consumer<WhereRule> consumer) {
        this.rules.forEach(consumer::accept);
        this.groups.forEach(g -> g.everyRule(consumer::accept));
        return this;
    }

    public Where<T, NT> optimize() {
        if (this.rules != null) {
            this.rules = this.rules.stream().filter(rule -> !WhereRuleOper.cn.toString().equals(String.valueOf(rule.getOp())) || !"%".equals(rule.getData()) && !"null".equals(rule.getData()) && !Judgment.nullOrBlank(rule.getData())).collect(Collectors.toList());
        }
        if (this.groups != null) {
            this.groups = this.groups.stream().filter(group -> {
                group.optimize();
                return group.rules != null && group.rules.size() > 0 || group.groups != null && group.groups.size() > 0;
            }).collect(Collectors.toList());
        }
        if (this.groups != null && this.groups.size() == 0) {
            this.groups = null;
        }
        if (this.rules != null && this.rules.size() == 0) {
            this.rules = null;
        }
        return this;
    }
}

