/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.sql;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.db.DbCvo;
import cn.remex.db.lambdaapi.ColumnPredicate;
import cn.remex.db.lambdaapi.ListColumnPredicate;
import cn.remex.db.lambdaapi.ModelColumnPredicate;
import cn.remex.db.rsql.RsqlUtils;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.sql.AggregateFunction;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.GroupFunction;
import cn.remex.db.sql.SqlType;
import cn.remex.db.sql.Where;
import cn.remex.db.sql.WhereGroupOp;
import cn.remex.db.sql.WhereRuleOper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SqlColumn<T extends Modelable, CT extends Modelable, ST extends Modelable> {
    private boolean _switchFilterToDbCvo = false;
    private FieldType type;
    private SqlColumn supColumn;
    private Class<ST> nodeClass;
    private Type nodeType;
    private ST nodeBean;
    private DbCvo<T> dbCvo;
    private String fieldName;
    private AggregateFunction aggregateFunction;
    private String aggregateAliasName;
    private GroupFunction groupFunction;
    private String groupAliasName;
    private Object[] aggregateFunArgs;
    private Object[] groupFunctionArgs;
    private boolean isGroupBy = false;
    private boolean distinct;
    private List<SqlColumn<T, ST, ?>> subColumns = new ArrayList();
    private String tableName;
    private String aliasName;
    private String fieldAliasName;
    private DbCvo subDbCvo;
    private Where<T, CT> filter;
    private Where<T, CT> onFilter;

    public static <T extends Modelable, CT extends Modelable, ST extends Modelable> void obtainFieldColumn(SqlColumn<T, CT, ST> supNode, Object input, Consumer<SqlColumn<T, ST, ?>> sqlColumnConsumer) {
        Consumer<Object> p = propName -> {
            SqlColumn sc = new SqlColumn(supNode).init(propName.toString(), null, null, null, FieldType.TBase);
            if (null != supNode) {
                supNode.subColumns.add(sc);
            }
            if (null != sqlColumnConsumer) {
                sqlColumnConsumer.accept(sc);
            }
        };
        Assert.notNull(input, "ERROR", "\u8f93\u5165\u4ec5\u63a5\u53d7\u5b57\u7b26\u4e32\u548cModelColumnPredicate lambda\u8868\u8fbe\u5f0f\u3002");
        if (input instanceof ColumnPredicate) {
            ColumnPredicate mcp = (ColumnPredicate)input;
            ReflectUtil.eachFieldWhenGet(supNode.nodeBean, c -> mcp.init((Modelable)c), p);
        } else {
            p.accept(input);
        }
    }

    public static <T extends Modelable, CT extends Modelable, ST extends Modelable, S2T extends Modelable> void obtainModelColumn(SqlColumn<T, CT, ST> supNode, Object input, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        Consumer<Object> p = propName -> {
            SqlColumn sc = supNode.getSubColumns().stream().filter(subColumn -> subColumn.getFieldName().equals(propName)).findFirst().orElse(null);
            if (null == sc) {
                sc = new SqlColumn(supNode);
                if (null != supNode) {
                    supNode.subColumns.add(sc);
                }
            }
            Class nodeClass = (Class)SqlType.getFields(supNode.nodeClass, FieldType.TObject).get(propName.toString());
            Modelable nodeBean = (Modelable)ReflectUtil.createAopBean(nodeClass);
            Assert.notNull(nodeClass, "ERROR", "Model\u5c5e\u6027\u4e0d\u5728\u6a21\u578b\u4e2d\uff01");
            sc.init(propName.toString(), nodeBean, nodeClass, nodeClass, FieldType.TObject);
            if (null != sqlColumnConsumer) {
                sqlColumnConsumer.accept(sc);
            }
        };
        Assert.notNull(input, "ERROR", "\u8f93\u5165\u4ec5\u63a5\u53d7\u5b57\u7b26\u4e32\u548cModelColumnPredicate lambda\u8868\u8fbe\u5f0f\u3002");
        if (input instanceof ModelColumnPredicate) {
            ModelColumnPredicate mcp = (ModelColumnPredicate)input;
            ReflectUtil.eachFieldWhenGet(supNode.nodeBean, c -> mcp.init((Modelable)c), p);
        } else {
            p.accept(input);
        }
    }

    public static <T extends Modelable, CT extends Modelable, ST extends Modelable, S2T extends Modelable> void obtainListColumn(SqlColumn<T, CT, ST> supNode, Object input, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        Consumer<Object> p = propName -> {
            SqlColumn sc = supNode.getSubColumns().stream().filter(subColumn -> subColumn.getFieldName().equals(propName)).findFirst().orElse(null);
            if (null == sc) {
                sc = new SqlColumn(supNode);
                if (null != supNode) {
                    supNode.subColumns.add(sc);
                }
            }
            Type listClass = SqlType.getFields(supNode.nodeClass, FieldType.TCollection).get(propName.toString());
            Class<?> nodeClass = ReflectUtil.getListActualType(listClass);
            Assert.notNull(nodeClass, "ERROR", "List\u5c5e\u6027\u4e0d\u5728\u6a21\u578b\u4e2d\uff01");
            Modelable nodeBean = (Modelable)ReflectUtil.createAopBean(nodeClass);
            sc.init(propName.toString(), nodeBean, nodeClass, listClass, FieldType.TCollection);
            if (null != sqlColumnConsumer) {
                sqlColumnConsumer.accept(sc);
            }
        };
        Assert.notNull(input, "ERROR", "\u8f93\u5165\u4ec5\u63a5\u53d7\u5b57\u7b26\u4e32\u548cModelColumnPredicate lambda\u8868\u8fbe\u5f0f\u3002");
        if (input instanceof ListColumnPredicate) {
            ListColumnPredicate mcp = (ListColumnPredicate)input;
            ReflectUtil.eachFieldWhenGet(supNode.nodeBean, c -> mcp.init((Modelable)c), p);
        } else {
            p.accept(input);
        }
    }

    private Where<T, CT> obtainCurFilter() {
        Where<T, Object> where;
        if (this._isSwitchFilterToDbCvo()) {
            where = this.filter == null ? (this.filter = new Where()) : this.filter;
        } else if (this.onFilter == null) {
            this.onFilter = new Where();
            where = this.onFilter;
        } else {
            where = this.onFilter;
        }
        return where;
    }

    public SqlColumn(DbCvo<T> dbCvo, Class<ST> beanClass, ST t) {
        this.dbCvo = dbCvo;
        this.supColumn = null;
        this.type = FieldType.TROOT;
        this.nodeType = beanClass;
        this.nodeClass = beanClass;
        this.nodeBean = t;
        String string = null == this.supColumn ? this.fieldName : (this.fieldAliasName = this.obtainChain() + (FieldType.TBase == this.type ? this.fieldName : "$"));
        if (this.fieldAliasName != null && this.fieldAliasName.endsWith(".$")) {
            this.fieldAliasName = this.fieldAliasName.substring(0, this.fieldAliasName.length() - 2);
        }
    }

    public SqlColumn(SqlColumn supColumn) {
        this.dbCvo = supColumn.dbCvo;
        this.supColumn = supColumn;
    }

    public SqlColumn<T, CT, ST> init(String fieldName, ST nodeBean, Class<ST> nodeClass, Type nodeType, FieldType type) {
        this.type = type;
        this.fieldName = fieldName;
        this.nodeType = nodeType;
        this.nodeClass = nodeClass;
        this.nodeBean = nodeBean;
        String string = null == this.supColumn ? this.fieldName : (this.fieldAliasName = this.obtainChain() + (FieldType.TBase == type ? this.fieldName : "$"));
        if (this.fieldAliasName != null && this.fieldAliasName.endsWith(".$")) {
            this.fieldAliasName = this.fieldAliasName.substring(0, this.fieldAliasName.length() - 2);
        }
        return this;
    }

    public StringBuilder obtainChain() {
        if (FieldType.TROOT.equals((Object)this.type)) {
            return new StringBuilder();
        }
        StringBuilder sb = this.supColumn.obtainChain();
        if (!FieldType.TBase.equals((Object)this.type)) {
            sb.append(this.fieldName).append(FieldType.TCollection.equals((Object)this.type) ? "[]." : ".");
        }
        return sb;
    }

    public SqlColumn<T, CT, ST> withColumn(String fieldAliasName) {
        Assert.notNullAndEmpty(fieldAliasName, "RSQL_SQL_ERROR", "field\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Param<Boolean> hasFound = new Param<Boolean>(false);
        int flag = fieldAliasName.indexOf(46);
        String fieldName = flag >= 0 ? fieldAliasName.substring(fieldAliasName.indexOf(46) + 1) : fieldAliasName;
        this.anySubColumnMatch(p -> !Judgment.nullOrBlank(p.getFieldAliasName()) && fieldAliasName.equals(p.getFieldAliasName()), c -> {
            if (flag > 0) {
                c.withColumn(fieldAliasName.substring(flag));
            }
            hasFound.param = true;
        });
        if (!((Boolean)hasFound.param).booleanValue()) {
            Type parentFieldType = SqlType.getFields(this.getNodeClass(), FieldType.TAll).get(fieldName);
            Assert.notNull(parentFieldType, "RSQL_SQL_ERROR", "where \u67e5\u8be2\u7684\u5217\u4e0d\u5c5e\u4e8e\u5bf9\u8c61\u7684\u5c5e\u6027:" + fieldName);
            if (SqlType.isTObject(parentFieldType)) {
                this.withModel(fieldName, (SqlColumn<T, ST, S2T> c) -> {
                    if (flag > 0) {
                        c.withColumn(fieldAliasName.substring(flag));
                    }
                    hasFound.param = true;
                });
            } else if (SqlType.isTCollection(parentFieldType)) {
                this.withList(fieldName, (SqlColumn<T, ST, S2T> c) -> {
                    if (flag > 0) {
                        c.withColumn(fieldAliasName.substring(flag));
                    }
                    hasFound.param = true;
                });
            } else {
                this.withBase(fieldName);
            }
        }
        return this;
    }

    public SqlColumn<T, CT, ST> withBase(ColumnPredicate<ST> cp, Consumer<SqlColumn<T, ST, ?>> sqlColumnConsumer) {
        SqlColumn.obtainFieldColumn(this, cp, sqlColumnConsumer);
        return this;
    }

    public SqlColumn<T, CT, ST> withBase() {
        SqlType.getGetters(this.nodeClass, FieldType.TBase).forEach((k, v) -> {
            if (!RsqlUtils.SysColumns.containsKey(k) || "id".equals(k)) {
                SqlColumn.obtainFieldColumn(this, k, null);
            }
        });
        return this;
    }

    public SqlColumn<T, CT, ST> withBase(ColumnPredicate<ST> cp) {
        SqlColumn.obtainFieldColumn(this, cp, null);
        return this;
    }

    public SqlColumn<T, CT, ST> withBase(String fieldName, Consumer<SqlColumn<T, ST, ?>> sqlColumnConsumer) {
        SqlColumn.obtainFieldColumn(this, fieldName, sqlColumnConsumer);
        return this;
    }

    public SqlColumn<T, CT, ST> withBase(String fieldName) {
        SqlColumn.obtainFieldColumn(this, fieldName, null);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withModel(ModelColumnPredicate<T, ST, S2T> mcp, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        SqlColumn.obtainModelColumn(this, mcp, sqlColumnConsumer);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withModel(ModelColumnPredicate<T, ST, S2T> mcp) {
        SqlColumn.obtainModelColumn(this, mcp, null);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withModel(String fieldName, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        SqlColumn.obtainModelColumn(this, fieldName, sqlColumnConsumer);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withModel(String fieldName) {
        SqlColumn.obtainModelColumn(this, fieldName, null);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withList(ListColumnPredicate<T, ST, S2T> lcp, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        SqlColumn.obtainListColumn(this, lcp, sqlColumnConsumer);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withList(ListColumnPredicate<CT, ST, S2T> lcp) {
        SqlColumn.obtainListColumn(this, lcp, null);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withList(String fieldName, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        SqlColumn.obtainListColumn(this, fieldName, sqlColumnConsumer);
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> withList(String fieldName) {
        SqlColumn.obtainListColumn(this, fieldName, null);
        return this;
    }

    public SqlColumn<T, CT, ST> filterInRoot(Consumer<SqlColumn<T, CT, ST>> sqlColumnConsumer) {
        this._setSwitchFilterToDbCvo(true);
        sqlColumnConsumer.accept(this);
        this._setSwitchFilterToDbCvo(false);
        return this;
    }

    public SqlColumn<T, CT, ST> filterBy(ColumnPredicate<ST> wp, WhereRuleOper oper, Object value) {
        ReflectUtil.eachFieldWhenGet(this.nodeBean, b -> wp.init((Modelable)b), s -> this.obtainCurFilter().addRule((String)s, oper, value));
        return this;
    }

    public SqlColumn<T, CT, ST> filterBy(Consumer<Where<T, CT>> filterConsumer) {
        filterConsumer.accept(this.obtainCurFilter());
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> filterByModel(ModelColumnPredicate<T, ST, S2T> mcp, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        SqlColumn.obtainModelColumn(this, mcp, sqlColumn -> sqlColumnConsumer.accept((SqlColumn)sqlColumn));
        return this;
    }

    public <S2T extends Modelable> SqlColumn<T, CT, ST> filterByList(ListColumnPredicate<T, ST, S2T> lcp, Consumer<SqlColumn<T, ST, S2T>> sqlColumnConsumer) {
        SqlColumn.obtainListColumn(this, lcp, sqlColumn -> sqlColumnConsumer.accept((SqlColumn)sqlColumn));
        return this;
    }

    public <SSB extends ModelableImpl> SqlColumn<T, CT, ST> filterBy(ColumnPredicate<ST> wp, WhereRuleOper oper, Class<SSB> subSelectBeanClass, Consumer<DbCvo<SSB>> subSelectSqlColumnConsumer) {
        DbCvo subSelectDbCvo = new DbCvo(this.dbCvo._getSpaceName(), subSelectBeanClass, true);
        subSelectSqlColumnConsumer.accept(subSelectDbCvo);
        ReflectUtil.eachFieldWhenGet(this.nodeBean, b -> wp.init((Modelable)b), s -> this.obtainCurFilter().addSubSelectRule((String)s, oper, subSelectDbCvo));
        return this;
    }

    public <SSB extends ModelableImpl> SqlColumn<T, CT, ST> filterBy(ColumnPredicate<ST> wp, WhereRuleOper oper, Object ... args) {
        ReflectUtil.eachFieldWhenGet(this.nodeBean, b -> wp.init((Modelable)b), s -> this.obtainCurFilter().addSubSelectRule((String)s, oper, args));
        return this;
    }

    public SqlColumn<T, CT, ST> filterOper(WhereGroupOp groupOp) {
        this.obtainCurFilter().setGroupOp(groupOp);
        return this;
    }

    public SqlColumn<T, CT, ST> groupBy() {
        this.dbCvo._setHasGroupBy(true);
        this.setIsGroup(true);
        return this;
    }

    public SqlColumn<T, CT, ST> groupBy(GroupFunction groupFunction, Object ... groupFunArgs) {
        this.dbCvo._setHasGroupBy(true);
        this.setIsGroup(true);
        switch (groupFunction) {
            case DateStr2Day: {
                this.setGroupFunction(GroupFunction.SUBSTR);
                this.setGroupFunctionArgs(new Object[]{1, 10});
                break;
            }
            default: {
                this.setGroupFunction(groupFunction);
                this.setGroupFunctionArgs(groupFunArgs);
            }
        }
        if (this.isGroupBy() && null != this.groupFunction && !Judgment.nullOrBlank(this.groupAliasName)) {
            this.fieldAliasName = this.fieldAliasName.trim() + "#" + (Object)((Object)this.groupFunction);
            if (null != this.groupFunctionArgs) {
                for (Object arg : this.groupFunctionArgs) {
                    this.fieldAliasName = this.fieldAliasName + "_" + arg;
                }
            }
        }
        return this;
    }

    public SqlColumn<T, CT, ST> groupAlias(String groupAliasName) {
        this.groupAliasName = groupAliasName;
        return this;
    }

    public SqlColumn<T, CT, ST> aggregateBy(AggregateFunction fun) {
        this.dbCvo._setHasAggregateBy(true);
        this.aggregateFunction = fun;
        return this;
    }

    public SqlColumn<T, CT, ST> aggregateBy(AggregateFunction fun, Object ... aggregateFunArgs) {
        this.dbCvo._setHasAggregateBy(true);
        this.aggregateFunction = fun;
        switch (fun) {
            case CASE_SUM: {
                this.setAggregateFunArgs(aggregateFunArgs);
            }
        }
        return this;
    }

    public SqlColumn<T, CT, ST> aggregateAlias(String aliasAggrName) {
        this.aggregateAliasName = aliasAggrName;
        return this;
    }

    public SqlColumn<T, CT, ST> distinct() {
        this.dbCvo._setHasDistinct(true);
        this.distinct = true;
        return this;
    }

    public SqlColumn<T, CT, ST> alias(String fieldAliasName) {
        this.setFieldAliasName(fieldAliasName);
        return this;
    }

    public DbCvo<T> dbCvo() {
        return this.dbCvo;
    }

    public SqlColumn<T, CT, ST> forEvery(Consumer<SqlColumn> c) {
        c.accept(this);
        if (null != this.subColumns) {
            this.subColumns.forEach(cc -> cc.forEvery(c));
        }
        return this;
    }

    public SqlColumn<T, CT, ST> subColumn(String fieldName) {
        return this.anyMatchResult(sqlColumn -> null != sqlColumn.getSupColumn() && FieldType.TROOT.equals((Object)sqlColumn.getSupColumn().getType()) && null != sqlColumn.getFieldName() && sqlColumn.getFieldName().equals(fieldName));
    }

    public boolean anyMatchInRoot(String fieldName) {
        return null != this.subColumn(fieldName);
    }

    private SqlColumn<T, CT, ST> anyMatchResult(Predicate<SqlColumn> p) {
        if (p.test(this)) {
            return this;
        }
        if (null != this.subColumns) {
            for (SqlColumn<T, ST, ?> sqlColumn : this.subColumns) {
                if (super.anyMatchResult(p) == null) continue;
                return sqlColumn;
            }
        }
        return null;
    }

    public SqlColumn<T, CT, ST> anyMatchInRoot(Predicate<SqlColumn> p, Consumer<SqlColumn> c) {
        if (p.test(this)) {
            c.accept(this);
            return this;
        }
        this.anySubColumnMatch(p, c);
        return this;
    }

    public SqlColumn<T, CT, ST> anySubColumnMatch(Predicate<SqlColumn> p, Consumer<SqlColumn> c) {
        if (null != this.subColumns) {
            for (SqlColumn<T, ST, ?> sqlColumn : this.subColumns) {
                SqlColumn<T, ST, ?> sc = super.anyMatchResult(p);
                if (null == sc) continue;
                c.accept(sc);
                break;
            }
        }
        return this;
    }

    public SqlColumn supColumn() {
        return this.supColumn;
    }

    public boolean hasAnyColumn() {
        return this.getSubColumns() != null && this.getSubColumns().size() > 0;
    }

    public SqlColumn getSupColumn() {
        return this.supColumn;
    }

    public void setSupColumn(SqlColumn supColumn) {
        this.supColumn = supColumn;
    }

    public Class<ST> getNodeClass() {
        return this.nodeClass;
    }

    public void setNodeClass(Class<ST> nodeClass) {
        this.nodeClass = nodeClass;
    }

    public ST getNodeBean() {
        return this.nodeBean;
    }

    public void setNodeBean(ST nodeBean) {
        this.nodeBean = nodeBean;
    }

    public DbCvo<T> getDbCvo() {
        return this.dbCvo;
    }

    public void setDbCvo(DbCvo<T> dbCvo) {
        this.dbCvo = dbCvo;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public Where<T, CT> getFilter() {
        return this.filter;
    }

    public void setFilter(Where<T, CT> filter) {
        this.filter = filter;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public String getFieldAliasName() {
        return this.fieldAliasName;
    }

    public void setFieldAliasName(String fieldAliasName) {
        this.fieldAliasName = fieldAliasName;
    }

    public List<SqlColumn<T, ST, ?>> getSubColumns() {
        return this.subColumns;
    }

    public void setSubColumns(List<SqlColumn<T, ST, ?>> subColumns) {
        this.subColumns = subColumns;
    }

    public Type getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(Type nodeType) {
        this.nodeType = nodeType;
    }

    public AggregateFunction getAggregateFunction() {
        return this.aggregateFunction;
    }

    public void setAggregateFunction(AggregateFunction aggregateFunction) {
        this.aggregateFunction = aggregateFunction;
    }

    public String getAggregateAliasName() {
        return this.aggregateAliasName;
    }

    public void setAggregateAliasName(String aggregateAliasName) {
        this.aggregateAliasName = aggregateAliasName;
    }

    public boolean isGroupBy() {
        return this.isGroupBy;
    }

    public void setIsGroup(boolean isGroupBy) {
        this.isGroupBy = isGroupBy;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public GroupFunction getGroupFunction() {
        return this.groupFunction;
    }

    public void setGroupFunction(GroupFunction groupFunction) {
        this.groupFunction = groupFunction;
    }

    public Object[] getGroupFunctionArgs() {
        return this.groupFunctionArgs;
    }

    public void setGroupFunctionArgs(Object[] groupFunctionArgs) {
        this.groupFunctionArgs = groupFunctionArgs;
    }

    public Object[] getAggregateFunArgs() {
        return this.aggregateFunArgs;
    }

    public void setAggregateFunArgs(Object[] aggregateFunArgs) {
        this.aggregateFunArgs = aggregateFunArgs;
    }

    public Where<T, CT> getOnFilter() {
        return this.onFilter;
    }

    public void setOnFilter(Where<T, CT> onFilter) {
        this.onFilter = onFilter;
    }

    public boolean _isSwitchFilterToDbCvo() {
        return this._switchFilterToDbCvo;
    }

    public void _setSwitchFilterToDbCvo(boolean _switchFilterToDbCvo) {
        this._switchFilterToDbCvo = _switchFilterToDbCvo;
    }

    public String getGroupAliasName() {
        return this.groupAliasName;
    }

    public void setGroupAliasName(String groupAliasName) {
        this.groupAliasName = groupAliasName;
    }

    public DbCvo getSubDbCvo() {
        return this.subDbCvo;
    }

    public void setSubDbCvo(DbCvo subDbCvo) {
        this.subDbCvo = subDbCvo;
    }
}

