/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.sql;

import cn.remex.core.cache.DataCacheCloneable;
import cn.remex.db.exception.RsqlException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class NamedParam
implements DataCacheCloneable {
    private int index;
    private String name;
    private int type;
    private Object value;

    public NamedParam(int index, String name, int type, Object value) {
        this.index = index;
        this.name = name;
        this.type = type;
        this.value = value;
    }

    @Override
    public NamedParam clone() throws CloneNotSupportedException {
        NamedParam cloned = (NamedParam)super.clone();
        cloned.setValue(null);
        return cloned;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        if (null == this.value || this.value.toString().length() == 0) {
            return null;
        }
        if (this.type == 1) {
            return this.value.toString();
        }
        if (this.type == 16) {
            return String.valueOf(this.value);
        }
        if (this.type == 4) {
            try {
                return Integer.parseInt(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new RsqlException("RSQL_DATA_ERROR", "\u5b57\u6bb5\u3010" + this.name + "\u3011\u6570\u636e\u7c7b\u578b\u5e94\u4e3a\u6574\u578b[int]\uff1a" + this.value);
            }
        }
        if (this.type == 6) {
            try {
                return Float.valueOf(Float.parseFloat(this.value.toString()));
            }
            catch (NumberFormatException e) {
                throw new RsqlException("RSQL_DATA_ERROR", "\u5b57\u6bb5\u3010" + this.name + "\u3011\u6570\u636e\u7c7b\u578b\u5e94\u4e3a\u6570\u5b57\u7c7b\u578b[float]\uff1a" + this.value);
            }
        }
        if (this.type == 8) {
            try {
                return Double.parseDouble(this.value.toString());
            }
            catch (NumberFormatException e) {
                throw new RsqlException("RSQL_DATA_ERROR", "\u5b57\u6bb5\u3010" + this.name + "\u3011\u6570\u636e\u7c7b\u578b\u5e94\u4e3a\u6570\u5b57\u7c7b\u578b[double]\uff1a" + this.value);
            }
        }
        if (this.type == 2000) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.value);
                String ret = baos.toString();
                oos.close();
                baos.close();
                return ret;
            }
            catch (IOException e) {
                throw new RsqlException("RSQL_DATA_ERROR", "\u5b57\u6bb5\u3010" + this.name + "\u3011\u6570\u636e\u7c7b\u578b\u4e3a\u5bf9\u8c61\u7c7b\u578b[object]\uff0c\u4f46\u8f6c\u5316\u4e3a\u5b57\u8282\u6d41\u5931\u8d25\uff01" + this.value);
            }
        }
        return this.value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append("param=").append(this.index).append(", type=").append(this.type).append(',').append(this.name).append('=').append(this.value).append(']');
        return builder.toString();
    }

    public void setIndex(int namedParamIndex) {
        this.index = namedParamIndex;
    }

    public void setName(String namedParamName) {
        this.name = namedParamName;
    }

    public void setType(int namedParamType) {
        this.type = namedParamType;
    }

    public void setValue(Object namedParamValue) {
        this.value = namedParamValue;
    }
}

