/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.sqlutil;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.CollectionUtils;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.core.util.StringHelper;
import cn.remex.db.DbRvo;
import cn.remex.db.sql.FieldType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Node<T> {
    public static final String regx = "([A-Za-z_][A-Za-z\\d_\\$]*)$|(([A-Za-z_][A-Za-z\\d_\\$]*)\\.)|(([A-Za-z_][A-Za-z\\d_\\$]*)\\[\\]\\.)";
    private Node<?> rootNode;
    private Node<?> supNode;
    private FieldType type;
    private Class<T> nodeModel;
    private Class nodeType;
    private String nodeName;
    private String nodeExpr;
    private List<Node<?>> subNodes;
    private Map<String, Node<?>> paths;
    private Map<String, T> listItemMap;
    private List<T> list;
    private T nodeBean;
    private Map<String, ?> rowData;
    private DbRvo dbRvo;
    private int dbRvoIndex;
    private Object dbRvoInstanceFactory;
    private Method dbRvoInstanceMethod;

    public Node(Class<T> clazz) {
        this.type = FieldType.TObject;
        this.rootNode = this;
        this.nodeModel = clazz;
        this.paths = new HashMap();
    }

    public <PT> Node(Node<PT> supNode, FieldType type, String nodeName) {
        this.type = type;
        this.rootNode = supNode.rootNode;
        this.supNode = supNode;
        this.nodeName = nodeName;
        if (FieldType.TCollection.equals((Object)type)) {
            this.nodeModel = ReflectUtil.getListActualType(ReflectUtil.getGetter(supNode.getNodeModel(), nodeName).getGenericReturnType());
        } else {
            Method getter = ReflectUtil.getGetter(supNode.getNodeModel(), nodeName);
            if (null != getter) {
                this.nodeModel = (Class)getter.getGenericReturnType();
            }
        }
    }

    public <ST> Node<ST> addSubNode(FieldType type, String baseField, String nodeExpr) {
        Assert.isTrue(this.type.equals((Object)FieldType.TCollection) || this.type.equals((Object)FieldType.TObject), "ERROR", "\u53ea\u6709Model\u8282\u70b9\u6216Collection\u8282\u70b9\u80fd\u6dfb\u52a0\u5b50\u8282\u70b9\uff01");
        Node<T> subNode = new Node<T>(this, type, baseField);
        if (this.subNodes == null) {
            this.subNodes = new ArrayList();
        }
        subNode.nodeExpr = nodeExpr;
        this.subNodes.add(subNode);
        return subNode;
    }

    public void addIndex(String expr) {
        Param<Node> param = new Param<Node>(this);
        StringHelper.forEachMatch(expr, regx, (m, end) -> {
            String baseField = m.group(1);
            String objField = m.group(3);
            String listField = m.group(5);
            if (baseField != null) {
                Assert.isTrue(end, "ERROR", "\u7d22\u5f15\u5230\u6b64\u5904\u5fc5\u987b\u7ed3\u675f\uff0c\u7ed3\u675f\u6807\u8bc6\u4e3abaseField");
                this.paths.put(expr, ((Node)param.param).addSubNode(FieldType.TBase, baseField, baseField));
            } else if (objField != null) {
                Assert.isTrue(end == false, "ERROR", "\u7d22\u5f15\u4e0d\u80fd\u4ee5\u672a\u5b8c\u6210\u7684Object\u5f15\u7528\u7ed3\u675f");
                param.param = ((Node)param.param).addSubNode(FieldType.TObject, objField, m.group(2));
            } else if (listField != null) {
                Assert.isTrue(end == false, "ERROR", "\u7d22\u5f15\u4e0d\u80fd\u4ee5\u672a\u5b8c\u6210\u7684List\u5f15\u7528\u7ed3\u675f");
                param.param = ((Node)param.param).addSubNode(FieldType.TCollection, listField, m.group(4));
            }
        });
    }

    public Node<T> start(T nodeBean, Map<String, Object> rowData) {
        this.nodeBean = nodeBean;
        this.rowData = rowData;
        return this;
    }

    public Node<T> start(T nodeBean, DbRvo dbRvo, int rowIndex, Object instanceFactory, Method instanceMethod) {
        this.nodeBean = nodeBean;
        this.dbRvo = dbRvo;
        this.dbRvoIndex = rowIndex;
        this.dbRvoInstanceFactory = instanceFactory;
        this.dbRvoInstanceMethod = instanceMethod;
        return this;
    }

    public void evalEnd() {
        this.forEvery(n -> {
            n.nodeBean = null;
            n.rowData = null;
            n.dbRvo = null;
            n.dbRvoIndex = 0;
            n.list = null;
            n.listItemMap = null;
        });
    }

    public Node<T> eval(String expr, Object value) {
        Node<?> targetNode = this.paths.get(expr);
        Object curBean = super.obtainBean();
        if (null != targetNode.nodeModel) {
            ReflectUtil.invokeSetter(targetNode.nodeName, curBean, ReflectUtil.caseObject(targetNode.nodeModel, value, new Object[0]));
        }
        return this;
    }

    private StringBuilder obtainPath() {
        if (Judgment.nullOrBlank(this.nodeExpr)) {
            return new StringBuilder();
        }
        return super.obtainPath().append(this.nodeExpr);
    }

    private T obtainBean() {
        if (null == this.nodeBean) {
            if (FieldType.TCollection.equals((Object)this.type)) {
                if (this.listItemMap == null) {
                    ArrayList bean = ReflectUtil.invokeGetter(this.nodeName, super.obtainBean());
                    if (null == bean) {
                        bean = new ArrayList();
                        ReflectUtil.invokeSetter(this.nodeName, this.supNode.nodeBean, bean);
                    }
                    this.listItemMap = CollectionUtils.listToMap(bean, "id");
                    this.list = bean;
                }
                Object id = this.rootNode.dbRvo != null ? this.rootNode.dbRvo.getCell(this.rootNode.dbRvoIndex, this.obtainPath().append("id").toString()) : this.rootNode.rowData.get(this.obtainPath().append("id").toString());
                Assert.notNull(id, "ERROR", "\u68c0\u7d22\u5339\u914d\u7684\u5bf9\u8c61\u7684id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8d4b\u503c\uff0c\u5982\u679c\u6570\u636e\u64cd\u4f5c\u4e2d\u5bf9List \u6216Model\u8fdb\u884c\u4e86\u5206\u7ec4\uff0c\u9700\u8981\u663e\u793a\u6307\u5b9aid\u503c\uff01");
                this.nodeBean = this.listItemMap.get(id);
                if (null == this.nodeBean) {
                    this.nodeBean = this.rootNode.dbRvoInstanceFactory == null ? ReflectUtil.invokeNewInstance(this.nodeModel) : ReflectUtil.invokeMethod(this.rootNode.dbRvoInstanceMethod, this.rootNode.dbRvoInstanceFactory, this.nodeModel);
                    ReflectUtil.invokeSetter("id", this.nodeBean, String.valueOf(id));
                    this.list = null == this.list ? (List)ReflectUtil.invokeGetter(this.nodeName, this.supNode.nodeBean) : this.list;
                    this.list.add(this.nodeBean);
                }
            } else if (FieldType.TObject.equals((Object)this.type)) {
                Object bean = ReflectUtil.invokeGetter(this.nodeName, super.obtainBean());
                this.nodeBean = bean;
                if (null == this.nodeBean) {
                    this.nodeBean = this.dbRvoInstanceFactory == null ? ReflectUtil.invokeNewInstance(this.nodeModel) : ReflectUtil.invokeMethod(this.dbRvoInstanceMethod, this.dbRvoInstanceFactory, this.nodeModel);
                    ReflectUtil.invokeSetter(this.nodeName, this.supNode.nodeBean, this.nodeBean);
                }
            }
        }
        return this.nodeBean;
    }

    public Node<?> forEvery(Consumer<Node<?>> c) {
        c.accept(this);
        if (null != this.subNodes) {
            this.subNodes.forEach(cc -> cc.forEvery(c));
        }
        return this;
    }

    public Map<String, T> getListItemMap() {
        return this.listItemMap;
    }

    public void setListItemMap(Map<String, T> listItemMap) {
        this.listItemMap = listItemMap;
    }

    public List<Node<?>> getSubNodes() {
        return this.subNodes;
    }

    public void setSubNodes(List<Node<?>> subNodes) {
        this.subNodes = subNodes;
    }

    public Class<T> getNodeModel() {
        return this.nodeModel;
    }

    public void setNodeModel(Class<T> nodeModel) {
        this.nodeModel = nodeModel;
    }

    public Class getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(Class nodeType) {
        this.nodeType = nodeType;
    }

    public Node<?> getSupNode() {
        return this.supNode;
    }

    public void setSupNode(Node<?> supNode) {
        this.supNode = supNode;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public Map<String, Node<?>> getPaths() {
        return this.paths;
    }

    public void setPaths(Map<String, Node<?>> paths) {
        this.paths = paths;
    }
}

