/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.connection.dialect;

import cn.remex.db.exception.RsqlDialectException;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.sql.ColumnType;
import java.util.Map;

public class OracleDialect
extends Dialect {
    @Override
    public String aliasFullName(String tableAliasName, String fieldName, String aliasName) {
        return tableAliasName + "." + this.openQuote() + fieldName + this.closeQuote() + " " + this.openQuote() + aliasName + this.closeQuote();
    }

    @Override
    public String aliasAggrFun(String fieldName, String aliasName) {
        return fieldName + " " + this.openQuote() + aliasName + this.closeQuote();
    }

    @Override
    public String obtainSelectRegex() {
        return "FROM\\s+\\" + this.openQuote() + "([\\w_0-9]+)\\" + this.closeQuote() + "\\s+[\\" + this.openQuote() + "]?([\\w_0-9]+)[\\" + this.closeQuote() + "]?";
    }

    @Override
    public String aliasTableName(String tableName, String aliasName) {
        return this.openQuote() + tableName + this.closeQuote() + " " + aliasName;
    }

    @Override
    public char closeQuote() {
        return '\"';
    }

    @Override
    public char closeStringQuote() {
        return '\'';
    }

    @Override
    public String concat(String ... strings) {
        StringBuffer sb = new StringBuffer();
        int c = strings.length - 1;
        for (int i = 0; i < c; ++i) {
            sb.append(strings[i]).append("||");
        }
        return sb.append(strings[c]).toString();
    }

    @Override
    public String obtainPagingSQL(String sqlString, long start, long end, long rowCount) {
        StringBuilder sb = new StringBuilder("SELECT * FROM (SELECT A.*,ROWNUM rn FROM ( ").append(sqlString).append(") A WHERE ROWNUM<=").append(end).append(") WHERE rn>").append(start);
        return sb.toString();
    }

    @Override
    public String obtainSQLSelectIndexs(String beanName) {
        return "SELECT * FROM User_Indexes";
    }

    @Override
    public String obtainSQLIndexNameField() {
        return "INDEX_NAME";
    }

    @Override
    public String obtainSQLSelectTableNames() {
        return "SELECT TABLE_NAME AS NAME FROM " + this.quoteKey("USER_TABLES");
    }

    @Override
    public String obtainSQLSelectTablesColumnNames(String tableName) {
        StringBuilder sqlString = new StringBuilder();
        sqlString.append("SELECT\n  t.COLUMN_NAME,\n  t.DATA_TYPE,\n  t.DATA_LENGTH,\n  c.COMMENTS,\n  t.DATA_PRECISION,\n  t.DATA_SCALE,\n  t.NULLABLE\nFROM user_tab_columns t, user_col_comments c\nWHERE t.table_name = c.table_name AND t.column_name = c.column_name\n      AND t.table_name = :tableName");
        return sqlString.toString();
    }

    @Override
    public String obtainSQLTypeString(int type) {
        return this.obtainSQLTypeString(new ColumnType(type, -1));
    }

    @Override
    public String obtainSQLTypeString(ColumnType columnType) {
        String nullSql = columnType.nullable ? " NULL " : " NOT NULL ";
        switch (columnType.type) {
            case 4: 
            case 6: 
            case 8: {
                return " NUMBER " + nullSql;
            }
            case 16: {
                return " VARCHAR2(5) " + nullSql;
            }
            case -7: {
                return " BIT " + nullSql;
            }
            case 1: {
                return " VARCHAR2(" + (columnType.length == -1 ? 600 : columnType.length) + ") " + nullSql;
            }
            case 91: {
                return " VARCHAR2(20) " + nullSql;
            }
            case 2000: {
                return " VARCHAR2(2000) " + nullSql;
            }
            case 2005: {
                return " CLOB " + nullSql;
            }
        }
        throw new RsqlDialectException("RSQL_DIALECT_ERROR", OracleDialect.class + "\u4e2d\u4f7f\u7528\u4e86\u672a\u5b9a\u4e49\u7684SQLTypes!");
    }

    @Override
    public char openQuote() {
        return '\"';
    }

    @Override
    public char openStringQuote() {
        return '\'';
    }

    @Override
    public String quoteAsString(Object value) {
        if (null == value) {
            return "null";
        }
        return "" + this.openStringQuote() + value + this.closeStringQuote();
    }

    @Override
    public String quoteFullName(String tableName, String fieldName) {
        return tableName + "." + this.openQuote() + fieldName + this.closeQuote();
    }

    @Override
    public String renameTableSql() {
        return "alter table :oldTableName rename to :newTableName ";
    }

    @Override
    public String renameColumnSql() {
        return "alter table :oldTableName rename column :oldColumn to :newColumn ";
    }

    @Override
    public String obtainCreateSerialNumberFunctionSQL() {
        return "CREATE OR REPLACE FUNCTION\r\n       \"createSerialNumber\" \r\n          (beanName in \"SysSerialNumber\".\"beanName\"%type,\r\n           fieldName in \"SysSerialNumber\".\"fieldName\"%type)\r\nRETURN INTEGER\r\nIS\r\n       currentValue integer := 0;  --\u5b9a\u4e49\u8fd4\u56de\u53d8\u91cf\r\n \r\nPRAGMA AUTONOMOUS_TRANSACTION;\r\nBEGIN\r\n    --\u6700\u5927\u6570\u52a01\r\n    UPDATE \"SysSerialNumber\" SET \"currentValue\" = \"currentValue\"+1 where \"beanName\" = beanName and \"fieldName\" = fieldName\r\n    Returning \"currentValue\" Into currentValue; --\u53d6\u51fa\u6700\u5927\u6570\r\n    If(SQL%NOTFOUND) THEN  --\u7b2c\u4e00\u6b21\u5411\u6570\u636e\u5e93\u4e2d\u63d2\u5165\u6700\u5927\u6570\u4e3a 1 \u7684\u8bb0\u5f55\r\n       INSERT INTO \"SysSerialNumber\"(\"id\",\"beanName\",\"fieldName\",\"currentValue\") values('SSN'|| to_char(sysdate,'yyyyMMddhhmmss')||ABS(MOD(DBMS_RANDOM.RANDOM,10000)),beanName,fieldName,1) ;\r\n       currentValue := 1;\r\n    End If ;\r\n     commit;\r\n  return(currentValue); --\u8fd4\u56de\u7ed3\u679c\r\nend \"createSerialNumber\";";
    }

    @Override
    public String obtainQuerySerialNumberFunctionSQL() {
        return "SELECT \"createSerialNumber\"(:beanName,:fieldName) from dual";
    }

    @Override
    public StringBuilder obtainDecodeSQL(Map<String, String> map, String decodeKey, String displayName) {
        StringBuilder sb = new StringBuilder("DECODE(").append(decodeKey);
        for (String code : map.keySet()) {
            sb.append(",").append(this.quoteAsString(code)).append(",").append(this.quoteAsString(map.get(code)));
        }
        sb.append(") ");
        if (displayName != null) {
            sb.append(this.quoteKey(displayName));
        }
        return sb;
    }

    @Override
    public String obtainCountSql(String sqlString) {
        StringBuilder sb = new StringBuilder("SELECT COUNT(*) FROM ( ").append(sqlString).append(") tmptb");
        return sb.toString();
    }

    @Override
    public String prepareSqlForCount(String sqlString) {
        return sqlString;
    }

    @Override
    public boolean needSetParamForCount() {
        return true;
    }

    @Override
    public boolean needLowCaseTableName() {
        return false;
    }
}

