/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.connection.dialect;

import cn.remex.db.sql.ColumnType;
import java.util.Map;

public abstract class Dialect {
    public abstract String aliasAggrFun(String var1, String var2);

    public abstract String aliasFullName(String var1, String var2, String var3);

    public abstract String aliasTableName(String var1, String var2);

    public abstract char closeStringQuote();

    public abstract String concat(String ... var1);

    public abstract boolean needLowCaseTableName();

    public abstract boolean needSetParamForCount();

    public String obtainConstraintSql(String beanName, String name, String ... columnNames) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(this.quoteKey(beanName)).append(" ADD CONSTRAINT ").append(name).append(" UNIQUE ( ");
        for (String c : columnNames) {
            sb.append(this.quoteKey(c)).append(",");
        }
        sb.deleteCharAt(sb.length() - 1).append(")");
        return sb.toString();
    }

    public String quoteKey(String ... keys) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(this.openQuote()).append(key).append(this.closeQuote()).append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public abstract char openQuote();

    public abstract char closeQuote();

    public abstract String obtainCountSql(String var1);

    public abstract String obtainCreateSerialNumberFunctionSQL();

    public abstract StringBuilder obtainDecodeSQL(Map<String, String> var1, String var2, String var3);

    public String obtainIndexName(String beanName, String ... columnNames) {
        StringBuilder idxname = new StringBuilder(beanName.replaceAll("[^A-Z]", "")).append("_");
        StringBuilder cols = new StringBuilder(beanName);
        for (String c : columnNames) {
            idxname.append(c.charAt(0));
            cols.append(c);
        }
        return idxname.append(String.valueOf((beanName + cols.toString()).hashCode()).replaceAll("\\-", "_")).toString().toUpperCase();
    }

    public String obtainIndexSql(String beanName, String name, String ... columnNames) {
        StringBuilder sb = new StringBuilder("CREATE INDEX ").append(name).append(" ON ").append(this.quoteKey(beanName)).append(" ( ");
        for (String c : columnNames) {
            sb.append(this.quoteKey(c)).append(",");
        }
        sb.deleteCharAt(sb.length() - 1).append(")");
        return sb.toString();
    }

    public abstract String obtainPagingSQL(String var1, long var2, long var4, long var6);

    public abstract String obtainQuerySerialNumberFunctionSQL();

    public abstract String obtainSQLIndexNameField();

    public abstract String obtainSQLSelectIndexs(String var1);

    public abstract String obtainSQLSelectTableNames();

    public abstract String obtainSQLSelectTablesColumnNames(String var1);

    public abstract String obtainSQLTypeString(int var1);

    public abstract String obtainSQLTypeString(ColumnType var1);

    public abstract String obtainSelectRegex();

    public abstract char openStringQuote();

    public abstract String prepareSqlForCount(String var1);

    public abstract String quoteAsString(Object var1);

    public abstract String quoteFullName(String var1, String var2);

    public abstract String renameColumnSql();

    public abstract String renameTableSql();
}

