/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.connection;

import cn.remex.db.Container;
import cn.remex.db.rsql.RsqlContainer;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.rsql.model.Modelable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;

public class RDBSpaceConfig
implements InitializingBean {
    private Dialect dialect;
    private Class<? extends Container> containerClass = RsqlContainer.class;
    private String spaceName;
    private String type;
    private Map<String, Class<? extends Modelable>> ormBeans = new HashMap<String, Class<? extends Modelable>>();
    private List<String> ormBeanPackages;
    private DataSource dataSource;
    private boolean cannotRebuild;
    private int defaultScale = 2;

    public void afterPropertiesSet() throws Exception {
        RDBManager.createSpace(this);
    }

    public void setDialectClass(String dialect) throws Exception {
        this.dialect = (Dialect)Class.forName(dialect).newInstance();
    }

    public void setContainerClass(Class<? extends Container> containerClass) {
        this.containerClass = containerClass;
    }

    public Class<? extends Container> getContainerClass() {
        return this.containerClass;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Class<? extends Modelable> getOrmBeanClass(String beanName) {
        return null != beanName ? this.ormBeans.get(beanName.split("\\$\\$EnhancerByCGLIB\\$\\$")[0]) : null;
    }

    public List<String> getOrmBeanPackages() {
        return this.ormBeanPackages;
    }

    public Map<String, Class<?>> getOrmBeans() {
        HashMap ret = new HashMap();
        ret.putAll(this.ormBeans);
        return ret;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasOrmBeanClass(Type type) {
        if (type instanceof Class) {
            return null != this.getOrmBeanClass(((Class)type).getSimpleName());
        }
        return false;
    }

    public void setOrmBeanPackages(List<String> ormBeanPackages) {
        this.ormBeanPackages = ormBeanPackages;
    }

    public void setOrmBeans(Map<String, Class<? extends Modelable>> ormBeans) {
        this.ormBeans = ormBeans;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isCannotRebuild() {
        return this.cannotRebuild;
    }

    public void setCannotRebuild(boolean cannotRebuild) {
        this.cannotRebuild = cannotRebuild;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public void setDefaultScale(int defaultScale) {
        this.defaultScale = defaultScale;
    }
}

