/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.aspect;

import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.transactional.RsqlTransaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class RsqlTransactionalAspect {
    public RsqlTransactionalAspect() {
        RsqlConstants.logger.info((Object)("Remex2\u4e2d\u7684\u5207\u9762\u7c7b" + RsqlTransactionalAspect.class + "\u521d\u59cb\u5316\u5b8c\u6210\uff01"));
    }

    @Around(value="@annotation(cn.remex.db.rsql.transactional.RsqlTransaction) && @annotation(rsqlTranAnno)")
    public Object doAround(ProceedingJoinPoint pjp, RsqlTransaction rsqlTranAnno) throws Throwable {
        try {
            RDBManager.beginTransactional(RDBManager.DEFAULT_SPACE, rsqlTranAnno);
            Object retVal = pjp.proceed();
            RDBManager.finishTransactional(RDBManager.DEFAULT_SPACE);
            return retVal;
        }
        catch (Throwable t) {
            RDBManager.abortTransactional(t, RDBManager.DEFAULT_SPACE);
            throw t;
        }
    }
}

