/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql.aspect;

import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.exception.RsqlDataException;
import cn.remex.db.exception.RsqlExecuteException;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.sql.Select;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class RsqlMonitorAspect {
    private static boolean isDebug = RsqlConstants.logger.isDebugEnabled();

    @Around(value="execution(java.util.*List cn.remex.db.model.*.get*())|| execution(java.util.*Map cn.remex.db.model.*.get*())|| execution(java.util.*Set cn.remex.db.model.*.get*())|| execution(java.util.*Vector cn.remex.db.model.*.get*())")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Object retVal = pjp.proceed();
        return retVal;
    }

    @Around(value="execution(public * cn.remex.db.rsql.RsqlExecutor.execute*(..))")
    public Object doAroundRemexSqlExecute(ProceedingJoinPoint pjp) throws Throwable {
        DbRvo retVal;
        long time = System.currentTimeMillis();
        StringBuilder msg = new StringBuilder("RsqlExecutor.").append(pjp.getSignature().getName()).append("() executed [ ms ], Message:");
        DbCvo dbCvo = (DbCvo)pjp.getArgs()[0];
        msg.append("\r\n\tSQL\uff1a").append(dbCvo._getSqlString()).append(dbCvo._getSqlString().trim().startsWith("SELECT") ? Select.obtainSQLOrder(dbCvo) : "").append("\r\n\tParameters\uff1a").append(dbCvo._getNamedParams().toString());
        try {
            retVal = (DbRvo)pjp.proceed();
            RsqlConstants.logger.info((Object)msg.append("\r\n\tDataBase Msg\uff1a").append(retVal.getMsg()).insert(34, System.currentTimeMillis() - time));
        }
        catch (RsqlExecuteException e) {
            if (null != e.getCause() && e.getCause().getMessage().contains("Duplicate entry")) {
                String causeMsg = e.getCause().getMessage();
                throw new RsqlDataException("RSQL_DATA_INVALID", "\u4e3b\u952e\u6570\u636e\u91cd\u590d\uff1a" + causeMsg.substring(causeMsg.indexOf("Duplicate entry") + 15, causeMsg.indexOf("for")));
            }
            if (null != e.getCause() && e.getCause().getMessage().contains("Data truncation: Data too long")) {
                String causeMsg = e.getCause().getMessage();
                throw new RsqlDataException("RSQL_DATA_INVALID", "\u4fdd\u5b58\u6570\u636e\u8fc7\u957f\uff1a" + causeMsg.substring(causeMsg.indexOf("Data too long for column") + 24, causeMsg.indexOf(" at")));
            }
            RsqlConstants.logger.error((Object)msg.append("\r\n\tRsqlExecuteException\uff1a").append(e.getMessage()).insert(39, System.currentTimeMillis() - time), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            RsqlConstants.logger.error((Object)msg.append("\r\n\tException\uff1a").append(e.getMessage()).insert(39, System.currentTimeMillis() - time), (Throwable)e);
            throw e;
        }
        return retVal;
    }
}

