/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql;

import cn.remex.core.cache.DataCachePool;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.core.util.ReadOnlyMap;
import cn.remex.core.util.StringHelper;
import cn.remex.db.Database;
import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.exception.RsqlConnectionException;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.sql.ColumnType;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.NamedParam;
import cn.remex.db.sql.Select;
import cn.remex.db.sql.SqlColumn;
import cn.remex.db.sql.SqlType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.apache.oro.text.regex.MatchResult;

public final class RsqlUtils
implements RsqlConstants {
    private static final String NamedSqlEquationRegex = "(([_\\.\\w\u4e00-\u9fa5]+)=:)";
    private static final String NamedSqlEquationRegexRplc = ":";
    private static final String NamedSqlParamRegex = "(:([_\\.\\w\u4e00-\u9fa5]+))";
    private static final String NamedSqlParamRegexRplc = "(:([_\\.\\w\u4e00-\u9fa5]+))";
    private static Map<Type, ColumnType> SqlTypes;
    private static Map<String, ColumnType> SysCreateColumns;
    private static Map<String, ColumnType> SysModifyColumns;
    public static Map<String, ColumnType> SysColumns;

    public static boolean modelIdIsNew(Object objId) {
        return Judgment.nullOrBlank(objId) || "-1".equals(objId) || "_empty".equals(objId);
    }

    public static TreeMap<Integer, String> obtainNamedParamIndexs(String sql) {
        TreeMap<Integer, String> paramsMap = new TreeMap<Integer, String>();
        Pattern p1 = Pattern.compile("(:([_\\.\\w\u4e00-\u9fa5]+))");
        Pattern p2 = Pattern.compile(NamedSqlEquationRegex);
        Matcher m1 = p1.matcher(sql);
        Matcher m2 = p2.matcher(sql);
        int idx = 1;
        int stt1 = 10000;
        int stt2 = 10000;
        boolean b1 = m1.find();
        boolean b2 = m2.find();
        while (b1 || b2) {
            String word;
            if (b1) {
                stt1 = m1.start();
            }
            if (b2) {
                stt2 = m2.start();
            }
            if (b1 && !b2 || b1 && stt1 < stt2) {
                word = m1.group(2);
                paramsMap.put(new Integer(idx++), word);
                b1 = m1.find();
                if (!b1) continue;
                stt1 = m1.start();
                continue;
            }
            if ((!b2 || b1) && (!b2 || stt2 >= stt1)) continue;
            word = m2.group(2);
            paramsMap.put(new Integer(idx++), word);
            b2 = m2.find();
            if (!b2) continue;
            stt2 = m2.start();
        }
        return paramsMap;
    }

    public static String obtainNamedSql(String sqlString) {
        sqlString = sqlString.replaceAll("(:([_\\.\\w\u4e00-\u9fa5]+))", "?");
        return sqlString.replaceAll(NamedSqlEquationRegexRplc, "?");
    }

    static Map<String, ColumnType> obtainColumnTypeOfSysColumn() {
        return SysColumns;
    }

    static Map<String, ColumnType> obtainColumnType(Class<?> beanClass, SqlColumn rootColumn, FieldType tType) {
        HashMap<String, ColumnType> columns = new HashMap<String, ColumnType>();
        SqlType.getFields(beanClass, tType).forEach((fieldName, fieldType) -> {
            if (null == rootColumn || !rootColumn.hasAnyColumn() || rootColumn.anyMatchInRoot((String)fieldName)) {
                columns.put((String)fieldName, tType == FieldType.TObject ? new ColumnType(1, 50) : RsqlUtils.obtainSQLType(fieldType, fieldName, beanClass));
            }
        });
        SysColumns.keySet().forEach(columns::remove);
        return columns;
    }

    private static ColumnType obtainSQLType(Type type, String fieldName, Class<?> beanClass) {
        Column at = null != beanClass ? ReflectUtil.getAnnotation(beanClass, fieldName, Column.class) : null;
        ColumnType sqlType = null;
        if (null != beanClass && null != (sqlType = SqlTypes.get(type)) && null != at) {
            return new ColumnType(SqlTypes.get(type), at);
        }
        if (null != sqlType) {
            return sqlType;
        }
        if (SqlType.isTObject(type)) {
            return new ColumnType(1, 50);
        }
        if (Enum.class.isAssignableFrom(ReflectUtil.obtainClass(type))) {
            return null == at ? new ColumnType(1, 100) : new ColumnType(SqlTypes.get(Enum.class), at);
        }
        return new ColumnType(2000, 100);
    }

    public static DbRvo doListColumn_select(String spaceName, Class<?> beanClass, String fieldName, Object beanId) {
        boolean isOnetoMany;
        Dialect dialect = RDBManager.getLocalSpaceConfig(spaceName).getDialect();
        String beanName = StringHelper.getClassSimpleName(beanClass);
        Type fieldType = SqlType.getFields(beanClass, FieldType.TCollection).get(fieldName);
        StringBuilder sqlString = new StringBuilder();
        Class<?> subBeanClass = ReflectUtil.getListActualType(fieldType);
        OneToMany oneToMany = ReflectUtil.getAnnotation(beanClass, fieldName, OneToMany.class);
        ManyToMany manyToMany = ReflectUtil.getAnnotation(beanClass, fieldName, ManyToMany.class);
        String primaryBeanName = beanName;
        Class<?> primaryBeanClass = beanClass;
        String primaryFieldName = fieldName;
        Type primaryFieldType = fieldType;
        boolean bl = isOnetoMany = null != oneToMany;
        if (isOnetoMany) {
            Assert.isTrue(null != oneToMany.mappedBy(), "ERROR", "\u4e00\u5bf9\u591a\u5fc5\u987b\u5236\u5b9a\u591a\u65b9\u7ef4\u62a4\u7684\u5c5e\u6027\u5b57\u6bb5", RsqlConnectionException.class);
        }
        boolean meIsManyToManyPrimary = true;
        if (!isOnetoMany) {
            String tmb = null;
            String mb = null;
            if (null != manyToMany) {
                Map<String, Method> tcGetters = SqlType.getGetters(subBeanClass, FieldType.TCollection);
                mb = manyToMany.mappedBy();
                Assert.notNull(mb, "ERROR", "\u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\u672c\u7c7b" + beanClass.getName() + "\u6ca1\u6709\u6307\u5b9a\u5bf9\u65b9\u7c7b\u591a\u5bf9\u591a\u5c5e\u6027:" + mb, RsqlConnectionException.class);
                Assert.isTrue(tcGetters.containsKey(mb), "ERROR", " \u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\u5bf9\u65b9\u7c7b" + subBeanClass.getName() + "\u4e0d\u5b58\u5728\u8be5\u591a\u5bf9\u591a\u5c5e\u6027:" + mb, RsqlConnectionException.class);
                ManyToMany tMtm = ReflectUtil.getAnnotation(subBeanClass, mb, ManyToMany.class);
                Assert.notNull(tMtm, "ERROR", "\u663e\u793a\u58f0\u660e\u591a\u5bf9\u591a\u65f6\uff0c\u9700\u8981\u53cc\u65b9\u6307\u5b9aManyToMany\u58f0\u660e\uff0c\u6b64\u5904\u5bf9\u65b9\u7c7b\u7684ManyToMany\u58f0\u660e\u4e3a\u7a7a\uff01\u8bf7\u66f4\u6b63\uff01", RsqlConnectionException.class);
                tmb = tMtm.mappedBy();
                Assert.notNull(tmb, "ERROR", "\u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\u5bf9\u65b9\u7c7b" + subBeanClass.getName() + "\u6ca1\u6709\u6307\u5b9a\u672c\u7c7b\u7684\u591a\u5bf9\u591a\u5c5e\u6027:" + mb, RsqlConnectionException.class);
                Class te = manyToMany.targetEntity();
                Class tte = tMtm.targetEntity();
                Assert.isTrue(null == te && null == tte || null != te && null != tte, "ERROR", "\u663e\u5f0f\u6307\u5b9a\u4e3a\u53cc\u65b9\u7ef4\u62a4\u7684\u591a\u5bf9\u591a\u6620\u5c04\u4e2d\uff0cManyToMany\u58f0\u660e\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6e\u6216\u8005\u540c\u65f6\u4e3a\u7a7a\uff01\u8bbe\u7f6etargetEntity\u7684\u4e3a\u4e3b\u7ef4\u62a4\u65b9\u3002" + mb, RsqlConnectionException.class);
                meIsManyToManyPrimary = !"void".equals(te.toString());
            } else {
                meIsManyToManyPrimary = true;
            }
            if (!meIsManyToManyPrimary) {
                primaryBeanName = subBeanClass.getSimpleName();
                primaryBeanClass = subBeanClass;
                primaryFieldName = mb;
                primaryFieldType = SqlType.getFields(primaryBeanClass, FieldType.TCollection).get(primaryFieldName);
            }
        }
        Map<String, ColumnType> ctColumns = RsqlUtils.obtainListColumnFKColumnType(primaryBeanName, primaryFieldName, primaryFieldType);
        Iterator<Map.Entry<String, ColumnType>> ctkeys = ctColumns.entrySet().iterator();
        String F_column = ctkeys.next().getKey();
        String P_column = ctkeys.next().getKey();
        String F_table = StringHelper.getClassSimpleName(subBeanClass);
        String F_table_alias = "T";
        sqlString.append("SELECT ");
        for (String f : SqlType.getGetters(subBeanClass, FieldType.TBase).keySet()) {
            sqlString.append(dialect.aliasFullName(F_table_alias, f, f)).append(",");
        }
        for (String f : SqlType.getGetters(subBeanClass, FieldType.TObject).keySet()) {
            sqlString.append(dialect.aliasFullName(F_table_alias, f, f)).append(",");
        }
        sqlString.delete(sqlString.length() - 1, sqlString.length());
        sqlString.append(" FROM ").append(dialect.quoteKey(F_table)).append(" ").append(F_table_alias);
        if (isOnetoMany) {
            sqlString.append(" WHERE 1=1 AND ").append(dialect.quoteFullName(F_table_alias, oneToMany.mappedBy())).append("= :RMX_beanId");
        } else {
            String search_column = meIsManyToManyPrimary ? P_column : F_column;
            String join_column = meIsManyToManyPrimary ? F_column : P_column;
            sqlString.append(" LEFT JOIN ").append(dialect.quoteKey(RsqlUtils.obtainListColumnFKTableName(dialect, primaryBeanName, primaryFieldName))).append(" ON ").append(dialect.quoteKey(join_column)).append("=").append(dialect.quoteFullName(F_table_alias, "id"));
            sqlString.append(" WHERE 1=1 AND ").append(dialect.quoteKey(search_column)).append("= :RMX_beanId");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("RMX_beanId", beanId);
        params.put("RMX_beanClass", subBeanClass);
        return Database.getSession().executeQuery(sqlString.toString(), params);
    }

    static DbRvo doManyToMany_insert(String spaceName, Class<?> beanClass, String beanName, String fieldName, Object obj_id, Object coField_id, boolean meIsPrimaryTable) {
        String doManyToMany_insert_cacheKey = "RsqlUtils.doManyToMany_insert";
        StringBuilder key = new StringBuilder().append(beanClass.hashCode()).append(beanName.hashCode()).append(fieldName.hashCode()).append(meIsPrimaryTable);
        ArrayList<String> sqlOpts = (ArrayList<String>)DataCachePool.get(doManyToMany_insert_cacheKey, key);
        if (null == sqlOpts) {
            Dialect dialect = RDBManager.getLocalSpaceConfig(spaceName).getDialect();
            StringBuilder sqlString = new StringBuilder();
            ManyToMany manyToMany = ReflectUtil.getAnnotation(beanClass, fieldName, ManyToMany.class);
            Type fieldType = SqlType.getFields(beanClass, FieldType.TCollection).get(fieldName);
            Class<?> subBeanClass = ReflectUtil.getListActualType(fieldType);
            Class<?> primaryBeanClass = beanClass;
            String primaryBeanName = beanName;
            String primaryFieldName = fieldName;
            Type primaryFieldType = fieldType;
            if (!meIsPrimaryTable) {
                primaryBeanName = subBeanClass.getSimpleName();
                primaryBeanClass = subBeanClass;
                primaryFieldName = manyToMany.mappedBy();
                primaryFieldType = SqlType.getFields(primaryBeanClass, FieldType.TCollection).get(primaryFieldName);
            }
            Map<String, ColumnType> ctColumns = RsqlUtils.obtainListColumnFKColumnType(primaryBeanName, primaryFieldName, primaryFieldType);
            Iterator<String> kitr = ctColumns.keySet().iterator();
            String fkey = kitr.next();
            String pkey = kitr.next();
            sqlString.append("INSERT INTO ").append(dialect.quoteKey(RsqlUtils.obtainListColumnFKTableName(dialect, primaryBeanName, primaryFieldName))).append(" (\r\n\t");
            sqlString.append(dialect.quoteKey("id")).append(",");
            sqlString.append(dialect.quoteKey(fkey)).append(",");
            sqlString.append(dialect.quoteKey(pkey));
            sqlString.append("\r\n)VALUES(\r\n\t");
            sqlString.append(NamedSqlEquationRegexRplc).append("id");
            sqlString.append(",:").append(fkey);
            sqlString.append(",:").append(pkey);
            sqlString.append("\r\n)");
            sqlOpts = new ArrayList<String>();
            sqlOpts.add(sqlString.toString());
            sqlOpts.add(pkey);
            sqlOpts.add(fkey);
            sqlOpts.trimToSize();
            DataCachePool.put(doManyToMany_insert_cacheKey, key, sqlOpts);
        }
        Object P_id = meIsPrimaryTable ? obj_id : coField_id;
        Object F_id = meIsPrimaryTable ? coField_id : obj_id;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", String.valueOf(System.currentTimeMillis()) + (100000.0 + Math.random() * 10000.0));
        params.put((String)sqlOpts.get(1), P_id);
        params.put((String)sqlOpts.get(2), F_id);
        return Database.getSession().executeUpdate((String)sqlOpts.get(0), params);
    }

    static DbRvo doManyToMany_delete(String spaceName, Class<?> beanClass, String beanName, String fieldName, Object obj_id, Object coField_id, boolean meIsPrimaryTable) {
        String doManyToMany_delete_cacheKey = "RsqlUtils.doManyToMany_delete";
        StringBuilder key = new StringBuilder().append(beanClass.hashCode()).append(beanName.hashCode()).append(fieldName.hashCode()).append(meIsPrimaryTable);
        ArrayList<String> sqlOpts = (ArrayList<String>)DataCachePool.get(doManyToMany_delete_cacheKey, key);
        if (null == sqlOpts) {
            Dialect dialect = RDBManager.getLocalSpaceConfig(spaceName).getDialect();
            StringBuilder sqlString = new StringBuilder();
            ManyToMany manyToMany = ReflectUtil.getAnnotation(beanClass, fieldName, ManyToMany.class);
            Type fieldType = SqlType.getFields(beanClass, FieldType.TCollection).get(fieldName);
            Class<?> primaryBeanClass = beanClass;
            String primaryBeanName = beanName;
            String primaryFieldName = fieldName;
            Type primaryFieldType = fieldType;
            if (!meIsPrimaryTable) {
                Class<?> subBeanClass = ReflectUtil.getListActualType(fieldType);
                primaryBeanName = subBeanClass.getSimpleName();
                primaryBeanClass = subBeanClass;
                primaryFieldName = manyToMany.mappedBy();
                primaryFieldType = SqlType.getFields(primaryBeanClass, FieldType.TCollection).get(primaryFieldName);
            }
            Map<String, ColumnType> ctColumns = RsqlUtils.obtainListColumnFKColumnType(primaryBeanName, primaryFieldName, primaryFieldType);
            Iterator<String> kitr = ctColumns.keySet().iterator();
            String fkey = kitr.next();
            String pkey = kitr.next();
            sqlString.append("DELETE FROM ").append(dialect.quoteKey(RsqlUtils.obtainListColumnFKTableName(dialect, primaryBeanName, primaryFieldName))).append(" \r\n\tWHERE ");
            sqlString.append(dialect.quoteKey(pkey)).append("= :").append(pkey);
            sqlString.append(" AND ");
            sqlString.append(dialect.quoteKey(fkey)).append("= :").append(fkey);
            sqlOpts = new ArrayList<String>();
            sqlOpts.add(sqlString.toString());
            sqlOpts.add(pkey);
            sqlOpts.add(fkey);
            sqlOpts.trimToSize();
            DataCachePool.put(doManyToMany_delete_cacheKey, key, sqlOpts);
        }
        Object P_id = meIsPrimaryTable ? obj_id : coField_id;
        Object F_id = meIsPrimaryTable ? coField_id : obj_id;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put((String)sqlOpts.get(1), P_id);
        params.put((String)sqlOpts.get(2), F_id);
        return Database.getSession().executeUpdate((String)sqlOpts.get(0), params);
    }

    public static <T extends Modelable> void createDeleteSql(DbCvo<T> cvo) {
        String beanName;
        Dialect dialect = RDBManager.getLocalSpaceConfig(cvo._getSpaceName()).getDialect();
        String tableAliasName = beanName = cvo.getBeanName();
        ArrayList<NamedParam> namedParams = new ArrayList<NamedParam>();
        cvo._setNamedParams(namedParams);
        namedParams.add(new NamedParam(-1, "id", 1, null));
        Param<Integer> tableIndex = new Param<Integer>(0);
        Param<Integer> paramIndex = new Param<Integer>(0);
        String part_where = "\r\nWHERE 1=1 " + (Judgment.nullOrBlank(cvo.getId()) ? "" : " AND" + dialect.quoteKey("id") + "= :" + "id");
        String filterStr = cvo.getFilter().toSQL(false, tableAliasName, namedParams, paramIndex, tableIndex, cvo);
        if (!Judgment.nullOrBlank(filterStr)) {
            part_where = part_where + " AND (" + filterStr + ") ";
        }
        namedParams.trimToSize();
        cvo._setSqlString("DELETE FROM " + dialect.quoteKey(beanName) + part_where);
    }

    public static <T extends Modelable> void createInsertSql(DbCvo<T> cvo) {
        Dialect dialect = RDBManager.getLocalSpaceConfig(cvo._getSpaceName()).getDialect();
        String beanName = cvo.getBeanName();
        Class beanClass = cvo.getBeanClass();
        String tableName = beanName;
        ArrayList<NamedParam> namedParams = new ArrayList<NamedParam>();
        cvo._setNamedParams(namedParams);
        String prefix = "INSERT INTO " + dialect.openQuote() + tableName + dialect.closeQuote();
        String part_col2val = ")\r\n VALUES \r\n\t(";
        StringBuilder part_column_sb = new StringBuilder();
        StringBuilder part_value_sb = new StringBuilder();
        StringBuilder sqlString = new StringBuilder();
        part_column_sb.append("\r\n\t(");
        SysColumns.forEach((column, columnType) -> {
            part_column_sb.append(dialect.quoteKey((String)column)).append(",");
            part_value_sb.append(NamedSqlEquationRegexRplc).append((String)column).append(",");
            namedParams.add(new NamedParam(-1, (String)column, columnType.type, null));
        });
        Map<String, ColumnType> baseColumns = RsqlUtils.obtainColumnType(beanClass, cvo._getRootColumn(), FieldType.TBase);
        baseColumns.forEach((column, columnType) -> {
            part_column_sb.append(dialect.quoteKey((String)column)).append(",");
            part_value_sb.append(NamedSqlEquationRegexRplc).append((String)column).append(",");
            namedParams.add(new NamedParam(-1, (String)column, columnType.type, null));
        });
        Map<String, ColumnType> objectColumns = RsqlUtils.obtainColumnType(beanClass, cvo._getRootColumn(), FieldType.TObject);
        objectColumns.forEach((column, columnType) -> {
            part_column_sb.append(dialect.quoteKey((String)column)).append(",");
            part_value_sb.append(NamedSqlEquationRegexRplc).append((String)column).append(",");
            namedParams.add(new NamedParam(-1, (String)column, columnType.type, null));
        });
        part_value_sb.append(")\r\n");
        String part_column = part_column_sb.deleteCharAt(part_column_sb.length() - 1).toString();
        String part_value = part_value_sb.deleteCharAt(part_value_sb.length() - 4).toString();
        sqlString.append(prefix).append(part_column).append(part_col2val).append(part_value);
        namedParams.trimToSize();
        cvo._setSqlString(sqlString.toString());
    }

    public static <T extends Modelable> void createSelectSql(DbCvo<T> cvo) {
        Select select = new Select(cvo);
        if (!(cvo._isHasGroupBy() || cvo._isHasAggregateBy() || cvo._isHasDistinct() || cvo._isSubStatment())) {
            select.appendBaseColumn("id", "id");
        }
        Param<Boolean> hasNotBaseColumn = new Param<Boolean>(true);
        cvo._getRootColumn().getSubColumns().stream().forEach(c -> c.forEvery(cc -> {
            if (FieldType.TBase.equals((Object)cc.getType())) {
                select.appendColumn((SqlColumn)cc);
                if (((Boolean)hasNotBaseColumn.param).booleanValue()) {
                    hasNotBaseColumn.param = !FieldType.TROOT.equals((Object)cc.getSupColumn().getType());
                }
            } else if (FieldType.TObject.equals((Object)cc.getType())) {
                select.leftJoinModel((SqlColumn)cc);
            } else if (FieldType.TCollection.equals((Object)cc.getType())) {
                select.leftJoinList((SqlColumn)cc);
            }
            if (cc.isGroupBy()) {
                select.groupBy((SqlColumn)cc);
            }
        }));
        if (!(!((Boolean)hasNotBaseColumn.param).booleanValue() || cvo._isSubStatment() || cvo._isHasGroupBy() || cvo._isHasAggregateBy() || cvo._isHasDistinct())) {
            Class beanClass = cvo.getBeanClass();
            Map<String, ColumnType> baseColumns = RsqlUtils.obtainColumnType(beanClass, null, FieldType.TBase);
            baseColumns.forEach((fieldName, ct) -> select.appendBaseColumn((String)fieldName, (String)fieldName));
        } else if (!((Boolean)hasNotBaseColumn.param).booleanValue() || cvo._isSubStatment()) {
            // empty if block
        }
        cvo._setSqlString(select.sqlString());
    }

    public static <T extends Modelable> void createStringSql(DbCvo<T> cvo) {
        Dialect dialect = RDBManager.getLocalSpaceConfig(cvo._getSpaceName()).getDialect();
        String sqlString = cvo._getSqlString();
        String regex = dialect.obtainSelectRegex();
        MatchResult mr = StringHelper.match(sqlString, regex, null);
        String tableAliasName = null;
        String tableName = null;
        if (null != mr) {
            tableName = mr.group(1);
            tableAliasName = mr.group(2);
            cvo.$S("bn", tableName);
        }
        ArrayList<NamedParam> namedParams = new ArrayList<NamedParam>();
        cvo._setNamedParams(namedParams);
        TreeMap<Integer, String> paramIndexs = RsqlUtils.obtainNamedParamIndexs(sqlString);
        for (Integer paramIdx : paramIndexs.keySet()) {
            namedParams.add(new NamedParam(-1, paramIndexs.get(paramIdx), 1, null));
        }
        namedParams.trimToSize();
        cvo._setSqlString(sqlString.toString());
    }

    public static <T extends Modelable> void createUpdateSql(DbCvo<T> cvo) {
        Dialect dialect = RDBManager.getLocalSpaceConfig(cvo._getSpaceName()).getDialect();
        String beanName = cvo.getBeanName();
        Class beanClass = cvo.getBeanClass();
        String tableAliasName = "T";
        ArrayList<NamedParam> namedParams = new ArrayList<NamedParam>();
        cvo._setNamedParams(namedParams);
        namedParams.add(new NamedParam(-1, "id", 1, null));
        Param<Integer> tableIndex = new Param<Integer>(0);
        Param<Integer> paramIndex = new Param<Integer>(0);
        String prefix = "UPDATE " + dialect.quoteKey(beanName) + " " + tableAliasName + " SET ";
        String part_where = "\r\nWHERE 1=1 " + (Judgment.nullOrBlank(cvo.getId()) ? "" : " AND" + dialect.quoteKey("id") + "= :" + "id");
        String filterStr = cvo.getFilter().toSQL(false, tableAliasName, namedParams, paramIndex, tableIndex, cvo);
        if (!Judgment.nullOrBlank(filterStr)) {
            part_where = part_where + " AND (" + filterStr + ") ";
        }
        StringBuilder part_colsetval_sb = new StringBuilder();
        StringBuilder sqlString = new StringBuilder();
        BiConsumer<String, ColumnType> columnBiConsumer = (column, columnType) -> {
            SqlColumn curSqlColumn = cvo._getRootColumn().subColumn((String)column);
            if (curSqlColumn == null || null == curSqlColumn.getSubDbCvo()) {
                part_colsetval_sb.append("\r\n\t").append(dialect.quoteKey((String)column)).append("= :").append((String)column).append(",");
                namedParams.add(new NamedParam(-1, (String)column, columnType.type, null));
            } else {
                curSqlColumn.getSubDbCvo()._initForSubStatement(cvo, tableIndex, paramIndex);
                part_colsetval_sb.append("\r\n\t").append(dialect.quoteKey((String)column)).append("= (").append(curSqlColumn.getSubDbCvo()._getPrettySqlString()).append("),");
            }
        };
        SysModifyColumns.forEach(columnBiConsumer);
        Map<String, ColumnType> baseColumns = RsqlUtils.obtainColumnType(beanClass, cvo._getRootColumn(), FieldType.TBase);
        baseColumns.forEach(columnBiConsumer);
        Map<String, ColumnType> objectColumns = RsqlUtils.obtainColumnType(beanClass, cvo._getRootColumn(), FieldType.TObject);
        objectColumns.forEach(columnBiConsumer);
        String part_colsetval = part_colsetval_sb.deleteCharAt(part_colsetval_sb.length() - 1).toString();
        sqlString.append(prefix).append(part_colsetval).append(part_where);
        cvo._setSqlString(sqlString.toString());
    }

    static void alterAddColumn(Dialect dialect, String tableName, String columnName, ColumnType columnType) {
        String sqlString = "ALTER TABLE " + dialect.quoteKey(tableName) + " ADD " + dialect.quoteKey(columnName) + "" + dialect.obtainSQLTypeString(columnType);
        Database.getSession().executeUpdate(sqlString, null);
    }

    static void alterModifyColumn(Dialect dialect, String tableName, String columnName, ColumnType columnType, String renameFrom) {
        String sqlString = Judgment.nullOrBlank(renameFrom) ? "ALTER TABLE " + dialect.quoteKey(tableName) + " MODIFY " + dialect.quoteKey(columnName) + "" + dialect.obtainSQLTypeString(columnType) : dialect.renameColumnSql().replaceAll(":tableName", dialect.quoteKey(tableName)).replaceAll(":oldColumnName", dialect.quoteKey(renameFrom)).replaceAll(":newColumnName", dialect.quoteKey(columnName)) + " " + dialect.obtainSQLTypeString(columnType);
        Database.getSession().executeUpdate(sqlString, null);
    }

    static void createBaseTable(Dialect dialect, String tableName, Class<?> beanClass) {
        String prefix = "\r\nCREATE TABLE " + dialect.quoteKey(tableName) + " (\r\n";
        String suffix = "\r\n)\r\n";
        StringBuilder content = new StringBuilder();
        SysColumns.forEach((sysColumn, ct) -> content.append("\t\t").append(dialect.quoteKey((String)sysColumn)).append(dialect.obtainSQLTypeString((ColumnType)ct)).append(sysColumn.equals("id") ? " NOT NULL PRIMARY KEY,\r\n" : " NULL,\r\n"));
        RsqlUtils.obtainColumnType(beanClass, null, FieldType.TBase).forEach((baseColumn, ct) -> content.append("\t\t").append(dialect.quoteKey((String)baseColumn)).append(dialect.obtainSQLTypeString((ColumnType)ct)).append(" NULL,\r\n"));
        RsqlUtils.obtainColumnType(beanClass, null, FieldType.TObject).forEach((objectColumn, ct) -> content.append("\t\t").append(dialect.quoteKey((String)objectColumn)).append(dialect.obtainSQLTypeString((ColumnType)ct)).append(" NULL,\r\n"));
        String mid = content.toString().substring(0, content.length() - 3);
        Database.getSession().executeUpdate(prefix + mid + suffix, null);
    }

    static void createCollectionTable(Dialect dialect, String beanName, String fieldName, Type fieldType) {
        Type[] types = ReflectUtil.getActualTypeArguments(fieldType);
        Map<String, ColumnType> columns = RsqlUtils.obtainListColumnFKColumnType(beanName, fieldName, fieldType);
        String tableName = RsqlUtils.obtainListColumnFKTableName(dialect, beanName, fieldName);
        String prefix = "CREATE TABLE " + dialect.quoteKey(tableName);
        String suffix = "\r\n)\r\n";
        StringBuilder content = new StringBuilder("(\n");
        for (Type type1 : types) {
            if (SqlType.isTCollection(type1)) {
                throw new RsqlConnectionException(beanName, "\u4e0d\u652f\u6301\u6df1\u5c42Collection\u6620\u5c04\uff0c\u6570\u636e\u5e93ORM\u6620\u5c04\u521b\u5efa\u5931\u8d25\uff01");
            }
            if (type1 != Object.class) continue;
            throw new RsqlConnectionException(beanName, "\u4e0d\u652f\u6301Object \u539f\u59cb\u7c7b\u578b\u76f4\u63a5Map\u6620\u5c04\uff0c\u6570\u636e\u5e93ORM\u6620\u5c04\u521b\u5efa\u5931\u8d25\uff01");
        }
        content.append("\t\t").append(dialect.quoteKey("id")).append(" ").append(dialect.obtainSQLTypeString(new ColumnType(1, 50))).append(" NOT NULL PRIMARY KEY,\r\n");
        for (String objectColumn : columns.keySet()) {
            ColumnType ct = columns.get(objectColumn);
            content.append("\t\t").append(dialect.quoteKey(objectColumn)).append(dialect.obtainSQLTypeString(ct)).append(" NOT NULL,\r\n");
        }
        String mid = content.toString();
        mid = mid.substring(0, mid.length() - 3);
        Database.getSession().executeUpdate(prefix + mid + suffix, null);
    }

    public static String obtainListColumnFKTableName(Dialect dialect, String primaryBeanName, String primaryFieldName) {
        return primaryBeanName + "_" + primaryFieldName;
    }

    public static Map<String, ColumnType> obtainListColumnFKColumnType(String beanName, String fieldName, Type fieldType) {
        Type[] types = (Type[])ReflectUtil.invokeMethod("getActualTypeArguments", (Object)fieldType, new Object[0]);
        TreeMap<String, ColumnType> neededColumns = new TreeMap<String, ColumnType>();
        neededColumns.put("P_" + beanName, new ColumnType(1, 50));
        neededColumns.put("F_" + StringHelper.getClassSimpleName(types[0]), RsqlUtils.obtainSQLType(types[0], null, null));
        return neededColumns;
    }

    static {
        SysCreateColumns = new ReadOnlyMap<String, ColumnType>();
        SysCreateColumns.put("createOperator", new ColumnType(1, 50));
        SysCreateColumns.put("createTime", new ColumnType(1, 50));
        SysCreateColumns.put("ownership", new ColumnType(1, 50));
        SysModifyColumns = new ReadOnlyMap<String, ColumnType>();
        SysModifyColumns.put("modifyOperator", new ColumnType(1, 50));
        SysModifyColumns.put("modifyTime", new ColumnType(1, 50));
        SysColumns = new ReadOnlyMap<String, ColumnType>();
        SysColumns.put("id", new ColumnType(1, 50, 0, false));
        SysColumns.putAll(SysCreateColumns);
        SysColumns.putAll(SysModifyColumns);
        SqlTypes = new ReadOnlyMap<Type, ColumnType>();
        SqlTypes.put(Short.TYPE, new ColumnType(4, 22, 0));
        SqlTypes.put((Type)((Object)Short.class), new ColumnType(4, 22, 0));
        SqlTypes.put(Integer.TYPE, new ColumnType(4, 22, 0));
        SqlTypes.put((Type)((Object)Integer.class), new ColumnType(4, 22, 0));
        SqlTypes.put(Long.TYPE, new ColumnType(2, 22, 0));
        SqlTypes.put((Type)((Object)Long.class), new ColumnType(2, 22, 0));
        SqlTypes.put(Double.TYPE, new ColumnType(8, 22, 2));
        SqlTypes.put((Type)((Object)Double.class), new ColumnType(8, 22, 2));
        SqlTypes.put(Float.TYPE, new ColumnType(6, 22, 2));
        SqlTypes.put((Type)((Object)Float.class), new ColumnType(6, 22, 2));
        SqlTypes.put(Boolean.TYPE, new ColumnType(16, 5));
        SqlTypes.put((Type)((Object)Boolean.class), new ColumnType(16, 5));
        SqlTypes.put(Byte.TYPE, new ColumnType(-7, 0));
        SqlTypes.put((Type)((Object)Byte.class), new ColumnType(-7, 0));
        SqlTypes.put(Character.TYPE, new ColumnType(1, 0));
        SqlTypes.put((Type)((Object)Character.class), new ColumnType(1, 0));
        SqlTypes.put((Type)((Object)String.class), new ColumnType(1, 100));
        SqlTypes.put((Type)((Object)Date.class), new ColumnType(1, 100));
        SqlTypes.put((Type)((Object)Enum.class), new ColumnType(1, 100));
    }
}

