/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql;

import cn.remex.core.CoreSvo;
import cn.remex.core.RemexApplication;
import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.exception.RsqlExecuteException;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.RsqlRvo;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.sql.NamedParam;
import cn.remex.db.sql.Select;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;

public class RsqlExecutor {
    private static RsqlExecutor rsqlExecutor;

    public static RsqlExecutor getDefaultSqlExecutor() {
        if (null == rsqlExecutor) {
            rsqlExecutor = RemexApplication.getBean(RsqlExecutor.class, "singleton");
        }
        return rsqlExecutor;
    }

    public <T extends Modelable> DbRvo<T> execute(DbCvo<T> dbCvo) {
        RsqlRvo<T> rsqlRvo = RsqlRvo.create(dbCvo);
        Connection con = null;
        PreparedStatement pstmt = null;
        con = RDBManager.getLocalConnection(dbCvo._getSpaceName());
        List<NamedParam> sqlNamedParams = dbCvo._getNamedParams();
        String sqlString = dbCvo._getSqlString();
        rsqlRvo.appendMsg("In table [ ").append(dbCvo.getBeanName()).append(" ]");
        try {
            pstmt = con.prepareStatement(sqlString);
            for (NamedParam sqlNamedParam : sqlNamedParams) {
                if (-1 == sqlNamedParam.getIndex()) continue;
                pstmt.setObject(sqlNamedParam.getIndex(), sqlNamedParam.getValue(), sqlNamedParam.getType());
            }
            long time = System.currentTimeMillis();
            pstmt.execute();
            rsqlRvo.appendMsg("Execute took:[").append(System.currentTimeMillis() - time).append("ms]");
            pstmt.clearParameters();
            pstmt.close();
            rsqlRvo.setMsg(true, "\u6570\u636e\u5e93\u64cd\u4f5c[execute]\u6570\u636e\u5e93\u64cd\u4f5c\u6210\u529f\uff01");
            rsqlRvo.setStatus(true);
            RDBManager.freeLocalConnection(dbCvo._getSpaceName(), con);
        }
        catch (SQLException e) {
            StringBuilder msg = new StringBuilder("\u6570\u636e\u5e93\u6267\u884cSql\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a\n");
            try {
                pstmt.close();
                msg.append("\u5f02\u5e38\u540e\u5904\u7406PreparedStatement.close()\u5df2\u5b8c\u6210\u3002");
            }
            catch (Exception e1) {
                msg.append("\u5f02\u5e38\u540e\u5904\u7406PreparedStatement.close()\u4e5f\u53d1\u751f\u5f02\u5e38\u3002");
            }
            throw new RsqlExecuteException("RSQL_SQL_ERROR", "RsqlExecutor execute \u9047\u5230\u6570\u636e\u5e93SQL\u5f02\u5e38", e);
        }
        finally {
            dbCvo.clear();
            if (!RDBManager.isTransaction(dbCvo._getSpaceName())) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return rsqlRvo;
    }

    public <T extends Modelable> RsqlRvo<T> executeQuery(DbCvo<T> dbCvo) {
        RsqlRvo<T> rsqlRvo = RsqlRvo.create(dbCvo);
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        con = RDBManager.getLocalConnection(dbCvo._getSpaceName());
        String sqlString = dbCvo._getSqlString();
        List<NamedParam> sqlNamedParams = dbCvo._getNamedParams();
        Dialect dialect = RDBManager.getLocalSpaceConfig(dbCvo._getSpaceName()).getDialect();
        rsqlRvo.appendMsg("In table [ ").append(dbCvo.getBeanName()).append(" ]");
        try {
            String orgSqlString = sqlString = sqlString + " " + Select.obtainSQLOrder(dbCvo);
            int pagination = dbCvo.getPagination();
            int rowCount = dbCvo.getRowCount();
            long time = System.currentTimeMillis();
            if (dbCvo.isDoPaging()) {
                int startId = rowCount * (pagination - 1);
                int endId = rowCount + startId;
                sqlString = dialect.obtainPagingSQL(sqlString, startId, endId, rowCount);
            }
            pstmt = con.prepareStatement(dialect.prepareSqlForCount(sqlString));
            for (NamedParam sqlNamedParam : sqlNamedParams) {
                if (-1 == sqlNamedParam.getIndex()) continue;
                pstmt.setObject(sqlNamedParam.getIndex(), sqlNamedParam.getValue(), sqlNamedParam.getType());
            }
            rs = pstmt.executeQuery();
            rsqlRvo.appendMsg("doQuery took:[").append(System.currentTimeMillis() - time).append("ms];");
            time = System.currentTimeMillis();
            rsqlRvo.saveData(rs, dbCvo);
            rs.close();
            pstmt.clearParameters();
            pstmt.close();
            int recordCount = dbCvo.getRecordCount();
            if (dbCvo.isDoCount()) {
                if (recordCount == 0 || pagination == 1 || pagination * rowCount > recordCount) {
                    time = System.currentTimeMillis();
                    pstmt = con.prepareStatement(dialect.obtainCountSql(orgSqlString));
                    if (dialect.needSetParamForCount()) {
                        for (NamedParam sqlNamedParam : sqlNamedParams) {
                            if (-1 == sqlNamedParam.getIndex()) continue;
                            pstmt.setObject(sqlNamedParam.getIndex(), sqlNamedParam.getValue(), sqlNamedParam.getType());
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        rsqlRvo.setRecordCount(rs.getInt(1));
                    } else {
                        rsqlRvo.setRecordCount(0);
                    }
                    rs.close();
                    pstmt.clearParameters();
                    pstmt.close();
                    rsqlRvo.appendMsg("doCount took:[").append(System.currentTimeMillis() - time).append("ms];");
                } else {
                    rsqlRvo.setRecordCount(recordCount);
                    rsqlRvo.appendMsg("useCount ").append(recordCount).append(" ;");
                }
            }
            rsqlRvo.appendMsg("Read Data Records [").append(rsqlRvo.getRows() != null ? rsqlRvo.getRows().size() : 0).append("], took:[").append(System.currentTimeMillis() - time).append("ms];");
            rsqlRvo.setMsg(true, "\u6570\u636e\u5e93\u64cd\u4f5c[executeQuery]\u6570\u636e\u5e93\u64cd\u4f5c\u6210\u529f\uff01");
            rsqlRvo.setStatus(true);
            RDBManager.freeLocalConnection(dbCvo._getSpaceName(), con);
        }
        catch (SQLException e) {
            StringBuilder msg = new StringBuilder("\u6570\u636e\u5e93\u6267\u884cSql\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a");
            try {
                if (rs != null) {
                    rs.close();
                    msg.append("\u5f02\u5e38\u540e\u5904\u7406ResultSet.close()\u5df2\u5b8c\u6210\u3002");
                }
            }
            catch (Exception e1) {
                msg.append("\u5f02\u5e38\u540e\u5904\u7406ResultSet.close()\u4e5f\u53d1\u751f\u5f02\u5e38\u3002");
            }
            try {
                pstmt.close();
                msg.append("\u5f02\u5e38\u540e\u5904\u7406PreparedStatement.close()\u5df2\u5b8c\u6210\u3002");
            }
            catch (Exception e1) {
                msg.append("\u5f02\u5e38\u540e\u5904\u7406PreparedStatement.close()\u4e5f\u53d1\u751f\u5f02\u5e38\u3002");
            }
            rsqlRvo.setMsg(false, "\u6570\u636e\u5e93\u64cd\u4f5c[executeQuery]\u51fa\u73b0\u5f02\u5e38:" + e.toString());
            throw new RsqlExecuteException("RSQL_QUERY_ERROR", "RsqlExecutor executeQuery \u9047\u5230\u6570\u636e\u5e93SQL\u5f02\u5e38", e);
        }
        finally {
            dbCvo.clear();
            if (!RDBManager.isTransaction(dbCvo._getSpaceName())) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return rsqlRvo;
    }

    public <T extends Modelable> RsqlRvo<T> executeUpdate(DbCvo<T> dbCvo) {
        RsqlRvo<T> rsqlRvo = RsqlRvo.create(dbCvo);
        Connection con = null;
        PreparedStatement pstmt = null;
        String id = dbCvo.getId();
        String sqlString = dbCvo._getSqlString();
        List<NamedParam> sqlNamedParams = dbCvo._getNamedParams();
        rsqlRvo.appendMsg("In table [ ").append(dbCvo.getBeanName()).append(" ]");
        boolean useBatch = RDBManager.isUseBatchUpdate(dbCvo._getSpaceName());
        HashMap batchPstmtMap = (HashMap)CoreSvo.valLocal(dbCvo._getSpaceName() + "#BacthPerpareStatement");
        try {
            if (useBatch && null == (pstmt = (PreparedStatement)batchPstmtMap.get(sqlString.hashCode()))) {
                con = RDBManager.getLocalConnection(dbCvo._getSpaceName());
                pstmt = con.prepareStatement(sqlString);
                batchPstmtMap.put(sqlString.hashCode(), pstmt);
            } else if (!useBatch) {
                con = RDBManager.getLocalConnection(dbCvo._getSpaceName());
                pstmt = con.prepareStatement(sqlString);
            }
            for (NamedParam sqlNamedParam : sqlNamedParams) {
                int t = sqlNamedParam.getType();
                if (-1 == sqlNamedParam.getIndex()) continue;
                if (t == 2000) {
                    if (null == sqlNamedParam.getValue()) {
                        pstmt.setBytes(sqlNamedParam.getIndex(), null);
                        continue;
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(sqlNamedParam.getValue());
                    bos.toByteArray();
                    pstmt.setBytes(sqlNamedParam.getIndex(), bos.toByteArray());
                    oos.close();
                    bos.close();
                    continue;
                }
                pstmt.setObject(sqlNamedParam.getIndex(), sqlNamedParam.getValue(), sqlNamedParam.getType() == 16 ? 12 : sqlNamedParam.getType());
            }
            long time = System.currentTimeMillis();
            if (useBatch) {
                pstmt.addBatch();
                Object countObj = CoreSvo.valLocal(dbCvo._getSpaceName() + "#BacthPerpareStatement#" + sqlString.hashCode() + "#batchCount");
                int count = countObj == null ? 0 : (Integer)countObj;
                CoreSvo.putLocal(dbCvo._getSpaceName() + "#BacthPerpareStatement#" + sqlString.hashCode() + "#batchCount", ++count);
                int[] ris = null;
                if (count > 1000) {
                    if (RsqlConstants.isDebug) {
                        RsqlConstants.logger.debug((Object)("\u6b63\u6267\u884cexecuteBatch\uff0csqlHashCode=" + sqlString.hashCode() + ";batchSize=" + count));
                    }
                    ris = pstmt.executeBatch();
                    con = RDBManager.getLocalConnection(dbCvo._getSpaceName());
                    con.commit();
                    pstmt.clearBatch();
                    CoreSvo.putLocal(dbCvo._getSpaceName() + "#BacthPerpareStatement#" + sqlString.hashCode() + "#batchCount", 0);
                }
                rsqlRvo.setMsg(true, "\u6570\u636e\u5e93 [\u6279\u91cf\u6570\u636e\u5e93\u64cd\u4f5c,count=" + count + "] \u64cd\u4f5c[executeUpdate " + sqlString.substring(0, 5) + "]\u6210\u529f! EffectRowCount is " + ris);
            } else {
                int ri = pstmt.executeUpdate();
                rsqlRvo.appendMsg("Execute took:[").append(System.currentTimeMillis() - time).append("ms];");
                pstmt.clearParameters();
                pstmt.close();
                rsqlRvo.setEffectRowCount(ri);
                rsqlRvo.setMsg(true, "\u6570\u636e\u5e93\u64cd\u4f5c[executeUpdate " + sqlString.substring(0, 5) + "]\u6210\u529f! EffectRowCount is " + ri);
            }
            rsqlRvo.setId(id);
            rsqlRvo.setStatus(true);
            if (!useBatch) {
                RDBManager.freeLocalConnection(dbCvo._getSpaceName(), con);
            }
        }
        catch (SQLException e) {
            StringBuilder msg = new StringBuilder("\u6570\u636e\u5e93\u6267\u884cSql\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a\n");
            if (!useBatch && null != pstmt) {
                try {
                    pstmt.close();
                    msg.append("\u5f02\u5e38\u540e\u5904\u7406PreparedStatement.close()\u5df2\u5b8c\u6210\u3002");
                }
                catch (Exception e1) {
                    msg.append("\u5f02\u5e38\u540e\u5904\u7406PreparedStatement.close()\u4e5f\u53d1\u751f\u5f02\u5e38\u3002");
                }
            }
            rsqlRvo.setMsg(false, "\u6570\u636e\u5e93\u64cd\u4f5c[executeQuery]\u51fa\u73b0\u5f02\u5e38:" + e.toString());
            throw new RsqlExecuteException("RSQL_EXECUTE_ERROR", "RsqlExecutor executeUpdate \u9047\u5230\u6570\u636e\u5e93SQL\u5f02\u5e38", e);
        }
        catch (IOException e) {
            rsqlRvo.setMsg(false, "\u6570\u636e\u5e93\u64cd\u4f5c[executeUpdate]\u51fa\u73b0\u5f02\u5e38:" + e.toString());
            throw new RsqlExecuteException("RSQL_DATA_ERROR", "RsqlExecutor executeUpdate \u9047\u5230\u6570\u636eIO\u5f02\u5e38", e);
        }
        finally {
            dbCvo.clear();
            if (!RDBManager.isTransaction(dbCvo._getSpaceName())) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return rsqlRvo;
    }

    public RsqlRvo createCall(String sqlString, String spaceName) {
        Connection con = RDBManager.getLocalConnection(spaceName);
        RsqlRvo rsqlRvo = RsqlRvo.create(null);
        try {
            Statement cstmt = con.createStatement();
            long time = System.currentTimeMillis();
            cstmt.executeUpdate(sqlString);
            cstmt.close();
            RDBManager.freeLocalConnection(spaceName, con);
            rsqlRvo.appendMsg("Execute took:[").append(System.currentTimeMillis() - time).append("ms]");
        }
        catch (SQLException e2) {
            throw new RsqlExecuteException("RSQL_CREATECALL_ERROR", e2.toString());
        }
        return rsqlRvo;
    }
}

