/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.db.Container;
import cn.remex.db.Database;
import cn.remex.db.DbRvo;
import cn.remex.db.exception.RsqlException;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.RsqlUtils;
import cn.remex.db.rsql.connection.RDBSpaceConfig;
import cn.remex.db.rsql.connection.dialect.Dialect;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.rsql.transactional.RsqlDefine;
import cn.remex.db.sql.ColumnType;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.SqlType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

public final class RsqlDefiner
extends Database
implements RsqlConstants {
    private static void renameTable(Dialect dialect, String oldTableName, String newTableName) {
        String sql = dialect.renameTableSql();
        Database.getSession().executeUpdate(sql.replaceAll(":oldTableName", dialect.quoteKey(oldTableName)).replaceAll(":newTableName", dialect.quoteKey(newTableName)), null);
    }

    private static void modifyColumn(String tableName, DbRvo columnNames, ColumnType ct, String columnName, Dialect dialect, String oldColumnName) {
        boolean notRename;
        List<Object> cns = columnNames.getCells(0, columnName, 0);
        String newColumnName = columnName;
        boolean bl = notRename = cns.size() == 1 || cns.size() == 0 && columnNames.getCells(0, oldColumnName, 0).size() == 0;
        if (cns.size() == 0 && notRename) {
            RsqlUtils.alterAddColumn(dialect, tableName, columnName, ct);
            logger.info((Object)("\u73b0\u5df2\u5b8c\u6210\u4e3a\u540d\u4e3a" + tableName + "\u7684\u8868\u6dfb\u52a0\u5217" + columnName));
        } else {
            boolean flag;
            oldColumnName = notRename ? columnName : oldColumnName;
            String type = columnNames.getCells(0, oldColumnName, "DATA_TYPE").get(0).toString();
            Object length = columnNames.getCells(0, oldColumnName, "DATA_LENGTH").get(0);
            Object precision = columnNames.getCells(0, oldColumnName, "DATA_PRECISION").get(0);
            Object scale = columnNames.getCells(0, oldColumnName, "DATA_SCALE").get(0);
            String nullable = columnNames.getCells(0, oldColumnName, "NULLABLE").get(0).toString();
            String sqlTypeStr = dialect.obtainSQLTypeString(ct).trim();
            if (notRename && ct.type == 2005) {
                return;
            }
            boolean needSetNullable = nullable.startsWith("Y") != ct.nullable;
            boolean bl2 = flag = !needSetNullable && notRename;
            if (flag && type.equalsIgnoreCase("INT") && sqlTypeStr.toUpperCase().startsWith("INTEGER")) {
                logger.info((Object)"Types.INT \u5bf9\u5e94\u4e3a INTEGER\uff0c\u65e0\u9700\u91cd\u6784\u7c7b\u578b!");
            } else if (flag && ct.type == 16 && type.equalsIgnoreCase("VARCHAR") && String.valueOf(length).equals("5")) {
                logger.info((Object)"Types.BOOLEAN \u5bf9\u5e94\u4e3a VARCHAR(5)\uff0c\u65e0\u9700\u91cd\u6784\u7c7b\u578b!");
            } else if (flag && ct.type == 8 && type.equalsIgnoreCase("DOUBLE") && String.valueOf(ct.length).equalsIgnoreCase(String.valueOf(precision)) && String.valueOf(2).equalsIgnoreCase(String.valueOf(scale))) {
                logger.info((Object)("Types.DOUBLE \u5bf9\u5e94\u4e3a DOUBLE(" + precision + "," + scale + ")\uff0c\u65e0\u9700\u91cd\u6784\u7c7b\u578b!,\u9ed8\u8ba4\u4e3a2\u4f4d"));
            } else if (flag && ct.type == 2 && (type.equalsIgnoreCase("NUMERIC") || type.equalsIgnoreCase("DECIMAL")) && String.valueOf(ct.length).equalsIgnoreCase(String.valueOf(precision)) && String.valueOf(ct.scale).equalsIgnoreCase(String.valueOf(scale))) {
                logger.info((Object)("Types.NUMERIC \u5bf9\u5e94\u4e3a " + type.toUpperCase() + "(" + precision + "," + scale + ")\uff0c\u65e0\u9700\u91cd\u6784\u7c7b\u578b!,\u9ed8\u8ba4\u4e3a0\u4f4d"));
            } else if (!(flag && sqlTypeStr.split("[ \t(]")[0].equalsIgnoreCase(type) && String.valueOf(ct.length).equalsIgnoreCase(String.valueOf(length)))) {
                logger.info((Object)("\u4fee\u6539\u8868 " + tableName + " \u5217" + newColumnName + " from " + oldColumnName + ":" + type + "(" + length + ") NULLABLE=" + nullable + " ->" + dialect.obtainSQLTypeString(ct)));
                RsqlUtils.alterModifyColumn(dialect, tableName, newColumnName, ct, oldColumnName);
                logger.info((Object)("\u5b8c\u6210\u4fee\u6539\u8868 " + tableName + " \u5217" + newColumnName + " from " + oldColumnName + ":" + type + "(" + length + ") NULLABLE=" + nullable + " ->" + dialect.obtainSQLTypeString(ct)));
            }
        }
    }

    public static void refreshORMBaseTables(RDBSpaceConfig spaceConfig) {
        Map<String, Class<?>> ormBeans = spaceConfig.getOrmBeans();
        Dialect dialect = spaceConfig.getDialect();
        logger.debug((Object)"\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u25e2RemexDB\u7684ORM\u7ec4\u4ef6\u6b63\u5728\u68c0\u67e5\u6570\u636e\u5e93\u4e2d\u7684 \u57fa\u672c\u8868BaseTables\u25e3\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584");
        Container session = Database.getSession();
        DbRvo tableNames = session.executeQuery(dialect.obtainSQLSelectTableNames(), null);
        for (String beanName : ormBeans.keySet()) {
            RsqlDefiner.refreshThisBaseTable(dialect, ormBeans, beanName, tableNames, spaceConfig.getSpaceName());
        }
        logger.debug((Object)"\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584END\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584");
    }

    private static void refreshThisBaseTable(Dialect dialect, Map<String, Class<?>> ormBeans, String beanName, DbRvo tableNames, String spaceName) {
        String tableName = dialect.needLowCaseTableName() ? beanName.toLowerCase() : beanName;
        RsqlDefine rsqlDefine = ormBeans.get(beanName).getAnnotation(RsqlDefine.class);
        if (!Judgment.nullOrBlank(rsqlDefine) && !Judgment.nullOrBlank(rsqlDefine.renameFrom()) && tableNames.getCells(0, rsqlDefine.renameFrom(), 0).size() == 1) {
            RsqlDefiner.renameTable(dialect, rsqlDefine.renameFrom(), tableName);
            logger.info((Object)("\u4fee\u6539\u8868\u540dfrom " + rsqlDefine.renameFrom() + " to " + tableName + "\u5b8c\u6210\uff01"));
            RsqlDefiner.modifyBaseTables(tableName, ormBeans.get(beanName), dialect, spaceName);
        } else if (tableNames.getCells(0, tableName, 0).size() != 1) {
            RsqlUtils.createBaseTable(dialect, tableName, ormBeans.get(beanName));
            logger.info((Object)("\u521b\u5efa\u540d\u4e3a" + tableName + "\u7684\u8868\u5b8c\u6210\uff01"));
        } else {
            RsqlDefiner.modifyBaseTables(tableName, ormBeans.get(beanName), dialect, spaceName);
        }
    }

    private static void modifyBaseTables(String tableName, Class<?> beanClass, Dialect dialect, String spaceName) {
        logger.debug((Object)("\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u540d\u4e3a" + tableName + "\u7684\u8868\uff01\u8df3\u8fc7\u521b\u5efa\u9636\u6bb5\uff0c\u8fdb\u884c\u8868\u7ed3\u6784\u68c0\u67e5\uff01"));
        ArrayList<Map<String, ColumnType>> columnsList = new ArrayList<Map<String, ColumnType>>();
        Map<String, ColumnType> sysColumns = RsqlUtils.obtainColumnTypeOfSysColumn();
        columnsList.add(sysColumns);
        Map<String, ColumnType> baseColumns = RsqlUtils.obtainColumnType(beanClass, null, FieldType.TBase);
        columnsList.add(baseColumns);
        Map<String, ColumnType> objectColumns = RsqlUtils.obtainColumnType(beanClass, null, FieldType.TObject);
        columnsList.add(objectColumns);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", tableName);
        DbRvo columnNames = Database.getSession(spaceName).executeQuery(dialect.obtainSQLSelectTablesColumnNames(tableName), params);
        for (Map map : columnsList) {
            for (String columnName : map.keySet()) {
                RsqlDefine rsqlDefine = ReflectUtil.getAnnotation(beanClass, columnName, RsqlDefine.class);
                String oldColumnName = rsqlDefine == null || Judgment.nullOrBlank(rsqlDefine.renameFrom()) ? columnName : rsqlDefine.renameFrom();
                RsqlDefiner.modifyColumn(tableName, columnNames, (ColumnType)map.get(columnName), columnName, dialect, oldColumnName);
            }
        }
    }

    public static void refreshORMCollectionTables(RDBSpaceConfig spaceConfig) {
        Map<String, Class<?>> ormBeans = spaceConfig.getOrmBeans();
        Dialect dialect = spaceConfig.getDialect();
        logger.debug((Object)"\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u25e2RemexDB\u7684ORM\u7ec4\u4ef6\u6b63\u5728\u68c0\u67e5\u6570\u636e\u5e93\u4e2d\u7684\u5916\u952e\u8868CollectionTables\u25e3\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584");
        Container session = Database.getSession();
        DbRvo tableNames = session.executeQuery(dialect.obtainSQLSelectTableNames(), null);
        for (String beanName : ormBeans.keySet()) {
            Class<?> beanClass = ormBeans.get(beanName);
            Map<String, Type> fields = SqlType.getFields(beanClass, FieldType.TCollection);
            for (String fieldName : fields.keySet()) {
                String oldTableName;
                String tableName = RsqlUtils.obtainListColumnFKTableName(dialect, beanName, fieldName);
                tableName = dialect.needLowCaseTableName() ? tableName.toLowerCase() : tableName;
                Type field = fields.get(fieldName);
                RsqlDefine curBeanRsqlDefine = ReflectUtil.getAnnotation(beanClass, RsqlDefine.class);
                RsqlDefine curFieldrsqlDefine = ReflectUtil.getAnnotation(beanClass, fieldName, RsqlDefine.class);
                String string = !(!Judgment.nullOrBlank(curBeanRsqlDefine) && !Judgment.nullOrBlank(curBeanRsqlDefine.renameFrom()) || !Judgment.nullOrBlank(curFieldrsqlDefine) && !Judgment.nullOrBlank(curFieldrsqlDefine.renameFrom())) ? tableName : (oldTableName = RsqlUtils.obtainListColumnFKTableName(dialect, Judgment.nullOrBlank(curBeanRsqlDefine) || Judgment.nullOrBlank(curBeanRsqlDefine.renameFrom()) ? beanName : curBeanRsqlDefine.renameFrom(), Judgment.nullOrBlank(curFieldrsqlDefine) || Judgment.nullOrBlank(curFieldrsqlDefine.renameFrom()) ? fieldName : curFieldrsqlDefine.renameFrom()));
                if (tableNames.getCells(0, tableName, 0).size() != 1 && tableNames.getCells(0, oldTableName, 0).size() != 1) {
                    boolean isweihufang;
                    Map<String, Type> fbFields;
                    Class<?> targetClass = ReflectUtil.getListActualType(field);
                    OneToMany otm = ReflectUtil.getAnnotation(beanClass, fieldName, OneToMany.class);
                    if (otm != null) {
                        String mappedField;
                        fbFields = SqlType.getFields(targetClass, FieldType.TObject);
                        if (!fbFields.containsKey(mappedField = otm.mappedBy())) {
                            throw new RsqlException("RSQL_INIT_ERROR", "OneToMany\u6620\u5c04\u9519\u8bef\uff0c\u5728\u591a\u65b9[ " + targetClass.toString() + " ]\u672a\u8bbe\u7f6e\u5916\u952e[ " + mappedField + " ]\u7ef4\u62a4\u5173\u7cfb\u3002\u53ef\u80fd\u662fgetter/setter\u7684\u540d\u79f0\u8bbe\u7f6e\u6709\u8bef\uff01");
                        }
                        if (fbFields.get(mappedField).equals(beanClass)) continue;
                        throw new RsqlException("RSQL_INIT_ERROR", "OneToMany\u6620\u5c04\u9519\u8bef\uff0c\u5728\u591a\u65b9\u8bbe\u7f6e\u7684\u5c5e\u6027[ " + mappedField + " ]\u7c7b\u578b\u6709\u8bef\uff0c\u5e94\u8be5\u4e3a\uff1a" + beanClass);
                    }
                    fbFields = SqlType.getFields(beanClass, FieldType.TCollection);
                    ManyToMany mtm = ReflectUtil.getAnnotation(beanClass, fieldName, ManyToMany.class);
                    if (null != mtm) {
                        String string2 = mtm.mappedBy();
                        Class<?> fbBeanClass = ReflectUtil.getListActualType(fbFields.get(fieldName));
                        Class te = mtm.targetEntity();
                        isweihufang = fbBeanClass.equals(te);
                        ManyToMany fk_mtm = ReflectUtil.getAnnotation(targetClass, string2, ManyToMany.class);
                        if (fk_mtm != null) {
                            Assert.isTrue(fieldName.equals(fk_mtm.mappedBy()), "ERROR", "\u591a\u5bf9\u591a\u5916\u952e\u5bf9\u8c61\u7684\u5c5e\u6027\u7684ManyToMany\u6ce8\u89e3\u7684mappedBy" + fk_mtm.mappedBy() + "\u5fc5\u987b\u4e0e\u5f53\u524d\u6a21\u578b\u7684list\u5c5e\u6027\u540d" + fieldName + "\u4e00\u81f4");
                            Assert.isTrue(Void.TYPE.equals(te) && fk_mtm.targetEntity().equals(beanClass) || Void.TYPE.equals(fk_mtm.targetEntity()) && te.equals(fbBeanClass), "FAIL", "\u5728\u591a\u5bf9\u591a\u5173\u7cfb\u4e2d\uff0ctargetEntity\u53ea\u80fd\u7531\u7ef4\u62a4\u65b9\u6307\u5b9a\uff0c\u6307\u5b9a\u7684\u503c\u4e3a\u5916\u952e\u5bf9\u8c61\u7684\u7c7b\u578b:targetEntity=" + te + ";beanClass=" + beanClass + ";fbBeanClass=" + fbBeanClass);
                        }
                    } else {
                        isweihufang = true;
                    }
                    if (!isweihufang) continue;
                    RsqlUtils.createCollectionTable(dialect, beanName, fieldName, field);
                    logger.info((Object)("\u521b\u5efa\u540d\u4e3a" + tableName + "\u7684\u8868\u5b8c\u6210\uff01 "));
                    continue;
                }
                logger.debug((Object)("\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u540d\u4e3a" + tableName + " / " + oldTableName + "\u7684\u8868\uff01\u8df3\u8fc7\u521b\u5efa\u9636\u6bb5\uff0c\u8fdb\u884c\u8868\u7ed3\u6784\u68c0\u67e5\uff01"));
                if (tableNames.getCells(0, tableName, 0).size() == 0 && tableNames.getCells(0, oldTableName, 0).size() == 1 && !tableName.equals(oldTableName)) {
                    RsqlDefiner.renameTable(dialect, oldTableName, tableName);
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("tableName", tableName);
                DbRvo columnNames = session.executeQuery(dialect.obtainSQLSelectTablesColumnNames(tableName), params);
                ArrayList<Map<String, ColumnType>> columnsList = new ArrayList<Map<String, ColumnType>>();
                Map<String, ColumnType> sysColumns = RsqlUtils.obtainColumnTypeOfSysColumn();
                columnsList.add(sysColumns);
                Map<String, ColumnType> neededColumns = RsqlUtils.obtainListColumnFKColumnType(beanName, fieldName, field);
                columnsList.add(neededColumns);
                for (Map map : columnsList) {
                    for (String columnName : map.keySet()) {
                        String fieldOldColumnName;
                        Class<?> fieldClass = columnName.startsWith("P_") ? beanClass : ReflectUtil.getListActualType(field);
                        RsqlDefine filedRsqlDefine = ReflectUtil.getAnnotation(fieldClass, RsqlDefine.class);
                        boolean notRename = filedRsqlDefine == null || Judgment.nullOrBlank(filedRsqlDefine.renameFrom());
                        String string3 = fieldOldColumnName = notRename ? columnName : filedRsqlDefine.renameFrom();
                        fieldOldColumnName = columnName.startsWith("P_") || columnName.startsWith("F_") ? (notRename ? columnName : columnName.split("_")[0] + "_" + fieldOldColumnName) : columnName;
                        RsqlDefiner.modifyColumn(tableName, columnNames, (ColumnType)map.get(columnName), columnName, dialect, fieldOldColumnName);
                    }
                }
            }
        }
        logger.debug((Object)"\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584END\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584");
    }

    public static void refreshORMConstraints(RDBSpaceConfig spaceConfig) {
        Map<String, Class<?>> ormBeans = spaceConfig.getOrmBeans();
        Dialect dialect = spaceConfig.getDialect();
        logger.debug((Object)"\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u25e2RemexDB\u7684ORM\u7ec4\u4ef6\u6b63\u5728\u68c0\u67e5\u6570\u636e\u5e93\u4e2d\u7684\u7ea6\u675f\u25e3\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584\u2584");
        Container session = Database.getSession();
        for (String beanName : ormBeans.keySet()) {
            DbRvo indexNames = session.executeQuery(dialect.obtainSQLSelectIndexs(beanName), null);
            Class<?> beanClass = ormBeans.get(beanName);
            RsqlUtils.SysColumns.keySet().stream().filter(col -> indexNames.getCells(dialect.obtainSQLIndexNameField(), dialect.obtainIndexName(beanName, (String)col), dialect.obtainSQLIndexNameField()).size() == 0 && !"id".equals(col)).forEach(col -> session.execute(dialect.obtainIndexSql(beanName, dialect.obtainIndexName(beanName, (String)col), (String)col), null));
            SqlType.getFields(beanClass, FieldType.TObject).keySet().stream().filter(col -> indexNames.getCells(dialect.obtainSQLIndexNameField(), dialect.obtainIndexName(beanName, (String)col), dialect.obtainSQLIndexNameField()).size() == 0 && !RsqlUtils.SysColumns.containsKey(col)).forEach(col -> session.execute(dialect.obtainIndexSql(beanName, dialect.obtainIndexName(beanName, (String)col), (String)col), null));
            Class<?> curClass = beanClass;
            HashMap handled = new HashMap();
            while (!ModelableImpl.class.equals(curClass)) {
                Table table_anno = ReflectUtil.getAnnotation(curClass, Table.class);
                if (null != table_anno) {
                    UniqueConstraint[] ucs;
                    Index[] idxs;
                    for (Index idx : idxs = table_anno.indexes()) {
                        String name;
                        if (Judgment.nullOrBlank(idx.columnList())) continue;
                        String[] listCols = idx.columnList().split(";");
                        String string = name = Judgment.nullOrBlank(idx.name()) ? dialect.obtainIndexName(beanName, listCols) : idx.name();
                        if (handled.containsKey("index_" + name) || listCols.length <= 0 || indexNames.getCells(dialect.obtainSQLIndexNameField(), name, dialect.obtainSQLIndexNameField()).size() != 0) continue;
                        logger.debug((Object)("\u4e3a" + beanName + "\u521b\u5efa\u7d22\u5f15\uff1aname=" + name + ";cols=" + listCols));
                        session.execute(dialect.obtainIndexSql(beanName, name, listCols), null);
                        logger.debug((Object)("\u5b8c\u6210\u4e3a" + beanName + "\u521b\u5efa\u7d22\u5f15\uff1aname=" + name + ";cols=" + listCols));
                    }
                    for (UniqueConstraint uc : ucs = table_anno.uniqueConstraints()) {
                        String name;
                        String[] cols = uc.columnNames();
                        String string = name = Judgment.nullOrBlank(uc.name()) ? dialect.obtainIndexName(beanName, cols) : uc.name();
                        if (handled.containsKey("unique_" + name) || cols.length <= 0 || indexNames.getCells(dialect.obtainSQLIndexNameField(), name, dialect.obtainSQLIndexNameField()).size() != 0) continue;
                        logger.debug((Object)("\u4e3a" + beanName + "\u521b\u5efa\u4e3b\u952e\uff1aname=" + name + ";cols=" + cols));
                        session.execute(dialect.obtainConstraintSql(beanName, name, cols), null);
                        logger.debug((Object)("\u5b8c\u6210\u4e3a" + beanName + "\u521b\u5efa\u4e3b\u952e\uff1aname=" + name + ";cols=" + cols));
                    }
                }
                curClass = curClass.getSuperclass();
            }
        }
    }
}

