/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db.rsql;

import cn.remex.contrib.auth.AuthenticateBtx;
import cn.remex.core.CoreSvo;
import cn.remex.core.RemexApplication;
import cn.remex.core.aop.AOPCaller;
import cn.remex.core.aop.AOPFactory;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.StringHelper;
import cn.remex.core.util.date.DateHelper;
import cn.remex.db.Container;
import cn.remex.db.Database;
import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.exception.RsqlExecuteException;
import cn.remex.db.model.cert.AuthUser;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.RsqlExecutor;
import cn.remex.db.rsql.RsqlRvo;
import cn.remex.db.rsql.RsqlUtils;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.rsql.transactional.RsqlTransaction;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.SqlType;
import cn.remex.db.sql.WhereRuleOper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import net.sf.cglib.proxy.MethodProxy;

public class RsqlContainer
implements Container,
RsqlConstants {
    private String spaceName = RDBManager.DEFAULT_SPACE;
    private static AOPFactory DBBeanFactory = new AOPFactory(new AOPCaller(null){
        private static final long serialVersionUID = 865574373191977031L;

        @Override
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Object result = proxy.invokeSuper(obj, args);
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            boolean isSetMethod = args.length == 1 && methodName.startsWith("set");
            boolean isRetCollection = false;
            boolean isRetObject = false;
            if (isSetMethod && (CoreSvo.valLocal(RsqlContainer.StoreObjectFlied) == null || ((Boolean)CoreSvo.valLocal(RsqlContainer.StoreObjectFlied)).booleanValue()) && !"_setDataStatussetId".contains(methodName)) {
                Modelable m = (Modelable)obj;
                m._setDataStatus("needSave");
                if (!Collection.class.isAssignableFrom(returnType) && !Modelable.class.isAssignableFrom(returnType)) {
                    m._addModifyFileds(StringHelper.lowerFirstLetter(methodName.substring(3)));
                }
            }
            return result;
        }
    });
    private static final String FecthObjectFlied = "cn.remex.db.rsql.RsqlContainer.FecthObjectFlied";
    private static final String StoreObjectFlied = "cn.remex.db.rsql.RsqlContainer.StoreObjectFlied";

    @Override
    public boolean isLocalAutoFetchObjectFiled() {
        Object b = CoreSvo.valLocal(FecthObjectFlied);
        return null == b ? true : (Boolean)b;
    }

    @Override
    public boolean isLocalAutoStoreObjectFiled() {
        Object b = CoreSvo.valLocal(StoreObjectFlied);
        return null == b ? true : (Boolean)b;
    }

    @Override
    public void setLocalAutoFecthObjectFiled(boolean b) {
        CoreSvo.putLocal(FecthObjectFlied, b);
    }

    @Override
    public void setLocalAutoStoreObjectFlied(boolean b) {
        CoreSvo.putLocal(StoreObjectFlied, b);
    }

    @Override
    public <T extends Modelable> T createDBBean(Class<T> clazz) {
        Assert.isTrue(RDBManager.getLocalSpaceConfig(this.spaceName).hasOrmBeanClass(clazz), "RSQL_BEANCLASS_ERROR", "\u6570\u636e\u5e93\u64cd\u4f5c\u7684\u7c7b\u578b\u4e0d\u662f\u7ee7\u627f\u4e8emodelable");
        Modelable t = (Modelable)DBBeanFactory.getBean(clazz);
        t._setAopModelBean();
        t._setDataStatus("beanNew");
        return (T)t;
    }

    @Override
    public <T extends Modelable> DbCvo<T> createDbCvo(Class<T> beanClass) {
        DbCvo<T> dbCvo = new DbCvo<T>(this.spaceName, beanClass);
        dbCvo.setContainer(this);
        return dbCvo;
    }

    @Override
    public <T extends Modelable> DbCvo<T> createDbCvo(String sqlString, Map<String, Object> params) {
        DbCvo dbCvo = new DbCvo(this.spaceName, this.obtainManualSql(sqlString), params);
        dbCvo.setContainer(this);
        return dbCvo;
    }

    @Override
    @RsqlTransaction
    public <T extends Modelable> DbRvo<T> store(T obj) {
        DbCvo dbCvo = new DbCvo(this.spaceName, obj.getClass(), RsqlConstants.SqlOper.store);
        return this.store(obj, dbCvo);
    }

    @Override
    @RsqlTransaction
    public <T extends Modelable> DbRvo<T> deleteById(Class<T> clazz, String id) {
        Modelable bean = (Modelable)ReflectUtil.invokeNewInstance(clazz);
        bean.setId(id);
        return this.delete(bean);
    }

    @Override
    @RsqlTransaction
    public <T extends Modelable> DbRvo<T> delete(T o) {
        Class<?> clazz = o.getClass();
        DbCvo dbCvo = new DbCvo(this.spaceName, clazz, RsqlConstants.SqlOper.del);
        dbCvo.setOper(RsqlConstants.SqlOper.del);
        o._setDataStatus(RsqlConstants.DataStatus.removed.toString());
        dbCvo._setSpaceName(this.spaceName);
        dbCvo.setId(o.getId());
        DbRvo<T> dbRvo = this.store(o, dbCvo);
        return dbRvo;
    }

    @Override
    @RsqlTransaction
    public <T extends Modelable> DbRvo<T> store(T obj, DbCvo<T> cvo) {
        Assert.notNull(obj, "RSQL_DATA_ERROR", "\u4e0d\u80fd\u4fdd\u5b58\u7a7a\u5bf9\u8c61");
        Assert.isTrue(Modelable.class.isAssignableFrom(obj.getClass()), "RSQL_BEANCLASS_ERROR", "\u6570\u636e\u5e93\u64cd\u4f5c\u7684\u5bf9\u8c61\u4e0d\u662f\u7ee7\u627f\u4e8emodelable");
        String beanName = StringHelper.getClassSimpleName(obj.getClass());
        Class<? extends Modelable> beanClass = RDBManager.getLocalSpaceConfig(this.spaceName).getOrmBeanClass(beanName);
        String dataStatus = this.getDS(obj);
        if ("saving".equals(dataStatus)) {
            return null;
        }
        this.updateDS(obj, "saving");
        String obj_id = this.getPK(obj, false);
        RsqlConstants.SqlOper oper = this.obtainOper(obj_id, dataStatus, cvo.getOper(), cvo);
        if (obj._isAopModelBean() && !Judgment.nullOrBlank(obj._getModifyFileds())) {
            for (String fieldName : obj._getModifyFileds().split("[,;]")) {
                cvo._getRootColumn().withColumn(fieldName);
            }
        }
        DbCvo dbCvo = new DbCvo(this.spaceName, obj.getClass(), oper, cvo._getRootColumn());
        dbCvo.setId(obj_id);
        dbCvo.setFilter(cvo.getFilter());
        dbCvo.setBean(obj);
        if (!RsqlConstants.SqlOper.del.equals((Object)oper)) {
            dbCvo.putParameters(this.maplizeObject(obj, oper, cvo));
        }
        Map<OneToOne, Modelable> map = null;
        map = this.storeFKBean(beanClass, obj, dbCvo);
        dbCvo._initForRsqlDao();
        RsqlRvo<?> dbRvo = RsqlExecutor.getDefaultSqlExecutor().executeUpdate(dbCvo);
        this.updateOne2One(obj, map);
        if (dbRvo.getStatus() && null != ((DbRvo)dbRvo).getId()) {
            obj_id = ((DbRvo)dbRvo).getId();
            this.updatePK(obj, obj_id);
            this.updateDS(obj, !RsqlConstants.SqlOper.del.equals((Object)oper) ? DS_managed : DS_removed);
        } else {
            this.updateDS(obj, dataStatus);
        }
        this.storeFKList(beanClass, obj, dbCvo, obj_id, beanName, oper);
        return dbRvo;
    }

    @Override
    public <T extends Modelable> DbRvo<T> query(DbCvo<T> dbCvo) {
        dbCvo._initForRsqlDao();
        return RsqlExecutor.getDefaultSqlExecutor().executeQuery(dbCvo);
    }

    @Override
    public <T extends Modelable> DbRvo<T> update(DbCvo<T> dbCvo) {
        dbCvo.setOper(RsqlConstants.SqlOper.edit);
        dbCvo._initForRsqlDao();
        return RsqlExecutor.getDefaultSqlExecutor().executeUpdate(dbCvo);
    }

    @Override
    public <T extends Modelable> DbRvo<T> delete(DbCvo<T> dbCvo) {
        dbCvo.setOper(RsqlConstants.SqlOper.del);
        dbCvo._initForRsqlDao();
        return RsqlExecutor.getDefaultSqlExecutor().executeUpdate(dbCvo);
    }

    @Override
    @RsqlTransaction
    public <T extends Modelable> DbRvo<T> execute(String sql, Map<String, Object> params) {
        DbCvo dbCvo = new DbCvo(this.spaceName, this.obtainManualSql(sql), params);
        dbCvo.setContainer(this);
        dbCvo._setSpaceName(this.spaceName);
        dbCvo._initForRsqlDao();
        return RsqlExecutor.getDefaultSqlExecutor().execute(dbCvo);
    }

    @Override
    public <T extends Modelable> DbRvo<T> executeQuery(String sql, Map<String, Object> params) {
        DbCvo dbCvo = new DbCvo(this.spaceName, this.obtainManualSql(sql), params);
        dbCvo.setContainer(this);
        dbCvo._setSpaceName(this.spaceName);
        dbCvo._initForRsqlDao();
        if (null != params && null != params.get("RMX_beanClass")) {
            dbCvo.setBeanClass((Class)params.get("RMX_beanClass"));
        }
        return RsqlExecutor.getDefaultSqlExecutor().executeQuery(dbCvo);
    }

    @Override
    public <T extends Modelable> DbRvo<T> executeQuery(DbCvo<T> dbCvo) {
        dbCvo._initForRsqlDao();
        return RsqlExecutor.getDefaultSqlExecutor().executeQuery(dbCvo);
    }

    @Override
    @RsqlTransaction
    public <T extends Modelable> DbRvo<T> executeUpdate(String sql, Map<String, Object> params) {
        DbCvo dbCvo = new DbCvo(this.spaceName, this.obtainManualSql(sql), params);
        dbCvo.setContainer(this);
        dbCvo._setSpaceName(this.spaceName);
        dbCvo._initForRsqlDao();
        return RsqlExecutor.getDefaultSqlExecutor().executeUpdate(dbCvo);
    }

    public DbRvo createCall(String callSql) {
        return RsqlExecutor.getDefaultSqlExecutor().createCall(callSql, this.spaceName);
    }

    @Override
    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    @Override
    public Class<? extends Modelable> obtainModelClass(String beanName) {
        return RDBManager.getLocalSpaceConfig(this.spaceName).getOrmBeanClass(beanName);
    }

    @Override
    public <T extends Modelable> boolean exists(T obj, boolean forceCheckFromDB) {
        String dataStatus = obj._getDataStatus();
        return "saving".equals(dataStatus) || null != this.getPK(obj, forceCheckFromDB);
    }

    @Override
    public String getSpaceName() {
        return this.spaceName;
    }

    private <T> void updateOne2One(T obj, Map<OneToOne, ? extends Modelable> map) {
        map.forEach((oto, foreignBean) -> {
            if (oto != null) {
                String tgtFieldName = oto.mappedBy();
                Assert.isTrue(!Judgment.nullOrBlank(tgtFieldName), "ERROR", "OneToOne\u7684mappedBy\u5bf9\u65b9\u5c5e\u6027\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                if (!"saving".equals(foreignBean._getDataStatus())) {
                    ReflectUtil.invokeSetter(tgtFieldName, foreignBean, obj);
                    Database.createDbCvo(foreignBean.getClass(), this.spaceName).withColumn(tgtFieldName).ready().store(foreignBean);
                }
            }
        });
    }

    private <T extends Modelable> boolean needStore(T obj) {
        String id = this.getPK(obj, false);
        String ds = this.getDS(obj);
        return null == id || id.compareTo("-1") <= 0 || RsqlConstants.DataStatus.needSave.equals(ds);
    }

    private String obtainManualSql(String str) {
        return str.startsWith("SQL_") ? ((Map)RemexApplication.getBean("Rsql_SQL")).get(str).toString() : str;
    }

    private <T extends Modelable> RsqlConstants.SqlOper obtainOper(String p_id, Object dataStatus, RsqlConstants.SqlOper sqlOper, DbCvo<T> cvo) {
        boolean idForNew = RsqlUtils.modelIdIsNew(p_id);
        boolean isUpdateByWhere = cvo.isUpdateByWhere();
        if (idForNew && !isUpdateByWhere && ("beanNew".equals(dataStatus) || "needSave".equals(dataStatus) || RsqlConstants.SqlOper.store.equals((Object)sqlOper))) {
            return RsqlConstants.SqlOper.add;
        }
        if (!idForNew && !isUpdateByWhere && ("removed".equals(dataStatus) || RsqlConstants.SqlOper.del.equals((Object)sqlOper))) {
            return RsqlConstants.SqlOper.del;
        }
        if (isUpdateByWhere || !idForNew && ("beanNew".equals(dataStatus) || "managed".equals(dataStatus) || "needSave".equals(dataStatus) || "part".equals(dataStatus) || RsqlConstants.SqlOper.edit.equals((Object)sqlOper))) {
            return RsqlConstants.SqlOper.edit;
        }
        throw new RsqlExecuteException("RSQL_SQL_ERROR", "\u6570\u636e\u72b6\u6001id\u53cadataStatus\u9519\u8bef\uff01(add\uff1aid\u4e3a\u7a7a\u6216\u8005-1 && beanNew\u6216\u8005needSave)\uff1bdel:id\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14removed\uff1bedit:isUpdateByWhere=true/id\u4e0d\u80fd\u4e3a\u7a7a && managed\u6216\u8005needSave");
    }

    private <T extends Modelable> Map<String, Object> maplizeObject(T o, RsqlConstants.SqlOper oper, DbCvo cvo) {
        String un;
        HashMap<String, Object> mapFromObject = new HashMap<String, Object>();
        boolean emptyRootColumn = !cvo._getRootColumn().hasAnyColumn();
        mapFromObject.putAll(cvo.getParameters());
        Map<String, Method> baseGetters = SqlType.getGetters(o.getClass(), FieldType.TBase);
        baseGetters.keySet().stream().filter(fieldName -> emptyRootColumn || cvo._getRootColumn().anyMatchInRoot((String)fieldName)).forEach(fieldName -> {
            if (cvo.getParameters().containsKey(fieldName)) {
                ReflectUtil.invokeSetterWithDefaultTypeCoventer(o, fieldName, cvo.$V((String)fieldName));
            } else {
                Method getter = (Method)baseGetters.get(fieldName);
                Object value = ReflectUtil.invokeMethod(getter, (Object)o, new Object[0]);
                mapFromObject.put((String)fieldName, value);
            }
        });
        String now = DateHelper.getNow(new String[0]);
        AuthUser au = AuthenticateBtx.obtainCurUser();
        String string = un = au == null || Judgment.nullOrBlank(au.getUsername()) ? "NONE" : au.getUsername();
        if (oper == RsqlConstants.SqlOper.add) {
            mapFromObject.put("id", o.getId());
            mapFromObject.put("createTime", now);
            mapFromObject.put("createOperator", un);
            mapFromObject.put("ownership", un);
        }
        mapFromObject.put("modifyTime", now);
        mapFromObject.put("modifyOperator", un);
        return mapFromObject;
    }

    private <T extends Modelable> Map<OneToOne, Modelable> storeFKBean(Class<?> beanClass, T obj, DbCvo<T> cvo) {
        Map<String, Method> objectGetters = SqlType.getGetters(beanClass, FieldType.TObject);
        String F_id = null;
        HashMap<OneToOne, Modelable> map = new HashMap<OneToOne, Modelable>();
        this.setLocalAutoFecthObjectFiled(false);
        for (String fieldName : objectGetters.keySet()) {
            List<CascadeType> cascade;
            boolean hasCascade;
            ManyToOne mto;
            Method getter;
            Modelable value;
            if (obj._isAopModelBean() && !cvo._getRootColumn().anyMatchInRoot(fieldName) || null == (value = (Modelable)ReflectUtil.invokeMethod(getter = objectGetters.get(fieldName), obj, new Object[0]))) continue;
            OneToOne oto = ReflectUtil.getAnnotation(beanClass, fieldName, OneToOne.class);
            if (RsqlConstants.DataStatus.removed.equalsString(obj._getDataStatus())) {
                mto = ReflectUtil.getAnnotation(beanClass, fieldName, ManyToOne.class);
                boolean bl = hasCascade = null != mto && mto.cascade().length > 0 || null != oto && oto.cascade().length > 0;
                List<CascadeType> list = hasCascade ? Arrays.asList(mto.cascade().length > 0 ? mto.cascade() : oto.cascade()) : (cascade = null);
                if (hasCascade && cascade.contains(CascadeType.REMOVE)) {
                    this.delete(obj);
                }
            } else if (this.needStore(value)) {
                mto = ReflectUtil.getAnnotation(beanClass, fieldName, ManyToOne.class);
                boolean bl = hasCascade = null != mto && mto.cascade().length > 0 || null != oto && oto.cascade().length > 0;
                List<CascadeType> list = hasCascade ? Arrays.asList(mto.cascade().length > 0 ? mto.cascade() : oto.cascade()) : (cascade = null);
                if (hasCascade && cascade.contains(CascadeType.PERSIST)) {
                    if (oto != null) {
                        map.put(oto, value);
                    }
                    F_id = Database.getSession(this.spaceName).store(value).getId();
                }
                if (null == F_id) {
                    throw new RsqlExecuteException("RSQL_DATA_ERROR", "\u5728\u975e\u7ea7\u8054\u72b6\u6001\u4e0b\uff0c\u4e00\u5bf9\u4e00\u4e2d\u7684\u5916\u952e\u5bf9\u8c61\u6ca1\u6709\u4fdd\u5b58\uff01\u6ca1\u6709\u4fdd\u5b58\u7684\u5c5e\u6027\u4e3a\uff1a" + fieldName);
                }
            } else {
                F_id = this.getPK(value, false);
                if (oto != null) {
                    map.put(oto, value);
                }
            }
            cvo.$S(fieldName, F_id);
        }
        this.setLocalAutoFecthObjectFiled(true);
        return map;
    }

    private <T extends Modelable> void storeFKList(Class<?> beanClass, T obj, DbCvo<T> cvo, Object obj_Id, String beanName, RsqlConstants.SqlOper oper) {
        Map<String, Method> cGetters = SqlType.getGetters(beanClass, FieldType.TCollection);
        Map<String, Type> cFields = SqlType.getFields(beanClass, FieldType.TCollection);
        cFields.keySet().stream().filter(key -> !cvo._getRootColumn().hasAnyColumn() || cvo._getRootColumn().anyMatchInRoot((String)key)).forEach(fieldName -> {
            boolean notDelOper;
            Type fieldType = (Type)cFields.get(fieldName);
            Class<?> subBeanClass = ReflectUtil.getListActualType(fieldType);
            Collection obj_fieldColl = (Collection)ReflectUtil.invokeMethod((Method)cGetters.get(fieldName), (Object)obj, new Object[0]);
            if (RsqlConstants.SqlOper.add.equals((Object)oper) && (null == obj_fieldColl || 0 == obj_fieldColl.size())) {
                return;
            }
            if (RsqlConstants.SqlOper.edit.equals((Object)oper) && obj._isAopModelBean() && !cvo._getRootColumn().anyMatchInRoot((String)fieldName)) {
                return;
            }
            boolean bl = notDelOper = !RsqlConstants.SqlOper.del.equals((Object)oper) && !RsqlConstants.DataStatus.removed.equalsString(obj._getDataStatus());
            if (notDelOper && null == obj_fieldColl) {
                return;
            }
            Map<String, ?> db_fieldMap = RsqlUtils.doListColumn_select(this.spaceName, beanClass, fieldName, obj_Id).obtainObjectsMap("id", subBeanClass);
            if (null != obj_fieldColl && 0 == obj_fieldColl.size() && (null == db_fieldMap || 0 == db_fieldMap.size())) {
                return;
            }
            OneToMany otm = ReflectUtil.getAnnotation(beanClass, fieldName, OneToMany.class);
            if (null != otm) {
                List<CascadeType> cascade;
                String mappedBy = otm.mappedBy();
                boolean hasCascade = otm.cascade().length > 0;
                List<CascadeType> list = cascade = hasCascade ? Arrays.asList(otm.cascade()) : null;
                if (Judgment.nullOrBlank(mappedBy)) {
                    return;
                }
                if (null != obj_fieldColl && notDelOper) {
                    boolean isPersist = hasCascade && cascade.contains(CascadeType.PERSIST);
                    for (Modelable co : obj_fieldColl) {
                        if (null == co) continue;
                        String coField_id = String.valueOf(ReflectUtil.invokeGetter("id", co));
                        if (db_fieldMap.containsKey(coField_id)) {
                            if (isPersist) {
                                ReflectUtil.invokeSetter(mappedBy, co, obj);
                                Database.getSession(this.spaceName).store(co);
                            } else {
                                if (RsqlConstants.DataStatus.needSave.equalsString(co._getDataStatus())) {
                                    throw new RsqlExecuteException("RSQL_DATA_ERROR", "\u5728\u975e\u7ea7\u8054\u72b6\u6001\u4e0b\uff0c\u4e00\u5bf9\u591a\u4e2d\u7684\u5916\u952e\u5bf9\u8c61\u6ca1\u6709\u4fdd\u5b58\u66f4\u65b0\uff01");
                                }
                                ReflectUtil.invokeSetter(mappedBy, co, obj);
                                Database.createDbCvo(co.getClass(), this.spaceName).withColumn(mappedBy).ready().store(co);
                            }
                            db_fieldMap.remove(coField_id);
                        } else {
                            if (isPersist) {
                                ReflectUtil.invokeSetter(mappedBy, co, obj);
                                coField_id = Database.getSession(this.spaceName).store(co).getId();
                            } else {
                                ReflectUtil.invokeSetter(mappedBy, co, obj);
                                Database.createDbCvo(co.getClass(), this.spaceName).withColumn(mappedBy).ready().store(co);
                            }
                            if (null == coField_id) {
                                throw new RsqlExecuteException("RSQL_DATA_ERROR", "\u5728\u975e\u7ea7\u8054\u72b6\u6001\u4e0b\uff0c\u4e00\u5bf9\u591a\u4e2d\u7684\u5916\u952e\u5bf9\u8c61\u6ca1\u6709\u4fdd\u5b58\uff01");
                            }
                        }
                        db_fieldMap.remove(coField_id);
                    }
                }
                if (hasCascade && cascade.contains(CascadeType.REMOVE)) {
                    for (Modelable co : db_fieldMap.values()) {
                        Database.getSession(this.spaceName).delete(co);
                    }
                } else {
                    for (Modelable co : db_fieldMap.values()) {
                        ReflectUtil.invokeSetter(mappedBy, co, null);
                        Database.getSession(this.spaceName).store(co);
                    }
                }
            } else {
                boolean meIsPrimaryTable;
                ManyToMany mtm = ReflectUtil.getAnnotation(beanClass, fieldName, ManyToMany.class);
                boolean hasCascade = null != mtm && mtm.cascade().length > 0;
                List<CascadeType> cascade = hasCascade ? Arrays.asList(mtm.cascade()) : null;
                boolean bl2 = meIsPrimaryTable = mtm == null || !"void".equals(mtm.targetEntity().toString());
                if (null != obj_fieldColl && notDelOper) {
                    boolean isPersist = hasCascade && cascade.contains(CascadeType.PERSIST);
                    for (Modelable co : obj_fieldColl) {
                        if (null == co) continue;
                        String coField_id = String.valueOf(ReflectUtil.invokeGetter("id", co));
                        if (db_fieldMap.containsKey(coField_id)) {
                            if (isPersist) {
                                Database.getSession(this.spaceName).store(co);
                            } else if (RsqlConstants.DataStatus.needSave.equalsString(co._getDataStatus())) {
                                throw new RsqlExecuteException("RSQL_DATA_ERROR", "\u5728\u975e\u7ea7\u8054\u72b6\u6001\u4e0b\uff0c\u591a\u5bf9\u591a\u4e2d\u7684\u5916\u952e\u5bf9\u8c61\u6ca1\u6709\u4fdd\u5b58\u66f4\u65b0\uff01");
                            }
                            db_fieldMap.remove(coField_id);
                            continue;
                        }
                        if (isPersist) {
                            coField_id = Database.getSession(this.spaceName).store(co).getId();
                        }
                        if (null != coField_id) {
                            RsqlUtils.doManyToMany_insert(this.spaceName, beanClass, beanName, fieldName, obj_Id, coField_id, meIsPrimaryTable);
                            continue;
                        }
                        throw new RsqlExecuteException("RSQL_DATA_ERROR", "\u5728\u975e\u7ea7\u8054\u72b6\u6001\u4e0b\uff0c\u591a\u5bf9\u591a\u4e2d\u7684\u5916\u952e\u5bf9\u8c61\u6ca1\u6709\u4fdd\u5b58\uff01");
                    }
                }
                if (hasCascade && cascade.contains(CascadeType.REMOVE)) {
                    for (Object co : db_fieldMap.values()) {
                        Database.getSession().delete(co);
                    }
                } else {
                    for (String F_id : db_fieldMap.keySet()) {
                        RsqlUtils.doManyToMany_delete(cvo._getSpaceName(), beanClass, beanName, fieldName, obj_Id, F_id, meIsPrimaryTable);
                    }
                }
            }
        });
    }

    private void updateDS(Object obj, Object dataStatus) {
        Method setter = ReflectUtil.getMethod(obj.getClass(), "_setDataStatus");
        if (null == setter) {
            throw new RsqlExecuteException("RSQL_BEANSTATUS_ERROR", obj.getClass().toGenericString() + "\u4fdd\u5b58\u4e86\u4e00\u4e2a\u6ca1\u6709dataStatus\u7684Bean\uff0c\u6570\u636e\u5e93\u6570\u636e\u4f1a\u51fa\u73b0\u9519\u8bef\uff01");
        }
        ReflectUtil.invokeMethod(setter, obj, ReflectUtil.caseObject(setter.getGenericParameterTypes()[0], dataStatus, new Object[0]));
    }

    private void updatePK(Object obj, Object P_Id) {
        Method setter = ReflectUtil.getAllSetters(obj.getClass()).get("id");
        if (null == setter) {
            throw new RsqlExecuteException("RSQL_DATA_ERROR", obj.getClass().toString() + "\u4fdd\u5b58\u4e86\u4e00\u4e2a\u6ca1\u6709id\u7684Bean\uff0c\u6570\u636e\u5e93\u6570\u636e\u4f1a\u51fa\u73b0\u9519\u8bef\uff01");
        }
        ReflectUtil.invokeMethod(setter, obj, ReflectUtil.caseObject(setter.getGenericParameterTypes()[0], P_Id, new Object[0]));
    }

    private <T extends Modelable> String getDS(T obj) {
        return obj._getDataStatus();
    }

    private <T extends Modelable> String getPK(T obj, boolean forceCheckFromDB) {
        if (null == obj) {
            return null;
        }
        String idObj = obj.getId();
        String id = (String)ReflectUtil.caseObject(String.class, idObj, new Object[0]);
        if (forceCheckFromDB && null != idObj) {
            DbRvo<Modelable> qr = Database.createDbCvo(obj.getClass()).filterBy(Modelable::getId, WhereRuleOper.eq, (Object)idObj.toString()).ready().query();
            if (qr.getRowCount() == 0) {
                return null;
            }
            if (qr.getRecordCount() > 1) {
                throw new RsqlExecuteException("RSQL_DATA_ERROR", obj.getClass() + idObj.toString() + "\u4e3b\u952eID\u91cd\u590d\uff01");
            }
            return (String)ReflectUtil.caseObject(String.class, qr.getCell(0, "id"), new Object[0]);
        }
        return id;
    }
}

