/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db;

import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Param;
import cn.remex.db.Container;
import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.lambdaapi.ColumnPredicate;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.RsqlUtils;
import cn.remex.db.rsql.model.Modelable;
import java.util.List;

public class Query<T extends Modelable> {
    private Container container;
    private DbCvo<T> dbCvo;

    Query(Container container, DbCvo<T> dbCvo) {
        this.container = container;
        this.dbCvo = dbCvo;
    }

    public DbRvo<T> executeQuery() {
        return this.container.executeQuery(this.dbCvo);
    }

    public T queryBeanById(String examTaskId) {
        this.dbCvo.filterById(examTaskId);
        return this.queryBean();
    }

    public DbRvo<T> update() {
        return this.container.update(this.dbCvo);
    }

    public DbRvo<T> delete() {
        return this.container.delete(this.dbCvo);
    }

    public DbRvo<T> query() {
        return this.container.query(this.dbCvo);
    }

    public DbRvo<T> store(T obj) {
        this.dbCvo.setOper(RsqlConstants.SqlOper.store);
        return this.container.store(obj, this.dbCvo);
    }

    public T queryBean() {
        List<T> beans = this.container.query(this.dbCvo).obtainBeans();
        return (T)(beans.size() > 0 ? (Modelable)beans.get(0) : null);
    }

    public List<T> queryBeans() {
        return this.container.query(this.dbCvo).obtainBeans();
    }

    public <ST extends Modelable> DbRvo<ST> queryCollectionField(ColumnPredicate<T> cp, Object foreignKey) {
        Param<Object> fieldNameParam = new Param<Object>(null);
        ReflectUtil.eachFieldWhenGet(this.dbCvo.getBeanClass(), bean -> cp.init((Modelable)bean), fieldName -> {
            fieldNameParam.param = fieldName;
            Object cfr_ignored_0 = fieldNameParam.param;
        });
        return RsqlUtils.doListColumn_select(this.container.getSpaceName(), this.dbCvo.getBeanClass(), (String)fieldNameParam.param, foreignKey);
    }

    public void update(T model, ColumnPredicate<T> cp) {
        this.dbCvo.filterById(model.getId());
        ReflectUtil.eachFieldWhenGet(model, c -> cp.init((Modelable)c), f -> this.dbCvo.assignColumn(cp, ReflectUtil.invokeGetter(f, model)));
        this.update();
    }
}

