/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db;

import cn.remex.contrib.auth.AuthenticateBtx;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.core.util.StringHelper;
import cn.remex.core.util.date.DateHelper;
import cn.remex.db.DbCvoBase;
import cn.remex.db.DbRvo;
import cn.remex.db.Query;
import cn.remex.db.exception.RsqlConnectionException;
import cn.remex.db.exception.RsqlExecuteException;
import cn.remex.db.lambdaapi.ColumnPredicate;
import cn.remex.db.lambdaapi.ListColumnPredicate;
import cn.remex.db.lambdaapi.ModelColumnPredicate;
import cn.remex.db.model.cert.AuthUser;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.rsql.RsqlUtils;
import cn.remex.db.rsql.model.Modelable;
import cn.remex.db.rsql.model.SerialNoGenerator;
import cn.remex.db.sql.FieldType;
import cn.remex.db.sql.NamedParam;
import cn.remex.db.sql.Sort;
import cn.remex.db.sql.SqlColumn;
import cn.remex.db.sql.SqlType;
import cn.remex.db.sql.Where;
import cn.remex.db.sql.WhereGroupOp;
import cn.remex.db.sql.WhereRule;
import cn.remex.db.sql.WhereRuleOper;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public class DbCvo<T extends Modelable>
extends DbCvoBase<T> {
    private static final long serialVersionUID = -4526274035605072155L;
    public static final String regx = "([A-Za-z_][A-Za-z\\d_,]*)$|(([A-Za-z_][A-Za-z\\d_]*)\\.)|(([A-Za-z_][A-Za-z\\d_]*)\\[\\]\\.)";

    public Query<T> ready() {
        return new Query(this.container, this);
    }

    public DbRvo<T> execute() {
        Query<Modelable> query = new Query<Modelable>(this.container, this);
        switch (this._executeMethod) {
            case "Select": {
                return query.query();
            }
            case "Insert": {
                return query.store(this.bean);
            }
            case "Update": {
                return query.update();
            }
            case "Delete": {
                return query.delete();
            }
            case "InsertOrUpdate": {
                return query.store(this.bean);
            }
            case "SQL": {
                return query.executeQuery();
            }
        }
        throw new RsqlExecuteException("RSQL_SQL_ERROR", "\u4e0d\u652f\u6301\u7684executeMethod");
    }

    public DbCvo<T> filterBy(ColumnPredicate<T> wp, WhereRuleOper oper, Object value) {
        ReflectUtil.eachFieldWhenGet(this._obtainAOPBean(), b -> wp.init((Modelable)b), s -> this.addRule((String)s, oper, value));
        return this;
    }

    public DbCvo<T> filterBy(ColumnPredicate<T> wp, WhereRuleOper oper, ColumnPredicate<T> wpValue) {
        this.rootColumn.withBase(wpValue, (SqlColumn<T, ST, ?> c) -> ReflectUtil.eachFieldWhenGet(this._obtainAOPBean(), b -> wp.init((Modelable)b), s -> this.addRule((String)s, oper, c)));
        return this;
    }

    public DbCvo<T> filterBy(ColumnPredicate<T> wp, WhereRuleOper oper, Object ... args) {
        ReflectUtil.eachFieldWhenGet(this._obtainAOPBean(), b -> wp.init((Modelable)b), s -> this.getFilter().addSubSelectRule((String)s, oper, args));
        return this;
    }

    public <ST extends Modelable> DbCvo<T> filterByModel(ModelColumnPredicate<T, T, ST> mcp, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.rootColumn.withModel(mcp, (SqlColumn<T, ST, S2T> sqlColumn) -> {
            sqlColumn._setSwitchFilterToDbCvo(true);
            sqlColumnConsumer.accept((SqlColumn)sqlColumn);
            sqlColumn._setSwitchFilterToDbCvo(false);
        });
        return this;
    }

    public <ST extends Modelable> DbCvo<T> filterByList(ListColumnPredicate<T, T, ST> mcp, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.rootColumn.withList(mcp, (SqlColumn<T, ST, S2T> sqlColumn) -> {
            sqlColumn._setSwitchFilterToDbCvo(true);
            sqlColumnConsumer.accept((SqlColumn)sqlColumn);
            sqlColumn._setSwitchFilterToDbCvo(false);
        });
        return this;
    }

    public <ST extends Modelable> DbCvo<T> filterBy(ColumnPredicate<T> wp, WhereRuleOper oper, Class<ST> subSelectBeanClass, Consumer<DbCvo<ST>> subSelectSqlColumnConsumer) {
        DbCvo subSelectDbCvo = new DbCvo(this._getSpaceName(), subSelectBeanClass, true);
        subSelectSqlColumnConsumer.accept(subSelectDbCvo);
        ReflectUtil.eachFieldWhenGet(this._obtainAOPBean(), b -> wp.init((Modelable)b), fieldName -> this.filter.addSubSelectRule((String)fieldName, oper, subSelectDbCvo));
        return this;
    }

    public <ST extends Modelable> DbCvo<T> filterBy(WhereRuleOper oper, Class<ST> subSelectBeanClass, Consumer<DbCvo<ST>> subSelectSqlColumnConsumer) {
        DbCvo<ST> subSelectDbCvo = new DbCvo<ST>(this._getSpaceName(), subSelectBeanClass, true);
        subSelectSqlColumnConsumer.accept(subSelectDbCvo);
        this.filter.addSubSelectRule("_NOT_NEED_FIELD", oper, subSelectDbCvo);
        return this;
    }

    public DbCvo<T> filterOper(WhereGroupOp groupOp) {
        this.filter.setGroupOp(groupOp);
        return this;
    }

    public DbCvo<T> filterByGroup(Consumer<Where<T, T>> groupConsumer) {
        this.filter.setSuperDbCvo(this);
        Where group = new Where();
        group.setSuperDbCvo(this);
        group.setSuperWhere(this.filter);
        this.filter.addGroup(group);
        groupConsumer.accept(group);
        return this;
    }

    public DbCvo<T> filterById(String id) {
        this.rowCount(1);
        this.filterBy(Modelable::getId, WhereRuleOper.eq, (Object)id);
        return this;
    }

    public DbCvo<T> filter(Where filter) {
        this.setFilter(filter);
        return this;
    }

    public DbCvo<T> filterByBean(T model) {
        Object value;
        Assert.isTrue(model.getClass().isAssignableFrom(this.beanClass), "ERROR", "\u5fc5\u987b\u4f20\u5165\u67e5\u8be2\u8868\u5bf9\u5e94\u7684Model\u7c7b\u578b\u7684\u5b9e\u4f8b\u5bf9\u8c61\u3002");
        Map<String, Method> baseGetters = SqlType.getGetters(this.beanClass, FieldType.TBase);
        Map<String, Method> objGetters = SqlType.getGetters(this.beanClass, FieldType.TObject);
        for (String fieldName : baseGetters.keySet()) {
            value = ReflectUtil.invokeGetter(fieldName, model);
            if (Judgment.nullOrBlank(value) || value.equals(0)) continue;
            this.addRule(fieldName, WhereRuleOper.eq, String.valueOf(value));
        }
        for (String fieldName : objGetters.keySet()) {
            value = ReflectUtil.invokeGetter(fieldName, model);
            if (Judgment.nullOrBlank(value) || value.equals(0)) continue;
            this.addRule(fieldName, WhereRuleOper.eq, String.valueOf(ReflectUtil.invokeGetter("id", value)));
        }
        return this;
    }

    public DbCvo<T> orderBy(String sidx, String sord) {
        this.addOrder(true, sidx, sord);
        return this;
    }

    public DbCvo<T> orderBy(ColumnPredicate<T> wp, Sort s) {
        ReflectUtil.eachFieldWhenGet(this._obtainAOPBean(), b -> wp.init((Modelable)b), s1 -> this.addOrder(true, (String)s1, s.toString()));
        return this;
    }

    public DbCvo<T> page(int page) {
        this.setPagination(page);
        return this;
    }

    public DbCvo<T> rowCount(int page) {
        this.setRowCount(page);
        return this;
    }

    public DbCvo<T> withColumn(String ... fields) {
        for (String field : fields) {
            this.rootColumn.withColumn(field);
        }
        return this;
    }

    public DbCvo<T> withBase(ColumnPredicate<T> cp, Consumer<SqlColumn<T, T, ?>> sqlColumnConsumer) {
        this.rootColumn.withBase(cp, sqlColumnConsumer);
        return this;
    }

    public DbCvo<T> withBase() {
        this.rootColumn.withBase();
        return this;
    }

    public DbCvo<T> withBase(ColumnPredicate<T> cp) {
        this.rootColumn.withBase(cp);
        return this;
    }

    public DbCvo<T> withBase(String fieldName, Consumer<SqlColumn<T, T, ?>> sqlColumnConsumer) {
        this.rootColumn.withBase(fieldName, sqlColumnConsumer);
        return this;
    }

    public DbCvo<T> withBase(String fieldName) {
        this.rootColumn.withBase(fieldName);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withModel(ModelColumnPredicate<T, T, ST> mcp, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.rootColumn.withModel(mcp, sqlColumnConsumer);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withModel(ModelColumnPredicate<T, T, ST> mcp) {
        this.rootColumn.withModel(mcp);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withModel(String fieldName, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.rootColumn.withModel(fieldName, sqlColumnConsumer);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withModel(String fieldName) {
        this.rootColumn.withModel(fieldName);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withList(ListColumnPredicate<T, T, ST> mcp, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.rowCount(100000);
        this.rootColumn.withList(mcp, sqlColumnConsumer);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withList(ListColumnPredicate<T, T, ST> mcp) {
        this.rowCount(100000);
        this.rootColumn.withList(mcp);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withList(String fieldName, Consumer<SqlColumn<T, T, ST>> sqlColumnConsumer) {
        this.rowCount(100000);
        this.rootColumn.withList(fieldName, sqlColumnConsumer);
        return this;
    }

    public <ST extends Modelable> DbCvo<T> withList(String fieldName) {
        this.rowCount(100000);
        this.rootColumn.withList(fieldName);
        return this;
    }

    public DbCvo<T> assignColumn(ColumnPredicate<T> cp, Object o) {
        this.rootColumn.withBase(cp, (SqlColumn<T, ST, ?> base) -> this.$S(base.getFieldName(), o));
        return this;
    }

    public <ST extends Modelable> DbCvo<T> assignColumn(ColumnPredicate<T> cp, Class<ST> subSelectBeanClass, Consumer<DbCvo<ST>> subSelectSqlColumnConsumer) {
        DbCvo subDbCvo = new DbCvo(this._getSpaceName(), subSelectBeanClass, true);
        subSelectSqlColumnConsumer.accept(subDbCvo);
        this.rootColumn.withBase(cp, (SqlColumn<T, ST, ?> base) -> base.setSubDbCvo(subDbCvo));
        return this;
    }

    public DbCvo<T> assignBean(T dbBean) {
        this.bean = dbBean;
        if (!dbBean.modelIsNew()) {
            this.filterById(dbBean.getId());
        }
        SqlType.getFields(this.getBeanClass(), FieldType.TAll).forEach((fieldName, fieldType) -> {
            Object o = ReflectUtil.invokeGetter(fieldName, this.bean);
            if (o != null) {
                this.withColumn((String)fieldName);
                this.$S((String)fieldName, o instanceof Modelable ? ((Modelable)o).getId() : o.toString());
            }
        });
        return this;
    }

    public DbCvo<T> withExprColumns(String columnExprs) {
        boolean[] end = new boolean[]{false};
        Param<Object> param = new Param<Object>(null);
        for (String expr : columnExprs.split(";")) {
            end[0] = false;
            param.param = null;
            StringHelper.forEachMatch(expr, regx, (m, b) -> {
                String baseField = m.group(1);
                String objField = m.group(3);
                String listField = m.group(5);
                if (baseField != null) {
                    for (String field : baseField.split(",")) {
                        ReflectUtil.invokeMethod("withBase", (Object)(param.param == null ? this : param.param), field);
                    }
                } else if (objField != null) {
                    if (param.param == null) {
                        this.withModel(objField, (SqlColumn<T, T, ST> curModel) -> {
                            param.param = curModel;
                        });
                    } else {
                        ((SqlColumn)param.param).withModel(objField, (SqlColumn<T, ST, S2T> curModel) -> {
                            param.param = curModel;
                        });
                    }
                } else if (listField != null) {
                    if (param.param == null) {
                        this.withList(listField, (SqlColumn<T, T, ST> curList) -> {
                            param.param = curList;
                        });
                    } else {
                        ((SqlColumn)param.param).withList(listField, (SqlColumn<T, ST, S2T> curList) -> {
                            param.param = curList;
                        });
                    }
                }
                end[0] = b;
            });
            Assert.isTrue(end[0], "ERROR", "\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u53ea\u5141\u8bb8name.   name[].  name \u4e09\u79cd\u683c\u5f0f!");
        }
        return this;
    }

    @Deprecated
    public DbCvo<T> putExtColumn(String extColumns) {
        for (String extColumn : extColumns.split(";")) {
            String[] columns = extColumn.split("\\.");
            Assert.isTrue(columns.length <= 3, "ERROR", "putExtColumn\u65b9\u6cd5\u53ea\u80fd\u652f\u6301\u4e24\u5c42\u5c5e\u6027\u62d3\u5c55");
            if (columns.length == 1) {
                this.rootColumn.withBase(columns[0]);
                continue;
            }
            this.rootColumn.withModel(columns[0], (SqlColumn<T, ST, S2T> m) -> {
                if (columns[1].indexOf("[") > 0) {
                    m.withList(columns[1], (SqlColumn<T, ST, S2T> m2) -> m2.withBase(columns[2]));
                } else if (columns.length > 2) {
                    m.withModel(columns[1], (SqlColumn<T, ST, S2T> m2) -> m2.withBase(columns[2]));
                } else {
                    m.withBase(columns[1]);
                }
            });
        }
        return this;
    }

    public DbCvo<T> eachRow(Consumer<List> rowConsumer) {
        this.rowConsumer = rowConsumer;
        return this;
    }

    public DbCvo(String spaceName, Class<T> beanClass) {
        this._init(spaceName, beanClass);
    }

    public DbCvo(String spaceName, Class<T> beanClass, boolean _isSubStatment) {
        this._isSubStatment = _isSubStatment;
        this._init(spaceName, beanClass);
    }

    public DbCvo(String spaceName, Class<T> beanClass, Map<String, Object> params) {
        if (null != params) {
            this.putParameters(params);
        }
        this._init(spaceName, beanClass);
    }

    public DbCvo(String spaceName, Class<T> beanClass, RsqlConstants.SqlOper oper) {
        Assert.notNull((Object)oper, "ERROR", "\u6570\u636e\u5e93\u64cd\u4f5c\u7b26oper\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.oper = oper;
        this._init(spaceName, beanClass);
    }

    public DbCvo(String spaceName, Class<T> beanClass, RsqlConstants.SqlOper oper, SqlColumn rootColumn) {
        Assert.notNull((Object)oper, "ERROR", "\u6570\u636e\u5e93\u64cd\u4f5c\u7b26oper\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.oper = oper;
        if (null != rootColumn) {
            this.rootColumn = rootColumn;
        }
        this._init(spaceName, beanClass);
    }

    public DbCvo(String spaceName, String sqlString, Map<String, Object> params) {
        this.sqlString = sqlString;
        this.oper = RsqlConstants.SqlOper.sql;
        if (null != params) {
            this.putParameters(params);
        }
        this._init(spaceName, null);
    }

    public DbCvo(String spaceName, String sqlString, RsqlConstants.SqlOper oper, Map<String, Object> params) {
        this.sqlString = sqlString;
        this.oper = oper;
        if (null != params) {
            this.putParameters(params);
        }
        this._init(spaceName, null);
    }

    private void _init(String spaceName, Class<T> clazz) {
        Class<Object> clazz1 = clazz;
        if (null != clazz1) {
            try {
                clazz1 = Class.forName(StringHelper.getClassName(clazz1));
            }
            catch (ClassNotFoundException e) {
                throw new RsqlConnectionException("RSQL_BEANCLASS_ERROR", "\u521d\u59cb\u5316DbCvo\u65f6,beanClass\u5f02\u5e38\uff01", e);
            }
            this.beanName = StringHelper.getClassSimpleName(clazz1);
        } else {
            this.beanName = "sqlString_" + this.sqlString.hashCode();
            this._prettySqlString = this._litterSqlString = this.sqlString;
            this._sqlString = this._litterSqlString;
        }
        this.beanClass = clazz1;
        this.spaceName = spaceName;
        if (null != this.beanClass && null == this.rootColumn) {
            this.rootColumn = new SqlColumn(this, this.beanClass, this._obtainAOPBean());
        }
    }

    public void _initForRsqlDao() {
        if (RsqlConstants.SqlOper.list.equals((Object)this.oper) || RsqlConstants.SqlOper.view.equals((Object)this.oper)) {
            RsqlUtils.createSelectSql(this);
        } else if (RsqlConstants.SqlOper.add.equals((Object)this.oper)) {
            RsqlUtils.createInsertSql(this);
        } else if (RsqlConstants.SqlOper.edit.equals((Object)this.oper)) {
            RsqlUtils.createUpdateSql(this);
        } else if (RsqlConstants.SqlOper.del.equals((Object)this.oper)) {
            RsqlUtils.createDeleteSql(this);
        } else if (RsqlConstants.SqlOper.sql.equals((Object)this.oper)) {
            RsqlUtils.createStringSql(this);
        } else {
            throw new RsqlExecuteException("RSQL_ERROR", "oper \u64cd\u4f5c\u6307\u4ee4\u9519\u8bef\uff01");
        }
        if (RsqlConstants.SqlOper.edit.equals((Object)this.oper) || RsqlConstants.SqlOper.add.equals((Object)this.oper)) {
            String un;
            String now = DateHelper.getNow(new String[0]);
            AuthUser au = AuthenticateBtx.obtainCurUser();
            String string = un = au == null || Judgment.nullOrBlank(au.getUsername()) ? "NONE" : au.getUsername();
            if (this.oper == RsqlConstants.SqlOper.add) {
                this.$S("createTime", now);
                this.$S("createOperator", un);
                this.$S("ownership", un);
            }
            this.$S("modifyTime", now);
            this.$S("modifyOperator", un);
        }
        this._initSqlString(this._sqlString);
        Where curWhere = this.getFilter();
        if (curWhere.isFilter()) {
            for (WhereRule rule : curWhere.getAllRules()) {
                this.$S(rule.getParamName(), rule.getData());
            }
        } else if (!Judgment.nullOrBlank(curWhere.getSearchField())) {
            this.$S(curWhere.getSearchField(), curWhere.getSearchString());
        }
        if (null != this._getRootColumn()) {
            this._getRootColumn().forEvery(sqlColumn -> {
                if (null != sqlColumn.getOnFilter()) {
                    List<WhereRule> curAllRules = sqlColumn.getOnFilter().getAllRules();
                    for (WhereRule rule : curAllRules) {
                        this.$S(rule.getParamName(), rule.getData());
                    }
                }
            });
        }
        if (null != this._getRootColumn()) {
            this._getRootColumn().forEvery(c1 -> {
                if (null != c1.getFilter()) {
                    c1.getFilter().getAllRules().forEach(rule -> this.$S(rule.getParamName(), rule.getData()));
                }
            });
        }
        for (NamedParam namedParam : this._getNamedParams()) {
            String key = namedParam.getName();
            if (!this.containsKey(key)) continue;
            Object paramValue = this.$V(key);
            namedParam.setValue(paramValue);
        }
        if (null != this.getBean() && this._sqlString.substring(0, 6).equalsIgnoreCase("INSERT")) {
            SerialNoGenerator idgen = (SerialNoGenerator)((Object)this.getBean());
            String id = idgen.obtainNewId() != null ? idgen.obtainNewId() : idgen.generateId();
            this.getBean().setId(id);
            this.setId(id);
            this._namedParams.stream().filter((? super T np) -> "id".equals(np.getName())).findFirst().ifPresent(np -> np.setValue(id));
        }
    }

    public void _initForSubStatement(DbCvoBase<Modelable> dbCvo, Param<Integer> tableIndex, Param<Integer> paramIndex) {
        this._setParamIndex(paramIndex);
        Param<Integer> param = tableIndex;
        Integer n = (Integer)param.param;
        param.param = (Integer)param.param + 1;
        Integer n2 = param.param;
        this._setTableAliasName("SS" + n);
        this._setNamedParams(dbCvo._getNamedParams());
        this._initForRsqlDao();
        this.getParameters().forEach((k, v) -> dbCvo.$S((String)k, v));
    }

    private void _initSqlString(String sqlString) {
        this._prettySqlString = sqlString;
        this._sqlString = this._prettySqlString.replaceAll("\\s+", " ");
        this._litterSqlString = this._sqlString.length() > 20 ? this._sqlString.substring(0, 20) + "..." : this._sqlString;
        TreeMap<Integer, String> paramIndexs = RsqlUtils.obtainNamedParamIndexs(this._sqlString);
        for (NamedParam param : this._namedParams) {
            Integer okIdx = null;
            for (Integer idx : paramIndexs.keySet()) {
                if (!param.getName().equals(paramIndexs.get(idx))) continue;
                okIdx = idx;
                break;
            }
            if (null == okIdx) continue;
            paramIndexs.remove(okIdx);
            param.setIndex(okIdx);
        }
        this._sqlString = RsqlUtils.obtainNamedSql(this._sqlString);
    }

    public DbCvo<T> executeMethod(String executeMethod) {
        this._executeMethod = executeMethod;
        return this;
    }
}

