/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.db;

import cn.remex.core.RemexApplication;
import cn.remex.db.Container;
import cn.remex.db.DbCvo;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.model.Modelable;

public class Database {
    public static Container getSession() {
        return Database.getSession(RDBManager.DEFAULT_SPACE);
    }

    public static Container getSession(String spaceName) {
        Class<? extends Container> containerClass = RDBManager.getLocalSpaceConfig(spaceName).getContainerClass();
        Container container = RemexApplication.getBean(containerClass, new String[0]);
        container.setSpaceName(spaceName);
        return container;
    }

    public static <T extends Modelable> DbCvo<T> createDbCvo(Class<T> beanClass) {
        return Database.createDbCvo(beanClass, RDBManager.DEFAULT_SPACE);
    }

    public static <T extends Modelable> DbCvo<T> createDbCvo(Class<T> beanClass, String spaceName) {
        return Database.getSession(spaceName).createDbCvo(beanClass);
    }

    public static Container space(String spaceName) {
        return Database.getSession(spaceName);
    }

    public static <T extends Modelable> DbCvo<T> select(Class<T> beanClass) {
        return Database.space(RDBManager.DEFAULT_SPACE).createDbCvo(beanClass).executeMethod("Select");
    }

    public static <T extends Modelable> DbCvo<T> update(Class<T> beanClass) {
        return Database.space(RDBManager.DEFAULT_SPACE).createDbCvo(beanClass).executeMethod("Update");
    }

    public static <T extends Modelable> DbCvo<T> delete(Class<T> beanClass) {
        return Database.space(RDBManager.DEFAULT_SPACE).createDbCvo(beanClass).executeMethod("Delete");
    }

    public static <T extends Modelable> DbCvo<T> insert(Class<T> beanClass) {
        return Database.space(RDBManager.DEFAULT_SPACE).createDbCvo(beanClass).executeMethod("Insert");
    }

    public static <T extends Modelable> DbCvo<T> insertOrUpdate(Class<T> beanClass) {
        return Database.space(RDBManager.DEFAULT_SPACE).createDbCvo(beanClass).executeMethod("InsertOrUpdate");
    }
}

