/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util.lock;

import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.MapHelper;
import cn.remex.db.Database;
import cn.remex.db.DbRvo;
import cn.remex.db.model.SysStatus;
import cn.remex.db.rsql.RsqlConstants;
import cn.remex.db.sql.WhereRuleOper;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.UUID;

public class Lock {
    private static final int timeOut = 60;

    public static boolean getLock(String lockName) {
        UUID uuid = UUID.randomUUID();
        LocalDateTime localDateTime = LocalDateTime.now();
        String lockNames = "LOCK" + lockName;
        SysStatus sysStatus = Database.getSession().createDbCvo(SysStatus.class).filterBy(SysStatus::getKey, WhereRuleOper.eq, (Object)lockNames).ready().queryBean();
        if (Judgment.nullOrBlank(sysStatus)) {
            sysStatus = new SysStatus();
            sysStatus.setKey(lockNames);
            sysStatus.setNote(uuid.toString());
            sysStatus.setDesc(localDateTime.toString());
            sysStatus.setStatus(RsqlConstants.SysStatusEnum.LOCKED);
            try {
                Database.getSession().store(sysStatus);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        String oldUID = sysStatus.getNote();
        LocalDateTime oldTime = LocalDateTime.parse(sysStatus.getDesc());
        if (sysStatus.getStatus().equals((Object)RsqlConstants.SysStatusEnum.LOCKED) && oldTime.until(localDateTime, ChronoUnit.MINUTES) > 60L) {
            sysStatus.setNote(uuid.toString());
            sysStatus.setDesc(localDateTime.toString());
            sysStatus.setStatus(RsqlConstants.SysStatusEnum.LOCKED);
            try {
                Database.getSession().store(sysStatus);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (sysStatus.getStatus().equals((Object)RsqlConstants.SysStatusEnum.UNLOCKED)) {
            try {
                Map<String, Object> map = MapHelper.toMap("note", uuid.toString(), "desc", localDateTime.toString(), "oldnote", oldUID, "id", sysStatus.getId(), "key", lockNames);
                DbRvo dbRvo = Database.getSession().executeUpdate("UPDATE SysStatus SET note = :note,`desc`= :desc,status='LOCKED' WHERE note = :oldnote AND id= :id AND status='UNLOCKED' AND  `key` = :key", map);
                return dbRvo.getEffectRowCount() == 1;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static void unlock(String lockName) {
        String lockNames = "LOCK" + lockName;
        SysStatus sysStatus = Database.getSession().createDbCvo(SysStatus.class).filterBy(SysStatus::getKey, WhereRuleOper.eq, (Object)lockNames).ready().queryBean();
        Assert.notNull(sysStatus, "FAIL", "\u6ca1\u6709\u83b7\u53d6\u5230\u9501\uff0c\u65e0\u6cd5\u5173\u95ed\uff01 \u9501\u540d\u4e3a\uff1a" + lockName);
        sysStatus.setStatus(RsqlConstants.SysStatusEnum.UNLOCKED);
        Database.getSession().store(sysStatus);
    }
}

