/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util.excelutils;

import cn.remex.RemexConstants;
import cn.remex.core.util.Assert;
import cn.remex.core.util.FileHelper;
import cn.remex.core.util.Judgment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExportUtil {
    private String firstSheetName = "first";
    private String excelFilePatch;
    private File file;
    private Workbook wb = new XSSFWorkbook();
    private Map<String, Sheet> sheetMap = new HashMap<String, Sheet>();
    private Map<String, List<String>> sheetTitles = null;
    private Map<String, Object> titleToLabelMap;

    public ExcelExportUtil(String excelFilePatch, String ... sheetNames) {
        Assert.notNullAndEmpty(excelFilePatch, "FAIL", "Excel\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
        this.file = FileHelper.createFile(excelFilePatch);
        if (sheetNames != null && sheetNames.length > 0) {
            for (String sheetName : sheetNames) {
                this.sheetMap.put(sheetName, this.wb.createSheet(sheetName));
            }
        } else {
            this.sheetMap.put(this.firstSheetName, this.wb.createSheet(this.firstSheetName));
        }
    }

    public File createExcelFile() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            this.wb.write((OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            RemexConstants.logger.error((Object)"Excel\u6587\u4ef6\u751f\u6210\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.file;
    }

    public ExcelExportUtil inputDataByList(List<List<Object>> rowsList) {
        Assert.isTrue(this.sheetTitles != null && this.sheetTitles.size() > 0, "FAIL", "\u6807\u9898\u4e3a\u7a7a\u8bf7\u5b9a\u4e49\u6807\u9898\uff01");
        HashMap<String, List<List<Object>>> sheetNameAndRowsMap = new HashMap<String, List<List<Object>>>();
        sheetNameAndRowsMap.put(this.getDefaultSheetName(), rowsList);
        this.inputDataByList(this.sheetTitles, sheetNameAndRowsMap);
        return this;
    }

    public ExcelExportUtil inputDataByList(List<String> sheetTitles, List<List<Object>> rowsList) {
        HashMap<String, List<String>> sheetTitlesMap = new HashMap<String, List<String>>();
        sheetTitlesMap.put(this.getDefaultSheetName(), sheetTitles);
        HashMap<String, List<List<Object>>> sheetNameAndRowsMap = new HashMap<String, List<List<Object>>>();
        sheetNameAndRowsMap.put(this.getDefaultSheetName(), rowsList);
        this.inputDataByList(sheetTitlesMap, sheetNameAndRowsMap);
        return this;
    }

    public ExcelExportUtil inputDataByList(Map<String, List<String>> sheetTitles, Map<String, List<List<Object>>> sheetNameAndRowsMap) {
        Assert.isTrue(sheetTitles != null && sheetTitles.size() > 0, "FAIL", "title\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue(sheetNameAndRowsMap != null && sheetNameAndRowsMap.size() > 0, "FAIL", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.sheetTitles = sheetTitles;
        sheetTitles.forEach((s, strings) -> {
            Sheet sheet = this.sheetMap.get(s);
            Assert.notNull(sheet, "FAIL", "sheet\u6807\u9898\u9519\u8bef\uff01");
            List rowsLists = (List)sheetNameAndRowsMap.get(s);
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum == 0) {
                this.createTitle(sheet, (List<String>)strings);
            }
            ++lastRowNum;
            for (List rowData : rowsLists) {
                this.setCellValue(sheet.createRow(lastRowNum), rowData);
                ++lastRowNum;
            }
        });
        return this;
    }

    public ExcelExportUtil inputDataBySheet(List<Map<String, Object>> sheetNameAndRows) {
        Assert.isTrue(this.sheetTitles != null && this.sheetTitles.size() > 0, "FAIL", "\u6807\u9898\u4e3a\u7a7a\u8bf7\u5b9a\u4e49\u6807\u9898\uff01");
        HashMap<String, List<Map<String, Object>>> sheetNameAndRowsMap = new HashMap<String, List<Map<String, Object>>>();
        sheetNameAndRowsMap.put(this.getDefaultSheetName(), sheetNameAndRows);
        this.inputDataBySheet(this.sheetTitles, sheetNameAndRowsMap);
        return this;
    }

    public ExcelExportUtil inputDataBySheet(List<String> sheetTitles, List<Map<String, Object>> sheetNameAndRows) {
        HashMap<String, List<String>> sheetTitlesMap = new HashMap<String, List<String>>();
        sheetTitlesMap.put(this.getDefaultSheetName(), sheetTitles);
        HashMap<String, List<Map<String, Object>>> sheetNameAndRowsMap = new HashMap<String, List<Map<String, Object>>>();
        sheetNameAndRowsMap.put(this.getDefaultSheetName(), sheetNameAndRows);
        this.inputDataBySheet(sheetTitlesMap, sheetNameAndRowsMap);
        return this;
    }

    public void inputDataBySheet(Map<String, List<String>> sheetTitles, Map<String, List<Map<String, Object>>> sheetNameAndRows) {
        Assert.isTrue(sheetTitles != null && sheetTitles.size() > 0, "FAIL", "title\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue(sheetNameAndRows != null && sheetNameAndRows.size() > 0, "FAIL", "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue(sheetNameAndRows.size() == sheetTitles.size(), "FAIL", "\u6570\u636e\u548c\u6807\u9898\u7684sheet\u6570\u91cf\u4e0d\u5bf9\u5e94\uff01");
        this.sheetTitles = sheetTitles;
        sheetTitles.forEach((s, strings) -> {
            Sheet sheet = this.sheetMap.get(s);
            Assert.notNull(sheet, "FAIL", "sheet\u6807\u9898\u9519\u8bef\uff01");
            List rows = (List)sheetNameAndRows.get(s);
            Assert.isTrue(rows != null, "FAIL", "\u6570\u636e\u9519\u8bef\uff01 sheet\u627e\u4e0d\u5230\uff01");
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum == 0) {
                this.createTitle(sheet, (List<String>)strings);
                ++lastRowNum;
            }
            for (Map rowData : rows) {
                this.setCellValue(sheet.createRow(lastRowNum), (List<String>)strings, rowData);
                ++lastRowNum;
            }
        });
    }

    private void createTitle(Sheet sheet, List<String> titles) {
        Row row = sheet.createRow(0);
        for (int i = 0; i < titles.size(); ++i) {
            if (this.titleToLabelMap == null || Judgment.nullOrBlank(this.titleToLabelMap.get(titles.get(i)))) {
                this.setCellValue(row, i, titles.get(i));
                continue;
            }
            this.setCellValue(row, i, this.titleToLabelMap.get(titles.get(i)));
        }
    }

    public ExcelExportUtil inputLabel(Map<String, Object> titleToLabelMap) {
        this.titleToLabelMap = titleToLabelMap;
        return this;
    }

    private void setCellValue(Row row, List<Object> rowData) {
        for (int i = 0; i < rowData.size(); ++i) {
            Object obj = rowData.get(i);
            this.setCellValue(row, i, obj);
        }
    }

    private void setCellValue(Row row, List<String> titles, Map<String, Object> rowData) {
        for (int i = 0; i < titles.size(); ++i) {
            Object obj = rowData.get(titles.get(i));
            this.setCellValue(row, i, obj);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setCellValue(Row row, int cellnum, Object value) {
        Cell cell = row.getCell(cellnum);
        if (Judgment.nullOrBlank(cell)) {
            cell = row.createCell(cellnum);
        }
        if (value != null) {
            if (value instanceof String) {
                cell.setCellValue((String)value);
                return;
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
                return;
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
                return;
            } else if (value instanceof Double || value instanceof Long || value instanceof Integer) {
                cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
                return;
            } else {
                if (!(value instanceof Calendar)) throw new Error("\u6ca1\u6709\u5408\u9002\u7684excel\u7c7b\u578b\uff01");
                cell.setCellValue((Calendar)value);
            }
            return;
        } else {
            String a = null;
            cell.setCellValue(a);
        }
    }

    private String getDefaultSheetName() {
        if (this.sheetMap.get(this.firstSheetName) != null) {
            return this.firstSheetName;
        }
        return (String)this.sheetMap.keySet().stream().findFirst().get();
    }
}

