/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util.excelutils;

import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.excelutils.bean.ExcelForReadInside;
import cn.remex.core.util.excelutils.bean.ExcelRead;
import cn.remex.core.util.excelutils.bean.ExcelReadRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ExcelAnalysisUtil {
    public static List<ExcelReadRule> obtainSimpleExcelReadRule(String[] excelTitle, String[] outTitle) {
        Assert.isTrue(excelTitle != null && outTitle != null, "FAIL", "\u521b\u9020excel\u8bfb\u53d6\u89c4\u5219\u65f6\uff0cexcelTitle\u4e0eoutTitle \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue(excelTitle.length == outTitle.length, "FAIL", "\u521b\u9020excel\u8bfb\u53d6\u89c4\u5219\u65f6\uff0cexcelTitle\u4e0eoutTitle \u957f\u5ea6\u4e0d\u76f8\u7b49");
        ArrayList<ExcelReadRule> excelReadRules = new ArrayList<ExcelReadRule>();
        for (int i = 0; i < excelTitle.length; ++i) {
            ExcelReadRule excelReadRule = new ExcelReadRule(excelTitle[i], outTitle[i]);
            excelReadRules.add(excelReadRule);
        }
        return excelReadRules;
    }

    public static List<Map<String, Object>> excelHandleReadData(ExcelRead excelRead, List<ExcelReadRule> excelReadRules) {
        Assert.notNull(excelRead, "FAIL", "\u6570\u636e\u9519\u8bef\uff01");
        String[] titles = excelRead.getTitles();
        Assert.isTrue(titles != null && titles.length > 0, "FAIL", "\u6807\u9898\u9519\u8bef\uff01");
        List<String[]> datas = excelRead.getList();
        Assert.isTrue(datas != null && datas.size() > 0, "FAIL", "\u6ca1\u6709\u6570\u636e\uff01");
        ArrayList excelForReadList = new ArrayList();
        excelReadRules.forEach(excelReadRule -> {
            Assert.isTrue(!Judgment.nullOrBlank(excelReadRule.getExcelTitle()) && !Judgment.nullOrBlank(excelReadRule.getOutTitle()), "FAIL", "\u4f20\u5165\u8f6c\u6362\u6807\u9898\u9519\u8bef\uff01");
            ExcelForReadInside excelForRead = new ExcelForReadInside();
            excelForRead.setExcelTitle(excelReadRule.getExcelTitle());
            excelForRead.setOutTitle(excelReadRule.getOutTitle());
            excelForRead.setCanNull(excelReadRule.isCanNull());
            excelForRead.setBiFunction(excelReadRule.getBiFunction());
            excelForReadList.add(excelForRead);
        });
        List<String> stringList = Arrays.asList(titles);
        excelForReadList.forEach(excelForReadInside -> {
            Optional<String> optional = stringList.stream().filter(s -> s.equals(excelForReadInside.getExcelTitle())).findFirst();
            Assert.isTrue(optional.isPresent(), "FAIL", "\u7f3a\u5c11\u6807\u9898\uff1a" + excelForReadInside.getExcelTitle());
            excelForReadInside.setDataIndex(stringList.indexOf(optional.get()));
        });
        ArrayList<Map<String, Object>> outers = new ArrayList<Map<String, Object>>();
        for (String[] data : datas) {
            HashMap outMap = new HashMap();
            ArrayList errorMapList = new ArrayList();
            excelForReadList.forEach(excelForRead -> {
                String errorM;
                String dataStr = data[excelForRead.getDataIndex()];
                HashMap<String, String> errorMap = new HashMap<String, String>();
                if (!excelForRead.isCanNull() && Judgment.nullOrBlank(dataStr)) {
                    errorMap.put("excelErrorCode", excelForRead.getOutTitle());
                    errorMap.put("excelErrorTitle", excelForRead.getExcelTitle());
                    errorMap.put("excelErrorMsg", "\u8fd9\u4e2a\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (!Judgment.nullOrBlank(excelForRead.getBiFunction()) && !Judgment.nullOrBlank(errorM = excelForRead.getBiFunction().apply(dataStr, data))) {
                    errorMap.put("excelErrorCode", excelForRead.getOutTitle());
                    errorMap.put("excelErrorTitle", excelForRead.getExcelTitle());
                    errorMap.put("excelErrorMsg", errorM);
                }
                if (!errorMap.isEmpty()) {
                    errorMapList.add(errorMap);
                }
                outMap.put(excelForRead.getOutTitle(), dataStr);
            });
            outMap.put("errorCell", errorMapList);
            outers.add(outMap);
        }
        return outers;
    }
}

