/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util.date;

import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.date.DateFomatters;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateHelper {
    public static LocalDateTime parse(String dateTimeStr) {
        LocalDateTime localDateTime = null;
        for (DateTimeFormatter dateTimeFormatter : DateFomatters.dateTimeFormatterList) {
            if (!Judgment.nullOrBlank(localDateTime)) break;
            try {
                localDateTime = LocalDateTime.parse(dateTimeStr, dateTimeFormatter);
            }
            catch (Exception exception) {}
        }
        for (DateTimeFormatter dateTimeFormatter : DateFomatters.dateFormattersList) {
            if (!Judgment.nullOrBlank(localDateTime)) break;
            try {
                localDateTime = LocalDate.parse(dateTimeStr, dateTimeFormatter).atStartOfDay();
            }
            catch (Exception exception) {}
        }
        Assert.notNull(localDateTime, "FAIL", "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef,\u4e0d\u7b26\u5408\u9ed8\u8ba4\u7684\u51e0\u4e2a\u683c\u5f0f\uff0c\u8bf7\u81ea\u5df1\u683c\u5f0f\u5316");
        return localDateTime;
    }

    public static String getNow(String ... format) {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format == null || format.length < 1 ? "yyyy-MM-dd HH:mm:ss" : format[0]);
        return localDateTime.format(dateTimeFormatter);
    }

    public static String formatDate(LocalDate localDate, String ... format) {
        if (null == format || format.length < 1) {
            return localDate.toString();
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format[0]);
        return localDate.format(dateTimeFormatter);
    }

    public static String formatDate(LocalDateTime localDateTime, String ... format) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(null == format || format.length < 1 ? "yyyy-MM-dd HH:mm:ss" : format[0]);
        return localDateTime.format(dateTimeFormatter);
    }

    public static LocalDate dateToLocalDate(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return localDateTime.toLocalDate();
    }
}

