/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.core.exception.JaxbException;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.StringHelper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;

public final class XmlHelper {
    private static final Map<Class<?>, JAXBContext> JAXBCONTEXTS = new HashMap();
    private static HashMap<Class<?>, XStream> xStreamMap = new HashMap();

    private static String obtainXmlPrex(String sourceCharset) {
        String charsetStr = null == sourceCharset ? "UTF-8" : sourceCharset;
        return "<?xml version=\"1.0\" encoding=\"" + charsetStr + "\" ?>\n";
    }

    private static JAXBContext getJAXBContext(Class<?> clazz) {
        if (JAXBCONTEXTS.containsKey(clazz)) {
            return JAXBCONTEXTS.get(clazz);
        }
        try {
            JAXBContext curJaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            JAXBCONTEXTS.put(clazz, curJaxbContext);
            return curJaxbContext;
        }
        catch (JAXBException e) {
            throw new JaxbException("\u65e0\u6cd5\u751f\u6210JaxbContext\u5b9e\u4f8b\uff0c\u76ee\u6807\u7c7b\u4e3a\uff1a" + clazz.getName(), e);
        }
    }

    private static XStream getXStream(Class<?> c) {
        XStream xStream = xStreamMap.get(c);
        if (null == xStream) {
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
            xStream.processAnnotations(c);
            xStreamMap.put(c, xStream);
        }
        return xStream;
    }

    private static <T> String useJaxbMarshall(Class<T> clazz, Object XMLObject, String orgnCharset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXBContext curJaxbContext = XmlHelper.getJAXBContext(clazz);
        try {
            Marshaller marshaller = curJaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)orgnCharset);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(XMLObject, (OutputStream)baos);
            return baos.toString(orgnCharset);
        }
        catch (Exception e) {
            throw new JaxbException("\u89e3\u7ec4\u62a5\u6587\u5931\u8d25,\u5f02\u5e38\u539f\u56e0\u662f\uff1a", e);
        }
    }

    private static <T> T useJaxbUnmarshall(Class<T> clazz, String responseXml, String orgnCharset) {
        JAXBContext curJaxbContext = XmlHelper.getJAXBContext(clazz);
        Object ret = null;
        try {
            ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(responseXml.getBytes(orgnCharset));
            Unmarshaller curUnmarshaller = curJaxbContext.createUnmarshaller();
            Marshaller marshaller = curJaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)orgnCharset);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            ret = curUnmarshaller.unmarshal((InputStream)tInputStringStream);
            tInputStringStream.close();
        }
        catch (Exception e) {
            throw new JaxbException("\u89e3\u7ec4\u62a5\u6587\u5931\u8d25\uff0c\u62a5\u6587\u5185\u5bb9\u662f\uff1a" + responseXml + ",\u5f02\u5e38\u539f\u56e0\u662f\uff1a", e);
        }
        return (T)ret;
    }

    public static Map<String, Object> maplizeObject(Object o) {
        return XmlHelper.maplizeObject(o, null);
    }

    public static Map<String, Object> maplizeObject(Object o, String pre) {
        HashMap<String, Object> mapFromObject = new HashMap<String, Object>();
        Class<?> clazz = o.getClass();
        Map<String, Method> baseGetters = ReflectUtil.getAllGetters(clazz);
        boolean preFlag = pre != null;
        for (String fieldName : baseGetters.keySet()) {
            Method getter = baseGetters.get(fieldName);
            Object value = ReflectUtil.invokeMethod(getter, o, new Object[0]);
            if (null == value) continue;
            ReflectUtil.isSimpleType(value.getClass());
            mapFromObject.put(preFlag ? pre + StringHelper.upperFirstLetter(fieldName) : fieldName, value);
        }
        return mapFromObject;
    }

    public static <T> T unmarshall(Class<T> c, String xml) {
        return XmlHelper.unmarshall(c, xml, "UTF-8");
    }

    public static <T> T unmarshall(Class<T> c, String xml, String sourceCharset) {
        if (c.isAnnotationPresent(XmlRootElement.class)) {
            return XmlHelper.useJaxbUnmarshall(c, xml, sourceCharset);
        }
        XStream xStream = XmlHelper.getXStream(c);
        Assert.notNullAndEmpty(xml, "XML_STRING_INVALID", "XStream\u4e0d\u80fd\u5c06null\u5b57\u7b26\u4e32\u6216\u8005empty\u5b57\u7b26\u4e32\u6839\u636exml\u6807\u51c6\u8f6c\u5316\u4e3a\u5bf9\u8c61\u3002");
        return (T)xStream.fromXML(xml);
    }

    public static String marshall(Object object) {
        return XmlHelper.marshall(object, "UTF-8");
    }

    public static String marshall(Object object, String sourceCharset) {
        if (object.getClass().isAnnotationPresent(XmlRootElement.class)) {
            return XmlHelper.useJaxbMarshall(object.getClass(), object, sourceCharset);
        }
        XStream xStream = XmlHelper.getXStream(object.getClass());
        return new StringBuffer().append(XmlHelper.obtainXmlPrex(sourceCharset)).append(xStream.toXML(object)).toString();
    }
}

