/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.RemexConstants;
import cn.remex.core.exception.StringHandleException;
import cn.remex.core.util.Judgment;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.function.BiConsumer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class StringHelper
implements RemexConstants {
    private static HashMap<String, Pattern> patterns = new HashMap();
    private static HashMap<Class<?>, String> ClassAbbreviation = new HashMap();

    public static String aequilate(String sourString, int width, String ... textAlign) {
        boolean textAlignLeft = "left".equals(textAlign != null && textAlign.length > 0 ? textAlign[0] : "left");
        StringBuilder sb = new StringBuilder(sourString);
        if (sourString.length() < width) {
            for (int i = width - sourString.length(); i > 0; --i) {
                if (textAlignLeft) {
                    sb.append(" ");
                    continue;
                }
                sb.insert(0, " ");
            }
        }
        return sb.toString();
    }

    public static String fomatString(String string) {
        return string.replaceAll("0", "\uff10").replaceAll("1", "\uff11").replaceAll("2", "\uff12").replaceAll("3", "\uff13").replaceAll("4", "\uff14").replaceAll("5", "\uff15").replaceAll("6", "\uff16").replaceAll("7", "\uff17").replaceAll("8", "\uff18").replaceAll("9", "\uff19");
    }

    public static String getAbbreviation(Type type) {
        if (type instanceof Class) {
            String abbr = ClassAbbreviation.get(type);
            if (null == abbr) {
                String sn = StringHelper.getClassSimpleName(type);
                abbr = sn.replaceAll("[^A-Z]", "");
                ClassAbbreviation.put((Class)type, abbr);
            }
            return abbr;
        }
        throw new StringHandleException("\u56e0\u4e3a\u6b64Type\u975eClass\u7c7b\u578b\uff0c\u65e0\u6cd5\u4e3aType" + type.toString() + "\u7c7b\u6307\u5b9a\u7f29\u5199\uff01");
    }

    public static String getClassSimpleName(Type type) {
        if (type instanceof Class) {
            String sn = ((Class)type).getSimpleName();
            return sn.split("\\$\\$EnhancerByCGLIB\\$\\$")[0];
        }
        throw new StringHandleException("\u56e0\u4e3a\u6b64Type\u975eClass\u7c7b\u578b\uff0c\u65e0\u6cd5\u4e3aType" + type.toString() + "\u7c7b\u7b80\u540d\uff01");
    }

    public static String getClassName(Type type) {
        if (type instanceof Class) {
            String sn = ((Class)type).getName();
            return sn.split("\\$\\$EnhancerByCGLIB\\$\\$")[0];
        }
        throw new StringHandleException("\u56e0\u4e3a\u6b64Type\u975eClass\u7c7b\u578b\uff0c\u65e0\u6cd5\u4e3aType" + type.toString() + "\u7c7b\u7b80\u540d\uff01");
    }

    public static String lowerFirstLetter(String string) {
        StringBuilder sb = new StringBuilder();
        return sb.append(string.substring(0, 1).toLowerCase()).append(string.substring(1)).toString();
    }

    public static MatchResult match(String string, String regex, String notMatchExceptionMsg) {
        Perl5Matcher m = new Perl5Matcher();
        Pattern p = StringHelper.obtainPattern(regex);
        if (!m.contains(string, p) && null != notMatchExceptionMsg) {
            throw new StringHandleException(notMatchExceptionMsg);
        }
        return m.getMatch();
    }

    private static synchronized Pattern obtainPattern(String regex) {
        Pattern p = patterns.get(regex);
        if (null == p) {
            try {
                p = compiler.compile(regex);
                patterns.put(regex, p);
            }
            catch (MalformedPatternException e) {
                throw new StringHandleException("\u8fde\u63a5\u6b63\u5219\u8868\u8fbe\u5f0f\u53d1\u751f\u5f02\u5e38\uff01", e);
            }
        }
        return p;
    }

    public static int forEachMatch(String string, String regex, BiConsumer<MatchResult, Boolean> matchConsumer) {
        Perl5Matcher m = new Perl5Matcher();
        Pattern p = StringHelper.obtainPattern(regex);
        PatternMatcherInput input = new PatternMatcherInput(string);
        int len = string.length();
        while (m.contains(input, p)) {
            matchConsumer.accept(m.getMatch(), input.endOfInput());
        }
        return input.getEndOffset();
    }

    public static String substitute(String string, String searchRegx, String replaceRegx, int replaceTimes) {
        Perl5Matcher m = new Perl5Matcher();
        Pattern sp = StringHelper.obtainPattern(searchRegx);
        String result = Util.substitute((PatternMatcher)m, (Pattern)sp, (Substitution)new Perl5Substitution(replaceRegx), (String)string, (int)replaceTimes);
        return result;
    }

    public static String substringByMaxLength(String string, int maxLength) {
        if (string.length() > maxLength) {
            string = string.substring(0, maxLength - 3) + "...";
        }
        return string.replaceAll("0", "\uff10").replaceAll("1", "\uff11").replaceAll("2", "\uff12").replaceAll("3", "\uff13").replaceAll("4", "\uff14").replaceAll("5", "\uff15").replaceAll("6", "\uff16").replaceAll("7", "\uff17").replaceAll("8", "\uff18").replaceAll("9", "\uff19");
    }

    public static String substringByStartAndEnd(String string, int start, int end) {
        if (start < 0 || end <= start) {
            return "\u5b57\u7b26\u957f\u5ea6\u8bbe\u7f6e\u9519\u8bef!";
        }
        if (end > string.length()) {
            end = string.length();
        }
        string = string.substring(start, end);
        return string.replaceAll("0", "\uff10").replaceAll("1", "\uff11").replaceAll("2", "\uff12").replaceAll("3", "\uff13").replaceAll("4", "\uff14").replaceAll("5", "\uff15").replaceAll("6", "\uff16").replaceAll("7", "\uff17").replaceAll("8", "\uff18").replaceAll("9", "\uff19");
    }

    public static String upperFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String exCharset(String str, String fromCharset, String toCharset) {
        try {
            return new String(str.getBytes(fromCharset), toCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new StringHandleException("\u8f6c\u6362String\u65f6\u5b57\u7b26\u96c6\u4e0d\u53d7\u652f\u6301", e);
        }
    }

    public static String urlEncode(String str, String charset) {
        try {
            return URLEncoder.encode(str, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new StringHandleException("URLEncode\u65f6\uff0c\u8f6c\u6362String\u65f6\u5b57\u7b26\u96c6\u4e0d\u53d7\u652f\u6301", e);
        }
    }

    public static String urlDecode(String data, String charset) {
        try {
            data = data.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            data = data.replaceAll("\\+", "%2B");
            data = URLDecoder.decode(data, charset);
            return data;
        }
        catch (UnsupportedEncodingException e) {
            throw new StringHandleException("URLDecode\u65f6\uff0c\u8f6c\u6362String\u65f6\u5b57\u7b26\u96c6\u4e0d\u53d7\u652f\u6301", e);
        }
    }

    public static void writeToStream(String requestBody, String charset, OutputStream outputStream) {
        try {
            if (!Judgment.nullOrBlank(requestBody)) {
                byte[] buffer = requestBody.getBytes(charset);
                outputStream.write(buffer);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            throw new StringHandleException("\u5b57\u7b26\u4e32\u5199\u5165\u6d41\u65f6\u53d1\u751f\u9519\u8bef\uff01", e);
        }
    }

    public static String readFromStream(String charset, InputStream inputStream) {
        try {
            int count;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bufferedInput = new BufferedInputStream(inputStream);
            while ((count = bufferedInput.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
            byte[] bytes = baos.toByteArray();
            return new String(bytes, charset);
        }
        catch (Exception e) {
            throw new StringHandleException("\u5b57\u7b26\u4e32\u5199\u5165\u6d41\u65f6\u53d1\u751f\u9519\u8bef\uff01", e);
        }
    }
}

