/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.core.CoreSvo;
import cn.remex.core.exception.JSONException;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Judgment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public class JsonHelper {
    private static final String LocalObjectMapper = "JsonHelper";

    public static String toJsonString(Object obj) {
        try {
            return JsonHelper.obtainLocalObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JSONException("\u65e0\u6cd5\u5c06\u5bf9\u8c61\u8f6c\u5316\u4e3aJson\u5b57\u7b26\u4e32\uff01", e);
        }
    }

    private static ObjectMapper obtainLocalObjectMapper() {
        ObjectMapper mapper = (ObjectMapper)CoreSvo.valLocal(LocalObjectMapper);
        if (null == mapper) {
            mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
            CoreSvo.putLocal(LocalObjectMapper, mapper);
        }
        return mapper;
    }

    public static void writJsonString(Writer writer, Object value) {
        try {
            JsonHelper.obtainLocalObjectMapper().writeValue(writer, value);
        }
        catch (Exception e) {
            throw new JSONException("\u65e0\u6cd5\u5411\u6d41\u4e2d\u5199\u5165Json\u5b57\u7b26\u4e32\uff01", e);
        }
    }

    public static <T> T toJavaObject(String jsonString, Class<T> clazz) {
        try {
            return (T)(Judgment.nullOrBlank(jsonString) ? null : JsonHelper.obtainLocalObjectMapper().readValue(jsonString, clazz));
        }
        catch (Exception e) {
            throw new JSONException("\u65e0\u6cd5\u5c06Json\u5b57\u7b26\u4e32\u8f6c\u5316\u4e3aJava\u5bf9\u8c61, jsonString = " + jsonString, e);
        }
    }

    public static JsonNode toJsonNode(String jsonString) {
        ObjectMapper mapper = JsonHelper.obtainLocalObjectMapper();
        try {
            return mapper.readTree(jsonString);
        }
        catch (IOException e) {
            throw new JSONException("\u65e0\u6cd5\u5c06Json\u5b57\u7b26\u4e32\u8f6c\u5316\u4e3aJava\u5bf9\u8c61, jsonString = " + jsonString, e);
        }
    }

    public static String readString(JsonNode jsonNode, String fieldName) {
        JsonNode subNode = jsonNode.get(fieldName);
        return null == subNode ? null : subNode.textValue();
    }

    public static void eachNode(String jsonString, BiConsumer<String, JsonNode> nodeConsumer) {
        try {
            ObjectMapper mapper = JsonHelper.obtainLocalObjectMapper();
            Iterator nodes = mapper.readTree(jsonString).fields();
            while (nodes.hasNext()) {
                Map.Entry node = (Map.Entry)nodes.next();
                nodeConsumer.accept((String)node.getKey(), (JsonNode)node.getValue());
            }
        }
        catch (Exception e) {
            throw new JSONException("\u65e0\u6cd5\u5c06Json\u5b57\u7b26\u4e32\u8f6c\u5316\u4e3aJava\u5bf9\u8c61\uff01", e);
        }
    }

    public static <T> T toJavaObject(String jsonString, Type clazz) {
        try {
            ObjectMapper mapper = JsonHelper.obtainLocalObjectMapper();
            JavaType javaType = mapper.getTypeFactory().constructParametricType(ReflectUtil.obtainClass(clazz), (Class[])ReflectUtil.obtainParameterClasses(clazz));
            return (T)(Judgment.nullOrBlank(jsonString) ? null : JsonHelper.obtainLocalObjectMapper().readValue(jsonString, javaType));
        }
        catch (Exception e) {
            throw new JSONException("\u65e0\u6cd5\u5c06Json\u5b57\u7b26\u4e32\u8f6c\u5316\u4e3aJava\u5bf9\u8c61,class=" + clazz.toString() + "\uff0cJsonString=" + jsonString, e);
        }
    }

    public static <T> T toJavaObject(String jsonString, Class<T> clazz, String path) {
        try {
            return (T)JsonHelper.obtainLocalObjectMapper().readValue(JsonHelper.obtainLocalObjectMapper().readTree(jsonString).path(path).traverse(), clazz);
        }
        catch (Exception e) {
            throw new JSONException("\u65e0\u6cd5\u5c06Json\u5b57\u7b26\u4e32\u8f6c\u5316\u4e3aJava\u5bf9\u8c61\uff01", e);
        }
    }

    public static <T> T toJavaObject(Reader reader, Class<T> clazz) {
        try {
            return (T)JsonHelper.obtainLocalObjectMapper().readValue(reader, clazz);
        }
        catch (Exception e) {
            throw new JSONException("\u65e0\u6cd5\u5c06Json\u5b57\u7b26\u4e32\u8f6c\u5316\u4e3aJava\u5bf9\u8c61\uff01", e);
        }
    }
}

