/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.core.exception.NestedException;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper {
    public static void forEachExcelSheetRow(Object _input, Object sheetIndexOrName, Map<String, String> titleMap, Consumer<Map<String, Object>> rowConsumer) {
        ArrayList titles = new ArrayList();
        HashMap rowData = new HashMap();
        BufferedInputStream in = null;
        try {
            Assert.notNullAndEmpty(_input, "ERROR", "\u5904\u7406Excel\u7684\u8f93\u5165\u53c2\u6570\u4ec5\u652f\u6301File / InputStream \u4e24\u79cd\u4e14\u4e0d\u80fd\u4e3a\u7a7a");
            if (_input instanceof File) {
                in = new BufferedInputStream(new FileInputStream((File)_input));
            } else if (_input instanceof InputStream) {
                in = new BufferedInputStream((InputStream)_input);
            }
            Assert.notNullAndEmpty(in, "ERROR", "\u5904\u7406Excel\u7684\u8f93\u5165\u53c2\u6570\u4ec5\u652f\u6301File / InputStream \u4e24\u79cd\u4e14\u4e0d\u80fd\u4e3a\u7a7a");
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)in);
            Sheet st = sheetIndexOrName instanceof String ? wb.getSheet(sheetIndexOrName.toString()) : wb.getSheetAt(Integer.parseInt(sheetIndexOrName.toString()));
            Assert.notNullAndEmpty(st, "ERROR", "\u5904\u7406Excel\u65f6\u6ca1\u6709\u6839\u636e\u4f20\u5165\u7684sheetIndexOrName\u627e\u5230\u5bf9\u5e94\u7684sheet\uff0c\u4e3b\u8981\u53c2\u6570\u4f20\u6574\u6570\u5219\u6839\u636e\u7b2c\u51e0\u4e2asheet\u83b7\u53d6\uff0c\u5b57\u7b26\u4e32\u5219\u6839\u636esheetName\u83b7\u53d6\uff0csheetIndexOrName=" + sheetIndexOrName);
            Param<Integer> physicalColCount = new Param<Integer>(0);
            st.forEach(row -> {
                int curPhysicalColCount = 0;
                curPhysicalColCount = row.getPhysicalNumberOfCells();
                if (curPhysicalColCount <= 1) {
                    return;
                }
                if ((Integer)physicalColCount.param == 0) {
                    physicalColCount.param = curPhysicalColCount;
                    row.forEach(titleCell -> titles.add(titleCell.getStringCellValue()));
                }
                if ((Integer)physicalColCount.param > 1 && row.getPhysicalNumberOfCells() >= 1) {
                    int i = 0;
                    for (Cell dataCell : row) {
                        String value = null;
                        switch (dataCell.getCellType()) {
                            case 1: {
                                value = dataCell.getStringCellValue();
                                break;
                            }
                            case 0: {
                                if (DateUtil.isCellDateFormatted((Cell)dataCell)) {
                                    Date date = dataCell.getDateCellValue();
                                    if (date == null) break;
                                    value = new SimpleDateFormat("yyyy-MM-dd hh:mm:dd").format(date);
                                    break;
                                }
                                value = new DecimalFormat("0").format(dataCell.getNumericCellValue());
                            }
                        }
                        rowData.put(Judgment.nullOrBlank(titleMap.get(titles.get(i))) ? (String)titles.get(i) : (String)titleMap.get(titles.get(i)), value);
                    }
                }
                rowConsumer.accept(rowData);
            });
        }
        catch (NumberFormatException e) {
            throw new NestedException("ERROR", "Excel \u5904\u7406\u65f6\uff0csheet\u540d\u5b57\u53ea\u80fd\u662f\u6574\u6570\u6216\u5b57\u7b26\u4e32", e);
        }
        catch (Exception e) {
            throw new NestedException("ERROR", "Excel \u5904\u7406\u89e3\u6790\u9519\u8bef", e);
        }
    }
}

