/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.RemexConstants;
import cn.remex.core.exception.NestedException;
import java.util.Collection;
import java.util.Map;

public abstract class Assert
implements RemexConstants {
    public static void isNull(Object object, String errorCode, String errorMsg) {
        if (object != null) {
            throw new NestedException(errorCode, errorMsg);
        }
    }

    public static void isNull(Object object, String errorCode, String errorMsg, Class<? extends RuntimeException> exceptionClassForThrow) {
        if (object != null) {
            throw Assert.createRuntimeException(errorCode, errorMsg, exceptionClassForThrow);
        }
    }

    public static void notNull(Object object, String errorCode, String errorMsg) {
        if (object == null) {
            throw new NestedException(errorCode, errorMsg);
        }
    }

    public static void notNull(Object object, String errorCode, String errorMsg, Class<? extends RuntimeException> exceptionClassForThrow) {
        if (object == null) {
            throw Assert.createRuntimeException(errorCode, errorMsg, exceptionClassForThrow);
        }
    }

    public static void notNullAndEmpty(Object stringOrObject, String errorCode, String errorMsg) {
        if (stringOrObject == null || stringOrObject instanceof String && "".equals(((String)stringOrObject).trim()) || stringOrObject instanceof Collection && ((Collection)stringOrObject).size() == 0 || stringOrObject instanceof Object[] && ((Object[])stringOrObject).length == 0) {
            throw new NestedException(errorCode, errorMsg);
        }
    }

    public static void nullOrEmpty(Object stringOrObject, String errorCode, String errorMsg) {
        if (!(stringOrObject == null || stringOrObject instanceof String && "".equals(((String)stringOrObject).trim()) || stringOrObject instanceof Collection && ((Collection)stringOrObject).size() == 0 || stringOrObject instanceof Object[] && ((Object[])stringOrObject).length == 0)) {
            throw new NestedException(errorCode, errorMsg);
        }
    }

    public static void isTrue(boolean expression, String errorCode, String errorMsg) {
        if (!expression) {
            throw new NestedException(errorCode, errorMsg);
        }
    }

    public static void isTrue(boolean expression, String errorCode, String message, Class<? extends RuntimeException> exceptionClassForThrow) {
        if (!expression) {
            throw Assert.createRuntimeException(errorCode, message, exceptionClassForThrow);
        }
    }

    public static void isSimpleBean(Object object, String errorCode, String errorMsg) {
        if (object instanceof Map || object instanceof Collection) {
            throw new NestedException(errorCode, errorMsg);
        }
    }

    private static RuntimeException createRuntimeException(String errorCode, String message, Class<? extends RuntimeException> exceptionClassForThrow) {
        try {
            if (NestedException.class.isAssignableFrom(exceptionClassForThrow)) {
                return exceptionClassForThrow.getConstructor(String.class, String.class).newInstance(message);
            }
            return exceptionClassForThrow.getConstructor(String.class).newInstance(message);
        }
        catch (Exception e) {
            return new IllegalArgumentException("\u81ea\u5b9a\u4e49\u5f02\u5e38\u7c7b" + exceptionClassForThrow.getName() + "\u65e0\u6cd5\u6784\u5efa\uff0c\u8c03\u7528\u9ed8\u8ba4\u5f02\u5e38IllegalArgumentException\uff0c\u5904\u7406\u65ad\u8a00\u3002\u6b64\u5904\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + message);
        }
    }
}

